/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.term.impl;

import com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.NonGroundFunctionalTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.functionsymbol.BooleanFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBStrictEqFunctionSymbol;
import it.unibz.inf.ontop.model.term.impl.GroundTermTools;
import it.unibz.inf.ontop.model.term.impl.ImmutableExpressionImpl;

public class NonGroundExpressionImpl
extends ImmutableExpressionImpl
implements NonGroundFunctionalTerm {
    protected NonGroundExpressionImpl(TermFactory termFactory, BooleanFunctionSymbol functor, ImmutableTerm ... terms) {
        super(termFactory, functor, terms);
        GroundTermTools.checkNonGroundTermConstraint(this);
    }

    protected NonGroundExpressionImpl(BooleanFunctionSymbol functor, ImmutableList<? extends ImmutableTerm> terms, TermFactory termFactory) {
        super(functor, terms, termFactory);
        GroundTermTools.checkNonGroundTermConstraint(this);
    }

    @Override
    public boolean isGround() {
        return false;
    }

    @Override
    public boolean isVar2VarEquality() {
        return this.getFunctionSymbol() instanceof DBStrictEqFunctionSymbol && this.getTerms().size() == 2 && this.getTerms().stream().allMatch(t -> t instanceof Variable);
    }
}

