/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.term.functionsymbol.impl.geof;

import it.unibz.inf.ontop.model.vocabulary.UOM;
import java.util.Arrays;
import org.apache.commons.rdf.api.IRI;

public enum DistanceUnit {
    METRE("metre", UOM.METRE),
    DEGREE("degree", UOM.DEGREE),
    RADIAN("radian", UOM.RADIAN);

    private final IRI iri;
    private final String name;

    public IRI getIri() {
        return this.iri;
    }

    public String getName() {
        return this.name;
    }

    private DistanceUnit(String name, IRI iri) {
        this.iri = iri;
        this.name = name;
    }

    static DistanceUnit findByName(String name) {
        return Arrays.stream(DistanceUnit.values()).filter(u -> u.name.equals(name)).findAny().orElseThrow(() -> new IllegalArgumentException("unknown unit name: " + name));
    }

    static DistanceUnit findByIRI(String iri) {
        return Arrays.stream(DistanceUnit.values()).filter(u -> u.iri.getIRIString().equals(iri)).findAny().orElseThrow(() -> new IllegalArgumentException("unknown unit iri: " + iri));
    }
}

