/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.term.functionsymbol.impl.geof;

import com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.model.term.Constant;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.NonGroundFunctionalTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.functionsymbol.FunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.NullRejectingDBConcatFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.SPARQLFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.geof.GeoUtils;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.geof.WKTLiteralValue;
import it.unibz.inf.ontop.model.type.RDFTermType;
import it.unibz.inf.ontop.model.type.TermType;
import it.unibz.inf.ontop.model.vocabulary.GEO;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Optional;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import org.apache.commons.rdf.api.IRI;

public abstract class AbstractGeofFunctionSymbolImpl
extends SPARQLFunctionSymbolImpl {
    protected AbstractGeofFunctionSymbolImpl(@Nonnull String functionSymbolName, @Nonnull IRI functionIRI, @Nonnull ImmutableList<TermType> expectedBaseTypes) {
        super(functionSymbolName, functionIRI, expectedBaseTypes);
        if (expectedBaseTypes.isEmpty()) {
            throw new IllegalArgumentException("The arity must be >= 1");
        }
    }

    @Override
    protected final ImmutableTerm buildTermAfterEvaluation(ImmutableList<ImmutableTerm> newTerms, TermFactory termFactory, VariableNullability variableNullability) {
        if (!this.tolerateNulls() && newTerms.stream().anyMatch(ImmutableTerm::isNull)) {
            return termFactory.getNullConstant();
        }
        if (newTerms.stream().allMatch(t -> this.isRDFFunctionalTerm((ImmutableTerm)t) || t instanceof Constant) && this.isGroundTerm(newTerms, termFactory)) {
            ImmutableList typeTerms = (ImmutableList)newTerms.stream().map(t -> this.extractRDFTermTypeTerm((ImmutableTerm)t, termFactory)).collect(ImmutableCollectors.toList());
            ImmutableList subLexicalTerms = (ImmutableList)newTerms.stream().map(t -> this.extractLexicalTerm((ImmutableTerm)t, termFactory)).collect(ImmutableCollectors.toList());
            Optional<Boolean> checkMismatchedSRID = this.misMatchedSRID((ImmutableList<ImmutableTerm>)subLexicalTerms, termFactory);
            if (checkMismatchedSRID.isPresent() && checkMismatchedSRID.get().booleanValue()) {
                return termFactory.getImmutableFunctionalTerm((FunctionSymbol)this, newTerms);
            }
            ImmutableExpression.Evaluation inputTypeErrorEvaluation = this.evaluateInputTypeError((ImmutableList<ImmutableTerm>)subLexicalTerms, (ImmutableList<ImmutableTerm>)typeTerms, termFactory, variableNullability);
            if (inputTypeErrorEvaluation.getValue().isPresent()) {
                switch (inputTypeErrorEvaluation.getValue().get()) {
                    case FALSE: {
                        return termFactory.getNullConstant();
                    }
                    case NULL: {
                        throw new MinorOntopInternalBugException("This evaluation (SPARQL type error on the arguments) should not produce a NULL");
                    }
                }
            }
            ImmutableTerm typeTerm = this.computeTypeTerm((ImmutableList<? extends ImmutableTerm>)subLexicalTerms, (ImmutableList<ImmutableTerm>)typeTerms, termFactory, variableNullability);
            ImmutableTerm lexicalTerm = this.computeLexicalTerm((ImmutableList<ImmutableTerm>)subLexicalTerms, (ImmutableList<ImmutableTerm>)typeTerms, termFactory, typeTerm);
            Optional<ImmutableExpression> inputErrorCondition = inputTypeErrorEvaluation.getExpression();
            ImmutableExpression nonNullLexicalTermCondition = termFactory.getDBIsNotNull(lexicalTerm);
            ImmutableExpression typeCondition = inputErrorCondition.map(c -> termFactory.getConjunction((ImmutableExpression)c, nonNullLexicalTermCondition)).orElse(nonNullLexicalTermCondition);
            return termFactory.getRDFFunctionalTerm(inputErrorCondition.map(c -> termFactory.getIfElseNull((ImmutableExpression)c, lexicalTerm)).orElse(lexicalTerm), termFactory.getIfElseNull(typeCondition, typeTerm));
        }
        return termFactory.getImmutableFunctionalTerm((FunctionSymbol)this, newTerms);
    }

    @Override
    protected boolean tolerateNulls() {
        return false;
    }

    protected ImmutableExpression.Evaluation evaluateInputTypeError(ImmutableList<ImmutableTerm> subLexicalTerms, ImmutableList<ImmutableTerm> typeTerms, TermFactory termFactory, VariableNullability variableNullability) {
        ImmutableList typeTestExpressions = (ImmutableList)IntStream.range(0, typeTerms.size()).mapToObj(i -> termFactory.getIsAExpression((ImmutableTerm)typeTerms.get(i), (RDFTermType)this.getExpectedBaseType(i))).collect(ImmutableCollectors.toList());
        return termFactory.getConjunction((ImmutableList<ImmutableExpression>)typeTestExpressions).evaluate(variableNullability);
    }

    protected abstract ImmutableTerm computeLexicalTerm(ImmutableList<ImmutableTerm> var1, ImmutableList<ImmutableTerm> var2, TermFactory var3, ImmutableTerm var4);

    protected abstract ImmutableTerm computeTypeTerm(ImmutableList<? extends ImmutableTerm> var1, ImmutableList<ImmutableTerm> var2, TermFactory var3, VariableNullability var4);

    private boolean isGroundTerm(ImmutableList<ImmutableTerm> newTerms, TermFactory termFactory) {
        return newTerms.stream().map(t -> this.extractLexicalTerm((ImmutableTerm)t, termFactory)).noneMatch(this::hasNonGroundTerminalSubterm);
    }

    private boolean hasNonGroundTerminalSubterm(ImmutableTerm term) {
        NonGroundFunctionalTerm nonGroundTerm;
        if (term instanceof Variable) {
            return true;
        }
        if (term instanceof NonGroundFunctionalTerm && (nonGroundTerm = (NonGroundFunctionalTerm)term).getFunctionSymbol() instanceof NullRejectingDBConcatFunctionSymbol) {
            return nonGroundTerm.getTerms().stream().anyMatch(this::hasNonGroundTerminalSubterm);
        }
        return false;
    }

    private Optional<Boolean> misMatchedSRID(ImmutableList<ImmutableTerm> subLexicalTerms, TermFactory termFactory) {
        if (this.getExpectedBaseTypes().stream().filter(t -> t.equals(GEO.GEO_WKT_LITERAL)).count() > 1L) {
            WKTLiteralValue v0 = GeoUtils.extractWKTLiteralValue(termFactory, (ImmutableTerm)subLexicalTerms.get(0));
            WKTLiteralValue v1 = GeoUtils.extractWKTLiteralValue(termFactory, (ImmutableTerm)subLexicalTerms.get(1));
            return Optional.of(!v0.getSRID().equals((Object)v1.getSRID()));
        }
        return Optional.empty();
    }
}

