/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.term.functionsymbol.impl;

import com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.RDFTermTypeConstant;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.FunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBIfThenFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.FunctionSymbolImpl;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.MetaRDFTermType;
import it.unibz.inf.ontop.model.type.RDFTermType;
import it.unibz.inf.ontop.model.type.TermType;
import it.unibz.inf.ontop.model.type.TermTypeInference;
import java.util.Optional;
import java.util.function.Function;

public class UnaryLatelyTypedFunctionSymbolImpl
extends FunctionSymbolImpl {
    private final DBTermType targetType;
    private final Function<DBTermType, Optional<DBFunctionSymbol>> dbFunctionSymbolFct;

    protected UnaryLatelyTypedFunctionSymbolImpl(DBTermType dbStringType, MetaRDFTermType metaRDFTermType, DBTermType targetType, Function<DBTermType, Optional<DBFunctionSymbol>> dbFunctionSymbolFct) {
        super("LATELY_TYPE_" + dbFunctionSymbolFct, (ImmutableList<TermType>)ImmutableList.of((Object)dbStringType, (Object)metaRDFTermType));
        this.targetType = targetType;
        this.dbFunctionSymbolFct = dbFunctionSymbolFct;
    }

    @Override
    protected boolean tolerateNulls() {
        return false;
    }

    @Override
    protected boolean mayReturnNullWithoutNullArguments() {
        return false;
    }

    @Override
    public boolean isAlwaysInjectiveInTheAbsenceOfNonInjectiveFunctionalTerms() {
        return false;
    }

    @Override
    public Optional<TermTypeInference> inferType(ImmutableList<? extends ImmutableTerm> terms) {
        return Optional.of(TermTypeInference.declareTermType(this.targetType));
    }

    @Override
    public boolean canBePostProcessed(ImmutableList<? extends ImmutableTerm> arguments) {
        return false;
    }

    @Override
    protected ImmutableTerm buildTermAfterEvaluation(ImmutableList<ImmutableTerm> newTerms, TermFactory termFactory, VariableNullability variableNullability) {
        ImmutableTerm rdfTypeTerm = (ImmutableTerm)newTerms.get(1);
        if (rdfTypeTerm instanceof RDFTermTypeConstant) {
            RDFTermType rdfType = ((RDFTermTypeConstant)rdfTypeTerm).getRDFTermType();
            DBTermType dbType = rdfType.getClosestDBType(termFactory.getTypeFactory().getDBTypeFactory());
            Optional<DBFunctionSymbol> subFunctionSymbol = this.dbFunctionSymbolFct.apply(dbType);
            if (!subFunctionSymbol.isPresent()) {
                return termFactory.getImmutableFunctionalTerm((FunctionSymbol)this, newTerms);
            }
            ImmutableFunctionalTerm dbTerm = termFactory.getImmutableFunctionalTerm((FunctionSymbol)subFunctionSymbol.get(), termFactory.getConversionFromRDFLexical2DB(dbType, (ImmutableTerm)newTerms.get(0), rdfType));
            return this.transformNaturalDBTerm(dbTerm, dbType, rdfType, termFactory).simplify(variableNullability);
        }
        return Optional.of(rdfTypeTerm).filter(t -> t instanceof ImmutableFunctionalTerm).map(t -> (ImmutableFunctionalTerm)t).filter(t -> t.getFunctionSymbol() instanceof DBIfThenFunctionSymbol).map(t -> ((DBIfThenFunctionSymbol)t.getFunctionSymbol()).pushDownRegularFunctionalTerm(termFactory.getImmutableFunctionalTerm((FunctionSymbol)this, (ImmutableList<? extends ImmutableTerm>)newTerms), newTerms.indexOf(t), termFactory)).map(t -> t.simplify(variableNullability)).orElseGet(() -> this.tryToLiftMagicNumbers(newTerms, termFactory, variableNullability, false).orElseGet(() -> super.buildTermAfterEvaluation(newTerms, termFactory, variableNullability)));
    }

    protected ImmutableTerm transformNaturalDBTerm(ImmutableFunctionalTerm dbTerm, DBTermType inputDBType, RDFTermType rdfType, TermFactory termFactory) {
        return dbTerm;
    }
}

