/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.term.functionsymbol.impl;

import com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.ReduciblePositiveAritySPARQLFunctionSymbolImpl;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.DBTypeFactory;
import it.unibz.inf.ontop.model.type.RDFTermType;
import it.unibz.inf.ontop.model.type.TermType;
import it.unibz.inf.ontop.model.type.TermTypeInference;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.apache.commons.rdf.api.IRI;

public class MultitypedInputUnarySPARQLFunctionSymbolImpl
extends ReduciblePositiveAritySPARQLFunctionSymbolImpl {
    private final RDFTermType targetType;
    private final boolean isAlwaysInjective;
    private final TriFunction<TermFactory, ImmutableTerm, ImmutableTerm, ImmutableFunctionalTerm> lexicalTermFct;

    protected MultitypedInputUnarySPARQLFunctionSymbolImpl(@Nonnull String functionSymbolName, @Nonnull IRI functionIRI, @Nonnull RDFTermType inputBaseType, @Nonnull RDFTermType targetType, boolean isAlwaysInjective, TriFunction<TermFactory, ImmutableTerm, ImmutableTerm, ImmutableFunctionalTerm> lexicalTermFct) {
        super(functionSymbolName, functionIRI, (ImmutableList<TermType>)ImmutableList.of((Object)inputBaseType));
        this.targetType = targetType;
        this.isAlwaysInjective = isAlwaysInjective;
        this.lexicalTermFct = lexicalTermFct;
        if (targetType.isAbstract()) {
            throw new IllegalArgumentException("The target type must be concrete");
        }
    }

    protected MultitypedInputUnarySPARQLFunctionSymbolImpl(@Nonnull String functionSymbolName, @Nonnull IRI functionIRI, @Nonnull RDFTermType inputBaseType, @Nonnull RDFTermType targetType, boolean isAlwaysInjective, DBTypeFactory dbTypeFactory, Function<DBTermType, Optional<DBFunctionSymbol>> dbFunctionSymbolFct) {
        this(functionSymbolName, functionIRI, inputBaseType, targetType, isAlwaysInjective, MultitypedInputUnarySPARQLFunctionSymbolImpl.createLatelyTypedFct(targetType, dbTypeFactory, dbFunctionSymbolFct));
    }

    protected MultitypedInputUnarySPARQLFunctionSymbolImpl(@Nonnull String functionSymbolName, @Nonnull String officialName, @Nonnull RDFTermType inputBaseType, @Nonnull RDFTermType targetType, boolean isAlwaysInjective, TriFunction<TermFactory, ImmutableTerm, ImmutableTerm, ImmutableFunctionalTerm> lexicalTermFct) {
        super(functionSymbolName, officialName, (ImmutableList<TermType>)ImmutableList.of((Object)inputBaseType));
        this.lexicalTermFct = lexicalTermFct;
        this.targetType = targetType;
        this.isAlwaysInjective = isAlwaysInjective;
        if (targetType.isAbstract()) {
            throw new IllegalArgumentException("The target type must be concrete");
        }
    }

    protected MultitypedInputUnarySPARQLFunctionSymbolImpl(@Nonnull String functionSymbolName, @Nonnull String officialName, @Nonnull RDFTermType inputBaseType, @Nonnull RDFTermType targetType, boolean isAlwaysInjective, DBTypeFactory dbTypeFactory, Function<DBTermType, Optional<DBFunctionSymbol>> dbFunctionSymbolFct) {
        this(functionSymbolName, officialName, inputBaseType, targetType, isAlwaysInjective, MultitypedInputUnarySPARQLFunctionSymbolImpl.createLatelyTypedFct(targetType, dbTypeFactory, dbFunctionSymbolFct));
    }

    private static TriFunction<TermFactory, ImmutableTerm, ImmutableTerm, ImmutableFunctionalTerm> createLatelyTypedFct(RDFTermType targetType, DBTypeFactory dbTypeFactory, Function<DBTermType, Optional<DBFunctionSymbol>> dbFunctionSymbolFct) {
        return (termFactory, lexicalTerm, rdfTermTypeTerm) -> termFactory.getUnaryLatelyTypedFunctionalTerm((ImmutableTerm)lexicalTerm, (ImmutableTerm)rdfTermTypeTerm, targetType.getClosestDBType(dbTypeFactory), dbFunctionSymbolFct);
    }

    @Override
    protected ImmutableTerm computeLexicalTerm(ImmutableList<ImmutableTerm> subLexicalTerms, ImmutableList<ImmutableTerm> typeTerms, TermFactory termFactory, ImmutableTerm returnedTypeTerm) {
        return termFactory.getConversion2RDFLexical(this.lexicalTermFct.apply(termFactory, (ImmutableTerm)subLexicalTerms.get(0), (ImmutableTerm)typeTerms.get(0)), this.targetType);
    }

    @Override
    protected ImmutableTerm computeTypeTerm(ImmutableList<? extends ImmutableTerm> subLexicalTerms, ImmutableList<ImmutableTerm> typeTerms, TermFactory termFactory, VariableNullability variableNullability) {
        return termFactory.getRDFTermTypeConstant(this.targetType);
    }

    @Override
    public boolean isAlwaysInjectiveInTheAbsenceOfNonInjectiveFunctionalTerms() {
        return this.isAlwaysInjective;
    }

    @Override
    public Optional<TermTypeInference> inferType(ImmutableList<? extends ImmutableTerm> terms) {
        return Optional.of(TermTypeInference.declareTermType(this.targetType));
    }

    @Override
    public boolean canBePostProcessed(ImmutableList<? extends ImmutableTerm> arguments) {
        return false;
    }

    @FunctionalInterface
    public static interface TriFunction<T, U, V, R> {
        public R apply(T var1, U var2, V var3);
    }
}

