/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.term.functionsymbol.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.iq.request.DefinitionPushDownRequest;
import it.unibz.inf.ontop.model.term.Constant;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.RDFTermTypeConstant;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.functionsymbol.InequalityLabel;
import it.unibz.inf.ontop.model.term.functionsymbol.SPARQLAggregationFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.SPARQLFunctionSymbolImpl;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.ObjectRDFType;
import it.unibz.inf.ontop.model.type.RDFDatatype;
import it.unibz.inf.ontop.model.type.RDFTermType;
import it.unibz.inf.ontop.model.type.TermType;
import it.unibz.inf.ontop.model.type.TermTypeInference;
import it.unibz.inf.ontop.model.type.TypeFactory;
import it.unibz.inf.ontop.substitution.Substitution;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class MinOrMaxOrSampleSPARQLFunctionSymbolImpl
extends SPARQLFunctionSymbolImpl
implements SPARQLAggregationFunctionSymbol {
    private final TypeFactory typeFactory;
    private final MinMaxSampleType type;
    private final RDFDatatype abstractNumericType;
    private final RDFDatatype dateTimeType;
    private final ObjectRDFType bnodeType;
    private final ObjectRDFType iriType;
    private final String defaultAggVariableName;
    private final InequalityLabel inequalityLabel;

    protected MinOrMaxOrSampleSPARQLFunctionSymbolImpl(TypeFactory typeFactory, MinMaxSampleType type) {
        this(type == MinMaxSampleType.MAX ? "SP_MAX" : (type == MinMaxSampleType.MIN ? "SP_MIN" : "SP_SAMPLE"), type == MinMaxSampleType.MAX ? "MAX" : (type == MinMaxSampleType.MIN ? "MIN" : "SAMPLE"), typeFactory, type);
    }

    protected MinOrMaxOrSampleSPARQLFunctionSymbolImpl(String name, String officialName, TypeFactory typeFactory, MinMaxSampleType type) {
        super(name, officialName, (ImmutableList<TermType>)ImmutableList.of((Object)typeFactory.getAbstractRDFTermType()));
        this.typeFactory = typeFactory;
        this.type = type;
        this.abstractNumericType = typeFactory.getAbstractOntopNumericDatatype();
        this.dateTimeType = typeFactory.getXsdDatetimeDatatype();
        this.bnodeType = typeFactory.getBlankNodeType();
        this.iriType = typeFactory.getIRITermType();
        this.defaultAggVariableName = type == MinMaxSampleType.MAX ? "max1" : (type == MinMaxSampleType.MIN ? "min1" : "sample1");
        this.inequalityLabel = type == MinMaxSampleType.MAX ? InequalityLabel.GT : InequalityLabel.LT;
    }

    @Override
    protected boolean tolerateNulls() {
        return false;
    }

    @Override
    public boolean isAlwaysInjectiveInTheAbsenceOfNonInjectiveFunctionalTerms() {
        return false;
    }

    @Override
    public boolean isAggregation() {
        return true;
    }

    @Override
    public Optional<TermTypeInference> inferType(ImmutableList<? extends ImmutableTerm> terms) {
        return Optional.empty();
    }

    @Override
    public boolean canBePostProcessed(ImmutableList<? extends ImmutableTerm> arguments) {
        return false;
    }

    @Override
    public boolean isNullable(ImmutableSet<Integer> nullableIndexes) {
        return true;
    }

    @Override
    public Optional<SPARQLAggregationFunctionSymbol.AggregationSimplification> decomposeIntoDBAggregation(ImmutableList<? extends ImmutableTerm> subTerms, ImmutableList<ImmutableSet<RDFTermType>> possibleRDFTypes, boolean hasGroupBy, VariableNullability variableNullability, VariableGenerator variableGenerator, TermFactory termFactory) {
        if (possibleRDFTypes.size() != this.getArity()) {
            throw new IllegalArgumentException("The size of possibleRDFTypes is expected to match the arity of the function symbol");
        }
        ImmutableTerm subTerm = (ImmutableTerm)subTerms.get(0);
        ImmutableSet subTermPossibleTypes = (ImmutableSet)possibleRDFTypes.get(0);
        switch (subTermPossibleTypes.size()) {
            case 0: {
                throw new MinorOntopInternalBugException("At least one RDF type was expected to be inferred for the first sub-term");
            }
            case 1: {
                return Optional.of(this.decomposeUnityped(subTerm, (RDFTermType)subTermPossibleTypes.iterator().next(), hasGroupBy, variableNullability, variableGenerator, termFactory));
            }
        }
        return Optional.of(this.decomposeMultityped(subTerm, (ImmutableSet<RDFTermType>)subTermPossibleTypes, hasGroupBy, variableNullability, variableGenerator, termFactory));
    }

    private SPARQLAggregationFunctionSymbol.AggregationSimplification decomposeUnityped(ImmutableTerm subTerm, RDFTermType subTermType, boolean hasGroupBy, VariableNullability variableNullability, VariableGenerator variableGenerator, TermFactory termFactory) {
        ImmutableTerm subTermLexicalTerm = this.extractLexicalTerm(subTerm, termFactory);
        ImmutableFunctionalTerm dbAggTerm = this.createAggregate(subTermType, termFactory.getConversionFromRDFLexical2DB(subTermLexicalTerm, subTermType), termFactory);
        RDFTermTypeConstant subTermTypeConstant = termFactory.getRDFTermTypeConstant(subTermType);
        Variable dbAggregationVariable = variableGenerator.generateNewVariable(this.defaultAggVariableName);
        boolean isSubTermNullable = subTermLexicalTerm.isNullable(variableNullability.getNullableVariables());
        boolean dbAggMayReturnNull = !hasGroupBy || isSubTermNullable;
        RDFTermTypeConstant typeTerm = dbAggMayReturnNull ? termFactory.getIfElseNull(termFactory.getDBIsNotNull(dbAggregationVariable), subTermTypeConstant) : subTermTypeConstant;
        ImmutableFunctionalTerm liftedTerm = termFactory.getRDFFunctionalTerm(termFactory.getConversion2RDFLexical(dbAggregationVariable, subTermType), typeTerm);
        ImmutableFunctionalTerm.FunctionalTermDecomposition decomposition = termFactory.getFunctionalTermDecomposition(liftedTerm, termFactory.getSubstitution(ImmutableMap.of((Object)dbAggregationVariable, (Object)dbAggTerm)));
        return SPARQLAggregationFunctionSymbol.AggregationSimplification.create(decomposition);
    }

    private ImmutableFunctionalTerm createAggregate(RDFTermType rdfType, ImmutableTerm dbSubTerm, TermFactory termFactory) {
        DBTermType dbType = rdfType.getClosestDBType(this.typeFactory.getDBTypeFactory());
        return this.type == MinMaxSampleType.MAX ? termFactory.getDBMax(dbSubTerm, dbType) : (this.type == MinMaxSampleType.MIN ? termFactory.getDBMin(dbSubTerm, dbType) : termFactory.getDBSample(dbSubTerm, dbType));
    }

    private SPARQLAggregationFunctionSymbol.AggregationSimplification decomposeMultityped(ImmutableTerm subTerm, ImmutableSet<RDFTermType> subTermPossibleTypes, boolean hasGroupBy, VariableNullability variableNullability, VariableGenerator variableGenerator, TermFactory termFactory) {
        ImmutableTerm subTermLexicalTerm = this.extractLexicalTerm(subTerm, termFactory);
        ImmutableTerm subTermTypeTerm = this.extractRDFTermTypeTerm(subTerm, termFactory);
        ImmutableMap<RDFTermType, Variable> subVariableMap = subTermPossibleTypes.stream().collect(ImmutableCollectors.toMap(t -> t, t -> variableGenerator.generateNewVariable()));
        ImmutableSet<DefinitionPushDownRequest> pushDownRequests = this.computeRequests(subTermLexicalTerm, subTermTypeTerm, subVariableMap, termFactory, variableNullability);
        ImmutableMap<RDFTermType, Variable> aggregateMap = subTermPossibleTypes.stream().collect(ImmutableCollectors.toMap(t -> t, t -> variableGenerator.generateNewVariable()));
        Substitution<ImmutableFunctionalTerm> substitution = this.computeSubstitution(subVariableMap, aggregateMap, termFactory);
        ImmutableFunctionalTerm liftableTerm = this.computeLiftableTerm(aggregateMap, termFactory);
        return SPARQLAggregationFunctionSymbol.AggregationSimplification.create(termFactory.getFunctionalTermDecomposition(liftableTerm, substitution), pushDownRequests);
    }

    private ImmutableSet<DefinitionPushDownRequest> computeRequests(ImmutableTerm subTermLexicalTerm, ImmutableTerm subTermTypeTerm, ImmutableMap<RDFTermType, Variable> subVariableMap, TermFactory termFactory, VariableNullability variableNullability) {
        return (ImmutableSet)subVariableMap.entrySet().stream().map(e -> this.computeRequest(subTermLexicalTerm, subTermTypeTerm, (RDFTermType)e.getKey(), (Variable)e.getValue(), termFactory, variableNullability)).collect(ImmutableCollectors.toSet());
    }

    private DefinitionPushDownRequest computeRequest(ImmutableTerm subTermLexicalTerm, ImmutableTerm subTermTypeTerm, RDFTermType rdfType, Variable newVariable, TermFactory termFactory, VariableNullability variableNullability) {
        ImmutableTerm definition = termFactory.getConversionFromRDFLexical2DB(subTermLexicalTerm, rdfType).simplify(variableNullability);
        ImmutableExpression condition = termFactory.getStrictEquality(subTermTypeTerm, termFactory.getRDFTermTypeConstant(rdfType), new ImmutableTerm[0]);
        return DefinitionPushDownRequest.create(newVariable, definition, condition);
    }

    private Substitution<ImmutableFunctionalTerm> computeSubstitution(ImmutableMap<RDFTermType, Variable> subVariableMap, ImmutableMap<RDFTermType, Variable> aggregateMap, TermFactory termFactory) {
        return termFactory.getSubstitution(aggregateMap.entrySet().stream().collect(ImmutableCollectors.toMap(Map.Entry::getValue, e -> this.createAggregate((RDFTermType)e.getKey(), (ImmutableTerm)subVariableMap.get(e.getKey()), termFactory))));
    }

    private ImmutableFunctionalTerm computeLiftableTerm(ImmutableMap<RDFTermType, Variable> aggregateMap, TermFactory termFactory) {
        ImmutableList<Map.Entry<ImmutableExpression, RDFTermTypeConstant>> typeTermWhenPairs = this.computeTypeTermWhenPairs(aggregateMap, termFactory);
        ImmutableFunctionalTerm typeTerm = termFactory.getDBCase(typeTermWhenPairs.stream(), termFactory.getNullConstant(), true);
        ImmutableFunctionalTerm lexicalTerm = this.computeLexicalTerm(typeTermWhenPairs, aggregateMap, termFactory);
        return termFactory.getRDFFunctionalTerm(lexicalTerm, typeTerm);
    }

    private ImmutableList<Map.Entry<ImmutableExpression, RDFTermTypeConstant>> computeTypeTermWhenPairs(ImmutableMap<RDFTermType, Variable> aggregateMap, TermFactory termFactory) {
        Optional<Map.Entry> bnodeEntry = Optional.ofNullable((Variable)aggregateMap.get((Object)this.bnodeType)).map(v -> this.createRegularTypeWhenPair((Variable)v, this.bnodeType, termFactory));
        Optional<Map.Entry> iriEntry = Optional.ofNullable((Variable)aggregateMap.get((Object)this.iriType)).map(v -> this.createRegularTypeWhenPair((Variable)v, this.iriType, termFactory));
        Stream<Map.Entry> objectEntries = Stream.of(bnodeEntry, iriEntry).filter(Optional::isPresent).map(Optional::get);
        Stream<Map.Entry<ImmutableExpression, RDFTermTypeConstant>> numericEntries = this.computeNumericOrDatetimeTypePairs(this.abstractNumericType, aggregateMap, (agg1, agg2) -> termFactory.getDBNumericInequality(this.inequalityLabel, (ImmutableTerm)agg1, (ImmutableTerm)agg2), termFactory);
        Stream<Map.Entry<ImmutableExpression, RDFTermTypeConstant>> datetimeEntries = this.computeNumericOrDatetimeTypePairs(this.dateTimeType, aggregateMap, (agg1, agg2) -> termFactory.getDBDatetimeInequality(this.inequalityLabel, (ImmutableTerm)agg1, (ImmutableTerm)agg2), termFactory);
        Stream<Map.Entry> otherEntries = aggregateMap.entrySet().stream().filter(e -> e.getKey() instanceof RDFDatatype).filter(e -> !((RDFTermType)e.getKey()).isA(this.abstractNumericType) && !((RDFTermType)e.getKey()).isA(this.dateTimeType)).map(e -> this.createRegularTypeWhenPair((Variable)e.getValue(), (RDFTermType)e.getKey(), termFactory));
        return (ImmutableList)Stream.concat(Stream.concat(objectEntries, numericEntries), Stream.concat(datetimeEntries, otherEntries)).collect(ImmutableCollectors.toList());
    }

    private BiFunction<Variable, Variable, ImmutableExpression> orOnlyFirstArgumentIsNotNull(BiFunction<Variable, Variable, ImmutableExpression> fct, TermFactory termFactory) {
        return (agg1, agg2) -> termFactory.getDisjunction((ImmutableExpression)fct.apply((Variable)agg1, (Variable)agg2), termFactory.getConjunction(termFactory.getDBIsNotNull((ImmutableTerm)agg1), termFactory.getDBIsNull((ImmutableTerm)agg2)));
    }

    private Map.Entry<ImmutableExpression, RDFTermTypeConstant> createRegularTypeWhenPair(Variable aggregateVariable, RDFTermType rdfType, TermFactory termFactory) {
        return Maps.immutableEntry((Object)termFactory.getDBIsNotNull(aggregateVariable), (Object)termFactory.getRDFTermTypeConstant(rdfType));
    }

    private Stream<Map.Entry<ImmutableExpression, RDFTermTypeConstant>> computeNumericOrDatetimeTypePairs(RDFDatatype baseDatatype, ImmutableMap<RDFTermType, Variable> aggregateMap, BiFunction<Variable, Variable, ImmutableExpression> partialComparisonFct, TermFactory termFactory) {
        BiFunction<Variable, Variable, ImmutableExpression> comparisonFct = this.orOnlyFirstArgumentIsNotNull(partialComparisonFct, termFactory);
        ImmutableList matchingTypes = (ImmutableList)aggregateMap.keySet().stream().filter(t -> t.isA(baseDatatype)).collect(ImmutableCollectors.toList());
        if (matchingTypes.isEmpty()) {
            return Stream.empty();
        }
        Stream<Map.Entry> firstPairStream = IntStream.range(0, matchingTypes.size() - 1).mapToObj(i -> this.createNumericOrDatetimeTypePair((RDFTermType)matchingTypes.get(i), (ImmutableList<RDFTermType>)matchingTypes.subList(i + 1, matchingTypes.size()), aggregateMap, comparisonFct, termFactory));
        RDFTermType lastType = (RDFTermType)matchingTypes.get(matchingTypes.size() - 1);
        Map.Entry<ImmutableExpression, RDFTermTypeConstant> lastPair = this.createRegularTypeWhenPair((Variable)aggregateMap.get((Object)lastType), lastType, termFactory);
        return Stream.concat(firstPairStream, Stream.of(lastPair));
    }

    private Map.Entry<ImmutableExpression, RDFTermTypeConstant> createNumericOrDatetimeTypePair(RDFTermType rdfType, ImmutableList<RDFTermType> typesToCompareWith, ImmutableMap<RDFTermType, Variable> aggregateMap, BiFunction<Variable, Variable, ImmutableExpression> comparisonFct, TermFactory termFactory) {
        Variable aggregateVariable = (Variable)aggregateMap.get((Object)rdfType);
        ImmutableExpression expression = termFactory.getConjunction(typesToCompareWith.stream().map(arg_0 -> aggregateMap.get(arg_0)).map(agg2 -> (ImmutableExpression)comparisonFct.apply(aggregateVariable, (Variable)agg2))).orElseThrow(() -> new MinorOntopInternalBugException("At least one type to compare with was expected"));
        return Maps.immutableEntry((Object)expression, (Object)termFactory.getRDFTermTypeConstant(rdfType));
    }

    private ImmutableFunctionalTerm computeLexicalTerm(ImmutableList<Map.Entry<ImmutableExpression, RDFTermTypeConstant>> typeTermWhenPairs, ImmutableMap<RDFTermType, Variable> aggregateMap, TermFactory termFactory) {
        Stream<Map.Entry> lexicalWhenPairs = typeTermWhenPairs.stream().map(e -> {
            RDFTermType rdfType = ((RDFTermTypeConstant)e.getValue()).getRDFTermType();
            ImmutableFunctionalTerm thenLexicalTerm = termFactory.getConversion2RDFLexical((ImmutableTerm)aggregateMap.get((Object)rdfType), rdfType);
            return Maps.immutableEntry((Object)((ImmutableExpression)e.getKey()), (Object)thenLexicalTerm);
        });
        return termFactory.getDBCase(lexicalWhenPairs, termFactory.getNullConstant(), true);
    }

    @Override
    public Constant evaluateEmptyBag(TermFactory termFactory) {
        return termFactory.getNullConstant();
    }

    public static enum MinMaxSampleType {
        MIN,
        MAX,
        SAMPLE;

    }
}

