/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.term.functionsymbol.impl;

import com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.ReduciblePositiveAritySPARQLFunctionSymbolImpl;
import it.unibz.inf.ontop.model.type.ObjectRDFType;
import it.unibz.inf.ontop.model.type.RDFDatatype;
import it.unibz.inf.ontop.model.type.RDFTermType;
import it.unibz.inf.ontop.model.type.TermType;
import it.unibz.inf.ontop.model.type.TermTypeInference;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.commons.rdf.api.IRI;

public class IriSPARQLFunctionSymbolImpl
extends ReduciblePositiveAritySPARQLFunctionSymbolImpl {
    private final RDFDatatype xsdStringType;
    private final ObjectRDFType iriType;
    private final IRI baseIRI;

    protected IriSPARQLFunctionSymbolImpl(RDFTermType abstractRDFType, RDFDatatype xsdStringType, ObjectRDFType iriType) {
        this(null, abstractRDFType, xsdStringType, iriType);
    }

    public IriSPARQLFunctionSymbolImpl(@Nullable IRI baseIRI, RDFTermType abstractRDFTermType, RDFDatatype xsdStringType, ObjectRDFType iriType) {
        super("SP_IRI", "IRI", (ImmutableList<TermType>)ImmutableList.of((Object)abstractRDFTermType));
        this.xsdStringType = xsdStringType;
        this.iriType = iriType;
        this.baseIRI = baseIRI;
    }

    @Override
    protected ImmutableTerm computeLexicalTerm(ImmutableList<ImmutableTerm> subLexicalTerms, ImmutableList<ImmutableTerm> typeTerms, TermFactory termFactory, ImmutableTerm returnedTypeTerm) {
        ImmutableTerm argLexical = (ImmutableTerm)subLexicalTerms.get(0);
        if (this.baseIRI == null) {
            return argLexical;
        }
        return termFactory.getIfThenElse(termFactory.getIsAExpression((ImmutableTerm)typeTerms.get(0), this.xsdStringType), termFactory.getDBIriStringResolution(this.baseIRI, argLexical), argLexical);
    }

    @Override
    protected ImmutableTerm computeTypeTerm(ImmutableList<? extends ImmutableTerm> subLexicalTerms, ImmutableList<ImmutableTerm> typeTerms, TermFactory termFactory, VariableNullability variableNullability) {
        return termFactory.getRDFTermTypeConstant(this.iriType);
    }

    @Override
    protected ImmutableExpression.Evaluation evaluateInputTypeError(ImmutableList<ImmutableTerm> subLexicalTerms, ImmutableList<ImmutableTerm> typeTerms, TermFactory termFactory, VariableNullability variableNullability) {
        ImmutableTerm typeTerm = (ImmutableTerm)typeTerms.get(0);
        return termFactory.getDisjunction(termFactory.getIsAExpression(typeTerm, this.iriType), termFactory.getIsAExpression(typeTerm, this.xsdStringType)).evaluate(variableNullability);
    }

    @Override
    public boolean isAlwaysInjectiveInTheAbsenceOfNonInjectiveFunctionalTerms() {
        return false;
    }

    @Override
    public Optional<TermTypeInference> inferType(ImmutableList<? extends ImmutableTerm> terms) {
        return Optional.of(TermTypeInference.declareTermType(this.iriType));
    }

    @Override
    public boolean canBePostProcessed(ImmutableList<? extends ImmutableTerm> arguments) {
        return false;
    }
}

