/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.term.functionsymbol.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.model.term.FunctionalTermSimplification;
import it.unibz.inf.ontop.model.term.GroundTerm;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.IncrementalEvaluation;
import it.unibz.inf.ontop.model.term.NonConstantTerm;
import it.unibz.inf.ontop.model.term.NonFunctionalTerm;
import it.unibz.inf.ontop.model.term.NonNullConstant;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.functionsymbol.BooleanFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.FunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.RDFTermTypeFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBCoalesceFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBIfElseNullFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.NonDeterministicDBFunctionSymbol;
import it.unibz.inf.ontop.model.term.impl.FunctionalTermNullabilityImpl;
import it.unibz.inf.ontop.model.term.impl.PredicateImpl;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.TermType;
import it.unibz.inf.ontop.model.type.TermTypeInference;
import it.unibz.inf.ontop.substitution.Substitution;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import it.unibz.inf.ontop.utils.impl.VariableGeneratorImpl;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public abstract class FunctionSymbolImpl
extends PredicateImpl
implements FunctionSymbol {
    private final ImmutableList<TermType> expectedBaseTypes;

    protected FunctionSymbolImpl(@Nonnull String name, @Nonnull ImmutableList<TermType> expectedBaseTypes) {
        super(name, expectedBaseTypes.size());
        this.expectedBaseTypes = expectedBaseTypes;
    }

    protected abstract boolean isAlwaysInjectiveInTheAbsenceOfNonInjectiveFunctionalTerms();

    @Override
    public FunctionSymbol.FunctionalTermNullability evaluateNullability(ImmutableList<? extends NonFunctionalTerm> arguments, VariableNullability childNullability, TermFactory termFactory) {
        IncrementalEvaluation evaluation = this.evaluateIsNotNull(this.transformIntoRegularArguments(arguments, termFactory), termFactory, childNullability);
        switch (evaluation.getStatus()) {
            case SIMPLIFIED_EXPRESSION: {
                return evaluation.getNewExpression().filter(e -> e.getFunctionSymbol().equals(termFactory.getDBFunctionSymbolFactory().getDBIsNotNull())).map(e -> e.getTerm(0)).filter(t -> t instanceof Variable).map(t -> (Variable)t).map(FunctionalTermNullabilityImpl::new).orElseGet(() -> new FunctionalTermNullabilityImpl(true));
            }
            case IS_NULL: {
                throw new MinorOntopInternalBugException("An IS_NOT_NULL cannot evaluate to NULL");
            }
            case IS_TRUE: {
                return new FunctionalTermNullabilityImpl(false);
            }
        }
        return new FunctionalTermNullabilityImpl(true);
    }

    protected ImmutableList<? extends ImmutableTerm> transformIntoRegularArguments(ImmutableList<? extends NonFunctionalTerm> arguments, TermFactory termFactory) {
        return arguments;
    }

    @Override
    public ImmutableTerm simplify(ImmutableList<? extends ImmutableTerm> terms, TermFactory termFactory, VariableNullability variableNullability) {
        ImmutableList newTerms = (ImmutableList)terms.stream().map(t -> t instanceof ImmutableFunctionalTerm ? t.simplify(variableNullability) : t).collect(ImmutableCollectors.toList());
        if (!this.tolerateNulls() && newTerms.stream().anyMatch(ImmutableTerm::isNull)) {
            return termFactory.getNullConstant();
        }
        return this.simplifyIfElseNullOrCoalesce((ImmutableList<ImmutableTerm>)newTerms, termFactory, variableNullability).orElseGet(() -> this.buildTermAfterEvaluation((ImmutableList<ImmutableTerm>)newTerms, termFactory, variableNullability));
    }

    private Optional<ImmutableTerm> simplifyIfElseNullOrCoalesce(ImmutableList<ImmutableTerm> terms, TermFactory termFactory, VariableNullability variableNullability) {
        return this.simplifyIfElseNull(terms, termFactory, variableNullability).or(() -> this.simplifyCoalesce(terms, termFactory, variableNullability));
    }

    private Optional<ImmutableTerm> simplifyIfElseNull(ImmutableList<ImmutableTerm> terms, TermFactory termFactory, VariableNullability variableNullability) {
        if (!this.enableIfElseNullLifting() || this.tolerateNulls() || this instanceof DBIfElseNullFunctionSymbol) {
            return Optional.empty();
        }
        return IntStream.range(0, terms.size()).filter(i -> {
            ImmutableTerm term = (ImmutableTerm)terms.get(i);
            return term instanceof ImmutableFunctionalTerm && ((ImmutableFunctionalTerm)term).getFunctionSymbol() instanceof DBIfElseNullFunctionSymbol;
        }).boxed().findAny().map(i -> this.liftIfElseNull(terms, (int)i, termFactory, variableNullability));
    }

    private ImmutableTerm liftIfElseNull(ImmutableList<ImmutableTerm> terms, int index, TermFactory termFactory, VariableNullability variableNullability) {
        ImmutableFunctionalTerm ifElseNullTerm = (ImmutableFunctionalTerm)terms.get(index);
        ImmutableExpression condition = (ImmutableExpression)ifElseNullTerm.getTerm(0);
        ImmutableTerm conditionalTerm = ifElseNullTerm.getTerm(1);
        ImmutableList newTerms = (ImmutableList)IntStream.range(0, terms.size()).mapToObj(i -> i == index ? conditionalTerm : (ImmutableTerm)terms.get(i)).collect(ImmutableCollectors.toList());
        ImmutableFunctionalTerm newFunctionalTerm = this instanceof BooleanFunctionSymbol ? termFactory.getBooleanIfElseNull(condition, termFactory.getImmutableExpression((BooleanFunctionSymbol)((Object)this), (ImmutableList<? extends ImmutableTerm>)newTerms)) : termFactory.getIfElseNull(condition, termFactory.getImmutableFunctionalTerm((FunctionSymbol)this, (ImmutableList<? extends ImmutableTerm>)newTerms));
        return newFunctionalTerm.simplify(variableNullability);
    }

    private Optional<ImmutableTerm> simplifyCoalesce(ImmutableList<ImmutableTerm> terms, TermFactory termFactory, VariableNullability variableNullability) {
        ImmutableTerm firstTerm;
        if (this.enableCoalesceLifting() && this.getArity() == 1 && !this.tolerateNulls() && !this.mayReturnNullWithoutNullArguments() && (firstTerm = (ImmutableTerm)terms.get(0)) instanceof ImmutableFunctionalTerm && ((ImmutableFunctionalTerm)firstTerm).getFunctionSymbol() instanceof DBCoalesceFunctionSymbol) {
            ImmutableFunctionalTerm initialCoalesceFunctionalTerm = (ImmutableFunctionalTerm)firstTerm;
            ImmutableList subTerms = (ImmutableList)initialCoalesceFunctionalTerm.getTerms().stream().map(t -> termFactory.getImmutableFunctionalTerm((FunctionSymbol)this, (ImmutableTerm)t)).collect(ImmutableCollectors.toList());
            if (this instanceof BooleanFunctionSymbol) {
                return Optional.of(termFactory.getDBBooleanCoalesce((ImmutableList<ImmutableTerm>)subTerms).simplify(variableNullability));
            }
            return Optional.of(termFactory.getDBCoalesce((ImmutableList<ImmutableTerm>)subTerms).simplify(variableNullability));
        }
        return Optional.empty();
    }

    @Override
    public IncrementalEvaluation evaluateStrictEq(ImmutableList<? extends ImmutableTerm> terms, ImmutableTerm otherTerm, TermFactory termFactory, VariableNullability variableNullability) {
        boolean incompatibleTypesDetected = this.inferType(terms).flatMap(TermTypeInference::getTermType).map(t1 -> otherTerm.inferType().flatMap(TermTypeInference::getTermType).map(t2 -> this.areIncompatibleForStrictEq((TermType)t1, (TermType)t2)).orElse(false)).orElse(false);
        if (incompatibleTypesDetected) {
            return IncrementalEvaluation.declareIsFalse();
        }
        if (otherTerm instanceof ImmutableFunctionalTerm) {
            return this.evaluateStrictEqWithFunctionalTerm(terms, (ImmutableFunctionalTerm)otherTerm, termFactory, variableNullability);
        }
        if (otherTerm instanceof NonNullConstant) {
            return this.evaluateStrictEqWithNonNullConstant(terms, (NonNullConstant)otherTerm, termFactory, variableNullability);
        }
        if (otherTerm.isNull()) {
            return IncrementalEvaluation.declareIsNull();
        }
        return IncrementalEvaluation.declareSameExpression();
    }

    private boolean areIncompatibleForStrictEq(TermType type1, TermType type2) {
        if (type1.equals(type2)) {
            return false;
        }
        return !(type1 instanceof DBTermType) || !(type2 instanceof DBTermType);
    }

    @Override
    public IncrementalEvaluation evaluateIsNotNull(ImmutableList<? extends ImmutableTerm> terms, TermFactory termFactory, VariableNullability variableNullability) {
        if (!this.mayReturnNullWithoutNullArguments() && !this.tolerateNulls()) {
            ImmutableSet<Variable> nullableVariables = variableNullability.getNullableVariables();
            Optional<ImmutableExpression> optionalExpression = termFactory.getDBIsNotNull(terms.stream().filter(t -> t.isNullable(nullableVariables)));
            return optionalExpression.map(e -> e.evaluate(variableNullability, true)).orElseGet(IncrementalEvaluation::declareIsTrue);
        }
        return IncrementalEvaluation.declareSameExpression();
    }

    @Override
    public boolean isDeterministic() {
        return !(this instanceof NonDeterministicDBFunctionSymbol);
    }

    @Override
    public boolean isNullable(ImmutableSet<Integer> nullableIndexes) {
        return this.mayReturnNullWithoutNullArguments() || !nullableIndexes.isEmpty();
    }

    @Override
    public boolean isAggregation() {
        return false;
    }

    @Override
    public Stream<Variable> proposeProvenanceVariables(ImmutableList<? extends ImmutableTerm> terms) {
        if (!this.mayReturnNullWithoutNullArguments() && !this.tolerateNulls()) {
            return terms.stream().filter(t -> t instanceof NonConstantTerm).flatMap(t -> t instanceof Variable ? Stream.of((Variable)t) : ((ImmutableFunctionalTerm)t).proposeProvenanceVariables());
        }
        return Stream.empty();
    }

    @Override
    public FunctionalTermSimplification simplifyAsGuaranteedToBeNonNull(ImmutableList<? extends ImmutableTerm> terms, TermFactory termFactory) {
        if (!this.mayReturnNullWithoutNullArguments() && !this.tolerateNulls()) {
            ImmutableMap<Integer, FunctionalTermSimplification> subTermSimplifications = IntStream.range(0, terms.size()).filter(i -> terms.get(i) instanceof ImmutableFunctionalTerm).boxed().collect(ImmutableCollectors.toMap(i -> i, i -> ((ImmutableFunctionalTerm)terms.get(i.intValue())).simplifyAsGuaranteedToBeNonNull()));
            ImmutableList newSubTerms = (ImmutableList)IntStream.range(0, terms.size()).mapToObj(i -> Optional.ofNullable((FunctionalTermSimplification)subTermSimplifications.get((Object)i)).map(FunctionalTermSimplification::getSimplifiedTerm).orElseGet(() -> (ImmutableTerm)terms.get(i))).collect(ImmutableCollectors.toList());
            ImmutableFunctionalTerm simplifiedTerm = termFactory.getImmutableFunctionalTerm((FunctionSymbol)this, (ImmutableList<? extends ImmutableTerm>)newSubTerms);
            ImmutableSet simplifiableVariables = (ImmutableSet)Stream.concat(subTermSimplifications.values().stream().flatMap(s -> s.getSimplifiableVariables().stream()), terms.stream().filter(t -> t instanceof Variable).map(v -> (Variable)v)).collect(ImmutableCollectors.toSet());
            return FunctionalTermSimplification.create(simplifiedTerm, (ImmutableSet<Variable>)simplifiableVariables);
        }
        return FunctionalTermSimplification.create(termFactory.getImmutableFunctionalTerm((FunctionSymbol)this, terms), (ImmutableSet<Variable>)ImmutableSet.of());
    }

    @Override
    public boolean shouldBeDecomposedInUnion() {
        return true;
    }

    protected IncrementalEvaluation evaluateStrictEqWithFunctionalTerm(ImmutableList<? extends ImmutableTerm> terms, ImmutableFunctionalTerm otherTerm, TermFactory termFactory, VariableNullability variableNullability) {
        if (otherTerm.getFunctionSymbol().equals(this)) {
            ImmutableList<? extends ImmutableTerm> otherTerms = otherTerm.getTerms();
            Decomposability decomposability = this.testDecomposabilityIntoConjunction(terms, variableNullability, otherTerms);
            if (decomposability == Decomposability.CANNOT_BE_DECOMPOSED) {
                return IncrementalEvaluation.declareSameExpression();
            }
            if (this.getArity() == 0) {
                return IncrementalEvaluation.declareIsTrue();
            }
            ImmutableExpression conjunction = termFactory.getConjunction((ImmutableList<ImmutableExpression>)((ImmutableList)IntStream.range(0, this.getArity()).mapToObj(i -> termFactory.getStrictEquality((ImmutableTerm)terms.get(i), otherTerm.getTerm(i), new ImmutableTerm[0])).collect(ImmutableCollectors.toList())));
            ImmutableExpression newExpression = decomposability == Decomposability.NEEDS_NON_NULL_CONDITION_WRAPPING ? termFactory.getBooleanIfElseNull(termFactory.getConjunction(Stream.concat(terms.stream(), otherTerms.stream()).map(termFactory::getDBIsNotNull)).orElseThrow(), conjunction) : conjunction;
            return newExpression.evaluate(variableNullability, true);
        }
        return IncrementalEvaluation.declareSameExpression();
    }

    protected Decomposability testDecomposabilityIntoConjunction(ImmutableList<? extends ImmutableTerm> terms, VariableNullability variableNullability, ImmutableList<? extends ImmutableTerm> otherTerms) {
        if (!this.isAlwaysInjectiveInTheAbsenceOfNonInjectiveFunctionalTerms()) {
            return Decomposability.CANNOT_BE_DECOMPOSED;
        }
        return this.testDecomposabilityIntoConjunctionWhenInjective(terms, variableNullability, otherTerms);
    }

    protected Decomposability testDecomposabilityIntoConjunctionWhenInjective(ImmutableList<? extends ImmutableTerm> terms, VariableNullability variableNullability, ImmutableList<? extends ImmutableTerm> otherTerms) {
        if (this.mayReturnNullWithoutNullArguments()) {
            return Decomposability.CANNOT_BE_DECOMPOSED;
        }
        if (this.getArity() < 2) {
            return Decomposability.NO_WRAPPING_NEEDED;
        }
        return variableNullability.canPossiblyBeNullSeparately(terms) || variableNullability.canPossiblyBeNullSeparately(otherTerms) ? Decomposability.NEEDS_NON_NULL_CONDITION_WRAPPING : Decomposability.NO_WRAPPING_NEEDED;
    }

    protected IncrementalEvaluation evaluateStrictEqWithNonNullConstant(ImmutableList<? extends ImmutableTerm> terms, NonNullConstant otherTerm, TermFactory termFactory, VariableNullability variableNullability) {
        return IncrementalEvaluation.declareSameExpression();
    }

    protected abstract boolean tolerateNulls();

    protected abstract boolean mayReturnNullWithoutNullArguments();

    protected boolean enableIfElseNullLifting() {
        return false;
    }

    protected boolean enableCoalesceLifting() {
        return false;
    }

    @Override
    public Optional<ImmutableFunctionalTerm.FunctionalTermDecomposition> analyzeInjectivity(ImmutableList<? extends ImmutableTerm> arguments, ImmutableSet<Variable> nonFreeVariables, VariableNullability variableNullability, VariableGenerator variableGenerator, TermFactory termFactory) {
        if (!this.isDeterministic()) {
            return Optional.empty();
        }
        if (arguments.stream().allMatch(t -> t instanceof GroundTerm && ((GroundTerm)t).isDeterministic() || nonFreeVariables.contains(t))) {
            return Optional.of(termFactory.getFunctionalTermDecomposition(termFactory.getImmutableFunctionalTerm((FunctionSymbol)this, arguments)));
        }
        if (!this.isAlwaysInjectiveInTheAbsenceOfNonInjectiveFunctionalTerms()) {
            return Optional.empty();
        }
        return Optional.of(this.decomposeInjectiveTopFunctionalTerm(arguments, nonFreeVariables, variableNullability, variableGenerator, termFactory));
    }

    protected ImmutableFunctionalTerm.FunctionalTermDecomposition decomposeInjectiveTopFunctionalTerm(ImmutableList<? extends ImmutableTerm> arguments, ImmutableSet<Variable> nonFreeVariables, VariableNullability variableNullability, VariableGenerator variableGenerator, TermFactory termFactory) {
        InjectivityAnalyzer analyzer = new InjectivityAnalyzer(nonFreeVariables, variableNullability, variableGenerator, termFactory);
        return analyzer.decomposeInjectiveTopFunctionalTerm(arguments);
    }

    protected final boolean isInjective(ImmutableList<? extends ImmutableTerm> arguments, VariableNullability variableNullability, TermFactory termFactory) {
        VariableGeneratorImpl testVariableGenerator = new VariableGeneratorImpl((Collection)arguments.stream().flatMap(ImmutableTerm::getVariableStream).collect(ImmutableCollectors.toSet()), termFactory);
        return this.analyzeInjectivity(arguments, (ImmutableSet<Variable>)ImmutableSet.of(), variableNullability, testVariableGenerator, termFactory).filter(d -> d.getSubstitution().isEmpty()).isPresent();
    }

    protected ImmutableTerm buildTermAfterEvaluation(ImmutableList<ImmutableTerm> newTerms, TermFactory termFactory, VariableNullability variableNullability) {
        return termFactory.getImmutableFunctionalTerm((FunctionSymbol)this, newTerms);
    }

    protected ImmutableList<TermType> getExpectedBaseTypes() {
        return this.expectedBaseTypes;
    }

    @Override
    public TermType getExpectedBaseType(int index) {
        return (TermType)this.expectedBaseTypes.get(index);
    }

    protected Optional<ImmutableTerm> tryToLiftMagicNumbers(ImmutableList<ImmutableTerm> newTerms, TermFactory termFactory, VariableNullability variableNullability, boolean isBoolean) {
        Optional<ImmutableFunctionalTerm> optionalTermTypeFunctionalTerm = newTerms.stream().filter(t -> t instanceof ImmutableFunctionalTerm).map(t -> (ImmutableFunctionalTerm)t).filter(t -> t.getFunctionSymbol() instanceof RDFTermTypeFunctionSymbol).findFirst();
        if (optionalTermTypeFunctionalTerm.isPresent()) {
            ImmutableFunctionalTerm firstTermTypeFunctionalTerm = optionalTermTypeFunctionalTerm.get();
            int index = newTerms.indexOf((Object)firstTermTypeFunctionalTerm);
            ImmutableTerm newTerm = ((RDFTermTypeFunctionSymbol)firstTermTypeFunctionalTerm.getFunctionSymbol()).lift(firstTermTypeFunctionalTerm.getTerms(), c -> termFactory.getImmutableFunctionalTerm((FunctionSymbol)this, (ImmutableList<? extends ImmutableTerm>)((ImmutableList)IntStream.range(0, newTerms.size()).mapToObj(i -> i == index ? c : (ImmutableTerm)newTerms.get(i)).collect(ImmutableCollectors.toList()))), termFactory, isBoolean).simplify(variableNullability);
            return Optional.of(newTerm);
        }
        return Optional.empty();
    }

    protected static enum Decomposability {
        NEEDS_NON_NULL_CONDITION_WRAPPING,
        NO_WRAPPING_NEEDED,
        CANNOT_BE_DECOMPOSED;

    }

    protected class InjectivityAnalyzer {
        private final ImmutableSet<Variable> nonFreeVariables;
        private final VariableNullability variableNullability;
        private final VariableGenerator variableGenerator;
        private final TermFactory termFactory;

        protected InjectivityAnalyzer(ImmutableSet<Variable> nonFreeVariables, VariableNullability variableNullability, VariableGenerator variableGenerator, TermFactory termFactory) {
            this.nonFreeVariables = nonFreeVariables;
            this.variableNullability = variableNullability;
            this.variableGenerator = variableGenerator;
            this.termFactory = termFactory;
        }

        protected ImmutableFunctionalTerm.FunctionalTermDecomposition decomposeInjectiveTopFunctionalTerm(ImmutableList<? extends ImmutableTerm> arguments) {
            ImmutableMap<Integer, ImmutableFunctionalTerm.FunctionalTermDecomposition> subTermDecompositions = IntStream.range(0, FunctionSymbolImpl.this.getArity()).filter(i -> arguments.get(i) instanceof ImmutableFunctionalTerm).boxed().collect(ImmutableCollectors.toMap(i -> i, i -> this.getFunctionalTermDecomposition((ImmutableFunctionalTerm)arguments.get(i.intValue()))));
            ImmutableList newArguments = (ImmutableList)IntStream.range(0, FunctionSymbolImpl.this.getArity()).mapToObj(i -> Optional.ofNullable((ImmutableFunctionalTerm.FunctionalTermDecomposition)subTermDecompositions.get((Object)i)).map(ImmutableFunctionalTerm.FunctionalTermDecomposition::getLiftableTerm).orElseGet(() -> (ImmutableTerm)arguments.get(i))).collect(ImmutableCollectors.toList());
            Substitution<ImmutableFunctionalTerm> subTermSubstitution = this.termFactory.getSubstitution(subTermDecompositions.values().stream().map(ImmutableFunctionalTerm.FunctionalTermDecomposition::getSubstitution).flatMap(Substitution::stream).collect(ImmutableCollectors.toMap()));
            ImmutableFunctionalTerm newFunctionalTerm = this.termFactory.getImmutableFunctionalTerm((FunctionSymbol)FunctionSymbolImpl.this, (ImmutableList<? extends ImmutableTerm>)newArguments);
            return this.termFactory.getFunctionalTermDecomposition(newFunctionalTerm, subTermSubstitution);
        }

        private ImmutableFunctionalTerm.FunctionalTermDecomposition getFunctionalTermDecomposition(ImmutableFunctionalTerm arg) {
            Optional<ImmutableFunctionalTerm.FunctionalTermDecomposition> optional = arg.analyzeInjectivity(this.nonFreeVariables, this.variableNullability, this.variableGenerator);
            if (optional.isPresent()) {
                return optional.get();
            }
            Variable var = this.variableGenerator.generateNewVariable();
            return this.termFactory.getFunctionalTermDecomposition(var, this.termFactory.getSubstitution(ImmutableMap.of((Object)var, (Object)arg)));
        }
    }
}

