/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.term.functionsymbol.impl;

import com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.model.term.Constant;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.FunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.ReduciblePositiveAritySPARQLFunctionSymbolImpl;
import it.unibz.inf.ontop.model.type.RDFTermType;
import it.unibz.inf.ontop.model.type.TermType;
import it.unibz.inf.ontop.model.type.TermTypeInference;
import it.unibz.inf.ontop.model.vocabulary.Ontop;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;

public class DateTruncSPARQLFunctionSymbolImpl
extends ReduciblePositiveAritySPARQLFunctionSymbolImpl {
    private static final String[] supportedDateParts = new String[]{"microsecond", "millisecond", "microseconds", "milliseconds", "second", "minute", "hour", "day", "week", "month", "quarter", "year", "decade", "century", "millennium"};
    private final Function<String, DBFunctionSymbol> dbFunctionSymbolFunction;
    private final RDFTermType targetType;

    public DateTruncSPARQLFunctionSymbolImpl(@Nonnull RDFTermType inputDateType, @Nonnull RDFTermType inputSecondType, @Nonnull Function<String, DBFunctionSymbol> dbFunctionSymbolFunction) {
        super("SP_DATE_TRUNC", Ontop.DATE_TRUNC, (ImmutableList<TermType>)ImmutableList.of((Object)inputDateType, (Object)inputSecondType));
        this.targetType = inputDateType;
        this.dbFunctionSymbolFunction = dbFunctionSymbolFunction;
    }

    @Override
    protected ImmutableTerm computeLexicalTerm(ImmutableList<ImmutableTerm> subLexicalTerms, ImmutableList<ImmutableTerm> typeTerms, TermFactory termFactory, ImmutableTerm returnedTypeTerm) {
        if (!(subLexicalTerms.get(1) instanceof Constant)) {
            throw new RuntimeException("Only constants are supported as Date-Part parameter.");
        }
        Constant constant = (Constant)subLexicalTerms.get(1);
        String value = constant.getValue();
        if (!Arrays.stream(supportedDateParts).anyMatch(part -> part.equalsIgnoreCase(value))) {
            throw new RuntimeException(String.format("Date-Part %s is not supported.", value));
        }
        return termFactory.getConversion2RDFLexical(termFactory.getImmutableFunctionalTerm((FunctionSymbol)this.dbFunctionSymbolFunction.apply(value), termFactory.getConversionFromRDFLexical2DB(this.targetType.getClosestDBType(termFactory.getTypeFactory().getDBTypeFactory()), (ImmutableTerm)subLexicalTerms.get(0), this.targetType), (ImmutableTerm)subLexicalTerms.get(1)), this.targetType);
    }

    @Override
    protected ImmutableTerm computeTypeTerm(ImmutableList<? extends ImmutableTerm> subLexicalTerms, ImmutableList<ImmutableTerm> typeTerms, TermFactory termFactory, VariableNullability variableNullability) {
        return termFactory.getRDFTermTypeConstant(this.targetType);
    }

    @Override
    public boolean isAlwaysInjectiveInTheAbsenceOfNonInjectiveFunctionalTerms() {
        return false;
    }

    @Override
    public Optional<TermTypeInference> inferType(ImmutableList<? extends ImmutableTerm> terms) {
        return Optional.of(TermTypeInference.declareTermType(this.targetType));
    }

    @Override
    public boolean canBePostProcessed(ImmutableList<? extends ImmutableTerm> arguments) {
        return false;
    }
}

