/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.term.functionsymbol.impl;

import com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.model.term.Constant;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.FunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.SPARQLFunctionSymbolImpl;
import it.unibz.inf.ontop.model.type.RDFDatatype;
import it.unibz.inf.ontop.model.type.RDFTermType;
import it.unibz.inf.ontop.model.type.TermType;
import it.unibz.inf.ontop.model.type.TermTypeInference;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.commons.rdf.api.IRI;

public abstract class AbstractBinaryComparisonSPARQLFunctionSymbol
extends SPARQLFunctionSymbolImpl {
    private final RDFDatatype xsdBooleanType;

    protected AbstractBinaryComparisonSPARQLFunctionSymbol(@Nonnull String functionSymbolName, @Nonnull IRI functionIRI, @Nonnull RDFTermType rdfRootType, RDFDatatype xsdBooleanType) {
        super(functionSymbolName, functionIRI, (ImmutableList<TermType>)ImmutableList.of((Object)rdfRootType, (Object)rdfRootType));
        this.xsdBooleanType = xsdBooleanType;
    }

    protected AbstractBinaryComparisonSPARQLFunctionSymbol(@Nonnull String functionSymbolName, @Nonnull String officialName, @Nonnull RDFTermType rdfRootType, RDFDatatype xsdBooleanType) {
        super(functionSymbolName, officialName, (ImmutableList<TermType>)ImmutableList.of((Object)rdfRootType, (Object)rdfRootType));
        this.xsdBooleanType = xsdBooleanType;
    }

    @Override
    protected boolean tolerateNulls() {
        return false;
    }

    @Override
    public boolean isAlwaysInjectiveInTheAbsenceOfNonInjectiveFunctionalTerms() {
        return false;
    }

    @Override
    public Optional<TermTypeInference> inferType(ImmutableList<? extends ImmutableTerm> terms) {
        return Optional.of(TermTypeInference.declareTermType(this.xsdBooleanType));
    }

    @Override
    public boolean canBePostProcessed(ImmutableList<? extends ImmutableTerm> arguments) {
        return false;
    }

    @Override
    protected final ImmutableTerm buildTermAfterEvaluation(ImmutableList<ImmutableTerm> newTerms, TermFactory termFactory, VariableNullability variableNullability) {
        if (newTerms.stream().allMatch(t -> this.isRDFFunctionalTerm((ImmutableTerm)t) || t instanceof Constant)) {
            ImmutableList typeTerms = (ImmutableList)newTerms.stream().map(t -> this.extractRDFTermTypeTerm((ImmutableTerm)t, termFactory)).collect(ImmutableCollectors.toList());
            ImmutableList subLexicalTerms = (ImmutableList)newTerms.stream().map(t -> this.extractLexicalTerm((ImmutableTerm)t, termFactory)).collect(ImmutableCollectors.toList());
            ImmutableTerm lexicalTerm = this.computeLexicalTerm((ImmutableList<ImmutableTerm>)subLexicalTerms, (ImmutableList<ImmutableTerm>)typeTerms, termFactory).simplify(variableNullability);
            if (lexicalTerm.equals(termFactory.getNullConstant())) {
                return lexicalTerm;
            }
            ImmutableTerm typeTerm = termFactory.getIfElseNull(termFactory.getDBIsNotNull(lexicalTerm), termFactory.getRDFTermTypeConstant(this.xsdBooleanType)).simplify(variableNullability);
            return termFactory.getRDFFunctionalTerm(lexicalTerm, typeTerm);
        }
        return termFactory.getImmutableFunctionalTerm((FunctionSymbol)this, newTerms);
    }

    protected abstract ImmutableTerm computeLexicalTerm(ImmutableList<ImmutableTerm> var1, ImmutableList<ImmutableTerm> var2, TermFactory var3);
}

