/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.term.functionsymbol.db.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.model.template.Template;
import it.unibz.inf.ontop.model.template.impl.TemplateParser;
import java.io.Serializable;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class SafeSeparatorFragment {
    private final String fragment;
    private final ImmutableList<Template.Component> components;
    private final char separator;
    private final String prefix;
    private final String suffix;
    private final boolean hasPlaceholders;
    private static final Pattern TO_BE_ESCAPED = Pattern.compile("[<(\\[{\\\\^=$!|\\]})?*+.>]");
    protected static final ImmutableSet<Character> SOME_SAFE_SEPARATORS = ImmutableSet.of((Object)Character.valueOf('!'), (Object)Character.valueOf('$'), (Object)Character.valueOf('&'), (Object)Character.valueOf('\''), (Object)Character.valueOf('('), (Object)Character.valueOf(')'), (Object[])new Character[]{Character.valueOf('*'), Character.valueOf('+'), Character.valueOf(','), Character.valueOf(';'), Character.valueOf('='), Character.valueOf('#'), Character.valueOf('/')});
    public static final String NOT_A_SAFE_SEPARATOR_REGEX = "[^" + SOME_SAFE_SEPARATORS.stream().map(Object::toString).map(SafeSeparatorFragment::makeRegexSafe).collect(Collectors.joining()) + "]*";

    private SafeSeparatorFragment(String fragment, char separator) {
        this.fragment = fragment;
        this.separator = separator;
        this.components = TemplateParser.getComponents(fragment, true);
        if (this.components.isEmpty()) {
            this.prefix = "";
            this.suffix = "";
            this.hasPlaceholders = false;
        } else {
            Template.Component first = (Template.Component)this.components.get(0);
            this.prefix = first.isColumn() ? "" : first.getComponent();
            Template.Component last = (Template.Component)this.components.get(this.components.size() - 1);
            this.suffix = last.isColumn() ? "" : last.getComponent();
            this.hasPlaceholders = this.components.size() > 1 || first.isColumn();
        }
    }

    public String getFragment() {
        return this.fragment;
    }

    public char getSeparator() {
        return this.separator;
    }

    public ImmutableList<Template.Component> getComponents() {
        return this.components;
    }

    public String toString() {
        return this.fragment + (Serializable)(this.separator != '\u0000' ? Character.valueOf(this.separator) : "") + "(" + this.prefix + ":" + this.suffix + ")";
    }

    public static ImmutableList<SafeSeparatorFragment> split(String s) {
        ImmutableList.Builder builder = ImmutableList.builder();
        int start = 0;
        int end = SafeSeparatorFragment.firstIndexOfSafeSeparator(s, start);
        while (end != -1) {
            int next_end = end;
            while ((next_end = SafeSeparatorFragment.firstIndexOfSafeSeparator(s, next_end + 1)) == end + 1) {
                end = next_end;
            }
            builder.add((Object)new SafeSeparatorFragment(s.substring(start, end), s.charAt(end)));
            start = end + 1;
            end = next_end;
        }
        if (start < s.length()) {
            builder.add((Object)new SafeSeparatorFragment(s.substring(start), '\u0000'));
        }
        return builder.build();
    }

    private static int firstIndexOfSafeSeparator(String s, int start) {
        for (int i = start; i < s.length(); ++i) {
            if (!SOME_SAFE_SEPARATORS.contains((Object)Character.valueOf(s.charAt(i)))) continue;
            return i;
        }
        return -1;
    }

    private static boolean matchFragments(SafeSeparatorFragment subTemplate1, SafeSeparatorFragment subTemplate2) {
        if (subTemplate1.fragment.equals(subTemplate2.fragment)) {
            return true;
        }
        if (subTemplate1.hasPlaceholders && !subTemplate2.hasPlaceholders) {
            if (!subTemplate2.fragment.startsWith(subTemplate1.prefix)) {
                return false;
            }
            String remainder = subTemplate2.fragment.substring(subTemplate1.prefix.length());
            return remainder.endsWith(subTemplate1.suffix);
        }
        if (subTemplate2.hasPlaceholders && !subTemplate1.hasPlaceholders) {
            if (!subTemplate1.fragment.startsWith(subTemplate2.prefix)) {
                return false;
            }
            String remainder = subTemplate1.fragment.substring(subTemplate2.prefix.length());
            return remainder.endsWith(subTemplate2.suffix);
        }
        return !(!subTemplate1.prefix.startsWith(subTemplate2.prefix) && !subTemplate2.prefix.startsWith(subTemplate1.prefix) || !subTemplate1.suffix.startsWith(subTemplate2.suffix) && !subTemplate2.suffix.startsWith(subTemplate1.suffix));
    }

    public static boolean areCompatible(ImmutableList<SafeSeparatorFragment> fragments1, ImmutableList<SafeSeparatorFragment> fragments2) {
        if (fragments1 == fragments2) {
            return true;
        }
        return fragments1.size() == fragments2.size() && IntStream.range(0, fragments1.size()).allMatch(i -> ((SafeSeparatorFragment)fragments1.get(i)).getSeparator() == ((SafeSeparatorFragment)fragments2.get(i)).getSeparator()) && IntStream.range(0, fragments1.size()).allMatch(i -> SafeSeparatorFragment.matchFragments((SafeSeparatorFragment)fragments1.get(i), (SafeSeparatorFragment)fragments2.get(i)));
    }

    public static String makeRegexSafe(String s) {
        return TO_BE_ESCAPED.matcher(s).replaceAll("\\\\$0");
    }
}

