/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.term.functionsymbol.db.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.UnmodifiableIterator;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.model.template.Template;
import it.unibz.inf.ontop.model.template.impl.TemplateParser;
import it.unibz.inf.ontop.model.term.Constant;
import it.unibz.inf.ontop.model.term.DBConstant;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.IncrementalEvaluation;
import it.unibz.inf.ontop.model.term.NonNullConstant;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.functionsymbol.FunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBTypeConversionFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.ObjectStringTemplateFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.StringConstantDecomposer;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.AbstractEncodeURIorIRIFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.SafeSeparatorFragment;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.FunctionSymbolImpl;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.RDFDatatype;
import it.unibz.inf.ontop.model.type.TermType;
import it.unibz.inf.ontop.model.type.TermTypeInference;
import it.unibz.inf.ontop.model.type.TypeFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.R2RMLIRISafeEncoder;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public abstract class ObjectStringTemplateFunctionSymbolImpl
extends FunctionSymbolImpl
implements ObjectStringTemplateFunctionSymbol {
    private final DBTermType lexicalType;
    private final boolean isInjective;
    private final ImmutableList<Template.Component> components;
    private final ImmutableList<SafeSeparatorFragment> safeSeparatorFragments;
    private final AbstractEncodeURIorIRIFunctionSymbol.IRISafeEnDecoder enDecoder;
    private final Pattern patternForInteger;
    private final Pattern patternForDecimalFloat;
    private final Pattern patternForUuid;
    private @Nullable Pattern injectivePattern;

    protected ObjectStringTemplateFunctionSymbolImpl(ImmutableList<Template.Component> components, TypeFactory typeFactory) {
        this(components, "", typeFactory);
    }

    protected ObjectStringTemplateFunctionSymbolImpl(ImmutableList<Template.Component> components, String suffix, TypeFactory typeFactory) {
        super(ObjectStringTemplateFunctionSymbolImpl.getTemplateString(components) + suffix, ObjectStringTemplateFunctionSymbolImpl.createBaseTypes(components, typeFactory));
        this.lexicalType = typeFactory.getDBTypeFactory().getDBStringType();
        this.components = components;
        this.safeSeparatorFragments = SafeSeparatorFragment.split(TemplateParser.getEncodedTemplateString(components));
        this.isInjective = this.atMostOnePlaceholderPerSeparator(this.safeSeparatorFragments);
        this.enDecoder = new AbstractEncodeURIorIRIFunctionSymbol.IRISafeEnDecoder();
        this.patternForInteger = Pattern.compile("^[0-9]+$");
        this.patternForDecimalFloat = Pattern.compile("^[0-9.+\\-eE]+$");
        this.patternForUuid = Pattern.compile("^[0-9a-fA-F\\-]+$");
    }

    private boolean atMostOnePlaceholderPerSeparator(ImmutableList<SafeSeparatorFragment> safeSeparatorFragments) {
        return safeSeparatorFragments.stream().map(SafeSeparatorFragment::getComponents).allMatch(this::atMostOnePlaceholder);
    }

    private boolean atMostOnePlaceholder(ImmutableList<Template.Component> components) {
        return components.stream().filter(Template.Component::isColumn).count() <= 1L;
    }

    private static String getTemplateString(ImmutableList<Template.Component> components) {
        return components.stream().map(c -> c.isColumn() ? "{}" : c.getComponent()).collect(Collectors.joining());
    }

    private static ImmutableList<TermType> createBaseTypes(ImmutableList<Template.Component> components, TypeFactory typeFactory) {
        RDFDatatype stringType = typeFactory.getXsdStringDatatype();
        return (ImmutableList)components.stream().filter(Template.Component::isColumn).map(c -> stringType).collect(ImmutableCollectors.toList());
    }

    @Override
    public String getTemplate() {
        return this.getName();
    }

    @Override
    public ImmutableList<Template.Component> getTemplateComponents() {
        return this.components;
    }

    @Override
    public Optional<TermTypeInference> inferType(ImmutableList<? extends ImmutableTerm> terms) {
        if (terms.stream().anyMatch(ImmutableTerm::isNull)) {
            return Optional.empty();
        }
        return Optional.of(TermTypeInference.declareTermType(this.lexicalType));
    }

    @Override
    protected ImmutableTerm buildTermAfterEvaluation(ImmutableList<ImmutableTerm> newTerms, TermFactory termFactory, VariableNullability variableNullability) {
        if (newTerms.stream().allMatch(t -> t instanceof DBConstant)) {
            return this.simplifyWithAllParametersConstant(newTerms, termFactory, variableNullability);
        }
        return termFactory.getImmutableFunctionalTerm((FunctionSymbol)this, newTerms);
    }

    protected ImmutableTerm simplifyWithAllParametersConstant(ImmutableList<DBConstant> newTerms, TermFactory termFactory, VariableNullability variableNullability) {
        return termFactory.getDBConstant(this.buildString(newTerms, termFactory, variableNullability), this.lexicalType);
    }

    protected String buildString(ImmutableList<DBConstant> newTerms, TermFactory termFactory, VariableNullability variableNullability) {
        return this.components.stream().map(c -> c.isColumn() ? ObjectStringTemplateFunctionSymbolImpl.encodeParameter((DBConstant)newTerms.get(c.getIndex()), termFactory, variableNullability) : c.getComponent()).collect(Collectors.joining());
    }

    private static String encodeParameter(DBConstant constant, TermFactory termFactory, VariableNullability variableNullability) {
        return Optional.of(constant).map(termFactory::getR2RMLIRISafeEncodeFunctionalTerm).map(t -> t.simplify(variableNullability)).filter(t -> t instanceof DBConstant).map(t -> (DBConstant)t).map(Constant::getValue).orElseThrow(() -> new MinorOntopInternalBugException("Was expecting the getR2RMLIRISafeEncodeFunctionalTerm to simplify itself to a DBConstant when receiving a DBConstant"));
    }

    @Override
    public boolean isAlwaysInjectiveInTheAbsenceOfNonInjectiveFunctionalTerms() {
        return this.isInjective;
    }

    @Override
    protected boolean mayReturnNullWithoutNullArguments() {
        return false;
    }

    @Override
    protected boolean tolerateNulls() {
        return false;
    }

    @Override
    public boolean canBePostProcessed(ImmutableList<? extends ImmutableTerm> arguments) {
        return true;
    }

    @Override
    public String getNativeDBString(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        ImmutableList termsToConcatenate = (ImmutableList)this.components.stream().map(c -> c.isColumn() ? termFactory.getR2RMLIRISafeEncodeFunctionalTerm((ImmutableTerm)terms.get(c.getIndex())).simplify() : termFactory.getDBStringConstant(c.getComponent())).collect(ImmutableCollectors.toList());
        DBConstant concatTerm = termsToConcatenate.isEmpty() ? termFactory.getDBStringConstant("") : (termsToConcatenate.size() == 1 ? (ImmutableTerm)termsToConcatenate.get(0) : termFactory.getNullRejectingDBConcatFunctionalTerm((ImmutableList<? extends ImmutableTerm>)termsToConcatenate).simplify());
        return termConverter.apply(concatTerm);
    }

    @Override
    protected IncrementalEvaluation evaluateStrictEqWithFunctionalTerm(ImmutableList<? extends ImmutableTerm> terms, ImmutableFunctionalTerm otherTerm, TermFactory termFactory, VariableNullability variableNullability) {
        FunctionSymbol otherFunctionSymbol = otherTerm.getFunctionSymbol();
        if (otherFunctionSymbol instanceof ObjectStringTemplateFunctionSymbolImpl) {
            ObjectStringTemplateFunctionSymbolImpl other = (ObjectStringTemplateFunctionSymbolImpl)otherFunctionSymbol;
            if (!SafeSeparatorFragment.areCompatible(this.safeSeparatorFragments, other.safeSeparatorFragments)) {
                Optional<ImmutableExpression> newExpression = termFactory.getDisjunction(Stream.concat(terms.stream(), otherTerm.getTerms().stream()).map(termFactory::getDBIsNull)).map(e -> termFactory.getFalseOrNullFunctionalTerm((ImmutableList<ImmutableExpression>)ImmutableList.of((Object)e)));
                return newExpression.map(e -> e.evaluate(variableNullability, true)).orElseGet(IncrementalEvaluation::declareIsFalse);
            }
            if (!other.equals(this)) {
                return this.tryToSimplifyCompatibleTemplates(other, terms, otherTerm, termFactory, variableNullability);
            }
        }
        return super.evaluateStrictEqWithFunctionalTerm(terms, otherTerm, termFactory, variableNullability);
    }

    private IncrementalEvaluation tryToSimplifyCompatibleTemplates(ObjectStringTemplateFunctionSymbolImpl other, ImmutableList<? extends ImmutableTerm> subTerms, ImmutableFunctionalTerm otherTerm, TermFactory termFactory, VariableNullability variableNullability) {
        UnmodifiableIterator subTermIterator = subTerms.iterator();
        UnmodifiableIterator otherSubTermIterator = otherTerm.getTerms().iterator();
        ImmutableList expressions = (ImmutableList)IntStream.range(0, this.safeSeparatorFragments.size()).mapToObj(i -> this.convertToEquality((SafeSeparatorFragment)this.safeSeparatorFragments.get(i), (UnmodifiableIterator<? extends ImmutableTerm>)subTermIterator, (SafeSeparatorFragment)other.safeSeparatorFragments.get(i), (UnmodifiableIterator<? extends ImmutableTerm>)otherSubTermIterator, termFactory)).filter(Optional::isPresent).map(Optional::get).collect(ImmutableCollectors.toList());
        if (!expressions.isEmpty()) {
            ImmutableExpression nonNull = termFactory.getDBIsNotNull(Stream.concat(subTerms.stream(), otherTerm.getTerms().stream())).orElseThrow(() -> new MinorOntopInternalBugException("cannot be empty because there is at least one variable in the templates (taken together)"));
            ImmutableExpression ifElseNull = termFactory.getBooleanIfElseNull(nonNull, termFactory.getConjunction((ImmutableList<ImmutableExpression>)expressions));
            return ifElseNull.evaluate(variableNullability, true);
        }
        return IncrementalEvaluation.declareIsTrue();
    }

    private Optional<ImmutableExpression> convertToEquality(SafeSeparatorFragment safeSeparatorFragment, UnmodifiableIterator<? extends ImmutableTerm> subTermIterator, SafeSeparatorFragment otherSafeSeparatorFragment, UnmodifiableIterator<? extends ImmutableTerm> otherSubTermIterator, TermFactory termFactory) {
        ImmutableList<Template.Component> components = safeSeparatorFragment.getComponents();
        ImmutableList<Template.Component> otherComponents = otherSafeSeparatorFragment.getComponents();
        if (!((Template.Component)components.get(0)).isColumn() && !((Template.Component)otherComponents.get(0)).isColumn()) {
            String otherFirst;
            String first = ((Template.Component)components.get(0)).getComponent();
            if (first.startsWith(otherFirst = ((Template.Component)otherComponents.get(0)).getComponent())) {
                components = Template.replaceFirst(components, first.substring(otherFirst.length()));
                otherComponents = Template.replaceFirst(otherComponents, "");
            } else if (otherFirst.startsWith(first)) {
                components = Template.replaceFirst(components, "");
                otherComponents = Template.replaceFirst(otherComponents, otherFirst.substring(first.length()));
            } else {
                return Optional.of(termFactory.getIsTrue(termFactory.getDBBooleanConstant(false)));
            }
            if (components.isEmpty() && otherComponents.isEmpty()) {
                return Optional.empty();
            }
        }
        if (components.size() > 0 && !((Template.Component)components.get(components.size() - 1)).isColumn() && otherComponents.size() > 0 && !((Template.Component)otherComponents.get(otherComponents.size() - 1)).isColumn()) {
            String otherLast;
            String last = ((Template.Component)components.get(components.size() - 1)).getComponent();
            if (last.endsWith(otherLast = ((Template.Component)otherComponents.get(otherComponents.size() - 1)).getComponent())) {
                components = Template.replaceLast(components, last.substring(0, last.length() - otherLast.length()));
                otherComponents = Template.replaceLast(otherComponents, "");
            } else if (otherLast.endsWith(last)) {
                components = Template.replaceLast(components, "");
                otherComponents = Template.replaceLast(otherComponents, otherLast.substring(0, otherLast.length() - last.length()));
            } else {
                return Optional.of(termFactory.getIsTrue(termFactory.getDBBooleanConstant(false)));
            }
            if (components.isEmpty() && otherComponents.isEmpty()) {
                return Optional.empty();
            }
        }
        return Optional.of(termFactory.getStrictEquality(this.convertIntoTerm(components, subTermIterator, termFactory), this.convertIntoTerm(otherComponents, otherSubTermIterator, termFactory), new ImmutableTerm[0]));
    }

    private ImmutableTerm convertIntoTerm(ImmutableList<Template.Component> components, UnmodifiableIterator<? extends ImmutableTerm> subTermIterator, TermFactory termFactory) {
        ImmutableList args = (ImmutableList)components.stream().map(c -> c.isColumn() ? (ImmutableTerm)subTermIterator.next() : termFactory.getDBStringConstant(this.enDecoder.decode(c.getComponent()))).collect(ImmutableCollectors.toList());
        switch (args.size()) {
            case 0: {
                return termFactory.getDBStringConstant("");
            }
            case 1: {
                return (ImmutableTerm)args.get(0);
            }
        }
        return termFactory.getNullRejectingDBConcatFunctionalTerm((ImmutableList<? extends ImmutableTerm>)args);
    }

    @Override
    protected FunctionSymbolImpl.Decomposability testDecomposabilityIntoConjunction(ImmutableList<? extends ImmutableTerm> terms, VariableNullability variableNullability, ImmutableList<? extends ImmutableTerm> otherTerms) {
        if (this.isAlwaysInjectiveInTheAbsenceOfNonInjectiveFunctionalTerms()) {
            return this.testDecomposabilityIntoConjunctionWhenInjective(terms, variableNullability, otherTerms);
        }
        ImmutableSet columnPositions = (ImmutableSet)IntStream.range(0, this.components.size()).filter(i -> ((Template.Component)this.components.get(i)).isColumn()).boxed().collect(ImmutableCollectors.toSet());
        if (columnPositions.stream().anyMatch(i -> columnPositions.contains((Object)(i + 1)))) {
            return FunctionSymbolImpl.Decomposability.CANNOT_BE_DECOMPOSED;
        }
        ImmutableSet separatorPositions = (ImmutableSet)IntStream.range(0, this.components.size()).filter(i -> !((Template.Component)this.components.get(i)).isColumn()).boxed().collect(ImmutableCollectors.toSet());
        if (IntStream.range(0, this.components.size() - 1).anyMatch(i -> separatorPositions.contains((Object)i) && separatorPositions.contains((Object)(i + 1)))) {
            return FunctionSymbolImpl.Decomposability.CANNOT_BE_DECOMPOSED;
        }
        if (separatorPositions.stream().filter(i -> columnPositions.contains((Object)(i - 1)) && columnPositions.contains((Object)(i + 1))).allMatch(i -> this.isSafelySeparating((int)i, terms, otherTerms))) {
            return this.testDecomposabilityIntoConjunctionWhenInjective(terms, variableNullability, otherTerms);
        }
        return FunctionSymbolImpl.Decomposability.CANNOT_BE_DECOMPOSED;
    }

    private boolean isSafelySeparating(int separatorIndex, ImmutableList<? extends ImmutableTerm> terms, ImmutableList<? extends ImmutableTerm> otherTerms) {
        String separatorString = ((Template.Component)this.components.get(separatorIndex)).getComponent();
        if (separatorString.isEmpty()) {
            return false;
        }
        int previousTermIndex = ((Template.Component)this.components.get(separatorIndex - 1)).getIndex();
        int nextTermIndex = ((Template.Component)this.components.get(separatorIndex + 1)).getIndex();
        return Stream.of((ImmutableTerm)terms.get(previousTermIndex), (ImmutableTerm)otherTerms.get(previousTermIndex)).anyMatch(t -> !this.couldContain((ImmutableTerm)t, separatorString, true)) || Stream.of((ImmutableTerm)terms.get(nextTermIndex), (ImmutableTerm)otherTerms.get(nextTermIndex)).anyMatch(t -> !this.couldContain((ImmutableTerm)t, separatorString, false));
    }

    private boolean couldContain(ImmutableTerm term, String separatorString, boolean isTermBefore) {
        if (term instanceof Variable) {
            return true;
        }
        if (term instanceof Constant) {
            Constant constant = (Constant)term;
            return term.isNull() || (isTermBefore ? constant.getValue().endsWith(separatorString) : constant.getValue().startsWith(separatorString));
        }
        ImmutableFunctionalTerm functionalTerm = (ImmutableFunctionalTerm)term;
        FunctionSymbol functionSymbol = functionalTerm.getFunctionSymbol();
        if (functionSymbol instanceof DBTypeConversionFunctionSymbol) {
            boolean isSafelySeparating = ((DBTypeConversionFunctionSymbol)functionSymbol).getInputType().filter(t -> {
                switch (t.getCategory()) {
                    case INTEGER: {
                        return !this.patternForInteger.matcher(separatorString).find();
                    }
                    case DECIMAL: 
                    case FLOAT_DOUBLE: {
                        return !this.patternForDecimalFloat.matcher(separatorString).find();
                    }
                    case UUID: {
                        return !this.patternForUuid.matcher(separatorString).find();
                    }
                }
                return false;
            }).isPresent();
            return !isSafelySeparating;
        }
        return true;
    }

    private Pattern getPattern() {
        if (this.injectivePattern == null) {
            String patternString = this.components.stream().map(c -> c.isColumn() ? "(" + SafeSeparatorFragment.NOT_A_SAFE_SEPARATOR_REGEX + ")" : SafeSeparatorFragment.makeRegexSafe(c.getComponent())).collect(Collectors.joining());
            this.injectivePattern = Pattern.compile("^" + patternString + "$");
        }
        return this.injectivePattern;
    }

    @Override
    protected IncrementalEvaluation evaluateStrictEqWithNonNullConstant(ImmutableList<? extends ImmutableTerm> terms, NonNullConstant otherTerm, TermFactory termFactory, VariableNullability variableNullability) {
        String otherValue = otherTerm.getValue();
        if (this.isInjective(terms, variableNullability, termFactory)) {
            Matcher matcher = this.getPattern().matcher(otherTerm.getValue());
            if (matcher.find()) {
                ImmutableExpression newExpression = termFactory.getConjunction((ImmutableList<ImmutableExpression>)((ImmutableList)IntStream.range(0, this.getArity()).mapToObj(i -> termFactory.getStrictEquality(termFactory.getR2RMLIRISafeEncodeFunctionalTerm((ImmutableTerm)terms.get(i)), termFactory.getDBStringConstant(matcher.group(i + 1)), new ImmutableTerm[0])).collect(ImmutableCollectors.toList())));
                return newExpression.evaluate(variableNullability, true);
            }
            return IncrementalEvaluation.declareIsFalse();
        }
        if (!SafeSeparatorFragment.areCompatible(this.safeSeparatorFragments, SafeSeparatorFragment.split(otherValue))) {
            return termFactory.getFalseOrNullFunctionalTerm((ImmutableList<ImmutableExpression>)((ImmutableList)terms.stream().map(termFactory::getDBIsNotNull).collect(ImmutableCollectors.toList()))).evaluate(variableNullability, true);
        }
        return super.evaluateStrictEqWithNonNullConstant(terms, otherTerm, termFactory, variableNullability);
    }

    @Override
    public Optional<StringConstantDecomposer> getDecomposer(ImmutableList<? extends ImmutableTerm> terms, TermFactory termFactory, VariableNullability variableNullability) {
        if (this.isInjective(terms, variableNullability, termFactory)) {
            Pattern pattern = this.getPattern();
            return Optional.of(cst -> {
                Matcher matcher = pattern.matcher(cst.getValue());
                if (matcher.find()) {
                    return Optional.of((ImmutableList)IntStream.range(0, this.getArity()).mapToObj(i -> termFactory.getDBStringConstant(R2RMLIRISafeEncoder.decode(matcher.group(i + 1)))).collect(ImmutableCollectors.toList()));
                }
                return Optional.empty();
            });
        }
        return Optional.empty();
    }

    @Override
    public boolean isPreferringToBePostProcessedOverBeingBlocked() {
        return true;
    }
}

