/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.term.functionsymbol.db.impl;

import com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.IncrementalEvaluation;
import it.unibz.inf.ontop.model.term.NonNullConstant;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBFunctionSymbolSerializer;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DefaultSimpleDBCastFunctionSymbol;
import it.unibz.inf.ontop.model.type.DBTermType;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

public class DefaultCastIntegerToStringFunctionSymbol
extends DefaultSimpleDBCastFunctionSymbol {
    private final @Nonnull DBTermType inputType;
    private final Pattern pattern;

    protected DefaultCastIntegerToStringFunctionSymbol(@Nonnull DBTermType inputType, DBTermType dbStringType, DBFunctionSymbolSerializer serializer) {
        super(inputType, dbStringType, serializer);
        this.inputType = inputType;
        if (inputType.isAbstract()) {
            throw new IllegalArgumentException("Was expecting a concrete input type");
        }
        this.pattern = Pattern.compile("^([0+]|-0)\\d+");
    }

    @Override
    protected boolean checkValueValidityForDecomposition(String value) {
        return !this.pattern.matcher(value).matches() && super.checkValueValidityForDecomposition(value);
    }

    @Override
    protected IncrementalEvaluation evaluateStrictEqWithNonNullConstant(ImmutableList<? extends ImmutableTerm> terms, NonNullConstant otherTerm, TermFactory termFactory, VariableNullability variableNullability) {
        String otherValue = otherTerm.getValue();
        if (this.pattern.matcher(otherValue).matches() && this.inputType.isValidLexicalValue(otherValue).filter(b -> b).isPresent()) {
            return IncrementalEvaluation.declareSameExpression();
        }
        return this.perform2ndStepEvaluationStrictEqWithConstant(terms, otherValue, termFactory, variableNullability);
    }
}

