/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.term.functionsymbol.db.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.IncrementalEvaluation;
import it.unibz.inf.ontop.model.term.NonNullConstant;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.AbstractArgDependentTypedDBFunctionSymbol;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.TermType;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class DBIntIndexFunctionSymbolImpl
extends AbstractArgDependentTypedDBFunctionSymbol {
    protected DBIntIndexFunctionSymbolImpl(DBTermType dbIntegerType, DBTermType rootDBType, int nbEntries) {
        super("DB_IDX_" + nbEntries, (ImmutableList<TermType>)((ImmutableList)Stream.concat(Stream.of(dbIntegerType), IntStream.range(0, nbEntries).mapToObj(i -> rootDBType)).collect(ImmutableCollectors.toList())));
        if (nbEntries == 0) {
            throw new IllegalArgumentException("nbEntries must be positive");
        }
    }

    @Override
    protected boolean tolerateNulls() {
        return true;
    }

    @Override
    protected boolean mayReturnNullWithoutNullArguments() {
        return false;
    }

    @Override
    protected Stream<? extends ImmutableTerm> extractPossibleValues(ImmutableList<? extends ImmutableTerm> terms) {
        return IntStream.range(2, terms.size()).filter(i -> i % 2 == 0).mapToObj(arg_0 -> terms.get(arg_0));
    }

    @Override
    public boolean isPreferringToBePostProcessedOverBeingBlocked() {
        return true;
    }

    @Override
    public ImmutableTerm simplify(ImmutableList<? extends ImmutableTerm> terms, TermFactory termFactory, VariableNullability variableNullability) {
        ImmutableTerm idTerm = ((ImmutableTerm)terms.get(0)).simplify(variableNullability);
        if (idTerm instanceof NonNullConstant) {
            NonNullConstant constant = (NonNullConstant)idTerm;
            if (!constant.getType().equals(termFactory.getTypeFactory().getDBTypeFactory().getDBLargeIntegerType())) {
                throw new MinorOntopInternalBugException("The idTerm was expecting to a be an integer");
            }
            int index = Integer.parseInt(constant.getValue()) + 1;
            if (index < 0 || index >= this.getArity()) {
                throw new MinorOntopInternalBugException("Invalid index in idTerm");
            }
            return ((ImmutableTerm)terms.get(index)).simplify(variableNullability);
        }
        return super.simplify(terms, termFactory, variableNullability);
    }

    @Override
    public String getNativeDBString(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        ImmutableTerm subTerm = (ImmutableTerm)terms.get(0);
        ImmutableFunctionalTerm caseTerm = termFactory.getDBCase(IntStream.range(0, this.getArity() - 1).mapToObj(i -> Maps.immutableEntry((Object)termFactory.getStrictEquality(subTerm, termFactory.getDBIntegerConstant(i), new ImmutableTerm[0]), (Object)((ImmutableTerm)terms.get(i + 1)))), termFactory.getNullConstant(), false);
        return termConverter.apply(caseTerm);
    }

    @Override
    public boolean isAlwaysInjectiveInTheAbsenceOfNonInjectiveFunctionalTerms() {
        return false;
    }

    @Override
    public boolean canBePostProcessed(ImmutableList<? extends ImmutableTerm> arguments) {
        return true;
    }

    @Override
    public IncrementalEvaluation evaluateStrictEq(ImmutableList<? extends ImmutableTerm> terms, ImmutableTerm otherTerm, TermFactory termFactory, VariableNullability variableNullability) {
        ImmutableTerm indexTerm = (ImmutableTerm)terms.get(0);
        if (otherTerm instanceof ImmutableFunctionalTerm && this.equals(((ImmutableFunctionalTerm)otherTerm).getFunctionSymbol()) && ((ImmutableFunctionalTerm)otherTerm).getTerm(0).equals(indexTerm)) {
            ImmutableList<? extends ImmutableTerm> otherTerms = ((ImmutableFunctionalTerm)otherTerm).getTerms();
            ImmutableExpression disjunction = termFactory.getDisjunction(IntStream.range(1, this.getArity()).mapToObj(i -> termFactory.getConjunction(termFactory.getStrictEquality(indexTerm, termFactory.getDBIntegerConstant(i), new ImmutableTerm[0]), termFactory.getStrictEquality((ImmutableTerm)terms.get(i), (ImmutableTerm)otherTerms.get(i + 1), new ImmutableTerm[0])))).orElseThrow(() -> new MinorOntopInternalBugException("Arity > 1 was expected"));
            return disjunction.evaluate(variableNullability, true);
        }
        return super.evaluateStrictEq(terms, otherTerm, termFactory, variableNullability);
    }
}

