/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.term.functionsymbol.db.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.IncrementalEvaluation;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DBBooleanFunctionSymbolImpl;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.TermType;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public abstract class AbstractDBStrictEqNeqFunctionSymbol
extends DBBooleanFunctionSymbolImpl {
    private final boolean isEq;

    protected AbstractDBStrictEqNeqFunctionSymbol(String name, int arity, boolean isEq, TermType rootTermType, DBTermType dbBooleanTermType) {
        super(name + arity, (ImmutableList<TermType>)((ImmutableList)IntStream.range(0, arity).mapToObj(i -> rootTermType).collect(ImmutableCollectors.toList())), dbBooleanTermType);
        this.isEq = isEq;
    }

    @Override
    public boolean isAlwaysInjectiveInTheAbsenceOfNonInjectiveFunctionalTerms() {
        return false;
    }

    @Override
    public boolean canBePostProcessed(ImmutableList<? extends ImmutableTerm> arguments) {
        return true;
    }

    @Override
    public boolean shouldBeDecomposedInUnion() {
        return false;
    }

    @Override
    protected ImmutableTerm buildTermAfterEvaluation(ImmutableList<ImmutableTerm> newTerms, TermFactory termFactory, VariableNullability variableNullability) {
        if (newTerms.size() < 2) {
            throw new IllegalArgumentException("newTerms must have at least two elements");
        }
        Optional<ImmutableTerm> optionalLifted = this.tryToLiftIfThenTerm(newTerms, termFactory, variableNullability);
        if (optionalLifted.isPresent()) {
            return optionalLifted.get();
        }
        ImmutableSet nonNullTerms = (ImmutableSet)newTerms.stream().filter(t -> !t.isNull()).collect(ImmutableCollectors.toSet());
        if (newTerms.stream().anyMatch(ImmutableTerm::isNull)) {
            if (nonNullTerms.size() <= 1) {
                return termFactory.getNullConstant();
            }
            ImmutableExpression newExpression = this.isEq ? termFactory.getFalseOrNullFunctionalTerm((ImmutableList<ImmutableExpression>)ImmutableList.of((Object)termFactory.getStrictEquality((ImmutableSet<ImmutableTerm>)nonNullTerms))) : termFactory.getTrueOrNullFunctionalTerm((ImmutableList<ImmutableExpression>)ImmutableList.of((Object)termFactory.getStrictNEquality((ImmutableSet<ImmutableTerm>)nonNullTerms)));
            return newExpression.simplify(variableNullability);
        }
        if (nonNullTerms.size() == 1) {
            ImmutableTerm nonNullTerm = (ImmutableTerm)nonNullTerms.iterator().next();
            return this.isEq ? termFactory.getTrueOrNullFunctionalTerm((ImmutableList<ImmutableExpression>)ImmutableList.of((Object)termFactory.getDBIsNotNull(nonNullTerm))).simplify(variableNullability) : termFactory.getFalseOrNullFunctionalTerm((ImmutableList<ImmutableExpression>)ImmutableList.of((Object)termFactory.getDBIsNull(nonNullTerm))).simplify(variableNullability);
        }
        return this.simplifyNonNullTerms((ImmutableList<ImmutableTerm>)ImmutableList.copyOf((Collection)nonNullTerms), termFactory, variableNullability);
    }

    private ImmutableTerm simplifyNonNullTerms(ImmutableList<ImmutableTerm> nonNullTerms, TermFactory termFactory, VariableNullability variableNullability) {
        ImmutableSet.Builder remainingTermBuilder = ImmutableSet.builder();
        ImmutableSet.Builder otherExpressionBuilder = ImmutableSet.builder();
        int size = nonNullTerms.size();
        for (int i = 0; i < size; ++i) {
            ImmutableTerm term = (ImmutableTerm)nonNullTerms.get(i);
            boolean keepTerm = true;
            block8: for (int j = i + 1; j < size && keepTerm; ++j) {
                ImmutableTerm otherTerm = (ImmutableTerm)nonNullTerms.get(j);
                IncrementalEvaluation evaluation = term.evaluateStrictEq(otherTerm, variableNullability);
                switch (evaluation.getStatus()) {
                    case SAME_EXPRESSION: {
                        continue block8;
                    }
                    case SIMPLIFIED_EXPRESSION: {
                        otherExpressionBuilder.add((Object)evaluation.getNewExpression().get());
                        keepTerm = false;
                        continue block8;
                    }
                    case IS_NULL: {
                        throw new MinorOntopInternalBugException("Was not expected an equality to be evaluated as NULL as both arguments were supposed to be non-nulls.\n Non-null terms: " + nonNullTerms);
                    }
                    case IS_FALSE: {
                        return termFactory.getDBBooleanConstant(!this.isEq);
                    }
                    case IS_TRUE: {
                        keepTerm = false;
                    }
                }
            }
            if (!keepTerm) continue;
            remainingTermBuilder.add((Object)term);
        }
        ImmutableSet remainingTerms = remainingTermBuilder.build();
        ImmutableSet otherExpressions = otherExpressionBuilder.build();
        if (remainingTerms.size() < 2) {
            return otherExpressions.isEmpty() ? termFactory.getDBBooleanConstant(this.isEq) : this.combineExpressions(otherExpressions.stream(), termFactory);
        }
        return this.combineExpressions(Stream.concat(Stream.of(termFactory.getStrictEquality((ImmutableSet<ImmutableTerm>)remainingTerms)), otherExpressions.stream()), termFactory);
    }

    private ImmutableExpression combineExpressions(Stream<ImmutableExpression> expressions, TermFactory termFactory) {
        return termFactory.getConjunction(expressions).map(c -> this.isEq ? c : c.negate(termFactory)).orElseThrow(() -> new IllegalArgumentException("expressions must not be empty"));
    }

    @Override
    public boolean blocksNegation() {
        return false;
    }

    @Override
    protected boolean tolerateNulls() {
        return this.getArity() > 2;
    }

    @Override
    public IncrementalEvaluation evaluateIsNotNull(ImmutableList<? extends ImmutableTerm> terms, TermFactory termFactory, VariableNullability variableNullability) {
        if (this.getArity() <= 2) {
            return super.evaluateIsNotNull(terms, termFactory, variableNullability);
        }
        return IncrementalEvaluation.declareSameExpression();
    }
}

