/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.template.impl;

import com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.model.template.Template;
import it.unibz.inf.ontop.model.template.impl.AbstractTemplateFactory;
import it.unibz.inf.ontop.model.template.impl.TemplateParser;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.NonVariableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBConcatFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBTypeConversionFunctionSymbol;
import it.unibz.inf.ontop.model.type.RDFDatatype;
import it.unibz.inf.ontop.model.type.TypeFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.rdf.api.IRI;

public class LiteralTemplateFactory
extends AbstractTemplateFactory {
    private final TypeFactory typeFactory;

    public LiteralTemplateFactory(TermFactory termFactory, TypeFactory typeFactory) {
        super(termFactory);
        this.typeFactory = typeFactory;
    }

    public Optional<RDFDatatype> extractDatatype(Optional<String> lang, Optional<IRI> iri) {
        Optional<RDFDatatype> datatype = lang.filter(tag -> !tag.isEmpty()).map(this.typeFactory::getLangTermType);
        return datatype.isPresent() ? datatype : iri.map(this.typeFactory::getDatatype);
    }

    public RDFDatatype getDatatype(IRI datatype) {
        return this.typeFactory.getDatatype(datatype);
    }

    public RDFDatatype getAbstractRDFSLiteral() {
        return this.typeFactory.getAbstractRDFSLiteral();
    }

    @Override
    public NonVariableTerm getConstant(String constant) {
        return this.termFactory.getDBStringConstant(constant);
    }

    @Override
    public ImmutableFunctionalTerm getColumn(String column) {
        return this.getVariable(column);
    }

    @Override
    public NonVariableTerm getTemplateTerm(ImmutableList<Template.Component> components) {
        switch (components.size()) {
            case 0: {
                return this.getConstant("");
            }
            case 1: {
                return this.templateComponentToTerm((Template.Component)components.get(0));
            }
        }
        return this.termFactory.getNullRejectingDBConcatFunctionalTerm((ImmutableList<? extends ImmutableTerm>)((ImmutableList)components.stream().map(this::templateComponentToTerm).collect(ImmutableCollectors.toList())));
    }

    @Override
    public String serializeTemplateTerm(ImmutableFunctionalTerm functionalTerm) {
        if (functionalTerm.getFunctionSymbol() instanceof DBConcatFunctionSymbol) {
            return functionalTerm.getTerms().stream().map(DBTypeConversionFunctionSymbol::uncast).map(TemplateParser::termToTemplateComponentString).collect(Collectors.joining());
        }
        throw new IllegalArgumentException("Invalid term type (DBConcat is expected): " + functionalTerm);
    }
}

