/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.request.impl;

import com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.iq.request.DefinitionPushDownRequest;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.substitution.Substitution;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Objects;
import java.util.stream.Stream;

public class DefPushDownRequestImpl
implements DefinitionPushDownRequest {
    private final Variable newVariable;
    private final ImmutableTerm definition;
    private final ImmutableExpression condition;

    public DefPushDownRequestImpl(Variable newVariable, ImmutableTerm definition, ImmutableExpression condition) {
        this.newVariable = newVariable;
        this.definition = definition;
        this.condition = condition;
    }

    @Override
    public Variable getNewVariable() {
        return this.newVariable;
    }

    @Override
    public ImmutableTerm getDefinitionWhenConditionSatisfied() {
        return this.definition;
    }

    @Override
    public ImmutableExpression getCondition() {
        return this.condition;
    }

    @Override
    public ImmutableSet<Variable> getDefinitionAndConditionVariables() {
        return (ImmutableSet)Stream.concat(this.definition.getVariableStream(), this.condition.getVariableStream()).collect(ImmutableCollectors.toSet());
    }

    @Override
    public DefinitionPushDownRequest newRequest(Substitution<? extends ImmutableTerm> substitution) {
        return new DefPushDownRequestImpl(this.newVariable, substitution.applyToTerm(this.definition), substitution.apply(this.condition));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefinitionPushDownRequest)) {
            return false;
        }
        DefinitionPushDownRequest that = (DefinitionPushDownRequest)o;
        return Objects.equals(this.newVariable, that.getNewVariable()) && Objects.equals(this.definition, that.getDefinitionWhenConditionSatisfied()) && Objects.equals(this.condition, that.getCondition());
    }

    public int hashCode() {
        return Objects.hash(this.newVariable, this.definition, this.condition);
    }
}

