/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.node.normalization.impl;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import it.unibz.inf.ontop.injection.CoreSingletons;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.UnaryIQTree;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Optional;
import java.util.Set;

@Singleton
public class RightProvenanceNormalizer {
    public static final String PROV = "prov";
    private final IntermediateQueryFactory iqFactory;
    private final SubstitutionFactory substitutionFactory;
    private final TermFactory termFactory;

    @Inject
    protected RightProvenanceNormalizer(CoreSingletons coreSingletons) {
        this.iqFactory = coreSingletons.getIQFactory();
        this.substitutionFactory = coreSingletons.getSubstitutionFactory();
        this.termFactory = coreSingletons.getTermFactory();
    }

    public RightProvenance normalizeRightProvenance(IQTree rightTree, ImmutableSet<Variable> leftVariables, Optional<ImmutableExpression> leftJoinExpression, VariableGenerator variableGenerator) {
        ImmutableSet<Variable> rightVariables = rightTree.getVariables();
        VariableNullability rightNullability = leftJoinExpression.flatMap(e -> this.termFactory.getConjunction(e.flattenAND().filter(e1 -> rightVariables.containsAll(e1.getVariables())))).map(e -> this.iqFactory.createUnaryIQTree(this.iqFactory.createFilterNode((ImmutableExpression)e), rightTree)).orElse(rightTree).getVariableNullability();
        return this.normalizeRightProvenance(rightTree, leftVariables, rightTree.getVariables(), variableGenerator, rightNullability);
    }

    public RightProvenance normalizeRightProvenance(IQTree rightTree, ImmutableSet<Variable> leftVariables, ImmutableSet<Variable> rightRequiredVariables, VariableGenerator variableGenerator) {
        return this.normalizeRightProvenance(rightTree, leftVariables, rightRequiredVariables, variableGenerator, rightTree.getVariableNullability());
    }

    private RightProvenance normalizeRightProvenance(IQTree rightTree, ImmutableSet<Variable> leftVariables, ImmutableSet<Variable> rightRequiredVariables, VariableGenerator variableGenerator, VariableNullability rightNullability) {
        ImmutableSet<Variable> rightVariables = rightTree.getVariables();
        Optional<Variable> nonNullableRightVariable = rightVariables.stream().filter(v -> !leftVariables.contains(v)).filter(v -> !rightNullability.isPossiblyNullable((Variable)v)).findFirst();
        return nonNullableRightVariable.map(variable -> new RightProvenance((Variable)variable, rightTree)).orElseGet(() -> this.createProvenanceInConstructionNode(rightTree, rightRequiredVariables, variableGenerator));
    }

    private RightProvenance createProvenanceInConstructionNode(IQTree rightTree, ImmutableSet<Variable> rightRequiredVariables, VariableGenerator variableGenerator) {
        Variable provenanceVariable = variableGenerator.generateNewVariable(PROV);
        ImmutableSet newRightProjectedVariables = Sets.union((Set)ImmutableSet.of((Object)provenanceVariable), rightRequiredVariables).immutableCopy();
        ConstructionNode newRightConstructionNode = this.iqFactory.createConstructionNode((ImmutableSet<Variable>)newRightProjectedVariables, this.substitutionFactory.getSubstitution(provenanceVariable, this.termFactory.getProvenanceSpecialConstant()));
        UnaryIQTree newRightTree = this.iqFactory.createUnaryIQTree(newRightConstructionNode, rightTree);
        return new RightProvenance(provenanceVariable, newRightTree);
    }

    public static class RightProvenance {
        private final Variable variable;
        private final IQTree rightTree;

        protected RightProvenance(Variable provenanceVariable, IQTree rightTree) {
            this.variable = provenanceVariable;
            this.rightTree = rightTree;
        }

        public Variable getProvenanceVariable() {
            return this.variable;
        }

        public IQTree getRightTree() {
            return this.rightTree;
        }
    }
}

