/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.node.normalization.impl;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.IQTreeCache;
import it.unibz.inf.ontop.iq.UnaryIQTree;
import it.unibz.inf.ontop.iq.impl.IQTreeTools;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.DistinctNode;
import it.unibz.inf.ontop.iq.node.EmptyNode;
import it.unibz.inf.ontop.iq.node.OrderByNode;
import it.unibz.inf.ontop.iq.node.QueryNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.iq.node.normalization.OrderByNormalizer;
import it.unibz.inf.ontop.model.term.NonGroundTerm;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Optional;
import java.util.stream.Stream;

public class OrderByNormalizerImpl
implements OrderByNormalizer {
    private static final int MAX_ITERATIONS = 1000;
    private final IntermediateQueryFactory iqFactory;
    private final IQTreeTools iqTreeTools;

    @Inject
    private OrderByNormalizerImpl(IntermediateQueryFactory iqFactory, IQTreeTools iqTreeTools) {
        this.iqFactory = iqFactory;
        this.iqTreeTools = iqTreeTools;
    }

    @Override
    public IQTree normalizeForOptimization(OrderByNode orderByNode, IQTree child, VariableGenerator variableGenerator, IQTreeCache treeCache) {
        Optional<OrderByNode> simplifiedOrderByNode = this.simplifyOrderByNode(orderByNode, child.getVariableNullability());
        if (!simplifiedOrderByNode.isPresent()) {
            return child.normalizeForOptimization(variableGenerator);
        }
        State state = new State(simplifiedOrderByNode.get(), child, variableGenerator);
        for (int i = 0; i < 1000; ++i) {
            State newState = state.liftChild();
            if (newState.hasConverged(state)) {
                return newState.createNormalizedTree(variableGenerator, treeCache);
            }
            state = newState;
        }
        throw new MinorOntopInternalBugException("OrderByNormalizerImpl.normalizeForOptimization has not converged after 1000 iterations");
    }

    private Optional<OrderByNode> simplifyOrderByNode(OrderByNode orderByNode, VariableNullability variableNullability) {
        ImmutableList newComparators = (ImmutableList)orderByNode.getComparators().stream().flatMap(c -> Stream.of(c.getTerm()).map(t -> t.simplify(variableNullability)).filter(t -> t instanceof NonGroundTerm).map(t -> (NonGroundTerm)t).map(t -> this.iqFactory.createOrderComparator((NonGroundTerm)t, c.isAscending()))).collect(ImmutableCollectors.toList());
        return Optional.of(newComparators).filter(cs -> !cs.isEmpty()).map(this.iqFactory::createOrderByNode);
    }

    private class State {
        private final ImmutableList<UnaryOperatorNode> ancestors;
        private final Optional<OrderByNode> orderByNode;
        private final IQTree child;
        private final VariableGenerator variableGenerator;

        private State(ImmutableList<UnaryOperatorNode> ancestors, Optional<OrderByNode> orderByNode, IQTree child, VariableGenerator variableGenerator) {
            this.ancestors = ancestors;
            this.orderByNode = orderByNode;
            this.child = child;
            this.variableGenerator = variableGenerator;
        }

        public State(OrderByNode orderByNode, IQTree child, VariableGenerator variableGenerator) {
            this((ImmutableList<UnaryOperatorNode>)ImmutableList.of(), Optional.of(orderByNode), child, variableGenerator);
        }

        private State updateParentOrderByAndChild(UnaryOperatorNode newParent, Optional<OrderByNode> newOrderByNode, IQTree newChild) {
            ImmutableList newAncestors = ImmutableList.builder().add((Object)newParent).addAll(this.ancestors).build();
            return new State((ImmutableList<UnaryOperatorNode>)newAncestors, newOrderByNode, newChild, this.variableGenerator);
        }

        private State updateChild(IQTree newChild) {
            if (newChild.equals(this.child)) {
                return this;
            }
            return new State(this.ancestors, this.orderByNode, newChild, this.variableGenerator);
        }

        private State declareAsEmpty(IQTree newChild) {
            return new State(this.ancestors, Optional.empty(), newChild, this.variableGenerator);
        }

        public boolean hasConverged(State previousState) {
            return this.child.equals(previousState.child);
        }

        public State liftChild() {
            if (!this.orderByNode.isPresent()) {
                return this;
            }
            OrderByNode orderBy = this.orderByNode.get();
            IQTree newChild = this.child.normalizeForOptimization(this.variableGenerator);
            QueryNode newChildRoot = newChild.getRootNode();
            if (newChildRoot instanceof ConstructionNode) {
                return this.liftChildConstructionNode((ConstructionNode)newChildRoot, (UnaryIQTree)newChild, orderBy);
            }
            if (newChildRoot instanceof EmptyNode) {
                return this.declareAsEmpty(newChild);
            }
            if (newChildRoot instanceof DistinctNode) {
                return this.updateParentOrderByAndChild((DistinctNode)newChildRoot, Optional.of(orderBy), ((UnaryIQTree)newChild).getChild());
            }
            return this.updateChild(newChild);
        }

        private State liftChildConstructionNode(ConstructionNode childRoot, UnaryIQTree child, OrderByNode orderBy) {
            return this.updateParentOrderByAndChild(childRoot, orderBy.applySubstitution(childRoot.getSubstitution()).flatMap(o -> OrderByNormalizerImpl.this.simplifyOrderByNode((OrderByNode)o, child.getChild().getVariableNullability())), child.getChild());
        }

        public IQTree createNormalizedTree(VariableGenerator variableGenerator, IQTreeCache treeCache) {
            IQTree orderByLevelTree = this.orderByNode.map(n -> OrderByNormalizerImpl.this.iqFactory.createUnaryIQTree((UnaryOperatorNode)n, this.child, treeCache.declareAsNormalizedForOptimizationWithEffect())).orElse(this.child);
            if (this.ancestors.isEmpty()) {
                return orderByLevelTree;
            }
            return OrderByNormalizerImpl.this.iqTreeTools.createAncestorsUnaryIQTree(this.ancestors, orderByLevelTree).normalizeForOptimization(variableGenerator);
        }
    }
}

