/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.node.normalization.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.IQTreeCache;
import it.unibz.inf.ontop.iq.NaryIQTree;
import it.unibz.inf.ontop.iq.UnaryIQTree;
import it.unibz.inf.ontop.iq.impl.IQTreeTools;
import it.unibz.inf.ontop.iq.node.CommutativeJoinNode;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.DistinctNode;
import it.unibz.inf.ontop.iq.node.EmptyNode;
import it.unibz.inf.ontop.iq.node.FilterNode;
import it.unibz.inf.ontop.iq.node.LeftJoinNode;
import it.unibz.inf.ontop.iq.node.NaryOperatorNode;
import it.unibz.inf.ontop.iq.node.QueryNode;
import it.unibz.inf.ontop.iq.node.TrueNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.iq.node.impl.JoinOrFilterVariableNullabilityTools;
import it.unibz.inf.ontop.iq.node.impl.UnsatisfiableConditionException;
import it.unibz.inf.ontop.iq.node.normalization.ConditionSimplifier;
import it.unibz.inf.ontop.iq.node.normalization.LeftJoinNormalizer;
import it.unibz.inf.ontop.iq.node.normalization.impl.JoinLikeChildBindingLifter;
import it.unibz.inf.ontop.iq.node.normalization.impl.RightProvenanceNormalizer;
import it.unibz.inf.ontop.model.term.Constant;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import it.unibz.inf.ontop.substitution.Substitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

@Singleton
public class LeftJoinNormalizerImpl
implements LeftJoinNormalizer {
    private static final int MAX_ITERATIONS = 10000;
    private final Constant specialProvenanceConstant;
    private final SubstitutionFactory substitutionFactory;
    private final TermFactory termFactory;
    private final IntermediateQueryFactory iqFactory;
    private final ConditionSimplifier conditionSimplifier;
    private final JoinLikeChildBindingLifter bindingLifter;
    private final JoinOrFilterVariableNullabilityTools variableNullabilityTools;
    private final RightProvenanceNormalizer rightProvenanceNormalizer;
    private final IQTreeTools iqTreeTools;

    @Inject
    private LeftJoinNormalizerImpl(SubstitutionFactory substitutionFactory, TermFactory termFactory, IntermediateQueryFactory iqFactory, ConditionSimplifier conditionSimplifier, JoinLikeChildBindingLifter bindingLifter, JoinOrFilterVariableNullabilityTools variableNullabilityTools, RightProvenanceNormalizer rightProvenanceNormalizer, IQTreeTools iqTreeTools) {
        this.substitutionFactory = substitutionFactory;
        this.termFactory = termFactory;
        this.iqFactory = iqFactory;
        this.conditionSimplifier = conditionSimplifier;
        this.bindingLifter = bindingLifter;
        this.variableNullabilityTools = variableNullabilityTools;
        this.rightProvenanceNormalizer = rightProvenanceNormalizer;
        this.iqTreeTools = iqTreeTools;
        this.specialProvenanceConstant = termFactory.getProvenanceSpecialConstant();
    }

    @Override
    public IQTree normalizeForOptimization(LeftJoinNode ljNode, IQTree initialLeftChild, IQTree initialRightChild, VariableGenerator variableGenerator, IQTreeCache treeCache) {
        ImmutableSet projectedVariables = (ImmutableSet)Stream.of(initialLeftChild, initialRightChild).flatMap(c -> c.getVariables().stream()).collect(ImmutableCollectors.toSet());
        LJNormalizationState state = new LJNormalizationState((ImmutableSet<Variable>)projectedVariables, initialLeftChild, initialRightChild, ljNode.getOptionalFilterCondition(), variableGenerator);
        if ((state = state.liftLeftChild()).isEmpty()) {
            return state.createNormalizedTree(treeCache);
        }
        state = state.propagateDownLJCondition();
        for (int i = 0; i < 10000; ++i) {
            LJNormalizationState newState = state.checkRightChildContribution().optimizeLeftJoinCondition().liftRightChild().liftLeftChild();
            if (state.equals(newState)) {
                return state.createNormalizedTree(treeCache);
            }
            state = newState;
        }
        throw new MinorOntopInternalBugException("LJ.normalizeForOptimization() did not converge after 10000");
    }

    private ImmutableExpression getConjunction(Optional<ImmutableExpression> optionalExpression, ImmutableExpression expression) {
        return optionalExpression.map(e -> this.termFactory.getConjunction((ImmutableExpression)e, expression)).orElse(expression);
    }

    private class LJNormalizationState {
        private final IQTree leftChild;
        private final IQTree rightChild;
        private final VariableGenerator variableGenerator;
        private final Optional<ImmutableExpression> ljCondition;
        private final ImmutableList<UnaryOperatorNode> ancestors;
        private final ImmutableSet<Variable> projectedVariables;

        private LJNormalizationState(ImmutableSet<Variable> projectedVariables, IQTree leftChild, IQTree rightChild, Optional<ImmutableExpression> ljCondition, ImmutableList<UnaryOperatorNode> ancestors, VariableGenerator variableGenerator) {
            this.projectedVariables = projectedVariables;
            this.leftChild = leftChild;
            this.rightChild = rightChild;
            this.ljCondition = ljCondition;
            this.ancestors = ancestors;
            this.variableGenerator = variableGenerator;
        }

        protected LJNormalizationState(ImmutableSet<Variable> projectedVariables, IQTree initialLeftChild, IQTree initialRightChild, Optional<ImmutableExpression> ljCondition, VariableGenerator variableGenerator) {
            this(projectedVariables, initialLeftChild, initialRightChild, ljCondition, (ImmutableList<UnaryOperatorNode>)ImmutableList.of(), variableGenerator);
        }

        private LJNormalizationState updateConditionAndRightChild(Optional<ImmutableExpression> newLJCondition, IQTree newRightChild) {
            if (this.ljCondition.equals(newLJCondition) && this.rightChild.equals(newRightChild)) {
                return this;
            }
            return new LJNormalizationState(this.projectedVariables, this.leftChild, newRightChild, newLJCondition, this.ancestors, this.variableGenerator);
        }

        private LJNormalizationState updateParentConditionRightChild(UnaryOperatorNode newParent, Optional<ImmutableExpression> newLJCondition, IQTree newRightChild) {
            return this.updateParentConditionChildren(newParent, newLJCondition, this.leftChild, newRightChild);
        }

        private LJNormalizationState updateParentConditionChildren(UnaryOperatorNode newParent, Optional<ImmutableExpression> newLJCondition, IQTree newLeftChild, IQTree newRightChild) {
            ImmutableList newAncestors = ImmutableList.builder().add((Object)newParent).addAll(this.ancestors).build();
            return new LJNormalizationState(this.projectedVariables, newLeftChild, newRightChild, newLJCondition, (ImmutableList<UnaryOperatorNode>)newAncestors, this.variableGenerator);
        }

        private LJNormalizationState updateAncestorsConditionChildren(ImmutableList<UnaryOperatorNode> additionalAncestors, Optional<ImmutableExpression> newLJCondition, IQTree newLeftChild, IQTree newRightChild) {
            ImmutableList newAncestors = ImmutableList.builder().addAll(additionalAncestors).addAll(this.ancestors).build();
            return new LJNormalizationState(this.projectedVariables, newLeftChild, newRightChild, newLJCondition, (ImmutableList<UnaryOperatorNode>)newAncestors, this.variableGenerator);
        }

        private LJNormalizationState updateLeftChild(IQTree newLeftChild) {
            return new LJNormalizationState(this.projectedVariables, newLeftChild, this.rightChild, this.ljCondition, this.ancestors, this.variableGenerator);
        }

        public LJNormalizationState liftLeftChild() {
            IQTree liftedLeftChild = this.leftChild.normalizeForOptimization(this.variableGenerator);
            QueryNode leftRootNode = liftedLeftChild.getRootNode();
            if (leftRootNode instanceof ConstructionNode) {
                return this.liftLeftConstruction((UnaryIQTree)liftedLeftChild);
            }
            if (leftRootNode instanceof DistinctNode) {
                return this.liftLeftDistinct((UnaryIQTree)liftedLeftChild);
            }
            if (leftRootNode instanceof FilterNode) {
                return this.liftLeftFilterNode((UnaryIQTree)liftedLeftChild);
            }
            if (leftRootNode instanceof CommutativeJoinNode) {
                return this.liftLeftCommutativeJoin(liftedLeftChild);
            }
            if (liftedLeftChild.isDeclaredAsEmpty()) {
                return new LJNormalizationState(this.projectedVariables, liftedLeftChild, LeftJoinNormalizerImpl.this.iqFactory.createEmptyNode(this.rightChild.getVariables()), Optional.empty(), this.ancestors, this.variableGenerator);
            }
            return this.updateLeftChild(liftedLeftChild);
        }

        private LJNormalizationState liftLeftConstruction(UnaryIQTree liftedLeftChild) {
            ConstructionNode leftConstructionNode = (ConstructionNode)liftedLeftChild.getRootNode();
            IQTree leftGrandChild = liftedLeftChild.getChild();
            try {
                ImmutableList children = ImmutableList.of((Object)liftedLeftChild, (Object)this.rightChild);
                VariableNullability childVariableNullability = LeftJoinNormalizerImpl.this.variableNullabilityTools.getChildrenVariableNullability((ImmutableList<IQTree>)ImmutableList.of((Object)leftGrandChild, (Object)this.rightChild));
                return LeftJoinNormalizerImpl.this.bindingLifter.liftRegularChildBinding(leftConstructionNode, 0, leftGrandChild, (ImmutableList<IQTree>)children, leftGrandChild.getVariables(), this.ljCondition, this.variableGenerator, childVariableNullability, this::applyLeftChildBindingLift).liftLeftChild();
            }
            catch (UnsatisfiableConditionException e) {
                EmptyNode newRightChild = LeftJoinNormalizerImpl.this.iqFactory.createEmptyNode(this.rightChild.getVariables());
                ConstructionNode newParentConstructionNode = LeftJoinNormalizerImpl.this.iqFactory.createConstructionNode(LeftJoinNormalizerImpl.this.iqTreeTools.getChildrenVariables((IQTree)liftedLeftChild, this.rightChild), leftConstructionNode.getSubstitution());
                return this.updateParentConditionChildren(newParentConstructionNode, Optional.empty(), leftGrandChild, newRightChild);
            }
        }

        private LJNormalizationState liftLeftDistinct(UnaryIQTree liftedLeftChild) {
            DistinctNode distinctNode = (DistinctNode)liftedLeftChild.getRootNode();
            if (this.isLJDistinctWhileLeftIsDistinct(liftedLeftChild)) {
                IQTree newRightChild = this.rightChild.removeDistincts();
                IQTree newLeftChild = liftedLeftChild.getChild();
                return this.updateParentConditionChildren(distinctNode, this.ljCondition, newLeftChild, newRightChild).liftLeftChild();
            }
            return this.updateLeftChild(liftedLeftChild);
        }

        private boolean isLJDistinctWhileLeftIsDistinct(IQTree distinctLeftChild) {
            if (this.rightChild.isDistinct()) {
                return true;
            }
            NaryIQTree innerJoinTree = LeftJoinNormalizerImpl.this.iqFactory.createNaryIQTree(LeftJoinNormalizerImpl.this.iqFactory.createInnerJoinNode(this.ljCondition), (ImmutableList<IQTree>)ImmutableList.of((Object)distinctLeftChild, (Object)this.rightChild));
            return innerJoinTree.isDistinct();
        }

        private Optional<LJNormalizationState> tryToLiftRightDistinct(UnaryIQTree liftedRightChild) {
            DistinctNode distinctNode = (DistinctNode)liftedRightChild.getRootNode();
            if (this.leftChild.isDistinct()) {
                IQTree newLeftChild = this.leftChild.removeDistincts();
                IQTree newRightChild = liftedRightChild.getChild();
                return Optional.of(this.updateParentConditionChildren(distinctNode, this.ljCondition, newLeftChild, newRightChild));
            }
            return Optional.empty();
        }

        private LJNormalizationState liftLeftFilterNode(UnaryIQTree liftedLeftChild) {
            FilterNode filterNode = (FilterNode)liftedLeftChild.getRootNode();
            return this.updateParentConditionChildren(filterNode, this.ljCondition, liftedLeftChild.getChild(), this.rightChild);
        }

        private LJNormalizationState liftLeftCommutativeJoin(IQTree liftedLeftChild) {
            CommutativeJoinNode joinNode = (CommutativeJoinNode)liftedLeftChild.getRootNode();
            Optional<ImmutableExpression> filterCondition = joinNode.getOptionalFilterCondition();
            if (filterCondition.isPresent()) {
                FilterNode newParent = LeftJoinNormalizerImpl.this.iqFactory.createFilterNode(filterCondition.get());
                NaryIQTree newLeftChild = LeftJoinNormalizerImpl.this.iqFactory.createNaryIQTree((NaryOperatorNode)((Object)joinNode.changeOptionalFilterCondition(Optional.empty())), liftedLeftChild.getChildren());
                return this.updateParentConditionChildren(newParent, this.ljCondition, newLeftChild, this.rightChild);
            }
            return this.updateLeftChild(liftedLeftChild);
        }

        private LJNormalizationState liftRightFilter(UnaryIQTree liftedRightChild) {
            FilterNode filterNode = (FilterNode)liftedRightChild.getRootNode();
            ImmutableExpression newLJCondition = LeftJoinNormalizerImpl.this.getConjunction(this.ljCondition, filterNode.getFilterCondition());
            return this.updateConditionAndRightChild(Optional.of(newLJCondition), liftedRightChild.getChild());
        }

        private Optional<LJNormalizationState> tryToLiftRightCommutativeJoin(IQTree liftedRightChild) {
            CommutativeJoinNode joinNode = (CommutativeJoinNode)liftedRightChild.getRootNode();
            Optional<ImmutableExpression> filterCondition = joinNode.getOptionalFilterCondition();
            if (filterCondition.isPresent()) {
                ImmutableExpression condition = filterCondition.get();
                ImmutableExpression newLJCondition = LeftJoinNormalizerImpl.this.getConjunction(this.ljCondition, condition);
                NaryIQTree newRightChild = LeftJoinNormalizerImpl.this.iqFactory.createNaryIQTree((NaryOperatorNode)((Object)joinNode.changeOptionalFilterCondition(Optional.empty())), liftedRightChild.getChildren());
                return Optional.of(this.updateConditionAndRightChild(Optional.of(newLJCondition), newRightChild));
            }
            return Optional.empty();
        }

        private LJNormalizationState applyLeftChildBindingLift(ImmutableList<IQTree> children, IQTree leftGrandChild, int leftChildPosition, Optional<ImmutableExpression> ljCondition, Substitution<ImmutableTerm> naiveAscendingSubstitution, Substitution<? extends VariableOrGroundTerm> descendingSubstitution) {
            if (children.size() != 2) {
                throw new MinorOntopInternalBugException("Two children were expected, not " + children);
            }
            IQTree initialRightChild = (IQTree)children.get(1);
            IQTree rightSubTree = initialRightChild.applyDescendingSubstitution(descendingSubstitution, ljCondition, this.variableGenerator);
            ImmutableSet<Variable> leftVariables = LeftJoinNormalizerImpl.this.iqTreeTools.getChildrenVariables((IQTree)children.get(0), leftGrandChild);
            Optional<RightProvenanceNormalizer.RightProvenance> rightProvenance = this.createProvenanceElements(rightSubTree, naiveAscendingSubstitution, leftVariables, rightSubTree.getVariables(), this.variableGenerator);
            IQTree newRightChild = rightProvenance.map(RightProvenanceNormalizer.RightProvenance::getRightTree).orElse(rightSubTree);
            Optional<Variable> defaultProvenanceVariable = rightProvenance.map(RightProvenanceNormalizer.RightProvenance::getProvenanceVariable);
            Substitution<ImmutableTerm> ascendingSubstitution = naiveAscendingSubstitution.builder().transformOrRetain(v -> !leftVariables.contains(v) ? v : null, (t, v) -> this.transformRightSubstitutionValue((ImmutableTerm)t, leftVariables, defaultProvenanceVariable)).build();
            ConstructionNode parentConstructionNode = LeftJoinNormalizerImpl.this.iqFactory.createConstructionNode(LeftJoinNormalizerImpl.this.iqTreeTools.getChildrenVariables(children), ascendingSubstitution);
            return this.updateParentConditionChildren(parentConstructionNode, ljCondition, leftGrandChild, newRightChild);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof LJNormalizationState) {
                LJNormalizationState that = (LJNormalizationState)o;
                return this.leftChild.equals(that.leftChild) && this.rightChild.equals(that.rightChild) && this.ljCondition.equals(that.ljCondition) && this.ancestors.equals(that.ancestors);
            }
            return false;
        }

        private LJNormalizationState optimizeLeftJoinCondition() {
            if (!this.ljCondition.isPresent()) {
                return this;
            }
            ImmutableSet<Variable> leftVariables = this.leftChild.getVariables();
            ImmutableSet<Variable> rightVariables = this.rightChild.getVariables();
            try {
                ConditionSimplifier.ExpressionAndSubstitution simplificationResults = LeftJoinNormalizerImpl.this.conditionSimplifier.simplifyCondition(this.ljCondition, leftVariables, (ImmutableList<IQTree>)ImmutableList.of((Object)this.rightChild), LeftJoinNormalizerImpl.this.variableNullabilityTools.getChildrenVariableNullability((ImmutableList<IQTree>)ImmutableList.of((Object)this.leftChild, (Object)this.rightChild)));
                Substitution<VariableOrGroundTerm> downSubstitution = simplificationResults.getSubstitution().restrictDomainTo((Set<Variable>)rightVariables);
                if (downSubstitution.isEmpty()) {
                    return this.updateConditionAndRightChild(simplificationResults.getOptionalExpression(), this.rightChild);
                }
                IQTree updatedRightChild = this.rightChild.applyDescendingSubstitution(downSubstitution, simplificationResults.getOptionalExpression(), this.variableGenerator);
                Optional<RightProvenanceNormalizer.RightProvenance> rightProvenance = this.createProvenanceElements(updatedRightChild, downSubstitution, leftVariables, updatedRightChild.getVariables(), this.variableGenerator);
                IQTree newRightChild = rightProvenance.map(RightProvenanceNormalizer.RightProvenance::getRightTree).orElse(updatedRightChild);
                Substitution<ImmutableTerm> newAscendingSubstitution = this.computeLiftableSubstitution(downSubstitution, rightProvenance.map(RightProvenanceNormalizer.RightProvenance::getProvenanceVariable), leftVariables);
                ConstructionNode newParentConstructionNode = LeftJoinNormalizerImpl.this.iqFactory.createConstructionNode(LeftJoinNormalizerImpl.this.iqTreeTools.getChildrenVariables(this.leftChild, this.rightChild), newAscendingSubstitution);
                return this.updateParentConditionChildren(newParentConstructionNode, simplificationResults.getOptionalExpression(), this.leftChild, newRightChild);
            }
            catch (UnsatisfiableConditionException e) {
                return this.updateConditionAndRightChild(Optional.empty(), LeftJoinNormalizerImpl.this.iqFactory.createEmptyNode(rightVariables));
            }
        }

        private LJNormalizationState liftRightChild() {
            IQTree liftedRightChild = this.rightChild.normalizeForOptimization(this.variableGenerator);
            return this.tryToLiftRightChild(liftedRightChild).orElseGet(() -> this.updateConditionAndRightChild(this.ljCondition.filter(c -> !liftedRightChild.isDeclaredAsEmpty()), liftedRightChild));
        }

        private Optional<LJNormalizationState> tryToLiftRightChild(IQTree liftedRightChild) {
            QueryNode rightRootNode = liftedRightChild.getRootNode();
            if (rightRootNode instanceof ConstructionNode) {
                ConstructionNode rightConstructionNode = (ConstructionNode)liftedRightChild.getRootNode();
                IQTree rightGrandChild = ((UnaryIQTree)liftedRightChild).getChild();
                Substitution<ImmutableTerm> rightSubstitution = rightConstructionNode.getSubstitution();
                return this.tryToLiftRightConstruction(rightConstructionNode.getChildVariables(), rightGrandChild, rightSubstitution);
            }
            if (rightRootNode instanceof DistinctNode) {
                return this.tryToLiftRightDistinct((UnaryIQTree)liftedRightChild);
            }
            if (rightRootNode instanceof FilterNode) {
                return Optional.of(this.liftRightFilter((UnaryIQTree)liftedRightChild));
            }
            if (rightRootNode instanceof CommutativeJoinNode) {
                return this.tryToLiftRightCommutativeJoin(liftedRightChild);
            }
            return Optional.empty();
        }

        private Optional<LJNormalizationState> tryToLiftRightConstruction(ImmutableSet<Variable> rightChildRequiredVariables, IQTree rightGrandChild, Substitution<ImmutableTerm> rightSubstitution) {
            if (rightGrandChild instanceof TrueNode) {
                return this.liftRightConstructionWithTrueNode(rightSubstitution);
            }
            ImmutableSet<Variable> leftVariables = this.leftChild.getVariables();
            if (rightSubstitution.isEmpty()) {
                ConstructionNode newParent = LeftJoinNormalizerImpl.this.iqFactory.createConstructionNode(LeftJoinNormalizerImpl.this.iqTreeTools.getChildrenVariables(this.leftChild, this.rightChild));
                return Optional.of(this.updateParentConditionRightChild(newParent, this.ljCondition, rightGrandChild));
            }
            Optional<Variable> provenanceVariable = rightSubstitution.getPreImage(t -> t.equals(LeftJoinNormalizerImpl.this.specialProvenanceConstant)).stream().findFirst();
            Substitution<ImmutableTerm> selectedSubstitution = provenanceVariable.map(pv -> rightSubstitution.removeFromDomain((Set<Variable>)ImmutableSet.of((Object)pv))).orElse(rightSubstitution);
            if (selectedSubstitution.isEmpty()) {
                return this.liftRightGrandChildWithProvenance((Variable)provenanceVariable.orElseThrow(() -> new MinorOntopInternalBugException("An entry was expected")), rightChildRequiredVariables, rightGrandChild);
            }
            Optional<ImmutableExpression> notOptimizedLJCondition = LeftJoinNormalizerImpl.this.termFactory.getConjunction(this.ljCondition.map(selectedSubstitution::apply), selectedSubstitution.builder().restrictDomainTo((Set<Variable>)leftVariables).toStream((x$0, x$1) -> LeftJoinNormalizerImpl.this.termFactory.getStrictEquality((ImmutableTerm)x$0, (ImmutableTerm)x$1, new ImmutableTerm[0])));
            Optional<RightProvenanceNormalizer.RightProvenance> rightProvenance = provenanceVariable.map(v -> this.createProvenanceElements((Variable)v, rightGrandChild, rightChildRequiredVariables)).or(() -> this.createProvenanceElements(rightGrandChild, selectedSubstitution, leftVariables, rightChildRequiredVariables, this.variableGenerator));
            IQTree newRightChild = rightProvenance.map(RightProvenanceNormalizer.RightProvenance::getRightTree).orElse(rightGrandChild);
            Substitution<ImmutableTerm> liftableSubstitution = this.computeLiftableSubstitution(selectedSubstitution, rightProvenance.map(RightProvenanceNormalizer.RightProvenance::getProvenanceVariable), leftVariables);
            ConstructionNode newParentNode = LeftJoinNormalizerImpl.this.iqFactory.createConstructionNode(LeftJoinNormalizerImpl.this.iqTreeTools.getChildrenVariables(this.leftChild, this.rightChild), liftableSubstitution);
            return Optional.of(this.updateParentConditionRightChild(newParentNode, notOptimizedLJCondition, newRightChild));
        }

        private Optional<LJNormalizationState> liftRightConstructionWithTrueNode(Substitution<ImmutableTerm> rightSubstitution) {
            Substitution<ImmutableTerm> liftableSubstitution = this.ljCondition.map(c -> rightSubstitution.transform(t -> LeftJoinNormalizerImpl.this.termFactory.getIfElseNull((ImmutableExpression)c, (ImmutableTerm)t))).orElse(rightSubstitution);
            ConstructionNode newParentNode = LeftJoinNormalizerImpl.this.iqFactory.createConstructionNode(LeftJoinNormalizerImpl.this.iqTreeTools.getChildrenVariables(this.leftChild, this.rightChild), liftableSubstitution);
            return Optional.of(this.updateParentConditionRightChild(newParentNode, this.ljCondition, LeftJoinNormalizerImpl.this.iqFactory.createTrueNode()));
        }

        private Optional<LJNormalizationState> liftRightGrandChildWithProvenance(Variable provenanceVariable, ImmutableSet<Variable> rightChildRequiredVariables, IQTree rightGrandChild) {
            QueryNode grandChildNode = rightGrandChild.getRootNode();
            Optional<ConstructionNode> optionalProjectingAwayParent = Optional.of(this.rightChild.getVariables()).filter(rvs -> !rightChildRequiredVariables.equals(rightGrandChild.getVariables())).map(rvs -> Sets.union(this.leftChild.getVariables(), (Set)rvs).immutableCopy()).map(LeftJoinNormalizerImpl.this.iqFactory::createConstructionNode);
            if (grandChildNode instanceof DistinctNode) {
                if (this.leftChild.isDistinct()) {
                    IQTree newLeftChild = this.leftChild.removeDistincts();
                    IQTree newRightChild = this.createNewRightChildWithProvenance(provenanceVariable, ((UnaryIQTree)rightGrandChild).getChild(), rightGrandChild.getVariables());
                    ImmutableList additionalAncestors = optionalProjectingAwayParent.map(p -> ImmutableList.of((Object)((DistinctNode)grandChildNode), (Object)p)).orElseGet(() -> ImmutableList.of((Object)((DistinctNode)grandChildNode)));
                    return Optional.of(this.updateAncestorsConditionChildren((ImmutableList<UnaryOperatorNode>)additionalAncestors, this.ljCondition, newLeftChild, newRightChild));
                }
                return Optional.empty();
            }
            if (grandChildNode instanceof FilterNode) {
                FilterNode filterNode = (FilterNode)grandChildNode;
                ImmutableExpression filterCondition = filterNode.getFilterCondition();
                ImmutableExpression newLJCondition = LeftJoinNormalizerImpl.this.getConjunction(this.ljCondition, filterCondition);
                ImmutableSet childVariablesToProject = Sets.union(rightChildRequiredVariables, filterCondition.getVariables()).immutableCopy();
                IQTree newRightChild = this.createNewRightChildWithProvenance(provenanceVariable, ((UnaryIQTree)rightGrandChild).getChild(), (ImmutableSet<Variable>)childVariablesToProject);
                return Optional.of(optionalProjectingAwayParent.map(p -> this.updateParentConditionRightChild((UnaryOperatorNode)p, Optional.of(newLJCondition), newRightChild)).orElseGet(() -> this.updateConditionAndRightChild(Optional.of(newLJCondition), newRightChild)));
            }
            if (grandChildNode instanceof CommutativeJoinNode) {
                CommutativeJoinNode joinNode = (CommutativeJoinNode)grandChildNode;
                Optional<ImmutableExpression> filterCondition = joinNode.getOptionalFilterCondition();
                if (filterCondition.isPresent()) {
                    ImmutableExpression condition = filterCondition.get();
                    ImmutableExpression newLJCondition = LeftJoinNormalizerImpl.this.getConjunction(this.ljCondition, condition);
                    NaryIQTree newRightGrandChild = LeftJoinNormalizerImpl.this.iqFactory.createNaryIQTree((NaryOperatorNode)((Object)joinNode.changeOptionalFilterCondition(Optional.empty())), rightGrandChild.getChildren());
                    ImmutableSet childVariablesToProject = Sets.union(rightChildRequiredVariables, condition.getVariables()).immutableCopy();
                    IQTree newRightChild = this.createNewRightChildWithProvenance(provenanceVariable, newRightGrandChild, (ImmutableSet<Variable>)childVariablesToProject);
                    return Optional.of(optionalProjectingAwayParent.map(p -> this.updateParentConditionRightChild((UnaryOperatorNode)p, Optional.of(newLJCondition), newRightChild)).orElseGet(() -> this.updateConditionAndRightChild(Optional.of(newLJCondition), newRightChild)));
                }
                return Optional.empty();
            }
            return Optional.empty();
        }

        private IQTree createNewRightChildWithProvenance(Variable provenanceVariable, IQTree child, ImmutableSet<Variable> childVariablesToProject) {
            ConstructionNode newConstructionNode = LeftJoinNormalizerImpl.this.iqFactory.createConstructionNode((ImmutableSet<Variable>)Sets.union((Set)ImmutableSet.of((Object)provenanceVariable), childVariablesToProject).immutableCopy(), LeftJoinNormalizerImpl.this.substitutionFactory.getSubstitution(provenanceVariable, LeftJoinNormalizerImpl.this.specialProvenanceConstant));
            return LeftJoinNormalizerImpl.this.iqFactory.createUnaryIQTree(newConstructionNode, child);
        }

        public boolean isEmpty() {
            return this.leftChild.isDeclaredAsEmpty();
        }

        public IQTree createNormalizedTree(IQTreeCache treeCache) {
            IQTree ljLevelTree;
            if (this.leftChild.isDeclaredAsEmpty()) {
                return LeftJoinNormalizerImpl.this.iqFactory.createEmptyNode(this.projectedVariables);
            }
            IQTreeCache normalizedProperties = treeCache.declareAsNormalizedForOptimizationWithEffect();
            if (this.rightChild.isDeclaredAsEmpty()) {
                Sets.SetView rightSpecificVariables = Sets.difference(this.rightChild.getVariables(), this.leftChild.getVariables());
                ConstructionNode newParentConstructionNode = LeftJoinNormalizerImpl.this.iqFactory.createConstructionNode(LeftJoinNormalizerImpl.this.iqTreeTools.getChildrenVariables(this.leftChild, this.rightChild), rightSpecificVariables.stream().collect(LeftJoinNormalizerImpl.this.substitutionFactory.toSubstitution(v -> LeftJoinNormalizerImpl.this.termFactory.getNullConstant())));
                ljLevelTree = LeftJoinNormalizerImpl.this.iqFactory.createUnaryIQTree(newParentConstructionNode, this.leftChild, normalizedProperties);
            } else {
                ljLevelTree = this.rightChild.getRootNode() instanceof TrueNode ? this.leftChild : LeftJoinNormalizerImpl.this.iqFactory.createBinaryNonCommutativeIQTree(LeftJoinNormalizerImpl.this.iqFactory.createLeftJoinNode(this.ljCondition), this.leftChild, this.rightChild, normalizedProperties);
            }
            IQTree ancestorTree = LeftJoinNormalizerImpl.this.iqTreeTools.createAncestorsUnaryIQTree(this.ancestors, ljLevelTree);
            IQTree nonNormalizedTree = LeftJoinNormalizerImpl.this.iqTreeTools.createConstructionNodeTreeIfNontrivial(ancestorTree, this.projectedVariables);
            return nonNormalizedTree.normalizeForOptimization(this.variableGenerator);
        }

        private Substitution<ImmutableTerm> computeLiftableSubstitution(Substitution<? extends ImmutableTerm> selectedSubstitution, Optional<Variable> rightProvenanceVariable, ImmutableSet<Variable> leftVariables) {
            return selectedSubstitution.builder().removeFromDomain((Set<Variable>)leftVariables).transform(t -> this.transformRightSubstitutionValue((ImmutableTerm)t, leftVariables, rightProvenanceVariable)).build();
        }

        private ImmutableTerm transformRightSubstitutionValue(ImmutableTerm value, ImmutableSet<Variable> leftVariables, Optional<Variable> defaultRightProvenanceVariable) {
            if (this.isNullWhenRightIsRejected(value, leftVariables)) {
                return value;
            }
            Variable provenanceVariable = (Variable)Optional.of(value).filter(t -> t instanceof ImmutableFunctionalTerm).map(t -> (ImmutableFunctionalTerm)t).flatMap(f -> f.proposeProvenanceVariables().filter(v -> !leftVariables.contains(v)).findAny()).or(() -> defaultRightProvenanceVariable).orElseThrow(() -> new MinorOntopInternalBugException("A default provenance variable was needed"));
            return LeftJoinNormalizerImpl.this.termFactory.getIfElseNull(LeftJoinNormalizerImpl.this.termFactory.getDBIsNotNull(provenanceVariable), value);
        }

        private RightProvenanceNormalizer.RightProvenance createProvenanceElements(Variable rightProvenanceVariable, IQTree rightTree, ImmutableSet<Variable> rightRequiredVariables) {
            ImmutableSet newRightProjectedVariables = Sets.union((Set)ImmutableSet.of((Object)rightProvenanceVariable), rightRequiredVariables).immutableCopy();
            ConstructionNode newRightConstructionNode = LeftJoinNormalizerImpl.this.iqFactory.createConstructionNode((ImmutableSet<Variable>)newRightProjectedVariables, LeftJoinNormalizerImpl.this.substitutionFactory.getSubstitution(rightProvenanceVariable, LeftJoinNormalizerImpl.this.specialProvenanceConstant));
            UnaryIQTree newRightTree = LeftJoinNormalizerImpl.this.iqFactory.createUnaryIQTree(newRightConstructionNode, rightTree);
            return new RightProvenanceNormalizer.RightProvenance(rightProvenanceVariable, newRightTree);
        }

        private Optional<RightProvenanceNormalizer.RightProvenance> createProvenanceElements(IQTree rightTree, Substitution<? extends ImmutableTerm> selectedSubstitution, ImmutableSet<Variable> leftVariables, ImmutableSet<Variable> rightRequiredVariables, VariableGenerator variableGenerator) {
            if (selectedSubstitution.removeFromDomain((Set<Variable>)leftVariables).rangeAnyMatch(t -> this.needsAnExternalProvenanceVariable((ImmutableTerm)t, leftVariables))) {
                return Optional.of(LeftJoinNormalizerImpl.this.rightProvenanceNormalizer.normalizeRightProvenance(rightTree, leftVariables, rightRequiredVariables, variableGenerator));
            }
            return Optional.empty();
        }

        private boolean needsAnExternalProvenanceVariable(ImmutableTerm immutableTerm, ImmutableSet<Variable> leftVariables) {
            if (this.isNullWhenRightIsRejected(immutableTerm, leftVariables)) {
                return false;
            }
            if (immutableTerm instanceof ImmutableFunctionalTerm) {
                return ((ImmutableFunctionalTerm)immutableTerm).proposeProvenanceVariables().allMatch(arg_0 -> leftVariables.contains(arg_0));
            }
            return true;
        }

        private boolean isNullWhenRightIsRejected(ImmutableTerm immutableTerm, ImmutableSet<Variable> leftVariables) {
            Substitution<ImmutableTerm> nullSubstitution = Sets.difference((Set)((Set)immutableTerm.getVariableStream().collect(ImmutableCollectors.toSet())), leftVariables).stream().collect(LeftJoinNormalizerImpl.this.substitutionFactory.toSubstitution(v -> LeftJoinNormalizerImpl.this.termFactory.getNullConstant()));
            return nullSubstitution.applyToTerm(immutableTerm).simplify().isNull();
        }

        public LJNormalizationState propagateDownLJCondition() {
            if (this.ljCondition.isPresent()) {
                IQTree newRightChild = this.rightChild.propagateDownConstraint(this.ljCondition.get(), this.variableGenerator);
                return this.rightChild.equals(newRightChild) ? this : this.updateConditionAndRightChild(this.ljCondition, newRightChild);
            }
            return this;
        }

        public LJNormalizationState checkRightChildContribution() {
            if (Sets.difference(this.rightChild.getVariables(), this.leftChild.getVariables()).isEmpty() && !this.rightChild.inferUniqueConstraints().isEmpty()) {
                TrueNode newRightChild = LeftJoinNormalizerImpl.this.iqFactory.createTrueNode();
                return new LJNormalizationState(this.projectedVariables, this.leftChild, newRightChild, Optional.empty(), this.ancestors, this.variableGenerator);
            }
            return this;
        }
    }
}

