/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.node.normalization.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.injection.CoreSingletons;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.IQTreeCache;
import it.unibz.inf.ontop.iq.UnaryIQTree;
import it.unibz.inf.ontop.iq.impl.IQTreeTools;
import it.unibz.inf.ontop.iq.node.AggregationNode;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.FilterNode;
import it.unibz.inf.ontop.iq.node.QueryNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.iq.node.normalization.AggregationNormalizer;
import it.unibz.inf.ontop.iq.node.normalization.NotRequiredVariableRemover;
import it.unibz.inf.ontop.iq.node.normalization.impl.InjectiveBindingLiftState;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.NonFunctionalTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.functionsymbol.AggregationFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.FunctionSymbol;
import it.unibz.inf.ontop.substitution.Substitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Optional;
import java.util.Set;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public class AggregationNormalizerImpl
implements AggregationNormalizer {
    private final CoreSingletons coreSingletons;
    private final IntermediateQueryFactory iqFactory;
    private final TermFactory termFactory;
    private final SubstitutionFactory substitutionFactory;
    private final NotRequiredVariableRemover notRequiredVariableRemover;
    private final IQTreeTools iqTreeTools;

    @Inject
    protected AggregationNormalizerImpl(CoreSingletons coreSingletons, IQTreeTools iqTreeTools, NotRequiredVariableRemover notRequiredVariableRemover) {
        this.coreSingletons = coreSingletons;
        this.iqFactory = coreSingletons.getIQFactory();
        this.termFactory = coreSingletons.getTermFactory();
        this.substitutionFactory = coreSingletons.getSubstitutionFactory();
        this.iqTreeTools = iqTreeTools;
        this.notRequiredVariableRemover = notRequiredVariableRemover;
    }

    @Override
    public IQTree normalizeForOptimization(AggregationNode aggregationNode, IQTree child, VariableGenerator variableGenerator, IQTreeCache treeCache) {
        IQTreeCache normalizedTreeCache = treeCache.declareAsNormalizedForOptimizationWithEffect();
        if (aggregationNode.getGroupingVariables().isEmpty() && aggregationNode.getSubstitution().isEmpty()) {
            return this.iqFactory.createTrueNode();
        }
        if (aggregationNode.getSubstitution().isEmpty()) {
            UnaryIQTree newTree = this.iqFactory.createUnaryIQTree(this.iqFactory.createDistinctNode(), this.iqFactory.createUnaryIQTree(this.iqFactory.createConstructionNode(aggregationNode.getGroupingVariables()), child));
            return newTree.normalizeForOptimization(variableGenerator);
        }
        IQTree shrunkChild = this.notRequiredVariableRemover.optimize(child.normalizeForOptimization(variableGenerator), aggregationNode.getLocallyRequiredVariables(), variableGenerator);
        if (shrunkChild.isDeclaredAsEmpty()) {
            return this.normalizeEmptyChild(aggregationNode, normalizedTreeCache);
        }
        QueryNode rootNode = shrunkChild.getRootNode();
        AggregationNormalizationState stateAfterLiftingBindings = Optional.of(rootNode).filter(n -> n instanceof ConstructionNode).map(n -> (ConstructionNode)n).map(n -> this.normalizeWithChildConstructionNode(aggregationNode, (ConstructionNode)n, ((UnaryIQTree)shrunkChild).getChild(), variableGenerator)).orElseGet(() -> new AggregationNormalizationState(aggregationNode, null, shrunkChild, variableGenerator, null));
        AggregationNormalizationState finalState = stateAfterLiftingBindings.simplifyAggregationSubstitution();
        return finalState.createNormalizedTree(normalizedTreeCache);
    }

    private IQTree normalizeEmptyChild(AggregationNode aggregationNode, IQTreeCache normalizedTreeCache) {
        ImmutableSet<Variable> projectedVariables = aggregationNode.getVariables();
        if (!aggregationNode.getGroupingVariables().isEmpty()) {
            return this.iqFactory.createEmptyNode(projectedVariables);
        }
        Substitution<ImmutableTerm> newSubstitution = aggregationNode.getSubstitution().transform(this::simplifyEmptyAggregate);
        return this.iqFactory.createUnaryIQTree(this.iqFactory.createConstructionNode(projectedVariables, newSubstitution), this.iqFactory.createTrueNode(), normalizedTreeCache);
    }

    private ImmutableTerm simplifyEmptyAggregate(ImmutableFunctionalTerm aggregateTerm) {
        FunctionSymbol functionSymbol = aggregateTerm.getFunctionSymbol();
        if (functionSymbol instanceof AggregationFunctionSymbol) {
            return ((AggregationFunctionSymbol)functionSymbol).evaluateEmptyBag(this.termFactory);
        }
        throw new MinorOntopInternalBugException("Was expecting an AggregationFunctionSymbol");
    }

    private AggregationNormalizationState normalizeWithChildConstructionNode(AggregationNode aggregationNode, ConstructionNode childConstructionNode, IQTree grandChild, VariableGenerator variableGenerator) {
        return new AggregationNormalizationState(aggregationNode, childConstructionNode, grandChild, variableGenerator, null).propagateNonGroupingBindingsIntoToAggregationSubstitution().liftGroupingBindings().simplifyAggregationSubstitution();
    }

    protected class AggregationNormalizationState {
        private static final int MAX_ITERATIONS = 1000;
        private final ImmutableSet<Variable> groupingVariables;
        private final Substitution<ImmutableFunctionalTerm> aggregationSubstitution;
        private final @Nullable FilterNode sampleFilter;
        private final @Nullable ConstructionNode childConstructionNode;
        private final IQTree grandChild;
        private final VariableGenerator variableGenerator;
        private final ImmutableList<ConstructionNode> ancestors;

        private AggregationNormalizationState(@Nullable AggregationNode aggregationNode, ConstructionNode childConstructionNode, IQTree grandChild, @Nullable VariableGenerator variableGenerator, FilterNode sampleFilter) {
            this((ImmutableList<ConstructionNode>)ImmutableList.of(), aggregationNode.getGroupingVariables(), aggregationNode.getSubstitution(), childConstructionNode, grandChild, variableGenerator, sampleFilter);
        }

        private AggregationNormalizationState(ImmutableList<ConstructionNode> ancestors, ImmutableSet<Variable> groupingVariables, @Nullable Substitution<ImmutableFunctionalTerm> aggregationSubstitution, ConstructionNode childConstructionNode, IQTree grandChild, @Nullable VariableGenerator variableGenerator, FilterNode sampleFilter) {
            this.ancestors = ancestors;
            this.groupingVariables = groupingVariables;
            this.aggregationSubstitution = aggregationSubstitution;
            this.childConstructionNode = childConstructionNode;
            this.grandChild = grandChild;
            this.variableGenerator = variableGenerator;
            this.sampleFilter = sampleFilter;
        }

        public AggregationNormalizationState propagateNonGroupingBindingsIntoToAggregationSubstitution() {
            if (this.childConstructionNode == null) {
                return this;
            }
            Sets.SetView nonGroupingVariables = Sets.difference(AggregationNormalizerImpl.this.iqTreeTools.extractChildVariables(this.groupingVariables, this.aggregationSubstitution), this.groupingVariables);
            Substitution<ImmutableTerm> nonGroupingSubstitution = this.childConstructionNode.getSubstitution().restrictDomainTo((Set<Variable>)nonGroupingVariables);
            Substitution<ImmutableFunctionalTerm> newAggregationSubstitution = nonGroupingSubstitution.compose(this.aggregationSubstitution).builder().restrictDomainTo((Set<Variable>)this.aggregationSubstitution.getDomain()).transform(t -> (ImmutableFunctionalTerm)t).build();
            AggregationNode newAggregationNode = AggregationNormalizerImpl.this.iqFactory.createAggregationNode(this.groupingVariables, newAggregationSubstitution);
            ConstructionNode newChildConstructionNode = Optional.of(this.childConstructionNode.getSubstitution().restrictDomainTo((Set<Variable>)this.groupingVariables)).filter(s -> !s.isEmpty()).map(s -> AggregationNormalizerImpl.this.iqFactory.createConstructionNode(newAggregationNode.getChildVariables(), (Substitution<? extends ImmutableTerm>)s)).orElse(null);
            return new AggregationNormalizationState(this.ancestors, this.groupingVariables, newAggregationSubstitution, newChildConstructionNode, this.grandChild, this.variableGenerator, this.sampleFilter);
        }

        public AggregationNormalizationState liftGroupingBindings() {
            if (this.childConstructionNode == null) {
                return this;
            }
            Substitution<ImmutableTerm> substitution = this.childConstructionNode.getSubstitution();
            if (substitution.isEmpty()) {
                return this;
            }
            if (!this.groupingVariables.containsAll(substitution.getDomain())) {
                throw new MinorOntopInternalBugException("Was expecting all the non-grouping bindings to be lifted");
            }
            ConstructionNode groupingConstructionNode = AggregationNormalizerImpl.this.iqFactory.createConstructionNode(this.groupingVariables, substitution);
            InjectiveBindingLiftState subState = new InjectiveBindingLiftState(groupingConstructionNode, this.grandChild, this.variableGenerator, AggregationNormalizerImpl.this.coreSingletons);
            for (int i = 0; i < 1000; ++i) {
                InjectiveBindingLiftState newSubState = subState.liftBindings();
                if (newSubState.equals(subState)) {
                    return this.convertIntoState(subState);
                }
                subState = newSubState;
            }
            throw new MinorOntopInternalBugException("AggregationNormalizerImpl.liftGroupingBindings() did not converge after 1000");
        }

        private AggregationNormalizationState convertIntoState(InjectiveBindingLiftState subState) {
            ImmutableList<ConstructionNode> subStateAncestors = subState.getAncestors();
            ImmutableList newAncestors = (ImmutableList)Stream.concat(this.ancestors.stream(), subStateAncestors.stream().map(a -> AggregationNormalizerImpl.this.iqFactory.createConstructionNode((ImmutableSet<Variable>)Sets.union(a.getVariables(), this.aggregationSubstitution.getDomain()).immutableCopy(), a.getSubstitution()))).collect(ImmutableCollectors.toList());
            Substitution newAggregationSubstitution = subStateAncestors.stream().reduce(this.aggregationSubstitution, (s, a) -> a.getSubstitution().compose((Substitution<ImmutableTerm>)s).builder().restrictDomainTo((Set<Variable>)this.aggregationSubstitution.getDomain()).transform(t -> (ImmutableFunctionalTerm)t).build(), (s1, s2) -> {
                throw new MinorOntopInternalBugException("Substitution merging was not expected");
            });
            ImmutableSet newGroupingVariables = subStateAncestors.isEmpty() ? this.groupingVariables : Sets.difference(((ConstructionNode)subStateAncestors.get(subStateAncestors.size() - 1)).getChildVariables(), newAggregationSubstitution.getDomain()).immutableCopy();
            Optional<Variable> sampleVariable = newGroupingVariables.isEmpty() && !this.groupingVariables.isEmpty() ? Optional.of(this.variableGenerator.generateNewVariable("aggv")) : Optional.empty();
            Substitution finalAggregationSubstitution = sampleVariable.map(s -> newAggregationSubstitution.compose(AggregationNormalizerImpl.this.substitutionFactory.getSubstitution((Variable)sampleVariable.get(), AggregationNormalizerImpl.this.termFactory.getDBSample(AggregationNormalizerImpl.this.termFactory.getDBIntegerConstant(1), AggregationNormalizerImpl.this.termFactory.getTypeFactory().getDBTypeFactory().getDBLargeIntegerType()))).builder().transform(t -> (ImmutableFunctionalTerm)t).build()).orElse(newAggregationSubstitution);
            ConstructionNode newChildConstructionNode = subState.getChildConstructionNode().filter(n -> !n.getSubstitution().isEmpty()).map(n -> AggregationNormalizerImpl.this.iqFactory.createConstructionNode(AggregationNormalizerImpl.this.iqTreeTools.extractChildVariables((ImmutableSet<Variable>)newGroupingVariables, finalAggregationSubstitution), n.getSubstitution())).orElse(null);
            Optional<FilterNode> newFilter = sampleVariable.map(s -> AggregationNormalizerImpl.this.iqFactory.createFilterNode(AggregationNormalizerImpl.this.termFactory.getDBIsNotNull((ImmutableTerm)s)));
            return new AggregationNormalizationState((ImmutableList<ConstructionNode>)newAncestors, (ImmutableSet<Variable>)newGroupingVariables, finalAggregationSubstitution, newChildConstructionNode, subState.getGrandChildTree(), this.variableGenerator, newFilter.orElse(null));
        }

        public AggregationNormalizationState simplifyAggregationSubstitution() {
            VariableNullability variableNullability = AggregationNormalizerImpl.this.iqTreeTools.createOptionalUnaryIQTree(Optional.ofNullable(this.childConstructionNode), this.grandChild).getVariableNullability();
            Substitution<ImmutableTerm> simplifiedSubstitution = this.aggregationSubstitution.transform(t -> t.simplify(variableNullability));
            ImmutableMap decompositionMap = simplifiedSubstitution.builder().restrictRangeTo(ImmutableFunctionalTerm.class).toMapIgnoreOptional((v, t) -> this.decomposeFunctionalTerm((ImmutableFunctionalTerm)t));
            Substitution<ImmutableTerm> liftedSubstitution = AggregationNormalizerImpl.this.substitutionFactory.union(simplifiedSubstitution.restrictRangeTo(NonFunctionalTerm.class), simplifiedSubstitution.builder().restrictRangeTo(ImmutableFunctionalTerm.class).transformOrRemove(arg_0 -> decompositionMap.get(arg_0), ImmutableFunctionalTerm.FunctionalTermDecomposition::getLiftableTerm).build());
            Substitution<ImmutableFunctionalTerm> newAggregationSubstitution = simplifiedSubstitution.builder().restrictRangeTo(ImmutableFunctionalTerm.class).flatTransform(arg_0 -> decompositionMap.get(arg_0), ImmutableFunctionalTerm.FunctionalTermDecomposition::getSubstitution).build();
            if (liftedSubstitution.isEmpty()) {
                return new AggregationNormalizationState(this.ancestors, this.groupingVariables, newAggregationSubstitution, this.childConstructionNode, this.grandChild, this.variableGenerator, this.sampleFilter);
            }
            ConstructionNode liftedConstructionNode = AggregationNormalizerImpl.this.iqFactory.createConstructionNode((ImmutableSet<Variable>)Sets.union(this.groupingVariables, this.aggregationSubstitution.getDomain()).immutableCopy(), liftedSubstitution);
            ImmutableSet newGroupingVariables = Sets.difference(liftedConstructionNode.getChildVariables(), newAggregationSubstitution.getDomain()).immutableCopy();
            ImmutableList newAncestors = (ImmutableList)Stream.concat(this.ancestors.stream(), Stream.of(liftedConstructionNode)).collect(ImmutableCollectors.toList());
            return new AggregationNormalizationState((ImmutableList<ConstructionNode>)newAncestors, (ImmutableSet<Variable>)newGroupingVariables, newAggregationSubstitution, this.childConstructionNode, this.grandChild, this.variableGenerator, this.sampleFilter);
        }

        protected Optional<ImmutableFunctionalTerm.FunctionalTermDecomposition> decomposeFunctionalTerm(ImmutableFunctionalTerm functionalTerm) {
            FunctionSymbol functionSymbol = functionalTerm.getFunctionSymbol();
            if (functionSymbol.isAggregation()) {
                return Optional.empty();
            }
            ImmutableList<? extends ImmutableTerm> arguments = functionalTerm.getTerms();
            ImmutableMap<Integer, ImmutableFunctionalTerm.FunctionalTermDecomposition> subTermDecompositions = IntStream.range(0, arguments.size()).filter(i -> arguments.get(i) instanceof ImmutableFunctionalTerm).boxed().collect(ImmutableCollectors.toMap(i -> i, i -> this.getFunctionalTermDecomposition((ImmutableFunctionalTerm)arguments.get(i.intValue()))));
            ImmutableList newArguments = (ImmutableList)IntStream.range(0, arguments.size()).mapToObj(i -> Optional.ofNullable((ImmutableFunctionalTerm.FunctionalTermDecomposition)subTermDecompositions.get((Object)i)).map(ImmutableFunctionalTerm.FunctionalTermDecomposition::getLiftableTerm).orElseGet(() -> (ImmutableTerm)arguments.get(i))).collect(ImmutableCollectors.toList());
            ImmutableFunctionalTerm newFunctionalTerm = AggregationNormalizerImpl.this.termFactory.getImmutableFunctionalTerm(functionSymbol, (ImmutableList<? extends ImmutableTerm>)newArguments);
            Substitution subTermSubstitution = subTermDecompositions.values().stream().map(ImmutableFunctionalTerm.FunctionalTermDecomposition::getSubstitution).reduce(AggregationNormalizerImpl.this.substitutionFactory.getSubstitution(), AggregationNormalizerImpl.this.substitutionFactory::union);
            return Optional.of(AggregationNormalizerImpl.this.termFactory.getFunctionalTermDecomposition(newFunctionalTerm, subTermSubstitution));
        }

        private ImmutableFunctionalTerm.FunctionalTermDecomposition getFunctionalTermDecomposition(ImmutableFunctionalTerm arg) {
            return this.decomposeFunctionalTerm(arg).orElseGet(() -> {
                Variable var = this.variableGenerator.generateNewVariable();
                return AggregationNormalizerImpl.this.termFactory.getFunctionalTermDecomposition(var, AggregationNormalizerImpl.this.substitutionFactory.getSubstitution(var, arg));
            });
        }

        protected IQTree createNormalizedTree(IQTreeCache normalizedTreeCache) {
            IQTree newChildTree = AggregationNormalizerImpl.this.iqTreeTools.createOptionalUnaryIQTree(Optional.ofNullable(this.childConstructionNode), this.grandChild);
            AggregationNode aggregationNode = AggregationNormalizerImpl.this.iqFactory.createAggregationNode(this.groupingVariables, this.aggregationSubstitution);
            UnaryIQTree aggregationTree = AggregationNormalizerImpl.this.iqFactory.createUnaryIQTree(aggregationNode, newChildTree, normalizedTreeCache);
            IQTree baseTree = AggregationNormalizerImpl.this.iqTreeTools.createOptionalUnaryIQTree(Optional.ofNullable(this.sampleFilter), aggregationTree);
            return AggregationNormalizerImpl.this.iqTreeTools.createAncestorsUnaryIQTree((ImmutableList<? extends UnaryOperatorNode>)this.ancestors.reverse(), baseTree).normalizeForOptimization(this.variableGenerator);
        }
    }
}

