/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.node.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.injection.OntopModelSettings;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.LeafIQTree;
import it.unibz.inf.ontop.iq.exception.InvalidIntermediateQueryException;
import it.unibz.inf.ontop.iq.exception.QueryNodeTransformationException;
import it.unibz.inf.ontop.iq.impl.IQTreeTools;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.FilterNode;
import it.unibz.inf.ontop.iq.node.QueryNodeVisitor;
import it.unibz.inf.ontop.iq.node.ValuesNode;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.iq.node.impl.LeafIQTreeImpl;
import it.unibz.inf.ontop.iq.request.FunctionalDependencies;
import it.unibz.inf.ontop.iq.request.VariableNonRequirement;
import it.unibz.inf.ontop.iq.transform.IQTreeExtendedTransformer;
import it.unibz.inf.ontop.iq.transform.IQTreeVisitingTransformer;
import it.unibz.inf.ontop.iq.transform.node.HomogeneousQueryNodeTransformer;
import it.unibz.inf.ontop.iq.visit.IQVisitor;
import it.unibz.inf.ontop.model.term.Constant;
import it.unibz.inf.ontop.model.term.DBConstant;
import it.unibz.inf.ontop.model.term.GroundFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.NonVariableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import it.unibz.inf.ontop.model.term.functionsymbol.FunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBStrictEqFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBTypeConversionFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.ObjectStringTemplateFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.StringConstantDecomposer;
import it.unibz.inf.ontop.substitution.InjectiveSubstitution;
import it.unibz.inf.ontop.substitution.Substitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.CoreUtilsFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public class ValuesNodeImpl
extends LeafIQTreeImpl
implements ValuesNode {
    private static final String VALUES_NODE_STR = "VALUES";
    private final ImmutableList<Variable> orderedVariables;
    private final ImmutableSet<Variable> projectedVariables;
    private final ImmutableList<ImmutableMap<Variable, Constant>> valueMaps;
    private final CoreUtilsFactory coreUtilsFactory;
    private final SubstitutionFactory substitutionFactory;
    private final TermFactory termFactory;
    private final OntopModelSettings settings;
    private boolean isNormalized = false;
    private VariableNullability variableNullability;
    private Boolean isDistinct;
    private ImmutableSet<Substitution<NonVariableTerm>> possibleVariableDefinitions;
    private ImmutableSet<ImmutableSet<Variable>> uniqueConstraints;

    @AssistedInject
    protected ValuesNodeImpl(@Assisted(value="orderedVariables") ImmutableList<Variable> orderedVariables, @Assisted(value="values") ImmutableList<ImmutableList<Constant>> values, IQTreeTools iqTreeTools, IntermediateQueryFactory iqFactory, CoreUtilsFactory coreUtilsFactory, OntopModelSettings settings, SubstitutionFactory substitutionFactory, TermFactory termFactory) {
        this((ImmutableSet<Variable>)ImmutableSet.copyOf(orderedVariables), (ImmutableList<ImmutableMap<Variable, Constant>>)((ImmutableList)values.stream().map(tuple -> IntStream.range(0, orderedVariables.size()).mapToObj(i -> Maps.immutableEntry((Object)((Variable)orderedVariables.get(i)), (Object)((Constant)tuple.get(i)))).collect(ImmutableCollectors.toMap())).collect(ImmutableCollectors.toList())), iqTreeTools, iqFactory, coreUtilsFactory, settings, substitutionFactory, termFactory);
    }

    @AssistedInject
    protected ValuesNodeImpl(@Assisted(value="projectedVariables") ImmutableSet<Variable> projectedVariables, @Assisted(value="valueMaps") ImmutableList<ImmutableMap<Variable, Constant>> valueMaps, IQTreeTools iqTreeTools, IntermediateQueryFactory iqFactory, CoreUtilsFactory coreUtilsFactory, OntopModelSettings settings, SubstitutionFactory substitutionFactory, TermFactory termFactory) {
        this(projectedVariables, valueMaps, null, iqTreeTools, iqFactory, coreUtilsFactory, settings, substitutionFactory, termFactory);
    }

    private ValuesNodeImpl(ImmutableSet<Variable> projectedVariables, ImmutableList<ImmutableMap<Variable, Constant>> valueMaps, @Nullable ImmutableSet<ImmutableSet<Variable>> uniqueConstraints, IQTreeTools iqTreeTools, IntermediateQueryFactory iqFactory, CoreUtilsFactory coreUtilsFactory, OntopModelSettings settings, SubstitutionFactory substitutionFactory, TermFactory termFactory) {
        super(iqTreeTools, iqFactory);
        this.projectedVariables = projectedVariables;
        this.orderedVariables = ImmutableList.copyOf(projectedVariables);
        this.valueMaps = valueMaps;
        this.coreUtilsFactory = coreUtilsFactory;
        this.substitutionFactory = substitutionFactory;
        this.termFactory = termFactory;
        this.uniqueConstraints = uniqueConstraints;
        this.settings = settings;
        if (settings.isTestModeEnabled()) {
            this.validate();
        }
    }

    @Override
    public ImmutableList<ImmutableList<Constant>> getValues() {
        return (ImmutableList)this.valueMaps.stream().map(tuple -> (ImmutableList)this.orderedVariables.stream().map(arg_0 -> ((ImmutableMap)tuple).get(arg_0)).collect(ImmutableCollectors.toList())).collect(ImmutableCollectors.toList());
    }

    @Override
    public ImmutableList<ImmutableMap<Variable, Constant>> getValueMaps() {
        return this.valueMaps;
    }

    @Override
    public IQTree normalizeForOptimization(VariableGenerator variableGenerator) {
        if (this.isNormalized) {
            return this;
        }
        Optional<ConstructionAndValues> lift = this.liftSingleValueVariables();
        if (lift.isPresent()) {
            LeafIQTree normalizedLeaf = this.furtherNormalize(lift.get().valuesNode);
            return this.iqFactory.createUnaryIQTree(lift.get().constructionNode, normalizedLeaf, this.iqFactory.createIQTreeCache(true));
        }
        return this.furtherNormalize(this);
    }

    private Optional<ConstructionAndValues> liftSingleValueVariables() {
        ImmutableSet singleValueVariables = (ImmutableSet)this.projectedVariables.stream().filter(v -> 1L == ((Stream)this.getValueStream((Variable)v).unordered()).distinct().count()).collect(ImmutableCollectors.toSet());
        if (!singleValueVariables.isEmpty()) {
            Substitution<ImmutableTerm> substitutions = singleValueVariables.stream().collect(this.substitutionFactory.toSubstitution(v -> v, v -> (ImmutableTerm)((ImmutableMap)this.valueMaps.get(0)).get(v)));
            ConstructionNode constructionNode = this.iqFactory.createConstructionNode(this.projectedVariables, substitutions);
            ImmutableSet multiValueVariables = Sets.difference(this.projectedVariables, (Set)singleValueVariables).immutableCopy();
            ImmutableList newValuesNodeValues = (ImmutableList)this.valueMaps.stream().map(tuple -> tuple.entrySet().stream().filter(e -> multiValueVariables.contains(e.getKey())).collect(ImmutableCollectors.toMap())).collect(ImmutableCollectors.toList());
            ValuesNode valuesNode = this.iqFactory.createValuesNode((ImmutableSet<Variable>)multiValueVariables, (ImmutableList<ImmutableMap<Variable, Constant>>)newValuesNodeValues);
            return Optional.of(new ConstructionAndValues(constructionNode, valuesNode));
        }
        return Optional.empty();
    }

    private LeafIQTree furtherNormalize(ValuesNode valuesNode) {
        if (valuesNode.getValues().isEmpty()) {
            return this.iqFactory.createEmptyNode(valuesNode.getVariables());
        }
        if (valuesNode.getVariables().isEmpty() && valuesNode.getValues().size() == 1) {
            return this.iqFactory.createTrueNode();
        }
        if (valuesNode == this) {
            this.isNormalized = true;
        }
        return valuesNode;
    }

    @Override
    public Stream<Constant> getValueStream(Variable variable) {
        if (!this.projectedVariables.contains((Object)variable)) {
            return Stream.empty();
        }
        return this.valueMaps.stream().map(t -> (Constant)t.get((Object)variable));
    }

    @Override
    public void acceptVisitor(QueryNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public ValuesNode acceptNodeTransformer(HomogeneousQueryNodeTransformer transformer) throws QueryNodeTransformationException {
        return transformer.transform(this);
    }

    @Override
    public ImmutableSet<Variable> getLocalVariables() {
        return this.projectedVariables;
    }

    @Override
    public ImmutableSet<Variable> getLocallyRequiredVariables() {
        return ImmutableSet.of();
    }

    @Override
    public ImmutableSet<Variable> getLocallyDefinedVariables() {
        return this.projectedVariables;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ValuesNodeImpl) {
            ValuesNodeImpl that = (ValuesNodeImpl)o;
            return this.projectedVariables.equals(that.projectedVariables) && this.valueMaps.equals(that.valueMaps);
        }
        return false;
    }

    @Override
    public boolean wouldKeepDescendingGroundTermInFilterAbove(Variable variable, boolean isConstant) {
        return this.projectedVariables.contains((Object)variable) && !isConstant;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.projectedVariables, this.valueMaps);
    }

    @Override
    public ImmutableSet<Variable> getVariables() {
        return this.projectedVariables;
    }

    @Override
    public IQTree acceptTransformer(IQTreeVisitingTransformer transformer) {
        return transformer.transformValues(this);
    }

    @Override
    public <T> IQTree acceptTransformer(IQTreeExtendedTransformer<T> transformer, T context) {
        return transformer.transformValues(this, context);
    }

    @Override
    public <T> T acceptVisitor(IQVisitor<T> visitor) {
        return visitor.visitValues(this);
    }

    @Override
    public ValuesNode applyFreshRenaming(InjectiveSubstitution<Variable> freshRenamingSubstitution) {
        ImmutableSet<Variable> newVariables = this.substitutionFactory.apply(freshRenamingSubstitution, this.projectedVariables);
        if (newVariables.equals(this.projectedVariables)) {
            return this;
        }
        ImmutableSet newUniqueConstraints = this.uniqueConstraints == null ? null : (ImmutableSet)this.uniqueConstraints.stream().map(s -> this.substitutionFactory.apply((Substitution<Variable>)freshRenamingSubstitution, (ImmutableSet<Variable>)s)).collect(ImmutableCollectors.toSet());
        ImmutableList newValueMaps = (ImmutableList)this.valueMaps.stream().map(tuple -> tuple.entrySet().stream().map(e -> Maps.immutableEntry((Object)this.substitutionFactory.apply((Substitution<Variable>)freshRenamingSubstitution, (Variable)e.getKey()), (Object)((Constant)e.getValue()))).collect(ImmutableCollectors.toMap())).collect(ImmutableCollectors.toList());
        return new ValuesNodeImpl(newVariables, (ImmutableList<ImmutableMap<Variable, Constant>>)newValueMaps, (ImmutableSet<ImmutableSet<Variable>>)newUniqueConstraints, this.iqTreeTools, this.iqFactory, this.coreUtilsFactory, this.settings, this.substitutionFactory, this.termFactory);
    }

    @Override
    public IQTree applyDescendingSubstitutionWithoutOptimizing(Substitution<? extends VariableOrGroundTerm> descendingSubstitution, VariableGenerator variableGenerator) {
        FilterNode filterNode;
        ConstructionNode constructionNode;
        if (descendingSubstitution.isEmpty()) {
            return this;
        }
        IQTree valuesNode = this;
        Substitution<GroundFunctionalTerm> functionalSubstitutionFragment = descendingSubstitution.restrictRangeTo(GroundFunctionalTerm.class);
        if (!functionalSubstitutionFragment.isEmpty()) {
            InjectiveSubstitution<Variable> renaming = Sets.intersection(valuesNode.getVariables(), functionalSubstitutionFragment.getDomain()).stream().collect(this.substitutionFactory.toFreshRenamingSubstitution(variableGenerator));
            ImmutableExpression filterCondition = this.termFactory.getConjunction(this.substitutionFactory.rename(renaming, functionalSubstitutionFragment).builder().toStream((x$0, x$1) -> this.termFactory.getStrictEquality((ImmutableTerm)x$0, (ImmutableTerm)x$1, new ImmutableTerm[0]))).orElseThrow(() -> new MinorOntopInternalBugException("There must be an exception"));
            constructionNode = this.iqFactory.createConstructionNode((ImmutableSet<Variable>)Sets.difference(valuesNode.getVariables(), descendingSubstitution.getDomain()).immutableCopy());
            filterNode = this.iqFactory.createFilterNode(filterCondition);
            valuesNode = valuesNode.applyFreshRenaming((InjectiveSubstitution)renaming);
        } else {
            constructionNode = null;
            filterNode = null;
        }
        Substitution<Constant> constantSubstitutionFragment = descendingSubstitution.restrictRangeTo(Constant.class);
        valuesNode = this.substituteConstants(constantSubstitutionFragment, (ValuesNode)valuesNode);
        Substitution<Variable> variableSubstitutionFragment = descendingSubstitution.restrictRangeTo(Variable.class);
        valuesNode = this.substituteVariables(variableSubstitutionFragment, (ValuesNode)valuesNode);
        if (constructionNode == null) {
            return valuesNode;
        }
        return this.iqFactory.createUnaryIQTree(constructionNode, this.iqFactory.createUnaryIQTree(filterNode, valuesNode));
    }

    private ValuesNode substituteConstants(Substitution<Constant> substitution, ValuesNode valuesNode) {
        ImmutableSet<Variable> variables = valuesNode.getVariables();
        ImmutableSet newProjectionVariables = Sets.difference(variables, substitution.getDomain()).immutableCopy();
        if (newProjectionVariables.size() == variables.size()) {
            return valuesNode;
        }
        ImmutableList newValues = (ImmutableList)valuesNode.getValueMaps().stream().filter(tuple -> tuple.entrySet().stream().filter(e -> substitution.isDefining((Variable)e.getKey())).allMatch(e -> ((Constant)e.getValue()).equals(substitution.get((Variable)e.getKey())))).map(tuple -> tuple.entrySet().stream().filter(e -> !substitution.isDefining((Variable)e.getKey())).collect(ImmutableCollectors.toMap())).collect(ImmutableCollectors.toList());
        return this.iqFactory.createValuesNode((ImmutableSet<Variable>)newProjectionVariables, (ImmutableList<ImmutableMap<Variable, Constant>>)newValues);
    }

    private ValuesNode substituteVariables(Substitution<Variable> variableSubstitutionFragment, ValuesNode valuesNode) {
        ImmutableList newValues;
        ImmutableSet<Variable> variables = valuesNode.getVariables();
        ImmutableSet<Variable> newVariables = this.substitutionFactory.apply(variableSubstitutionFragment, variables);
        if (newVariables.equals(variables)) {
            return valuesNode;
        }
        if (newVariables.size() == variables.size()) {
            newValues = (ImmutableList)valuesNode.getValueMaps().stream().map(tuple -> tuple.entrySet().stream().map(e -> Maps.immutableEntry((Object)this.substitutionFactory.apply(variableSubstitutionFragment, (Variable)e.getKey()), (Object)((Constant)e.getValue()))).collect(ImmutableCollectors.toMap())).collect(ImmutableCollectors.toList());
        } else {
            ImmutableSet firstFoundVariables = (ImmutableSet)newVariables.stream().map(v -> variables.stream().filter(u -> this.substitutionFactory.apply(variableSubstitutionFragment, (Variable)u).equals(v)).findFirst().orElseThrow(() -> new MinorOntopInternalBugException("expected a non-empty pre-image"))).collect(ImmutableCollectors.toSet());
            newValues = (ImmutableList)valuesNode.getValueMaps().stream().filter(tuple -> tuple.entrySet().stream().allMatch(e1 -> tuple.entrySet().stream().filter(e2 -> variableSubstitutionFragment.apply((Variable)e1.getKey()).equals(variableSubstitutionFragment.apply((Variable)e2.getKey()))).allMatch(e2 -> ((Constant)e1.getValue()).equals(e2.getValue())))).map(tuple -> tuple.entrySet().stream().filter(e -> firstFoundVariables.contains(e.getKey())).map(e -> Maps.immutableEntry((Object)this.substitutionFactory.apply(variableSubstitutionFragment, (Variable)e.getKey()), (Object)((Constant)e.getValue()))).collect(ImmutableCollectors.toMap())).collect(ImmutableCollectors.toList());
        }
        return this.iqFactory.createValuesNode(newVariables, (ImmutableList<ImmutableMap<Variable, Constant>>)newValues);
    }

    @Override
    public IQTree propagateDownConstraint(ImmutableExpression constraint, VariableGenerator variableGenerator) {
        if (constraint.isGround()) {
            return this;
        }
        ImmutableMap<Boolean, ImmutableList<ImmutableExpression>> constraintClassification = constraint.flattenAND().collect(ImmutableCollectors.partitioningBy(e -> {
            if (!(e.getFunctionSymbol() instanceof DBStrictEqFunctionSymbol)) return false;
            if (e.getArity() != 2) return false;
            if (!e.getTerms().stream().filter(t -> t instanceof Variable).map(t -> (Variable)t).anyMatch(arg_0 -> this.projectedVariables.contains(arg_0))) return false;
            return true;
        }));
        ImmutableList strictEqualities = Optional.ofNullable((ImmutableList)constraintClassification.get((Object)true)).orElseGet(ImmutableList::of);
        ImmutableList otherConditions = Optional.ofNullable((ImmutableList)constraintClassification.get((Object)false)).orElseGet(ImmutableList::of);
        if (strictEqualities.isEmpty()) {
            return this.filterValuesNodeEntries(constraint);
        }
        ImmutableExpression firstStrictEquality = (ImmutableExpression)strictEqualities.get(0);
        Optional<IQTree> optionalReshapedTree = this.tryToReshapeValuesNodeToConstructFunctionalTerm(firstStrictEquality, variableGenerator);
        if (optionalReshapedTree.isPresent()) {
            IQTree reshapedTree = optionalReshapedTree.get();
            return this.termFactory.getConjunction(constraint.flattenAND().filter(c -> !c.equals(firstStrictEquality))).map(c -> reshapedTree.propagateDownConstraint((ImmutableExpression)c, variableGenerator)).orElse(reshapedTree);
        }
        IQTree filteredValuesNode = this.filterValuesNodeEntries(this.termFactory.getConjunction((ImmutableList<ImmutableExpression>)((ImmutableList)Stream.concat(Stream.of(firstStrictEquality), otherConditions.stream()).collect(ImmutableCollectors.toList()))));
        ImmutableList otherStrictEqualities = strictEqualities.subList(1, strictEqualities.size());
        return otherStrictEqualities.isEmpty() ? filteredValuesNode : this.propagateDownConstraint(this.termFactory.getConjunction((ImmutableList<ImmutableExpression>)otherStrictEqualities), variableGenerator);
    }

    private Optional<IQTree> tryToReshapeValuesNodeToConstructFunctionalTerm(ImmutableExpression binaryStrictEquality, VariableGenerator variableGenerator) {
        Variable variable = binaryStrictEquality.getTerms().stream().filter(t -> t instanceof Variable).map(v -> (Variable)v).filter(arg_0 -> this.projectedVariables.contains(arg_0)).findAny().orElseThrow(() -> new MinorOntopInternalBugException("A projected variable was expected as argument"));
        Optional<ImmutableFunctionalTerm> optionalFunctionalArgument = binaryStrictEquality.getTerms().stream().filter(t -> !t.equals(variable)).filter(t -> t instanceof ImmutableFunctionalTerm).map(t -> (ImmutableFunctionalTerm)t).findAny();
        if (optionalFunctionalArgument.isEmpty()) {
            return Optional.empty();
        }
        ImmutableFunctionalTerm functionalTerm = optionalFunctionalArgument.get();
        FunctionSymbol functionSymbol = functionalTerm.getFunctionSymbol();
        if (functionSymbol instanceof ObjectStringTemplateFunctionSymbol) {
            ObjectStringTemplateFunctionSymbol objectStringTemplateFunctionSymbol = (ObjectStringTemplateFunctionSymbol)functionSymbol;
            VariableNullability simplifiedVariableNullability = this.coreUtilsFactory.createSimplifiedVariableNullability(functionalTerm);
            return objectStringTemplateFunctionSymbol.getDecomposer(functionalTerm.getTerms(), this.termFactory, simplifiedVariableNullability).flatMap(decomposer -> this.decompose((StringConstantDecomposer)decomposer, variable, objectStringTemplateFunctionSymbol, variableGenerator));
        }
        if (functionSymbol instanceof DBTypeConversionFunctionSymbol) {
            DBTypeConversionFunctionSymbol dbTypeConversionFunctionSymbol = (DBTypeConversionFunctionSymbol)functionSymbol;
            return dbTypeConversionFunctionSymbol.getDecomposer(this.termFactory).flatMap(decomposer -> this.decompose((StringConstantDecomposer)decomposer, variable, functionSymbol, variableGenerator));
        }
        return Optional.empty();
    }

    private Optional<IQTree> decompose(StringConstantDecomposer decomposer, Variable variableToReplace, FunctionSymbol functionSymbol, VariableGenerator variableGenerator) {
        ImmutableList newVariables = (ImmutableList)IntStream.range(0, functionSymbol.getArity()).mapToObj(i -> variableGenerator.generateNewVariable()).collect(ImmutableCollectors.toList());
        ImmutableList newValues = (ImmutableList)this.valueMaps.stream().map(tuple -> Optional.of((Constant)tuple.get((Object)variableToReplace)).filter(c -> c instanceof DBConstant).map(c -> (DBConstant)c).flatMap(c -> decomposer.decompose((DBConstant)c).map(additionalColumns -> Streams.concat((Stream[])new Stream[]{tuple.entrySet().stream().filter(e -> !((Variable)e.getKey()).equals(variableToReplace)), IntStream.range(0, newVariables.size()).mapToObj(i -> Maps.immutableEntry((Object)((Variable)newVariables.get(i)), (Object)((Constant)additionalColumns.get(i))))}).collect(ImmutableCollectors.toMap())))).flatMap(Optional::stream).collect(ImmutableCollectors.toList());
        if (newValues.isEmpty()) {
            return Optional.of(this.iqFactory.createEmptyNode(this.projectedVariables));
        }
        ImmutableSet newProjectedVariables = Sets.union((Set)Sets.difference(this.projectedVariables, (Set)ImmutableSet.of((Object)variableToReplace)), (Set)ImmutableSet.copyOf((Collection)newVariables)).immutableCopy();
        ValuesNode newValueNode = this.iqFactory.createValuesNode((ImmutableSet<Variable>)newProjectedVariables, (ImmutableList<ImmutableMap<Variable, Constant>>)newValues);
        ConstructionNode constructionNode = this.iqFactory.createConstructionNode(this.projectedVariables, this.substitutionFactory.getSubstitution(variableToReplace, this.termFactory.getImmutableFunctionalTerm(functionSymbol, (ImmutableList<? extends ImmutableTerm>)newVariables)));
        return Optional.of(this.iqFactory.createUnaryIQTree(constructionNode, newValueNode).normalizeForOptimization(variableGenerator));
    }

    private IQTree filterValuesNodeEntries(ImmutableExpression constraint) {
        VariableNullability variableNullability = this.getVariableNullability();
        ImmutableList newValues = (ImmutableList)this.valueMaps.stream().filter(tuple -> !tuple.entrySet().stream().collect(this.substitutionFactory.toSubstitution()).apply(constraint).evaluate2VL(variableNullability).isEffectiveFalse()).collect(ImmutableCollectors.toList());
        return this.iqFactory.createValuesNode(this.projectedVariables, (ImmutableList<ImmutableMap<Variable, Constant>>)newValues);
    }

    @Override
    public ImmutableSet<Substitution<NonVariableTerm>> getPossibleVariableDefinitions() {
        if (this.possibleVariableDefinitions == null) {
            Stream distinctValuesStream = this.isDistinct != null && this.isDistinct != false ? this.valueMaps.stream() : this.valueMaps.stream().distinct();
            this.possibleVariableDefinitions = (ImmutableSet)distinctValuesStream.map(tuple -> tuple.entrySet().stream().collect(this.substitutionFactory.toSubstitution())).collect(ImmutableCollectors.toSet());
        }
        return this.possibleVariableDefinitions;
    }

    @Override
    public ImmutableSet<Variable> getKnownVariables() {
        return this.projectedVariables;
    }

    @Override
    public boolean isDistinct() {
        if (this.isDistinct == null) {
            this.isDistinct = (long)this.valueMaps.size() == ((Stream)this.valueMaps.stream().unordered()).distinct().count();
        }
        return this.isDistinct;
    }

    @Override
    public boolean isDeclaredAsEmpty() {
        return this.valueMaps.isEmpty();
    }

    @Override
    public synchronized VariableNullability getVariableNullability() {
        if (this.variableNullability == null) {
            ImmutableSet nullableGroups = (ImmutableSet)this.orderedVariables.stream().filter(v -> this.getValueStream((Variable)v).anyMatch(ImmutableTerm::isNull)).map(ImmutableSet::of).collect(ImmutableCollectors.toSet());
            this.variableNullability = this.coreUtilsFactory.createVariableNullability((ImmutableSet<ImmutableSet<Variable>>)nullableGroups, this.projectedVariables);
        }
        return this.variableNullability;
    }

    @Override
    public void validate() throws InvalidIntermediateQueryException {
        if (this.orderedVariables.size() != this.projectedVariables.size()) {
            throw new InvalidIntermediateQueryException("Variables must be unique");
        }
    }

    @Override
    public synchronized ImmutableSet<ImmutableSet<Variable>> inferUniqueConstraints() {
        if (this.uniqueConstraints == null) {
            this.uniqueConstraints = this.computeUniqueConstraints();
        }
        return this.uniqueConstraints;
    }

    private ImmutableSet<ImmutableSet<Variable>> computeUniqueConstraints() {
        int count = this.valueMaps.size();
        ImmutableSet atomicConstraints = (ImmutableSet)this.getVariables().stream().filter(v -> this.getValueStream((Variable)v).distinct().count() == (long)count).map(ImmutableSet::of).collect(ImmutableCollectors.toSet());
        if (!atomicConstraints.isEmpty()) {
            return atomicConstraints;
        }
        if (this.isDistinct()) {
            return ImmutableSet.of(this.getVariables());
        }
        return ImmutableSet.of();
    }

    @Override
    public FunctionalDependencies inferFunctionalDependencies() {
        return FunctionalDependencies.empty();
    }

    @Override
    public VariableNonRequirement getVariableNonRequirement() {
        return VariableNonRequirement.of(this.projectedVariables);
    }

    @Override
    public ImmutableList<Variable> getOrderedVariables() {
        return this.orderedVariables;
    }

    public String toString() {
        String valuesString = this.valueMaps.stream().map(tuple -> this.orderedVariables.stream().map(arg_0 -> ((ImmutableMap)tuple).get(arg_0)).map(String::valueOf).collect(Collectors.joining(",", " (", ")"))).collect(StringBuilder::new, StringBuilder::append, StringBuilder::append).toString();
        return "VALUES " + this.orderedVariables + valuesString;
    }

    private static class ConstructionAndValues {
        public final ConstructionNode constructionNode;
        public final ValuesNode valuesNode;

        private ConstructionAndValues(ConstructionNode constructionNode, ValuesNode valuesNode) {
            this.constructionNode = constructionNode;
            this.valuesNode = valuesNode;
        }
    }
}

