/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.node.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import it.unibz.inf.ontop.evaluator.TermNullabilityEvaluator;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.impl.IQTreeTools;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.utils.CoreUtilsFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;

public class JoinOrFilterVariableNullabilityTools {
    private final TermNullabilityEvaluator nullabilityEvaluator;
    private final CoreUtilsFactory coreUtilsFactory;
    private final IQTreeTools iqTreeTools;

    @Inject
    private JoinOrFilterVariableNullabilityTools(TermNullabilityEvaluator nullabilityEvaluator, CoreUtilsFactory coreUtilsFactory, IQTreeTools iqTreeTools) {
        this.nullabilityEvaluator = nullabilityEvaluator;
        this.coreUtilsFactory = coreUtilsFactory;
        this.iqTreeTools = iqTreeTools;
    }

    public VariableNullability getChildrenVariableNullability(ImmutableList<IQTree> children) {
        return this.getVariableNullability(children, Optional.empty());
    }

    public VariableNullability getVariableNullability(ImmutableList<IQTree> children, Optional<ImmutableExpression> joiningCondition) {
        ImmutableMap variableProvenanceMap = children.stream().flatMap(c -> c.getVariables().stream().map(v -> Maps.immutableEntry((Object)v, (Object)c))).collect(ImmutableCollectors.toMultimap()).asMap();
        ImmutableSet coOccuringVariables = (ImmutableSet)variableProvenanceMap.entrySet().stream().filter(e -> ((Collection)e.getValue()).size() > 1).map(Map.Entry::getKey).collect(ImmutableCollectors.toSet());
        ImmutableSet nullableGroups = (ImmutableSet)children.stream().flatMap(c -> c.getVariableNullability().getNullableGroups().stream()).filter(g -> g.stream().noneMatch(arg_0 -> ((ImmutableSet)coOccuringVariables).contains(arg_0))).collect(ImmutableCollectors.toSet());
        ImmutableSet<Variable> scope = this.iqTreeTools.getChildrenVariables(children);
        return joiningCondition.map(e -> this.updateWithFilter((ImmutableExpression)e, (ImmutableSet<ImmutableSet<Variable>>)nullableGroups, scope)).orElseGet(() -> this.coreUtilsFactory.createVariableNullability((ImmutableSet<ImmutableSet<Variable>>)nullableGroups, scope));
    }

    public VariableNullability updateWithFilter(ImmutableExpression filter, ImmutableSet<ImmutableSet<Variable>> nullableGroups, ImmutableSet<Variable> scope) {
        ImmutableSet newNullableGroups = (ImmutableSet)nullableGroups.stream().filter(g -> !this.nullabilityEvaluator.isFilteringNullValues(filter, (ImmutableSet<Variable>)g)).collect(ImmutableCollectors.toSet());
        return this.coreUtilsFactory.createVariableNullability((ImmutableSet<ImmutableSet<Variable>>)newNullableGroups, scope);
    }

    public VariableNullability getSimplifiedVariableNullability(ImmutableSet<Variable> variables) {
        return this.coreUtilsFactory.createSimplifiedVariableNullability(variables.stream());
    }
}

