/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.node.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.IQTreeCache;
import it.unibz.inf.ontop.iq.UnaryIQTree;
import it.unibz.inf.ontop.iq.exception.InvalidIntermediateQueryException;
import it.unibz.inf.ontop.iq.exception.QueryNodeTransformationException;
import it.unibz.inf.ontop.iq.impl.IQTreeTools;
import it.unibz.inf.ontop.iq.node.FilterNode;
import it.unibz.inf.ontop.iq.node.FlattenNode;
import it.unibz.inf.ontop.iq.node.QueryNode;
import it.unibz.inf.ontop.iq.node.QueryNodeVisitor;
import it.unibz.inf.ontop.iq.node.UnionNode;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.iq.node.impl.CompositeQueryNodeImpl;
import it.unibz.inf.ontop.iq.node.normalization.FlattenNormalizer;
import it.unibz.inf.ontop.iq.request.FunctionalDependencies;
import it.unibz.inf.ontop.iq.request.VariableNonRequirement;
import it.unibz.inf.ontop.iq.transform.IQTreeExtendedTransformer;
import it.unibz.inf.ontop.iq.transform.IQTreeVisitingTransformer;
import it.unibz.inf.ontop.iq.transform.node.HomogeneousQueryNodeTransformer;
import it.unibz.inf.ontop.iq.visit.IQVisitor;
import it.unibz.inf.ontop.model.term.GroundTerm;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.NonVariableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.GenericDBTermType;
import it.unibz.inf.ontop.model.type.TermType;
import it.unibz.inf.ontop.substitution.InjectiveSubstitution;
import it.unibz.inf.ontop.substitution.Substitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class FlattenNodeImpl
extends CompositeQueryNodeImpl
implements FlattenNode {
    private final Variable flattenedVariable;
    private final Variable outputVariable;
    private final Optional<Variable> indexVariable;
    private final DBTermType flattenedType;
    private final FlattenNormalizer normalizer;

    @AssistedInject
    private FlattenNodeImpl(@Assisted(value="outputVariable") Variable outputVariable, @Assisted(value="flattenedVariable") Variable flattenedVariable, @Assisted Optional<Variable> indexVariable, @Assisted DBTermType flattenedType, SubstitutionFactory substitutionFactory, IntermediateQueryFactory iqFactory, TermFactory termFactory, FlattenNormalizer normalizer, IQTreeTools iqTreeTools) {
        super(substitutionFactory, termFactory, iqFactory, iqTreeTools);
        this.outputVariable = outputVariable;
        this.flattenedVariable = flattenedVariable;
        this.indexVariable = indexVariable;
        this.flattenedType = flattenedType;
        this.normalizer = normalizer;
    }

    @Override
    public Variable getFlattenedVariable() {
        return this.flattenedVariable;
    }

    @Override
    public DBTermType getFlattenedType() {
        return this.flattenedType;
    }

    @Override
    public Variable getOutputVariable() {
        return this.outputVariable;
    }

    @Override
    public Optional<Variable> getIndexVariable() {
        return this.indexVariable;
    }

    @Override
    public Optional<TermType> inferOutputType(Optional<TermType> flattenedVarType) {
        return flattenedVarType.filter(t -> t instanceof DBTermType).map(t -> (DBTermType)t).flatMap(t -> {
            switch (t.getCategory()) {
                case JSON: 
                case STRING: {
                    return flattenedVarType;
                }
                case ARRAY: {
                    return Optional.of((DBTermType)((GenericDBTermType)t).getGenericArguments().get(0));
                }
            }
            return Optional.empty();
        });
    }

    @Override
    public Optional<TermType> getIndexVariableType() {
        return Optional.of(this.termFactory.getTypeFactory().getDBTypeFactory().getDBLargeIntegerType());
    }

    @Override
    public ImmutableSet<Variable> getVariables(ImmutableSet<Variable> childVariables) {
        return Sets.union((Set)Sets.difference(childVariables, this.getLocalVariables()), this.getLocallyDefinedVariables()).immutableCopy();
    }

    @Override
    public void acceptVisitor(QueryNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public ImmutableSet<Variable> getLocalVariables() {
        return ImmutableSet.of((Object)this.flattenedVariable);
    }

    public String toString() {
        return "FLATTEN  [" + this.outputVariable + "/flatten(" + this.flattenedVariable + ")" + this.indexVariable.map(v -> ", " + v + "/indexIn(" + this.flattenedVariable + ")").orElse("") + "]";
    }

    @Override
    public ImmutableSet<Variable> getLocallyRequiredVariables() {
        return ImmutableSet.of((Object)this.flattenedVariable);
    }

    @Override
    public IQTree normalizeForOptimization(IQTree child, VariableGenerator variableGenerator, IQTreeCache treeCache) {
        return this.normalizer.normalizeForOptimization(this, child, variableGenerator, treeCache);
    }

    @Override
    public IQTree applyDescendingSubstitution(Substitution<? extends VariableOrGroundTerm> descendingSubstitution, Optional<ImmutableExpression> constraint, IQTree child, VariableGenerator variableGenerator) {
        return this.applyDescendingSubstitution(descendingSubstitution, constraint, child, variableGenerator, IQTree::applyDescendingSubstitution);
    }

    private IQTree applyDescendingSubstitution(Substitution<? extends VariableOrGroundTerm> descendingSubstitution, Optional<ImmutableExpression> constraint, IQTree child, VariableGenerator variableGenerator, PropagateToChild propagateToChild) {
        Substitution<GroundTerm> blockedSubstitution = descendingSubstitution.restrictRangeTo(GroundTerm.class).restrictDomainTo((Set<Variable>)this.extendWithIndexVariable((ImmutableSet<Variable>)ImmutableSet.of((Object)this.outputVariable, (Object)this.flattenedVariable)));
        InjectiveSubstitution<Variable> renaming = blockedSubstitution.getDomain().stream().collect(this.substitutionFactory.toFreshRenamingSubstitution(variableGenerator));
        Substitution<? extends VariableOrGroundTerm> newDescendingSubstitution = blockedSubstitution.isEmpty() ? descendingSubstitution : this.substitutionFactory.union(renaming, descendingSubstitution.removeFromDomain((Set<Variable>)blockedSubstitution.getDomain()));
        UnaryIQTree flattenTree = this.iqFactory.createUnaryIQTree(this.applySubstitution(newDescendingSubstitution), propagateToChild.apply(child, newDescendingSubstitution, constraint, variableGenerator));
        if (blockedSubstitution.isEmpty()) {
            return flattenTree;
        }
        Substitution<ImmutableTerm> renamedBlockedSubstitution = this.substitutionFactory.rename(renaming, blockedSubstitution);
        ImmutableExpression condition = this.termFactory.getConjunction((ImmutableList<ImmutableExpression>)((ImmutableList)renamedBlockedSubstitution.builder().toStream((x$0, x$1) -> this.termFactory.getStrictEquality((ImmutableTerm)x$0, (ImmutableTerm)x$1, new ImmutableTerm[0])).collect(ImmutableCollectors.toList())));
        FilterNode filterNode = this.iqFactory.createFilterNode(condition);
        UnaryIQTree filterTree = this.iqFactory.createUnaryIQTree(filterNode, flattenTree);
        return this.iqFactory.createUnaryIQTree(this.iqFactory.createConstructionNode((ImmutableSet<Variable>)Sets.difference(filterTree.getVariables(), renamedBlockedSubstitution.getDomain()).immutableCopy()), filterTree);
    }

    private Variable applySubstitution(Variable var, Substitution<? extends VariableOrGroundTerm> sub) {
        VariableOrGroundTerm newVar = this.substitutionFactory.onVariableOrGroundTerms().apply(sub, var);
        if (!(newVar instanceof Variable)) {
            throw new InvalidIntermediateQueryException("This substitution application should yield a variable");
        }
        return (Variable)newVar;
    }

    @Override
    public IQTree applyDescendingSubstitutionWithoutOptimizing(Substitution<? extends VariableOrGroundTerm> descendingSubstitution, IQTree child, VariableGenerator variableGenerator) {
        return this.applyDescendingSubstitution(descendingSubstitution, Optional.empty(), child, variableGenerator, (c, s, constraint, vGenerator) -> c.applyDescendingSubstitutionWithoutOptimizing(s, vGenerator));
    }

    @Override
    public boolean isConstructed(Variable variable, IQTree child) {
        return child.isConstructed(variable);
    }

    @Override
    public ImmutableSet<Substitution<NonVariableTerm>> getPossibleVariableDefinitions(IQTree child) {
        return ImmutableSet.of();
    }

    @Override
    public IQTree removeDistincts(IQTree child, IQTreeCache treeCache) {
        IQTree newChild = child.removeDistincts();
        IQTreeCache newTreeCache = treeCache.declareDistinctRemoval(newChild.equals(child));
        return this.iqFactory.createUnaryIQTree(this, newChild, newTreeCache);
    }

    private ImmutableSet<Variable> extendWithIndexVariable(ImmutableSet<Variable> set) {
        return this.indexVariable.map(index -> Sets.union((Set)set, (Set)ImmutableSet.of((Object)index)).immutableCopy()).orElse(set);
    }

    @Override
    public ImmutableSet<ImmutableSet<Variable>> inferUniqueConstraints(IQTree child) {
        if (this.indexVariable.isEmpty()) {
            return ImmutableSet.of();
        }
        ImmutableSet<ImmutableSet<Variable>> childConstraints = child.inferUniqueConstraints();
        return (ImmutableSet)childConstraints.stream().map(this::extendWithIndexVariable).collect(ImmutableCollectors.toSet());
    }

    @Override
    public FunctionalDependencies inferFunctionalDependencies(IQTree child, ImmutableSet<ImmutableSet<Variable>> uniqueConstraints, ImmutableSet<Variable> variables) {
        FunctionalDependencies childFDs = child.inferFunctionalDependencies();
        if (this.indexVariable.isEmpty()) {
            return childFDs;
        }
        return childFDs.stream().filter(fd -> ((ImmutableSet)fd.getValue()).contains((Object)this.flattenedVariable)).map(fd -> Maps.immutableEntry(this.extendWithIndexVariable((ImmutableSet<Variable>)((ImmutableSet)fd.getKey())), (Object)ImmutableSet.of((Object)this.outputVariable))).collect(FunctionalDependencies.toFunctionalDependencies()).concat(childFDs).concat(FunctionalDependencies.fromUniqueConstraints(uniqueConstraints, variables));
    }

    @Override
    public VariableNonRequirement computeVariableNonRequirement(IQTree child) {
        return child.getVariableNonRequirement().filter((v, conds) -> !v.equals(this.flattenedVariable));
    }

    @Override
    public ImmutableSet<Variable> inferStrictDependents(UnaryIQTree tree, IQTree child) {
        return IQTreeTools.computeStrictDependentsFromFunctionalDependencies(tree);
    }

    @Override
    public void validateNode(IQTree child) throws InvalidIntermediateQueryException {
        if (!child.getVariables().contains((Object)this.flattenedVariable)) {
            throw new InvalidIntermediateQueryException(String.format("Variable %s is flattened by Node %s but is not projected by its child", this.flattenedVariable, this));
        }
    }

    @Override
    public VariableNullability getVariableNullability(IQTree child) {
        return child.getVariableNullability().extendToExternalVariables(this.getLocallyDefinedVariables().stream());
    }

    @Override
    public IQTree propagateDownConstraint(ImmutableExpression constraint, IQTree child, VariableGenerator variableGenerator) {
        return this.iqFactory.createUnaryIQTree(this, child.propagateDownConstraint(constraint, variableGenerator));
    }

    @Override
    public ImmutableSet<Variable> getLocallyDefinedVariables() {
        return this.extendWithIndexVariable((ImmutableSet<Variable>)ImmutableSet.of((Object)this.outputVariable));
    }

    @Override
    public boolean isDistinct(IQTree tree, IQTree child) {
        return false;
    }

    @Override
    public IQTree liftIncompatibleDefinitions(Variable variable, IQTree child, VariableGenerator variableGenerator) {
        UnionNode unionNode;
        IQTree newChild = child.liftIncompatibleDefinitions(variable, variableGenerator);
        QueryNode newChildRoot = newChild.getRootNode();
        if (newChildRoot instanceof UnionNode && (unionNode = (UnionNode)newChildRoot).hasAChildWithLiftableDefinition(variable, newChild.getChildren())) {
            ImmutableList<IQTree> newChildren = this.iqTreeTools.createUnaryOperatorChildren(this, newChild);
            return this.iqFactory.createNaryIQTree(unionNode, newChildren);
        }
        return this.iqFactory.createUnaryIQTree(this, newChild);
    }

    @Override
    public IQTree applyFreshRenaming(InjectiveSubstitution<Variable> renamingSubstitution, IQTree child, IQTreeCache treeCache) {
        IQTree newChild = child.applyFreshRenaming(renamingSubstitution);
        IQTreeCache newTreeCache = treeCache.applyFreshRenaming(renamingSubstitution);
        return this.iqFactory.createUnaryIQTree(this.applySubstitution(renamingSubstitution), newChild, newTreeCache);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof FlattenNodeImpl) {
            FlattenNodeImpl that = (FlattenNodeImpl)o;
            return this.flattenedVariable.equals(that.flattenedVariable) && this.outputVariable.equals(that.outputVariable) && this.indexVariable.equals(that.indexVariable);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.flattenedVariable, this.outputVariable, this.indexVariable);
    }

    @Override
    public FlattenNode acceptNodeTransformer(HomogeneousQueryNodeTransformer transformer) throws QueryNodeTransformationException {
        return transformer.transform(this);
    }

    @Override
    public IQTree acceptTransformer(IQTree tree, IQTreeVisitingTransformer transformer, IQTree child) {
        return transformer.transformFlatten(tree, this, child);
    }

    @Override
    public <T> IQTree acceptTransformer(IQTree tree, IQTreeExtendedTransformer<T> transformer, IQTree child, T context) {
        return transformer.transformFlatten(tree, this, child, context);
    }

    @Override
    public <T> T acceptVisitor(IQVisitor<T> visitor, IQTree child) {
        return visitor.visitFlatten(this, child);
    }

    @Override
    public boolean wouldKeepDescendingGroundTermInFilterAbove(Variable variable, boolean isConstant) {
        return this.getLocallyDefinedVariables().contains((Object)variable);
    }

    private FlattenNode applySubstitution(Substitution<? extends VariableOrGroundTerm> sub) {
        Variable sFlattenedVar = this.applySubstitution(this.flattenedVariable, sub);
        Variable sOutputVar = this.applySubstitution(this.outputVariable, sub);
        Optional<Variable> sIndexVar = this.indexVariable.map(index -> this.applySubstitution((Variable)index, sub));
        return sFlattenedVar.equals(this.flattenedVariable) && sOutputVar.equals(this.outputVariable) && sIndexVar.equals(this.indexVariable) ? this : this.iqFactory.createFlattenNode(sOutputVar, sFlattenedVar, sIndexVar, this.flattenedType);
    }

    @FunctionalInterface
    static interface PropagateToChild {
        public IQTree apply(IQTree var1, Substitution<? extends VariableOrGroundTerm> var2, Optional<ImmutableExpression> var3, VariableGenerator var4);
    }
}

