/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.node.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.impl.IQTreeTools;
import it.unibz.inf.ontop.iq.node.ExtendedProjectionNode;
import it.unibz.inf.ontop.iq.node.FilterNode;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.iq.node.impl.CompositeQueryNodeImpl;
import it.unibz.inf.ontop.model.term.GroundFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.NonFunctionalTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import it.unibz.inf.ontop.substitution.Substitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

public abstract class ExtendedProjectionNodeImpl
extends CompositeQueryNodeImpl
implements ExtendedProjectionNode {
    public ExtendedProjectionNodeImpl(SubstitutionFactory substitutionFactory, IntermediateQueryFactory iqFactory, IQTreeTools iqTreeTools, TermFactory termFactory) {
        super(substitutionFactory, termFactory, iqFactory, iqTreeTools);
    }

    @Override
    public IQTree applyDescendingSubstitution(Substitution<? extends VariableOrGroundTerm> descendingSubstitution, Optional<ImmutableExpression> constraint, IQTree child, VariableGenerator variableGenerator) {
        return this.applyDescendingSubstitution(descendingSubstitution, child, (c, r) -> this.propagateDescendingSubstitutionToChild(c, r, constraint, variableGenerator));
    }

    private IQTree propagateDescendingSubstitutionToChild(IQTree child, PropagationResults tauFPropagationResults, Optional<ImmutableExpression> constraint, VariableGenerator variableGenerator) throws EmptyTreeException {
        Optional<Object> descendingConstraint;
        if (constraint.isPresent()) {
            ImmutableExpression initialConstraint = constraint.get();
            VariableNullability extendedVariableNullability = child.getVariableNullability().extendToExternalVariables(initialConstraint.getVariableStream());
            descendingConstraint = this.computeChildConstraint(tauFPropagationResults.theta, initialConstraint, extendedVariableNullability);
        } else {
            descendingConstraint = Optional.empty();
        }
        return Optional.of(tauFPropagationResults.delta).filter(delta -> !delta.isEmpty()).map(delta -> child.applyDescendingSubstitution((Substitution<? extends VariableOrGroundTerm>)delta, (Optional<ImmutableExpression>)descendingConstraint, variableGenerator)).orElse(child);
    }

    @Override
    public IQTree applyDescendingSubstitutionWithoutOptimizing(Substitution<? extends VariableOrGroundTerm> descendingSubstitution, IQTree child, VariableGenerator variableGenerator) {
        return this.applyDescendingSubstitution(descendingSubstitution, child, (c, r) -> Optional.of(r.delta).filter(delta -> !delta.isEmpty()).map(d -> c.applyDescendingSubstitutionWithoutOptimizing((Substitution<? extends VariableOrGroundTerm>)d, variableGenerator)).orElse(c));
    }

    private IQTree applyDescendingSubstitution(Substitution<? extends VariableOrGroundTerm> tau, IQTree child, DescendingSubstitutionChildUpdateFunction updateChildFct) {
        ImmutableSet<Variable> newProjectedVariables = this.iqTreeTools.computeNewProjectedVariables(tau, this.getVariables());
        try {
            PropagationResults tauPropagationResults = this.propagateTau(tau, child.getVariables());
            Optional<FilterNode> filterNode = tauPropagationResults.filter.map(this.iqFactory::createFilterNode);
            IQTree newChild = updateChildFct.apply(child, tauPropagationResults);
            Optional<ExtendedProjectionNode> projectionNode = this.computeNewProjectionNode(newProjectedVariables, tauPropagationResults.theta, newChild);
            IQTree filterTree = this.iqTreeTools.createOptionalUnaryIQTree(filterNode, newChild);
            return this.iqTreeTools.createOptionalUnaryIQTree(projectionNode, filterTree);
        }
        catch (EmptyTreeException e) {
            return this.iqFactory.createEmptyNode(newProjectedVariables);
        }
    }

    protected abstract Optional<ExtendedProjectionNode> computeNewProjectionNode(ImmutableSet<Variable> var1, Substitution<ImmutableTerm> var2, IQTree var3);

    private PropagationResults propagateTau(Substitution<? extends VariableOrGroundTerm> tau, ImmutableSet<Variable> childVariables) throws EmptyTreeException {
        ImmutableSet<Variable> projectedVariables = this.getVariables();
        Substitution<? extends ImmutableTerm> substitution = this.getSubstitution();
        Substitution<NonFunctionalTerm> tauC = tau.restrictRangeTo(NonFunctionalTerm.class);
        Substitution<NonFunctionalTerm> thetaC = substitution.restrictRangeTo(NonFunctionalTerm.class);
        ImmutableSet<Variable> projectedVariablesAfterTauC = this.iqTreeTools.computeNewProjectedVariables(tauC, projectedVariables);
        Substitution newEta = this.substitutionFactory.onNonFunctionalTerms().unifierBuilder(thetaC).unify(tauC.stream(), Map.Entry::getKey, Map.Entry::getValue).build().map(eta -> this.substitutionFactory.onNonFunctionalTerms().compose((Substitution<NonFunctionalTerm>)this.substitutionFactory.getPrioritizingRenaming((Substitution<?>)eta, projectedVariablesAfterTauC), (Substitution<NonFunctionalTerm>)eta)).orElseThrow(EmptyTreeException::new);
        Substitution thetaCBar = newEta.restrictDomainTo((Set<Variable>)projectedVariablesAfterTauC);
        Substitution deltaC = newEta.builder().removeFromDomain((Set<Variable>)thetaC.getDomain()).removeFromDomain((Set<Variable>)Sets.difference(thetaCBar.getDomain(), projectedVariables)).build();
        Substitution<ImmutableFunctionalTerm> thetaF = substitution.restrictRangeTo(ImmutableFunctionalTerm.class);
        ImmutableMultimap<NonFunctionalTerm, ImmutableFunctionalTerm> m = thetaF.stream().collect(ImmutableCollectors.toMultimap(e -> this.substitutionFactory.onNonFunctionalTerms().apply((Substitution<NonFunctionalTerm>)deltaC, (Variable)e.getKey()), e -> this.substitutionFactory.onImmutableTerms().apply((Substitution<ImmutableTerm>)deltaC, (ImmutableFunctionalTerm)e.getValue())));
        Substitution<ImmutableFunctionalTerm> thetaFBar = m.asMap().entrySet().stream().filter(e -> e.getKey() instanceof Variable).filter(e -> !childVariables.contains((Object)((Variable)e.getKey()))).collect(this.substitutionFactory.toSubstitution(e -> (Variable)e.getKey(), e -> (ImmutableFunctionalTerm)((Collection)e.getValue()).iterator().next()));
        Substitution<ImmutableTerm> gamma = deltaC.builder().removeFromDomain((Set<Variable>)thetaF.getDomain()).removeFromDomain((Set<Variable>)Sets.difference(thetaFBar.getDomain(), projectedVariables)).transform(v -> this.substitutionFactory.onImmutableTerms().applyToTerm((Substitution<ImmutableTerm>)thetaFBar, (ImmutableTerm)v)).build();
        Substitution<NonFunctionalTerm> newDeltaC = gamma.restrictRangeTo(NonFunctionalTerm.class);
        Stream<ImmutableExpression> thetaFRelatedExpressions = m.entries().stream().filter(e -> !(e.getKey() instanceof Variable) || !thetaFBar.isDefining((Variable)e.getKey()) || !((ImmutableFunctionalTerm)thetaFBar.get((Variable)e.getKey())).equals(e.getValue())).map(e -> this.termFactory.getStrictEquality(thetaFBar.applyToTerm((ImmutableTerm)e.getKey()), (ImmutableTerm)e.getValue(), new ImmutableTerm[0]));
        Stream<ImmutableExpression> blockedExpressions = gamma.builder().restrictRangeTo(ImmutableFunctionalTerm.class).toStream((x$0, x$1) -> this.termFactory.getStrictEquality((ImmutableTerm)x$0, (ImmutableTerm)x$1, new ImmutableTerm[0]));
        Optional<ImmutableExpression> f = Optional.of((ImmutableList)Stream.concat(thetaFRelatedExpressions, blockedExpressions).collect(ImmutableCollectors.toList())).filter(l -> !l.isEmpty()).map(this.termFactory::getConjunction);
        Substitution<GroundFunctionalTerm> tauF = tau.restrictRangeTo(GroundFunctionalTerm.class);
        Substitution<ImmutableTerm> thetaBar = thetaFBar.compose(thetaCBar);
        Substitution<VariableOrGroundTerm> delta = this.substitutionFactory.onVariableOrGroundTerms().compose(tauF.builder().removeFromDomain((Set<Variable>)thetaBar.getDomain()).removeFromDomain((Set<Variable>)newDeltaC.getDomain()).build(), newDeltaC);
        Substitution<ImmutableTerm> newTheta = thetaBar.builder().removeFromDomain((Set<Variable>)tauF.getDomain()).build();
        Stream<ImmutableExpression> newConditionStream = Stream.concat(tauF.builder().restrictDomainTo((Set<Variable>)thetaBar.getDomain()).toStream((v, t) -> this.termFactory.getStrictEquality(thetaBar.apply((Variable)v), (ImmutableTerm)t, new ImmutableTerm[0])), tauF.builder().restrictDomainTo((Set<Variable>)newDeltaC.getDomain()).toStream((v, t) -> this.termFactory.getStrictEquality(newDeltaC.apply((Variable)v), (ImmutableTerm)t, new ImmutableTerm[0])));
        Optional<ImmutableExpression> newF = this.termFactory.getConjunction(f, newConditionStream);
        return new PropagationResults(newTheta, delta, newF);
    }

    @Override
    public IQTree propagateDownConstraint(ImmutableExpression constraint, IQTree child, VariableGenerator variableGenerator) {
        try {
            Optional<ImmutableExpression> childConstraint = this.computeChildConstraint(this.getSubstitution(), constraint, child.getVariableNullability().extendToExternalVariables(constraint.getVariableStream()));
            IQTree newChild = childConstraint.map(c -> child.propagateDownConstraint((ImmutableExpression)c, variableGenerator)).orElse(child);
            return this.iqFactory.createUnaryIQTree(this, newChild);
        }
        catch (EmptyTreeException e) {
            return this.iqFactory.createEmptyNode(this.getVariables());
        }
    }

    private Optional<ImmutableExpression> computeChildConstraint(Substitution<? extends ImmutableTerm> theta, ImmutableExpression initialConstraint, VariableNullability variableNullabilityForConstraint) throws EmptyTreeException {
        ImmutableExpression.Evaluation descendingConstraintResults = theta.apply(initialConstraint).evaluate2VL(variableNullabilityForConstraint);
        if (descendingConstraintResults.isEffectiveFalse()) {
            throw new EmptyTreeException();
        }
        return descendingConstraintResults.getExpression();
    }

    @Override
    public VariableNullability getVariableNullability(IQTree child) {
        return child.getVariableNullability().update(this.getSubstitution(), this.getVariables());
    }

    @Override
    public boolean isConstructed(Variable variable, IQTree child) {
        return this.getSubstitution().isDefining(variable) || this.getChildVariables().contains((Object)variable) && child.isConstructed(variable);
    }

    private static class PropagationResults {
        public final Substitution<VariableOrGroundTerm> delta;
        public final Optional<ImmutableExpression> filter;
        public final Substitution<ImmutableTerm> theta;

        PropagationResults(Substitution<ImmutableTerm> theta, Substitution<VariableOrGroundTerm> delta, Optional<ImmutableExpression> filter) {
            this.theta = theta;
            this.delta = delta;
            this.filter = filter;
        }
    }

    protected static class EmptyTreeException
    extends Exception {
        protected EmptyTreeException() {
        }
    }

    @FunctionalInterface
    protected static interface DescendingSubstitutionChildUpdateFunction {
        public IQTree apply(IQTree var1, PropagationResults var2) throws EmptyTreeException;
    }
}

