/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.evaluator.impl;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import it.unibz.inf.ontop.evaluator.TermNullabilityEvaluator;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.CoreUtilsFactory;
import java.util.Map;
import java.util.stream.Stream;

@Singleton
public class TermNullabilityEvaluatorImpl
implements TermNullabilityEvaluator {
    private static final long TERM_EVALUATOR_CACHE_SIZE = 10000L;
    private final TermFactory termFactory;
    private final SubstitutionFactory substitutionFactory;
    private final CoreUtilsFactory coreUtilsFactory;
    private final Cache<Map.Entry<ImmutableExpression, ImmutableSet<Variable>>, Boolean> cache;

    @Inject
    private TermNullabilityEvaluatorImpl(TermFactory termFactory, SubstitutionFactory substitutionFactory, CoreUtilsFactory coreUtilsFactory) {
        this.termFactory = termFactory;
        this.substitutionFactory = substitutionFactory;
        this.coreUtilsFactory = coreUtilsFactory;
        this.cache = CacheBuilder.newBuilder().maximumSize(10000L).build();
    }

    @Override
    public boolean isFilteringNullValue(ImmutableExpression expression, Variable variable) {
        ImmutableExpression nullCaseExpression = Stream.of(variable).collect(this.substitutionFactory.toSubstitution(v -> this.termFactory.getNullConstant())).apply(expression);
        return nullCaseExpression.evaluate2VL(this.coreUtilsFactory.createSimplifiedVariableNullability(expression)).isEffectiveFalse();
    }

    @Override
    public boolean isFilteringNullValues(ImmutableExpression expression, ImmutableSet<Variable> tightVariables) {
        Map.Entry entry = Maps.immutableEntry((Object)expression, tightVariables);
        Boolean cacheResult = (Boolean)this.cache.getIfPresent((Object)entry);
        if (cacheResult != null) {
            return cacheResult;
        }
        ImmutableExpression nullCaseExpression = tightVariables.stream().collect(this.substitutionFactory.toSubstitution(v -> this.termFactory.getNullConstant())).apply(expression);
        boolean result = nullCaseExpression.evaluate2VL(this.coreUtilsFactory.createSimplifiedVariableNullability(expression)).isEffectiveFalse();
        this.cache.put((Object)entry, (Object)result);
        return result;
    }
}

