/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.evaluator.impl;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import it.unibz.inf.ontop.evaluator.QueryContext;
import it.unibz.inf.ontop.injection.OntopModelSettings;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;

public class QueryContextImpl
implements QueryContext {
    public static final String USER_HTTP_HEADER_LOWERCASE = "x-user";
    public static final String GROUPS_HTTP_HEADER_LOWERCASE = "x-groups";
    public static final String ROLES_HTTP_HEADER_LOWERCASE = "x-roles";
    private final @Nullable String username;
    private final ImmutableSet<String> roles;
    private final ImmutableSet<String> groups;
    private final UUID salt;

    @AssistedInject
    protected QueryContextImpl(@Assisted ImmutableMap<String, String> normalizedHttpHeaders, OntopModelSettings settings) {
        if (settings.isAuthorizationEnabled()) {
            Splitter commaSplitter = Splitter.on((String)",");
            this.username = (String)normalizedHttpHeaders.get((Object)USER_HTTP_HEADER_LOWERCASE);
            this.roles = (ImmutableSet)Optional.ofNullable((String)normalizedHttpHeaders.get((Object)ROLES_HTTP_HEADER_LOWERCASE)).stream().flatMap(arg_0 -> ((Splitter)commaSplitter).splitToStream(arg_0)).collect(ImmutableCollectors.toSet());
            this.groups = (ImmutableSet)Optional.ofNullable((String)normalizedHttpHeaders.get((Object)GROUPS_HTTP_HEADER_LOWERCASE)).stream().flatMap(arg_0 -> ((Splitter)commaSplitter).splitToStream(arg_0)).collect(ImmutableCollectors.toSet());
        } else {
            this.username = null;
            this.roles = ImmutableSet.of();
            this.groups = ImmutableSet.of();
        }
        this.salt = UUID.randomUUID();
    }

    @Override
    public Optional<String> getUsername() {
        return Optional.ofNullable(this.username);
    }

    @Override
    public ImmutableSet<String> getRolesOrGroups() {
        return Sets.union(this.roles, this.groups).immutableCopy();
    }

    @Override
    public ImmutableSet<String> getRoles() {
        return this.roles;
    }

    @Override
    public ImmutableSet<String> getGroups() {
        return this.groups;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryContextImpl that = (QueryContextImpl)o;
        return Objects.equals(this.username, that.username) && Objects.equals(this.roles, that.roles) && Objects.equals(this.groups, that.groups);
    }

    @Override
    public UUID getSalt() {
        return this.salt;
    }

    public int hashCode() {
        return Objects.hash(this.username, this.roles, this.groups);
    }
}

