/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.dbschema.impl;

import com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.dbschema.QuotedID;
import it.unibz.inf.ontop.dbschema.QuotedIDFactory;
import it.unibz.inf.ontop.dbschema.RelationID;
import it.unibz.inf.ontop.dbschema.impl.QuotedIDImpl;
import it.unibz.inf.ontop.dbschema.impl.RelationIDImpl;
import java.util.Objects;
import java.util.function.UnaryOperator;
import org.eclipse.jdt.annotation.NonNullByDefault;

@QuotedIDFactory.IDFactoryType(value="STANDARD")
@NonNullByDefault
public class SQLStandardQuotedIDFactory
implements QuotedIDFactory {
    public static final String QUOTATION_STRING = "\"";
    public static final String NO_QUOTATION = "";

    @Override
    public QuotedID createAttributeID(String s) {
        return this.createFromString(s);
    }

    @Override
    public RelationID createRelationID(String tableId) {
        return new RelationIDImpl((ImmutableList<QuotedID>)ImmutableList.of((Object)this.createFromString(tableId)));
    }

    @Override
    public RelationID createRelationID(String ... components) {
        Objects.requireNonNull(components[components.length - 1]);
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = components.length - 1; i >= 0; --i) {
            if (components[i] == null) continue;
            builder.add((Object)this.createFromString(components[i]));
        }
        return new RelationIDImpl((ImmutableList<QuotedID>)builder.build());
    }

    protected QuotedID createFromString(String s) {
        return this.createFromString(s, QUOTATION_STRING, String::toUpperCase, NO_QUOTATION, true);
    }

    protected final QuotedID createFromString(String s, String quotationString, UnaryOperator<String> fold, String defaultQuotationString, boolean caseSensitive) {
        Objects.requireNonNull(s);
        if (s.startsWith(quotationString) && s.endsWith(quotationString)) {
            return new QuotedIDImpl(s.substring(1, s.length() - 1), quotationString, caseSensitive);
        }
        return new QuotedIDImpl((String)fold.apply(s), defaultQuotationString, caseSensitive);
    }

    @Override
    public String getIDQuotationString() {
        return QUOTATION_STRING;
    }

    @Override
    public boolean supportsSquareBracketQuotation() {
        return false;
    }
}

