/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.dbschema.impl;

import it.unibz.inf.ontop.dbschema.QuotedID;
import java.util.Objects;
import javax.annotation.Nullable;
import org.eclipse.jdt.annotation.NonNullByDefault;

@NonNullByDefault
public class QuotedIDImpl
implements QuotedID {
    private final String id;
    private final String quoteString;
    private final boolean caseSensitive;
    private final int hashCode;

    QuotedIDImpl(String id, String quoteString, boolean caseSensitive) {
        this.id = Objects.requireNonNull(id);
        this.quoteString = Objects.requireNonNull(quoteString);
        this.caseSensitive = caseSensitive;
        this.hashCode = id.toLowerCase().hashCode();
    }

    @Override
    public String getName() {
        return this.id;
    }

    @Override
    public String getSQLRendering() {
        return this.quoteString + this.id + this.quoteString;
    }

    public String toString() {
        return this.getSQLRendering();
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof QuotedIDImpl) {
            QuotedIDImpl other = (QuotedIDImpl)obj;
            if (this.id.length() != other.id.length()) {
                return false;
            }
            return this.id.regionMatches(!this.caseSensitive || !other.caseSensitive, 0, other.id, 0, this.id.length());
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }
}

