/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.dbschema.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import it.unibz.inf.ontop.dbschema.DBParameters;
import it.unibz.inf.ontop.dbschema.MetadataProvider;
import it.unibz.inf.ontop.dbschema.NamedRelationDefinition;
import it.unibz.inf.ontop.dbschema.QuotedIDFactory;
import it.unibz.inf.ontop.dbschema.RelationDefinition;
import it.unibz.inf.ontop.dbschema.RelationID;
import it.unibz.inf.ontop.dbschema.impl.DatabaseTableDefinition;
import it.unibz.inf.ontop.dbschema.impl.ImmutableMetadataProvider;
import it.unibz.inf.ontop.dbschema.impl.SQLStandardQuotedIDFactory;
import it.unibz.inf.ontop.injection.CoreSingletons;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.DBTypeFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;

public class OfflineMetadataProviderBuilder {
    private final DBTypeFactory dbTypeFactory;
    private final QuotedIDFactory idFactory;
    private final ImmutableList.Builder<NamedRelationDefinition> listBuilder = ImmutableList.builder();
    private final CoreSingletons coreSingletons;

    public OfflineMetadataProviderBuilder(CoreSingletons coreSingletons) {
        this.coreSingletons = coreSingletons;
        this.idFactory = new SQLStandardQuotedIDFactory();
        this.dbTypeFactory = coreSingletons.getTypeFactory().getDBTypeFactory();
    }

    public NamedRelationDefinition createDatabaseRelation(ImmutableList<RelationID> allIds, RelationDefinition.AttributeListBuilder builder) {
        DatabaseTableDefinition relation = new DatabaseTableDefinition(allIds, builder);
        this.listBuilder.add((Object)relation);
        return relation;
    }

    public NamedRelationDefinition createDatabaseRelation(String relation, String attribute1, DBTermType type1, boolean isNullable1) {
        return this.createDatabaseRelation((ImmutableList<RelationID>)ImmutableList.of((Object)this.idFactory.createRelationID(relation)), DatabaseTableDefinition.attributeListBuilder().addAttribute(this.idFactory.createAttributeID(attribute1), type1, isNullable1));
    }

    public NamedRelationDefinition createDatabaseRelation(String relation, String attribute1, DBTermType type1, boolean isNullable1, String attribute2, DBTermType type2, boolean isNullable2) {
        return this.createDatabaseRelation((ImmutableList<RelationID>)ImmutableList.of((Object)this.idFactory.createRelationID(relation)), DatabaseTableDefinition.attributeListBuilder().addAttribute(this.idFactory.createAttributeID(attribute1), type1, isNullable1).addAttribute(this.idFactory.createAttributeID(attribute2), type2, isNullable2));
    }

    public NamedRelationDefinition createDatabaseRelation(String relation, String attribute1, DBTermType type1, boolean isNullable1, String attribute2, DBTermType type2, boolean isNullable2, String attribute3, DBTermType type3, boolean isNullable3) {
        return this.createDatabaseRelation((ImmutableList<RelationID>)ImmutableList.of((Object)this.idFactory.createRelationID(relation)), DatabaseTableDefinition.attributeListBuilder().addAttribute(this.idFactory.createAttributeID(attribute1), type1, isNullable1).addAttribute(this.idFactory.createAttributeID(attribute2), type2, isNullable2).addAttribute(this.idFactory.createAttributeID(attribute3), type3, isNullable3));
    }

    public NamedRelationDefinition createDatabaseRelation(String relation, String attribute1, DBTermType type1, boolean isNullable1, String attribute2, DBTermType type2, boolean isNullable2, String attribute3, DBTermType type3, boolean isNullable3, String attribute4, DBTermType type4, boolean isNullable4) {
        return this.createDatabaseRelation((ImmutableList<RelationID>)ImmutableList.of((Object)this.idFactory.createRelationID(relation)), DatabaseTableDefinition.attributeListBuilder().addAttribute(this.idFactory.createAttributeID(attribute1), type1, isNullable1).addAttribute(this.idFactory.createAttributeID(attribute2), type2, isNullable2).addAttribute(this.idFactory.createAttributeID(attribute3), type3, isNullable3).addAttribute(this.idFactory.createAttributeID(attribute4), type4, isNullable4));
    }

    public NamedRelationDefinition createDatabaseRelation(String relation, String attribute1, DBTermType type1, boolean isNullable1, String attribute2, DBTermType type2, boolean isNullable2, String attribute3, DBTermType type3, boolean isNullable3, String attribute4, DBTermType type4, boolean isNullable4, String attribute5, DBTermType type5, boolean isNullable5) {
        return this.createDatabaseRelation((ImmutableList<RelationID>)ImmutableList.of((Object)this.idFactory.createRelationID(relation)), DatabaseTableDefinition.attributeListBuilder().addAttribute(this.idFactory.createAttributeID(attribute1), type1, isNullable1).addAttribute(this.idFactory.createAttributeID(attribute2), type2, isNullable2).addAttribute(this.idFactory.createAttributeID(attribute3), type3, isNullable3).addAttribute(this.idFactory.createAttributeID(attribute4), type4, isNullable4).addAttribute(this.idFactory.createAttributeID(attribute5), type5, isNullable5));
    }

    public NamedRelationDefinition createDatabaseRelation(String relation, String attribute1, DBTermType type1, boolean isNullable1, String attribute2, DBTermType type2, boolean isNullable2, String attribute3, DBTermType type3, boolean isNullable3, String attribute4, DBTermType type4, boolean isNullable4, String attribute5, DBTermType type5, boolean isNullable5, String attribute6, DBTermType type6, boolean isNullable6) {
        return this.createDatabaseRelation((ImmutableList<RelationID>)ImmutableList.of((Object)this.idFactory.createRelationID(relation)), DatabaseTableDefinition.attributeListBuilder().addAttribute(this.idFactory.createAttributeID(attribute1), type1, isNullable1).addAttribute(this.idFactory.createAttributeID(attribute2), type2, isNullable2).addAttribute(this.idFactory.createAttributeID(attribute3), type3, isNullable3).addAttribute(this.idFactory.createAttributeID(attribute4), type4, isNullable4).addAttribute(this.idFactory.createAttributeID(attribute5), type5, isNullable5).addAttribute(this.idFactory.createAttributeID(attribute6), type6, isNullable6));
    }

    public MetadataProvider build() {
        ImmutableList list = this.listBuilder.build();
        return new ImmutableMetadataProvider(this.getDBParameters(), list.stream().flatMap(r -> r.getAllIDs().stream().map(i -> Maps.immutableEntry((Object)i, (Object)r))).collect(ImmutableCollectors.toMap()));
    }

    public QuotedIDFactory getQuotedIDFactory() {
        return this.idFactory;
    }

    public DBTypeFactory getDBTypeFactory() {
        return this.dbTypeFactory;
    }

    private DBParameters getDBParameters() {
        return new DBParameters(){

            @Override
            public QuotedIDFactory getQuotedIDFactory() {
                return OfflineMetadataProviderBuilder.this.idFactory;
            }

            @Override
            public DBTypeFactory getDBTypeFactory() {
                return OfflineMetadataProviderBuilder.this.dbTypeFactory;
            }

            @Override
            public CoreSingletons getCoreSingletons() {
                return OfflineMetadataProviderBuilder.this.coreSingletons;
            }

            @Override
            public String getDriverName() {
                return null;
            }

            @Override
            public String getDriverVersion() {
                return null;
            }

            @Override
            public String getDbmsProductName() {
                return null;
            }

            @Override
            public String getDbmsVersion() {
                return null;
            }
        };
    }
}

