/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.constraints.impl;

import com.google.common.collect.ImmutableCollection;
import it.unibz.inf.ontop.constraints.Homomorphism;
import it.unibz.inf.ontop.constraints.HomomorphismFactory;
import it.unibz.inf.ontop.constraints.ImmutableCQ;
import it.unibz.inf.ontop.constraints.ImmutableCQContainmentCheck;
import it.unibz.inf.ontop.constraints.LinearInclusionDependencies;
import it.unibz.inf.ontop.model.atom.AtomPredicate;
import it.unibz.inf.ontop.model.atom.DataAtom;
import it.unibz.inf.ontop.model.term.Variable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ImmutableCQContainmentCheckUnderLIDs<P extends AtomPredicate>
implements ImmutableCQContainmentCheck<P> {
    private final Map<ImmutableCollection<DataAtom<P>>, ImmutableCollection<DataAtom<P>>> chaseCache = new HashMap<ImmutableCollection<DataAtom<P>>, ImmutableCollection<DataAtom<P>>>();
    private final HomomorphismFactory homomorphismFactory;
    private final LinearInclusionDependencies<P> dependencies;

    ImmutableCQContainmentCheckUnderLIDs(HomomorphismFactory homomorphismFactory, LinearInclusionDependencies<P> dependencies) {
        this.homomorphismFactory = homomorphismFactory;
        this.dependencies = dependencies;
    }

    @Override
    public boolean isContainedIn(ImmutableCQ<P> cq1, ImmutableCQ<P> cq2) {
        Homomorphism.Builder builder = this.homomorphismFactory.getHomomorphismBuilder();
        if (!cq1.getAnswerVariables().equals(cq2.getAnswerVariables())) {
            return false;
        }
        cq1.getAnswerVariables().forEach(v -> builder.extend(cq2.getAnswerTerm((Variable)v), cq1.getAnswerTerm((Variable)v)));
        if (builder.isValid()) {
            Iterator<Homomorphism> iterator = this.homomorphismFactory.getHomomorphismIterator(builder.build(), cq2.getAtoms(), this.chaseAllAtoms((ImmutableCollection<DataAtom<P>>)cq1.getAtoms()));
            return iterator.hasNext();
        }
        return false;
    }

    @Override
    public ImmutableCollection<DataAtom<P>> chaseAllAtoms(ImmutableCollection<DataAtom<P>> dataAtoms) {
        return this.chaseCache.computeIfAbsent(dataAtoms, this.dependencies::chaseAllAtoms);
    }
}

