/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.resource.management;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;

public class RestrictedStatementCollector
implements RDFHandler {
    private final Resource subject;
    private Collection<Statement> statements;
    private Map<String, String> namespaces;

    public RestrictedStatementCollector(Collection<Statement> statements, Resource subject) {
        this.statements = statements;
        this.subject = subject;
        this.namespaces = new HashMap<String, String>();
    }

    public void handleStatement(Statement st) throws RDFHandlerException {
        Resource currentSubject = st.getSubject();
        if (!this.subject.equals((Object)currentSubject)) {
            throw new RDFHandlerException("Invalid subject value \"" + String.valueOf(currentSubject) + "\". All statements must have the subject \"" + String.valueOf(this.subject) + "\"");
        }
        this.statements.add(st);
    }

    public void startRDF() throws RDFHandlerException {
    }

    public void endRDF() throws RDFHandlerException {
    }

    public void handleNamespace(String prefix, String uri) throws RDFHandlerException {
        if (!this.namespaces.containsKey(prefix)) {
            this.namespaces.put(prefix, uri);
        }
    }

    public void handleComment(String comment) throws RDFHandlerException {
    }
}

