/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.resource.management;

import com.ontotext.forest.core.semantic.SemanticDataManagement;
import com.ontotext.forest.resource.management.ResourceAlreadyPresentException;
import com.ontotext.forest.resource.management.ResourceNotPresentException;
import com.ontotext.forest.resource.management.RestrictedStatementCollector;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.RDFParser;
import org.eclipse.rdf4j.rio.RDFParserFactory;
import org.eclipse.rdf4j.rio.RDFParserRegistry;
import org.eclipse.rdf4j.rio.UnsupportedRDFormatException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ResourceManagementService {
    private Logger logger = LoggerFactory.getLogger(ResourceManagementService.class);
    @Autowired
    private SemanticDataManagement dataManagement;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createResource(Resource resource, InputStream is, String mimeType) throws IOException, RepositoryException, RDFParseException, RDFHandlerException, ResourceAlreadyPresentException {
        RepositoryConnection connection = this.dataManagement.getConnection();
        try {
            if (connection.hasStatement(resource, null, null, true, new Resource[0])) {
                throw new ResourceAlreadyPresentException("Resource \"" + String.valueOf(resource) + "\" already present in the repository.");
            }
            LinkedList<Statement> toAdd = new LinkedList<Statement>();
            RDFParser parser = this.getParser(mimeType);
            parser.setRDFHandler((RDFHandler)new RestrictedStatementCollector(toAdd, resource));
            parser.parse(is, "urn:forest:");
            connection.begin();
            connection.add(toAdd, new Resource[0]);
            connection.commit();
        }
        finally {
            try {
                connection.close();
            }
            catch (RepositoryException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateResource(Resource resource, InputStream is, String mimeType) throws ResourceNotPresentException, RepositoryException, RDFParseException, RDFHandlerException, IOException {
        RepositoryConnection connection = this.dataManagement.getConnection();
        try {
            if (!connection.hasStatement(resource, null, null, true, new Resource[0])) {
                throw new ResourceNotPresentException("Resource \"" + String.valueOf(resource) + "\" is not present in the repository.");
            }
            LinkedList<Statement> toAdd = new LinkedList<Statement>();
            connection.begin();
            connection.remove(resource, null, null, new Resource[0]);
            RDFParser parser = this.getParser(mimeType);
            parser.setRDFHandler((RDFHandler)new RestrictedStatementCollector(toAdd, resource));
            parser.parse(is, "urn:forest:");
            connection.add(toAdd, new Resource[0]);
            connection.commit();
        }
        finally {
            try {
                connection.close();
            }
            catch (RepositoryException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteResource(Resource resource) throws RepositoryException {
        RepositoryConnection connection = this.dataManagement.getConnection();
        try {
            connection.begin();
            connection.remove(resource, null, null, new Resource[0]);
            connection.commit();
        }
        finally {
            try {
                connection.close();
            }
            catch (RepositoryException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private RDFParser getParser(String mimeType) {
        RDFFormat format = (RDFFormat)RDFParserRegistry.getInstance().getFileFormatForMIMEType(mimeType).orElseThrow(() -> new UnsupportedRDFormatException("No such RDF format: " + mimeType));
        return ((RDFParserFactory)RDFParserRegistry.getInstance().get((Object)format).orElseThrow(() -> new UnsupportedRDFormatException("No parser for RDF format: " + String.valueOf(format)))).getParser();
    }
}

