/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.resource.explore;

import com.ontotext.forest.core.error.GraphDBWorkbenchException;
import com.ontotext.forest.core.semantic.SemanticDataManagement;
import com.ontotext.forest.core.semantic.SemanticLocation;
import com.ontotext.forest.core.semantic.repository.SemanticRepository;
import com.ontotext.forest.core.util.QueryUtils;
import com.ontotext.forest.core.util.ResourceUtils;
import com.ontotext.forest.repositories.RepositoryUtils;
import com.ontotext.forest.resource.explore.ResourceDetails;
import jakarta.annotation.Nullable;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Triple;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.impl.TreeModel;
import org.eclipse.rdf4j.model.vocabulary.RDF4J;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.impl.SimpleDataset;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.RepositoryResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class ExploreService {
    private static final Logger logger = LoggerFactory.getLogger(ExploreService.class);
    private static final IRI COUNT_URI = SimpleValueFactory.getInstance().createIRI("http://www.ontotext.com/count");
    @Autowired
    private ResourceUtils resourceUtils;
    @Inject
    private SemanticDataManagement semanticDataManagement;

    public <T extends Resource> Model getResourceGraph(T resource, String role, String inference, Boolean bnodes, Boolean sameAs, IRI context, Integer limit, Integer offset) throws GraphDBWorkbenchException {
        TreeModel results = new TreeModel();
        SemanticRepository semanticRepository = this.semanticDataManagement.getCurrentRepositoryOrThrow();
        if (this.isShaclContext(resource, context)) {
            this.fetchShaclShapeGraph(semanticRepository, (Model)results, resource, role, limit, offset);
        } else {
            this.fetchResourceGraph(semanticRepository, (Model)results, resource, role, inference, bnodes, sameAs, limit, offset);
        }
        return results;
    }

    private boolean isShaclContext(Resource resource, IRI context) {
        return context != null && context.equals((Object)RDF4J.SHACL_SHAPE_GRAPH) || resource instanceof IRI && resource.equals((Object)RDF4J.SHACL_SHAPE_GRAPH);
    }

    private void fetchShaclShapeGraph(SemanticRepository semanticRepository, final Model results, final Resource resource, final String role, final Integer limit, final Integer offset) {
        SemanticRepository semanticRepository2 = semanticRepository;
        Objects.requireNonNull(semanticRepository2);
        new SemanticRepository.WithRawConnection<Void>(semanticRepository2){

            protected Void doInConnection(RepositoryConnection connection) {
                LinkedList<RepositoryResult<Statement>> statementsQueue = new LinkedList<RepositoryResult<Statement>>();
                ExploreService.this.addShaclStatementsToQueue(resource, role, statementsQueue, connection);
                ExploreService.this.processShaclStatementsQueue(statementsQueue, statement -> results.add(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[]{RDF4J.SHACL_SHAPE_GRAPH}), offset, limit);
                return null;
            }
        }.run();
    }

    private void addShaclStatementsToQueue(Resource resource, String role, Queue<RepositoryResult<Statement>> statementsQueue, RepositoryConnection connection) {
        if (role.matches("all|subject")) {
            statementsQueue.add((RepositoryResult<Statement>)connection.getStatements(resource, null, null, true, new Resource[]{RDF4J.SHACL_SHAPE_GRAPH}));
        }
        if (role.matches("all|predicate") && resource instanceof IRI) {
            statementsQueue.add((RepositoryResult<Statement>)connection.getStatements(null, (IRI)resource, null, true, new Resource[]{RDF4J.SHACL_SHAPE_GRAPH}));
        }
        if (role.matches("all|object")) {
            statementsQueue.add((RepositoryResult<Statement>)connection.getStatements(null, null, (Value)resource, true, new Resource[]{RDF4J.SHACL_SHAPE_GRAPH}));
        }
        if (resource instanceof IRI && resource.equals((Object)RDF4J.SHACL_SHAPE_GRAPH) && role.matches("all|context")) {
            statementsQueue.add((RepositoryResult<Statement>)connection.getStatements(null, null, null, true, new Resource[]{RDF4J.SHACL_SHAPE_GRAPH}));
        }
    }

    private void processShaclStatementsQueue(Queue<RepositoryResult<Statement>> statementsQueue, Consumer<Statement> statementConsumer, Integer offset, Integer limit) {
        AtomicInteger offsetIterated = new AtomicInteger(0);
        AtomicInteger statementsAdded = new AtomicInteger(0);
        AtomicBoolean isEmpty = new AtomicBoolean(false);
        boolean done = false;
        while (!statementsQueue.isEmpty()) {
            RepositoryResult<Statement> statements = statementsQueue.remove();
            try {
                if (done) continue;
                if (offset != null && offset > 0) {
                    this.iterateShaclOffsetStatements(statements, offsetIterated, offset, isEmpty);
                    if (isEmpty.getAndSet(false)) continue;
                }
                this.iterateShaclStatementsUntilLimit(statements, statementsAdded, limit, statementConsumer);
                if (!this.hasReachedLimit(limit, statementsAdded)) continue;
                done = true;
            }
            finally {
                if (statements == null) continue;
                statements.close();
            }
        }
    }

    private boolean hasReachedLimit(Integer limit, AtomicInteger statementsAdded) {
        if (limit != null) {
            return statementsAdded.get() >= limit;
        }
        return false;
    }

    private void iterateShaclOffsetStatements(RepositoryResult<Statement> statements, AtomicInteger offsetIterated, Integer offset, AtomicBoolean isEmpty) {
        for (int i = offsetIterated.get(); i < offset; ++i) {
            if (!statements.hasNext()) {
                isEmpty.set(true);
                break;
            }
            statements.next();
            offsetIterated.incrementAndGet();
        }
    }

    private void iterateShaclStatementsUntilLimit(RepositoryResult<Statement> statements, AtomicInteger statementsAdded, Integer limit, Consumer<Statement> statementConsumer) {
        while (statements.hasNext()) {
            statementConsumer.accept((Statement)statements.next());
            statementsAdded.incrementAndGet();
            if (limit == null || !limit.equals(statementsAdded.get())) continue;
            break;
        }
    }

    private <T extends Resource> void fetchResourceGraph(final SemanticRepository semanticRepository, final Model results, final T resource, final String role, final String inference, final Boolean bnodes, final Boolean sameAs, final Integer limit, final Integer offset) {
        SemanticRepository semanticRepository2 = semanticRepository;
        Objects.requireNonNull(semanticRepository2);
        new SemanticRepository.WithRawConnection<Void>(semanticRepository2){

            protected Void doInConnection(RepositoryConnection connection) throws RepositoryException {
                ArrayList<TupleQuery> queries = new ArrayList<TupleQuery>();
                try {
                    if (role.matches("all|subject")) {
                        queries.add(ExploreService.this.getResourceQuery(resource, null, null, null, inference, bnodes, sameAs, limit, offset, connection, semanticRepository.getRepositoryID()));
                    }
                    if (role.matches("all|predicate")) {
                        queries.add(ExploreService.this.getResourceQuery(null, resource, null, null, inference, bnodes, sameAs, limit, offset, connection, semanticRepository.getRepositoryID()));
                    }
                    if (role.matches("all|object")) {
                        queries.add(ExploreService.this.getResourceQuery(null, null, resource, null, inference, bnodes, sameAs, limit, offset, connection, semanticRepository.getRepositoryID()));
                    }
                    if (role.matches("all|context") && !(resource instanceof Triple)) {
                        queries.add(ExploreService.this.getResourceQuery(null, null, null, resource, inference, bnodes, sameAs, limit, offset, connection, semanticRepository.getRepositoryID()));
                    }
                }
                catch (MalformedQueryException | QueryEvaluationException e) {
                    throw new RepositoryException(e);
                }
                ExploreService.this.queryResultsToGraph(results, queries);
                return null;
            }
        }.run();
    }

    private void makeCount(TupleQuery query) {
        if (query.getDataset() == null) {
            query.setDataset((Dataset)new SimpleDataset());
        }
        ((SimpleDataset)query.getDataset()).addDefaultGraph(COUNT_URI);
    }

    public Integer getResourceGraphCount(IRI resource, String role, String inference, Boolean bnodes, Boolean sameAs, IRI context) throws GraphDBWorkbenchException {
        if (this.isShaclContext((Resource)resource, context)) {
            return this.fetchShaclGraphCount(resource, role);
        }
        return this.fetchResourceGraphCount(resource, role, inference, bnodes, sameAs);
    }

    public Integer fetchShaclGraphCount(final IRI resource, final String role) throws GraphDBWorkbenchException {
        SemanticRepository semanticRepository;
        final AtomicInteger count = new AtomicInteger(0);
        SemanticRepository semanticRepository2 = semanticRepository = this.semanticDataManagement.getCurrentRepositoryOrThrow();
        Objects.requireNonNull(semanticRepository2);
        new SemanticRepository.WithRawConnection<Void>(semanticRepository2){

            protected Void doInConnection(RepositoryConnection connection) throws RepositoryException {
                LinkedList<RepositoryResult<Statement>> statementsQueue = new LinkedList<RepositoryResult<Statement>>();
                ExploreService.this.addShaclStatementsToQueue((Resource)resource, role, statementsQueue, connection);
                ExploreService.this.processShaclStatementsQueue(statementsQueue, statement -> count.incrementAndGet(), null, null);
                return null;
            }
        }.run();
        return count.get();
    }

    private Integer fetchResourceGraphCount(final IRI resource, final String role, final String inference, final Boolean bnodes, final Boolean sameAs) throws GraphDBWorkbenchException {
        SemanticRepository semanticRepository;
        final AtomicInteger count = new AtomicInteger();
        SemanticRepository semanticRepository2 = semanticRepository = this.semanticDataManagement.getCurrentRepositoryOrThrow();
        Objects.requireNonNull(semanticRepository2);
        new SemanticRepository.WithRawConnection<Void>(semanticRepository2){

            protected Void doInConnection(RepositoryConnection connection) throws RepositoryException {
                ArrayList<TupleQuery> queries = new ArrayList<TupleQuery>();
                try {
                    TupleQuery query;
                    if (role.matches("all|subject")) {
                        query = ExploreService.this.getResourceQuery(resource, null, null, null, inference, bnodes, sameAs, Integer.MAX_VALUE, 0, connection, semanticRepository.getRepositoryID());
                        ExploreService.this.makeCount(query);
                        queries.add(query);
                    }
                    if (role.matches("predicate")) {
                        query = ExploreService.this.getResourceQuery(null, resource, null, null, inference, bnodes, sameAs, Integer.MAX_VALUE, 0, connection, semanticRepository.getRepositoryID());
                        ExploreService.this.makeCount(query);
                        queries.add(query);
                    }
                    if (role.matches("all")) {
                        query = ExploreService.this.getResourceQuery(null, resource, null, null, inference, bnodes, sameAs, Integer.MAX_VALUE, 0, connection, semanticRepository.getRepositoryID(), true);
                        ExploreService.this.makeCount(query);
                        queries.add(query);
                    }
                    if (role.matches("object")) {
                        query = ExploreService.this.getResourceQuery(null, null, resource, null, inference, bnodes, sameAs, Integer.MAX_VALUE, 0, connection, semanticRepository.getRepositoryID());
                        ExploreService.this.makeCount(query);
                        queries.add(query);
                    }
                    if (role.matches("all")) {
                        query = ExploreService.this.getResourceQuery(null, null, resource, null, inference, bnodes, sameAs, Integer.MAX_VALUE, 0, connection, semanticRepository.getRepositoryID(), true);
                        ExploreService.this.makeCount(query);
                        queries.add(query);
                    }
                }
                catch (MalformedQueryException | QueryEvaluationException e) {
                    throw new RepositoryException(e);
                }
                count.getAndAdd(ExploreService.this.getCount(queries));
                return null;
            }
        }.run();
        return count.get();
    }

    public <T extends Resource> TupleQuery getResourceQuery(T subject, T predicate, T object, T context, String inference, Boolean bnodes, Boolean sameAs, Integer limit, Integer offset, RepositoryConnection repositoryConnection, String repositoryId) throws QueryEvaluationException, MalformedQueryException, RepositoryException {
        return this.getResourceQuery(subject, predicate, object, context, inference, bnodes, sameAs, limit, offset, repositoryConnection, repositoryId, false);
    }

    public <T extends Resource> TupleQuery getResourceQuery(T subject, T predicate, T object, T context, String inference, Boolean bnodes, Boolean sameAs, Integer limit, Integer offset, RepositoryConnection repositoryConnection, String repositoryId, boolean doNotCountTwiceWhenSubjectEqObject) throws QueryEvaluationException, MalformedQueryException, RepositoryException {
        HashMap<String, String> values = new HashMap<String, String>();
        SemanticLocation semanticLocation = this.semanticDataManagement.getLocationFromHeaderOrThrow();
        boolean ontopRepo = RepositoryUtils.isOntopRepository((Repository)repositoryConnection.getRepository(), (SemanticLocation)semanticLocation, (String)repositoryId);
        boolean isFedXWithSPARQLEndpoint = RepositoryUtils.isFedXWithSPARQLEndpoint((Repository)repositoryConnection.getRepository(), (SemanticLocation)semanticLocation, (String)repositoryId);
        Value iri = null;
        String bindVarKey = null;
        if (!ontopRepo) {
            if (subject != null) {
                values.put("resourceFilter", "");
                iri = (Value)subject;
                bindVarKey = "subject";
            } else if (predicate != null) {
                if (doNotCountTwiceWhenSubjectEqObject) {
                    values.put("resourceFilter", "FILTER (?subject != ?predicate) . ");
                } else {
                    values.put("resourceFilter", "");
                }
                iri = (Value)predicate;
                bindVarKey = "predicate";
            } else if (object != null) {
                if (doNotCountTwiceWhenSubjectEqObject) {
                    values.put("resourceFilter", "FILTER (?subject != ?object) . ");
                } else {
                    values.put("resourceFilter", "");
                }
                iri = (Value)object;
                bindVarKey = "object";
            } else if (context != null) {
                values.put("namedGraph", "FROM NAMED <" + context.stringValue().replaceAll("\\$", "DOLL@R") + ">");
                if (doNotCountTwiceWhenSubjectEqObject) {
                    values.put("resourceFilter", "FILTER (?subject != ?object) . ");
                }
            }
            if (isFedXWithSPARQLEndpoint) {
                if (context == null && !"SYSTEM".equals(repositoryId) && inference.equals("implicit")) {
                    values.put("namedGraph", "FROM NAMED <http://www.ontotext.com/skip-redundant-implicit> FROM NAMED <http://www.ontotext.com/implicit>");
                }
            } else if (context == null && !"SYSTEM".equals(repositoryId)) {
                if (inference.equals("explicit")) {
                    values.put("namedGraph", "FROM NAMED <http://www.ontotext.com/explicit>");
                } else if (inference.equals("implicit")) {
                    values.put("namedGraph", "FROM NAMED <http://www.ontotext.com/skip-redundant-implicit> FROM NAMED <http://www.ontotext.com/implicit>");
                } else {
                    values.put("namedGraph", "FROM NAMED <http://www.ontotext.com/explicit> FROM NAMED <http://www.ontotext.com/skip-redundant-implicit> FROM NAMED <http://www.ontotext.com/implicit>");
                }
            }
            if (!"SYSTEM".equals(repositoryId) && sameAs != null && !sameAs.booleanValue()) {
                values.put("sameAsGraph", "FROM <http://www.ontotext.com/disable-sameAs>");
            }
        } else {
            if (subject != null) {
                values.put("bind", "BIND (<" + subject.stringValue() + "> as ?subject)");
            }
            if (predicate != null) {
                values.put("bind", "BIND (<" + predicate.stringValue() + "> as ?predicate)");
            }
            if (object != null) {
                values.put("bind", "BIND (<" + object.stringValue() + "> as ?object)");
            }
        }
        values.put("limit", limit.toString());
        values.put("offset", offset.toString());
        String queryTemplate = isFedXWithSPARQLEndpoint ? (String)this.resourceUtils.getProperty("resource.query.fedx.sparql") : (ontopRepo ? (String)this.resourceUtils.getProperty("resource.query.ontop") : (bnodes != false ? (String)this.resourceUtils.getProperty("resource.query") : (String)this.resourceUtils.getProperty("resource.query.skipbnodes")));
        String query = this.decorate(queryTemplate, values).replaceAll("DOLL@R", "\\$");
        TupleQuery tupleQuery = repositoryConnection.prepareTupleQuery(QueryLanguage.SPARQL, query);
        if (context != null && (inference.equals("explicit") || inference.equals("all"))) {
            tupleQuery.setIncludeInferred(false);
        }
        if (isFedXWithSPARQLEndpoint && context == null && !"SYSTEM".equals(repositoryId)) {
            if (inference.equals("explicit")) {
                tupleQuery.setIncludeInferred(false);
            } else if (!inference.equals("implicit")) {
                tupleQuery.setIncludeInferred(true);
            }
        }
        if (bindVarKey != null) {
            tupleQuery.setBinding(bindVarKey, iri);
        }
        return tupleQuery;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer getCount(List<TupleQuery> queries) {
        Integer count = 0;
        TupleQueryResult result = null;
        for (TupleQuery query : queries) {
            try {
                result = query.evaluate();
                while (result.hasNext()) {
                    BindingSet bs = (BindingSet)result.next();
                    count = count + Integer.valueOf(bs.getValue("subject").stringValue());
                }
            }
            catch (QueryEvaluationException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            finally {
                if (result == null) continue;
                try {
                    result.close();
                }
                catch (QueryEvaluationException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queryResultsToGraph(Model graph, List<TupleQuery> queries) {
        TupleQueryResult result = null;
        for (TupleQuery query : queries) {
            try {
                result = query.evaluate();
                while (result.hasNext()) {
                    BindingSet bs = (BindingSet)result.next();
                    IRI predicate = (IRI)bs.getValue("predicate");
                    Resource context = bs.getValue("context") != null ? (Resource)bs.getValue("context") : null;
                    Object subject = bs.getValue("subject") instanceof IRI ? (IRI)bs.getValue("subject") : (Resource)bs.getValue("subject");
                    Value object = bs.getValue("object");
                    if (context != null) {
                        graph.add((Resource)subject, predicate, object, new Resource[]{context});
                        continue;
                    }
                    graph.add((Resource)subject, predicate, object, new Resource[0]);
                }
            }
            catch (QueryEvaluationException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            finally {
                if (result == null) continue;
                try {
                    result.close();
                }
                catch (QueryEvaluationException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private String decorate(String str, Map<String, String> values) {
        Matcher m = Pattern.compile("\\$\\{[^}]*\\}").matcher(str);
        while (m.find()) {
            String key = m.group().replaceAll("^\\$\\{|\\}$", "");
            String value = values.get(key);
            if (value == null) {
                value = "";
            }
            str = str.replaceAll("\\$\\{" + key + "\\}", Matcher.quoteReplacement(value));
        }
        return str;
    }

    public ResponseEntity<ResourceDetails> getResourceDetails(final Resource resource, final List<String> languages, final @Nullable IRI context) throws GraphDBWorkbenchException {
        SemanticRepository repository = this.semanticDataManagement.getCurrentRepositoryOrThrow();
        SemanticLocation semanticLocation = this.semanticDataManagement.getLocationFromHeaderOrThrow();
        final boolean isOntopRepo = RepositoryUtils.isOntopRepository((SemanticRepository)repository, (SemanticLocation)semanticLocation);
        final boolean isFedXWithSPARQLEndpoint = RepositoryUtils.isFedXWithSPARQLEndpoint((SemanticRepository)repository, (SemanticLocation)semanticLocation);
        SemanticRepository semanticRepository = repository;
        Objects.requireNonNull(semanticRepository);
        ResourceDetails details = (ResourceDetails)new SemanticRepository.WithConnection<ResourceDetails>(semanticRepository){

            protected ResourceDetails doInConnection() throws RepositoryException {
                try {
                    ResourceDetails fillDetails = new ResourceDetails();
                    if (!isOntopRepo && !isFedXWithSPARQLEndpoint) {
                        String langMatches = QueryUtils.generateLangMatchesIfs((String)"?langLabel", (Collection)languages);
                        String langComment = QueryUtils.generateLangMatchesIfs((String)"?langComment", (Collection)languages);
                        String query = ((String)ExploreService.this.resourceUtils.getProperty("resource.details")).replace("{{langMatches}}", langMatches).replace("{{langComment}}", langComment);
                        TupleQuery tupleQuery = this.prepare(query);
                        tupleQuery.setBinding("iri", (Value)resource);
                        TupleQueryResult result = this.evaluate(tupleQuery);
                        if (result.hasNext()) {
                            BindingSet bs = (BindingSet)result.next();
                            if (bs.hasBinding("label")) {
                                fillDetails.setLabel(ExploreService.this.getLabel(bs));
                            }
                            if (bs.hasBinding("comment")) {
                                fillDetails.setComment(ExploreService.this.getComment(bs));
                            }
                            if (bs.hasBinding("img")) {
                                fillDetails.setImage(ExploreService.this.getImg(bs));
                            }
                        }
                    }
                    if (ExploreService.this.isShaclContext(resource, context)) {
                        fillDetails.setContext(RDF4J.SHACL_SHAPE_GRAPH);
                    } else if (context != null) {
                        fillDetails.setContext(context);
                    }
                    fillDetails.setUri(resource);
                    return fillDetails;
                }
                catch (MalformedQueryException | QueryEvaluationException e) {
                    throw new RepositoryException(e);
                }
            }
        }.run();
        return new ResponseEntity((Object)details, (HttpStatusCode)HttpStatus.OK);
    }

    private String getImg(BindingSet bs) {
        try {
            return bs.getBinding("img").getValue().stringValue();
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getLabel(BindingSet bs) {
        try {
            return ((Literal)bs.getBinding("label").getValue()).getLabel();
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getComment(BindingSet bs) {
        try {
            return ((Literal)bs.getBinding("comment").getValue()).getLabel();
        }
        catch (Exception e) {
            return null;
        }
    }
}

