/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.resource.explore;

import com.ontotext.forest.core.error.GraphDBWorkbenchException;
import com.ontotext.forest.resource.explore.ExploreBean;
import com.ontotext.forest.resource.explore.ExploreService;
import com.ontotext.forest.resource.explore.ResourceDetails;
import com.ontotext.rio.jsonld.JsonLDUtils;
import com.ontotext.rio.jsonld.NoWhitelistPatternsException;
import io.swagger.v3.oas.annotations.Hidden;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.Valid;
import java.io.IOException;
import java.util.List;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Triple;
import org.eclipse.rdf4j.sail.memory.model.MemIRI;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/rest/explore"})
public class ExploreController {
    @Autowired
    private ExploreService resourceService;

    @Hidden
    @RequestMapping(value={"/graph"}, method={RequestMethod.GET})
    public ResponseEntity<Model> resource(@Valid @ModelAttribute ExploreBean bean, HttpServletRequest request) throws GraphDBWorkbenchException, NoWhitelistPatternsException {
        JsonLDUtils.extractProvidedJSONLDLinkAndValidate((String)request.getHeader("Link"));
        if (bean.getUri() != null) {
            return this.getModelResponseEntity(bean, this.trimIRI(bean.getUri()));
        }
        return this.getModelResponseEntity(bean, bean.getTriple());
    }

    @NotNull
    private <T extends Resource> ResponseEntity<Model> getModelResponseEntity(@ModelAttribute @Valid ExploreBean bean, T resource) {
        return new ResponseEntity((Object)this.resourceService.getResourceGraph(resource, bean.getRole(), bean.getInference(), bean.getBnodes(), bean.getSameAs(), bean.getContext(), bean.getLimit(), bean.getOffset()), (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"/graph/count"}, method={RequestMethod.GET})
    public ResponseEntity<Integer> resourceCount(@Valid @ModelAttribute ExploreBean bean) throws IOException, GraphDBWorkbenchException {
        return new ResponseEntity((Object)this.resourceService.getResourceGraphCount(this.trimIRI(bean.getUri()), bean.getRole(), bean.getInference(), bean.getBnodes(), bean.getSameAs(), bean.getContext()), (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"/details"}, produces={"application/json"}, method={RequestMethod.GET}, params={"uri"})
    @ResponseBody
    public ResponseEntity<ResourceDetails> resourceDetails(@RequestParam IRI uri, @RequestParam(required=false) List<String> languages, @RequestParam(required=false) IRI context) throws GraphDBWorkbenchException {
        return this.resourceService.getResourceDetails((Resource)this.trimIRI(uri), languages, context);
    }

    @RequestMapping(value={"/details"}, produces={"application/json"}, method={RequestMethod.GET}, params={"triple"})
    @ResponseBody
    public ResponseEntity<ResourceDetails> resourceDetails(@RequestParam Triple triple, @RequestParam(required=false) List<String> languages, @RequestParam(required=false) IRI context) throws GraphDBWorkbenchException {
        return this.resourceService.getResourceDetails((Resource)triple, languages, context);
    }

    private IRI trimIRI(IRI iri) {
        return new MemIRI((Object)iri, iri.getNamespace(), iri.getLocalName().trim());
    }
}

