/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.platform.dynamicvalidator;

import com.ontotext.graphql.responder.UpdateExecution;
import com.ontotext.graphql.responder.validation.AsyncMutationActiveValidator;
import com.ontotext.graphql.responder.validation.AsyncMutationActiveValidatorCallback;
import com.ontotext.graphql.responder.validation.MutationActiveValidator;
import com.ontotext.models.Shape;
import com.ontotext.models.extensions.OperationResponse;
import com.ontotext.models.extensions.Order;
import com.ontotext.models.mutation.Change;
import com.ontotext.models.mutation.DeleteMutation;
import com.ontotext.soaas.common.rdf.RdfTree;
import com.ontotext.soaas.common.rdf.Triple;
import com.ontotext.soaas.common.rdf.ValueReader;
import com.ontotext.validator.mutation.SoTypeValidator;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Order(value=30)
public class SoTypeDeleteValidator
implements AsyncMutationActiveValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private SoTypeValidator soTypeValidator = new SoTypeValidator();

    public MutationActiveValidator.Phase getPhase() {
        return MutationActiveValidator.Phase.PRE_TX;
    }

    public AsyncMutationActiveValidatorCallback createAsyncValidator(final UpdateExecution request, final MutationActiveValidator.ActiveValidationContext context) {
        if (!(request.getOperation() instanceof DeleteMutation)) {
            return null;
        }
        final HashMap idTypes = new HashMap();
        List changes = request.getOperation().getChanges();
        for (Change change : changes) {
            change.getEntityId().ifPresent(id -> idTypes.put(id, change));
        }
        idTypes.keySet().removeIf(context.getTrackedObjects()::containsKey);
        if (idTypes.isEmpty()) {
            return null;
        }
        if (!request.isSilent()) {
            LOGGER.info("Checking {} entities if exists and have correct type on delete: {}", (Object)idTypes.size(), idTypes.keySet());
        }
        return new AsyncMutationActiveValidatorCallback(){
            private RdfTree rdfTree;

            public void invokeAsync() {
                this.rdfTree = context.getStoreInvoker().executeObjectQuery(request.getSchema(), idTypes.keySet(), true, request.getOperationOptions());
            }

            public OperationResponse completeValidation() {
                if (this.rdfTree == null) {
                    return OperationResponse.createFailed();
                }
                idTypes.keySet().removeIf(context.getTrackedObjects()::containsKey);
                ValueReader reader = this.rdfTree.getValueReader();
                OperationResponse resp = new OperationResponse();
                for (Triple triple : this.rdfTree.findAtAnyDepth(null, "http://www.ontotext.com/semantic-object/type", null)) {
                    if (context.getTrackedObjects().containsKey(triple.getSubject())) {
                        idTypes.remove(triple.getSubject());
                        continue;
                    }
                    SoTypeDeleteValidator.this.checkIdValidity(idTypes, resp, triple, reader);
                }
                for (Map.Entry entry : idTypes.entrySet()) {
                    SoTypeDeleteValidator.this.soTypeValidator.addErrorMessage(((Change)entry.getValue()).getSourceLocation(), resp, "mutation.filter.type.invalid", new Object[]{entry.getKey(), request.getOperation().getResponseTypeInstance().getType().toString()});
                }
                return resp;
            }

            public MutationActiveValidator getValidator() {
                return SoTypeDeleteValidator.this;
            }
        };
    }

    private void checkIdValidity(Map<String, Change> idTypes, OperationResponse resp, Triple triple, ValueReader reader) {
        String dbId = triple.getSubject();
        if (!idTypes.containsKey(dbId)) {
            return;
        }
        Object dbType = reader.read(triple.getObject());
        Change change = idTypes.get(dbId);
        Object expectedType = change.getShape().getType();
        if (dbType instanceof String && !this.isTypeMatching(dbType, change)) {
            this.soTypeValidator.addErrorMessage(change.getSourceLocation(), resp, "mutation.filter.type.mismatch", new Object[]{dbId, expectedType.toString(), change.getShape().getContainedIn().resolveByType((String)dbType, Shape::asGraphQl)});
        }
        idTypes.remove(dbId);
    }

    private boolean isTypeMatching(Object dbType, Change change) {
        String graphQlName = change.getShape().asGraphQl();
        if (graphQlName.equals(dbType)) {
            return true;
        }
        Shape shape = change.getShape().getContainedIn().getByType((String)dbType);
        if (shape == null) {
            return false;
        }
        return shape.getId().equals(change.getShape().getId());
    }
}

