/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.externalsync.impl.kafka;

import com.ontotext.trree.plugin.externalsync.ExternalSyncPlugin;
import com.ontotext.trree.plugin.externalsync.config.Options;
import com.ontotext.trree.plugin.externalsync.config.validators.ValidatorWithPlugin;
import com.ontotext.trree.plugin.externalsync.impl.kafka.KafkaProducerRegistry;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaUrlValidation
implements ValidatorWithPlugin<String> {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaUrlValidation.class);

    @Nullable
    public String validate(ExternalSyncPlugin plugin, @Nullable String nodes, Options optionsSet) {
        assert (nodes != null);
        if (plugin.isTestingTransaction()) {
            try {
                String canConnectToKafka = KafkaProducerRegistry.canConnectToKafka(optionsSet);
                if (canConnectToKafka != null) {
                    return "Couldn't connect to Kafka at " + nodes + "! " + canConnectToKafka;
                }
            }
            catch (Exception ex) {
                LOG.error("Couldn't connect to Kafka at " + nodes, (Throwable)ex);
                return "Couldn't connect to Kafka at " + nodes + "! " + ex.getMessage();
            }
        }
        return null;
    }

    @Nullable
    public Object validate(@Nullable String value, Options optionsSet) {
        throw new IllegalStateException("Plugin required. Use the other method to validate.");
    }
}

