/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.externalsync.impl.kafka;

import com.ontotext.trree.plugin.externalsync.ExternalSyncPlugin;
import com.ontotext.trree.plugin.externalsync.config.Options;
import com.ontotext.trree.plugin.externalsync.config.validators.IndexExistValidator;
import com.ontotext.trree.plugin.externalsync.impl.kafka.KafkaPlugin;
import com.ontotext.trree.plugin.externalsync.impl.kafka.KafkaProducerRegistry;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class KafkaTopicExistValidator
implements IndexExistValidator<String> {
    @Nullable
    public String validate(ExternalSyncPlugin plugin, @Nullable Options optionsToUpdate, Options optionsSet) {
        String nodes = (String)optionsSet.getValue(KafkaPlugin.KAFKA_NODE);
        String storeName = optionsSet.getStoreName();
        if (optionsToUpdate != null && plugin.isTestingTransaction() && StringUtils.isNotEmpty((CharSequence)nodes)) {
            try {
                if (!KafkaProducerRegistry.doesKafkaTopicExistOnNode(optionsSet, storeName)) {
                    return "A Kafka topic '" + storeName + "' doesn't exist on the provided '" + nodes + "' node!";
                }
            }
            catch (Exception ex) {
                plugin.getLogger().error("A Kafka topic '{}' doesn't exist on the provided '{}' node!", (Object)storeName, (Object)nodes);
                return "A Kafka topic '" + storeName + "' doesn't exist on the provided '" + nodes + "' node! " + ex.getMessage();
            }
        }
        return null;
    }

    @Nullable
    public Object validate(@Nullable String value, Options optionsSet) {
        throw new IllegalStateException("Plugin required. Use the other method to validate.");
    }
}

