/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.externalsync.impl.kafka;

import com.ontotext.trree.plugin.externalsync.ExternalSyncPlugin;
import com.ontotext.trree.plugin.externalsync.ExternalSyncRequestContext;
import com.ontotext.trree.plugin.externalsync.api.ConnectorException;
import com.ontotext.trree.plugin.externalsync.api.ConnectorServerException;
import com.ontotext.trree.plugin.externalsync.api.ExternalRetrieve;
import com.ontotext.trree.plugin.externalsync.api.ExternalStore;
import com.ontotext.trree.plugin.externalsync.api.SyncDocument;
import com.ontotext.trree.plugin.externalsync.config.Options;
import com.ontotext.trree.plugin.externalsync.impl.AbstractExternalStore;
import com.ontotext.trree.plugin.externalsync.impl.Property;
import com.ontotext.trree.plugin.externalsync.impl.kafka.IndexedEntitiesModifiablePairCollection;
import com.ontotext.trree.plugin.externalsync.impl.kafka.KafkaDriver;
import com.ontotext.trree.plugin.externalsync.impl.kafka.KafkaMappingGenerator;
import com.ontotext.trree.plugin.externalsync.impl.kafka.KafkaPlugin;
import com.ontotext.trree.plugin.externalsync.iterators.master.MasterResultIterator;
import com.ontotext.trree.plugin.externalsync.util.EntitiesUtil;
import com.ontotext.trree.plugin.externalsync.util.ValuesUtil;
import com.ontotext.trree.sdk.ClientErrorException;
import com.ontotext.trree.sdk.Entities;
import com.ontotext.trree.sdk.HealthResult;
import com.ontotext.trree.sdk.PluginConnection;
import com.ontotext.trree.sdk.ServerErrorException;
import com.ontotext.trree.sdk.Statements;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Value;
import org.json.simple.JSONObject;

public class KafkaStore
extends AbstractExternalStore<Map<String, Object>> {
    private static final String FIELD_TYPES_KEY = "fieldTypes";
    private static final String OUT_OF_SYNC_KEY = "outOfSync";
    private final KafkaDriver driver;
    private final KafkaMappingGenerator mappingGenerator;
    private IndexedEntitiesModifiablePairCollection indexedEntities;
    private AtomicBoolean outOfSync = new AtomicBoolean();

    private KafkaStore(String storeName, Options storeOptions, boolean wasJustCreated, long initialFingerprint, KafkaPlugin kafkaPlugin, PluginConnection pluginConnection, Entities entities) {
        super(storeName, storeOptions, wasJustCreated, initialFingerprint, (ExternalSyncPlugin)kafkaPlugin, pluginConnection, entities);
        this.mappingGenerator = new KafkaMappingGenerator();
        this.driver = new KafkaDriver((KafkaPlugin)this.plugin, this, this.name, this.options);
    }

    static ExternalStore open(String storeName, Options storeOptions, KafkaPlugin kafkaPlugin, PluginConnection pluginConnection) {
        return new KafkaStore(storeName, storeOptions, false, 0L, kafkaPlugin, pluginConnection, pluginConnection.getEntities());
    }

    public static ExternalStore create(String storeName, Options options, KafkaPlugin kafkaPlugin, PluginConnection pluginConnection, Entities entitiesForCreation) {
        KafkaStore kafkaStore = new KafkaStore(storeName, options, true, 0L, kafkaPlugin, pluginConnection, entitiesForCreation);
        kafkaStore.createIndex(true);
        return kafkaStore;
    }

    protected void createIndex(boolean cleanupAfterFailure) {
        try {
            this.init();
        }
        catch (Exception e) {
            if (cleanupAfterFailure) {
                try {
                    this.remove(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (e instanceof ConnectorException) {
                throw e;
            }
            throw new ConnectorServerException("Unable to create connector: " + e.getMessage(), (Throwable)e);
        }
    }

    protected void deleteEntity(long subject, Value subjectValue) {
        this.driver.delete(EntitiesUtil.valueToString((Value)subjectValue));
        this.indexedEntities.remove(subject);
    }

    protected boolean syncEntity(long subject, long predicate, long context, SyncDocument<Map<String, Object>> syncDoc, List<Property> propertiesToSync, Entities entities, Statements statements, boolean skip) {
        try {
            boolean anyProperty = this.syncEntityToDocument(syncDoc, subject, predicate, context, propertiesToSync, entities, statements);
            if (anyProperty && this.convertSyncDocumentToNativeDocument(syncDoc, propertiesToSync)) {
                if (!skip) {
                    this.driver.index(EntitiesUtil.valueToString((Value)entities.get(subject)), (Map)syncDoc.nativeDocument);
                }
                this.indexedEntities.add(subject);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            throw new ServerErrorException("Couldn't index entity " + String.valueOf(entities.get(subject)), (Throwable)e);
        }
    }

    protected boolean writePropertyValueToNativeDocument(Map<String, Object> doc, Property property, String fieldName, Value value) {
        try {
            Object objValue;
            String type = this.mappingGenerator.computeType(fieldName, value, property);
            try {
                switch (type) {
                    case "long": {
                        objValue = this.asLiteral(value).longValue();
                        break;
                    }
                    case "integer": {
                        objValue = this.asLiteral(value).intValue();
                        break;
                    }
                    case "double": {
                        objValue = this.asLiteral(value).doubleValue();
                        break;
                    }
                    case "float": {
                        objValue = Float.valueOf(this.asLiteral(value).floatValue());
                        break;
                    }
                    case "boolean": {
                        objValue = this.asLiteral(value).booleanValue();
                        break;
                    }
                    case "date": 
                    case "dateTime": 
                    case "time": 
                    case "gYear": 
                    case "gYearMonth": {
                        objValue = EntitiesUtil.valueToString((Value)this.asLiteral(value));
                        IRI xsdType = property.getXsdType();
                        if (xsdType == null && !ValuesUtil.INSTANCE.isSupportedType(xsdType = this.asLiteral(value).getDatatype())) break;
                        objValue = ValuesUtil.INSTANCE.xsdTemporalAsISO((String)objValue, xsdType);
                        break;
                    }
                    default: {
                        objValue = EntitiesUtil.valueToString((Value)value);
                    }
                }
            }
            catch (RuntimeException e) {
                if (property.isIgnoreInvalidValues()) {
                    this.notifyIgnoreInvalidValue(fieldName, type, value);
                    return false;
                }
                throw e;
            }
            if (property.isIndexed()) {
                this.setFieldValue(property, doc, fieldName, objValue);
            }
        }
        catch (IOException ex) {
            throw new ServerErrorException("Couldn't index " + fieldName + " with value " + String.valueOf(value), (Throwable)ex);
        }
        this.logger.debug("[{}] Indexing: '{}' = '{}'", new Object[]{this.name, fieldName, value});
        return true;
    }

    protected void addNativeNestedDocument(Map<String, Object> doc, Property property, Map<String, Object> nestedDoc) {
        this.setFieldValue(property, doc, property.getFieldNameWithoutSuffix(), nestedDoc);
    }

    protected Map<String, Object> newNativeDocument() {
        return new HashMap<String, Object>();
    }

    protected boolean isEntityIndexed(long subject) {
        return this.indexedEntities.isEntityIndexed(subject);
    }

    private void setFieldValue(Property property, Map<String, Object> doc, String key, Object value) {
        if (property.isArray()) {
            if (property.isMultivalued()) {
                ArrayList<Object> values = (ArrayList<Object>)doc.get(key);
                if (values == null) {
                    values = new ArrayList<Object>(2);
                    doc.put(key, values);
                }
                values.add(value);
            } else {
                doc.put(key, Collections.singletonList(value));
            }
        } else if (property.isMultivalued()) {
            Object oldValue = doc.get(key);
            if (oldValue == null) {
                doc.put(key, value);
            } else if (oldValue instanceof List) {
                List values = (List)oldValue;
                values.add(value);
            } else {
                ArrayList<Object> replacedValue = new ArrayList<Object>(2);
                replacedValue.add(oldValue);
                replacedValue.add(value);
                doc.put(key, replacedValue);
            }
        } else {
            doc.put(key, value);
        }
    }

    protected boolean isValidFieldNameImplementation(String fieldName, boolean isTopField) {
        return true;
    }

    public ExternalRetrieve createRetrieve(MasterResultIterator mri, ExternalSyncRequestContext requestContext) {
        throw new IllegalStateException("Kafka connector does not support search");
    }

    public void transactionStarted(PluginConnection pluginConnection) {
        super.transactionStarted(pluginConnection);
        if (this.initialised.get()) {
            this.driver.begin();
            this.mappingGenerator.setMappingChanged(false);
        }
    }

    public boolean transactionCompleted(PluginConnection pluginConnection) {
        if (this.initialised.get()) {
            this.indexedEntities.commit();
        }
        return super.transactionCompleted(pluginConnection);
    }

    public void rollbackCurrent(PluginConnection pluginConnection) throws IOException {
        this.indexedEntities.rollback();
        super.rollbackCurrent(pluginConnection);
    }

    public void rollbackLastCommitted(PluginConnection pluginConnection) throws IOException {
        if (this.driver.getNumberOfDocumentsInTransaction() > 0L) {
            this.outOfSync.set(true);
            this.dynamicOptionsUpdated = true;
        }
        super.rollbackLastCommitted(pluginConnection);
    }

    public void drop(boolean force) throws Exception {
        if (this.indexedEntities != null) {
            this.indexedEntities.drop();
        }
        super.drop(force);
    }

    @Nonnull
    public List<String> getSyncedFields() {
        try {
            ArrayList<String> result = new ArrayList<String>();
            for (String field : this.mappingGenerator.getExistingFields()) {
                if (!this.isValidFieldName(field, true)) continue;
                result.add(field);
            }
            return result;
        }
        catch (IOException e) {
            throw new ClientErrorException("Unable to get fields from Kafka.", (Throwable)e);
        }
    }

    public void closeNetworkResources() {
        try {
            if (this.driver != null) {
                this.driver.close();
            }
        }
        catch (Exception e) {
            this.logger.warn("[" + this.name + "] Error closing ES connector driver.", (Throwable)e);
        }
        if (this.indexedEntities != null) {
            this.indexedEntities.close();
            this.indexedEntities = null;
        }
    }

    protected String getNativeTypeFromDatatype(IRI datatype, boolean multivalued) {
        return KafkaMappingGenerator.getTypeFromDatatype(datatype);
    }

    public void removeAllEntities() {
        this.init();
        this.driver.deleteAll();
        this.indexedEntities.removeAll();
        super.removeAllEntities();
    }

    protected void validateProperties() {
        Boolean[] result = new Boolean[]{false, false};
        this.checkDotsAndNestedProperties(null, this.getProperties(), result);
        if (result[0].booleanValue() && result[1].booleanValue()) {
            throw new ClientErrorException("Field names with dots and nested objects may not be used together.");
        }
        this.validateNativeSettings(this.getProperties());
    }

    protected void initImpl() {
        if (this.indexedEntities == null) {
            this.indexedEntities = new IndexedEntitiesModifiablePairCollection(this.plugin.getDataDir().toPath(), this.name, this.plugin.getEntityIdSize());
        }
        this.driver.init();
    }

    private void checkDotsAndNestedProperties(@Nullable Property parent, List<Property> properties, Boolean[] result) {
        for (Property p : properties) {
            String type;
            boolean hasNested = !p.getObject().isEmpty();
            Boolean[] booleanArray = result;
            Boolean.valueOf(booleanArray[0] | p.getFieldNameWithSuffix().contains("."));
            booleanArray = result;
            Boolean.valueOf(booleanArray[1] | hasNested);
            if (hasNested && (type = p.getNativeType()) != null && !type.equals("object")) {
                throw new ClientErrorException("Fields with nested objects must be defined with datatype = object (object is the default).");
            }
            String fieldName = p.getFieldNameWithoutSuffix();
            if (parent != null && !this.isValidFieldName(fieldName, false)) {
                throw new ClientErrorException(String.format("Nested field name '%s' with parent '%s' may not be used.", fieldName, parent.getFieldNameWithoutSuffix()));
            }
            this.checkDotsAndNestedProperties(p, p.getObject(), result);
        }
    }

    private void validateNativeSettings(List<Property> properties) {
        for (Property property : properties) {
            Map nativeSettings = property.getNativeSettings();
            if (!(nativeSettings.isEmpty() || property.getNativeType() != null && property.getXsdType() == null)) {
                throw new ClientErrorException("Native field settings require an explicit native datatype");
            }
            this.validateNativeSettings(property.getObject());
        }
    }

    public HealthResult runHealthCheckInternal() {
        return this.driver.runHealthCheck();
    }

    public void updateOptions(Options newOptions) {
        Options updatedOptions = this.getOptions().copy();
        updatedOptions.updateOptions(newOptions, (Iterable)this.plugin.getAllOptions());
        this.driver.updateOptions(updatedOptions);
        super.updateOptions(newOptions);
    }

    void updateOptionsNoPropagate(Options newOptions) {
        super.updateOptions(newOptions);
    }

    protected void applyUpdatedOptions() {
        this.options.unsetValue(KafkaPlugin.KAFKA_PROPAGATE_CONFIG);
    }

    public JSONObject getSettingsAsJSON() {
        JSONObject settings = super.getSettingsAsJSON();
        settings.put((Object)FIELD_TYPES_KEY, (Object)this.mappingGenerator.getSettingsAsJSON());
        settings.put((Object)OUT_OF_SYNC_KEY, (Object)this.outOfSync.get());
        return settings;
    }

    public void setSettingsFromJSON(JSONObject json) {
        Object outOfSyncObj;
        super.setSettingsFromJSON(json);
        JSONObject fieldTypes = (JSONObject)json.get((Object)FIELD_TYPES_KEY);
        if (fieldTypes != null) {
            this.mappingGenerator.setSettingsFromJSON(fieldTypes);
        }
        if ((outOfSyncObj = json.get((Object)OUT_OF_SYNC_KEY)) instanceof Boolean) {
            this.outOfSync.set((Boolean)outOfSyncObj);
        }
    }

    public boolean settingsHaveChanged() {
        return super.settingsHaveChanged() || this.mappingGenerator.settingsHaveChanged();
    }

    boolean isOutOfSync() {
        return this.outOfSync.get();
    }
}

