/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.externalsync.impl.kafka;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import com.ontotext.graphdb.Config;
import com.ontotext.trree.plugin.externalsync.api.ConnectorUserException;
import com.ontotext.trree.plugin.externalsync.auth.PropertiesConfigurator;
import com.ontotext.trree.plugin.externalsync.auth.UsernamePasswordProvider;
import com.ontotext.trree.plugin.externalsync.config.Options;
import com.ontotext.trree.plugin.externalsync.config.OptionsUtil;
import com.ontotext.trree.plugin.externalsync.config.validators.Validator;
import com.ontotext.trree.plugin.externalsync.impl.kafka.KafkaJsonSerializer;
import com.ontotext.trree.plugin.externalsync.impl.kafka.KafkaPlugin;
import com.ontotext.trree.plugin.externalsync.impl.kafka.KafkaStore;
import com.ontotext.trree.statistics.StatisticsSettings;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.jetbrains.annotations.Nullable;

class KafkaProducerRegistry {
    private static final long KAFKA_ALIVE_TIMEOUT_SECONDS = Config.getPropertyAsInt((String)"graphdb.kafka.connector.alive.timeout", (int)30);
    private static final long DEFAULT_BATCH_SIZE = 0x100000L;
    private static final long DEFAULT_MAX_REQUEST_SIZE = 0x100000L;
    private static final long DEFAULT_LINGER_MS = 50L;
    private static final String DEFAULT_ACKS = "all";
    private static final long DEFAULT_TRANSACTION_TIMEOUT = 900000L;
    private static final String KAFKA_BATCH_SIZE = "batch.size";
    private static final String KAFKA_MAX_REQUEST_SIZE = "max.request.size";
    private static final String KAFKA_LINGER_MS = "linger.ms";
    private static final String KAFKA_ACKS = "acks";
    private static final String KAFKA_BOOTSTRAP_SERVERS = "bootstrap.servers";
    private static final String KAFKA_TRANSACTIONAL_ID = "transactional.id";
    private static final String KAFKA_KEY_SERIALIZER = "key.serializer";
    private static final String KAFKA_VALUE_SERIALIZER = "value.serializer";
    private static final String KAFKA_TRANSACTION_TIMEOUT = "transaction.timeout.ms";
    private static final String KAFKA_IDEMPOTENCE = "enable.idempotence";
    private static final Set<String> BANNED_CONFIG_KEYS = Stream.of("bootstrap.servers", "transactional.id", "key.serializer", "value.serializer").collect(Collectors.toSet());
    private static Runnable commitHook;
    private static Runnable createProducerHook;
    private static Runnable newProducerRecordHook;
    private final KafkaPlugin plugin;
    private final String repositoryId;
    private final Map<String, ReferencedProducer> producers;
    private final Properties producerConfigDefaults;

    static String canConnectToKafka(Options options) {
        try (KafkaConsumer<String, String> consumer = KafkaProducerRegistry.createConsumer(KafkaProducerRegistry.createPropertiesFromOptionsTestConnection(options));){
            consumer.listTopics(Duration.ofSeconds(KAFKA_ALIVE_TIMEOUT_SECONDS));
        }
        return null;
    }

    static boolean doesKafkaTopicExistOnNode(Options options, String kafkaTopic) {
        try (KafkaConsumer<String, String> consumer = KafkaProducerRegistry.createConsumer(KafkaProducerRegistry.createPropertiesFromOptionsTestConnection(options));){
            boolean bl = consumer.listTopics(Duration.ofSeconds(KAFKA_ALIVE_TIMEOUT_SECONDS)).containsKey(kafkaTopic);
            return bl;
        }
    }

    static void setCommitHook(Runnable commitHook) {
        KafkaProducerRegistry.commitHook = commitHook;
    }

    static void setCreateProducerHook(Runnable createProducerHook) {
        KafkaProducerRegistry.createProducerHook = createProducerHook;
    }

    static void setNewProducerRecordHook(Runnable newProducerRecordHook) {
        KafkaProducerRegistry.newProducerRecordHook = newProducerRecordHook;
    }

    KafkaProducerRegistry(KafkaPlugin plugin, String repositoryId) {
        this.plugin = plugin;
        this.repositoryId = repositoryId;
        this.producers = new HashMap<String, ReferencedProducer>();
        this.producerConfigDefaults = new Properties();
        this.producerConfigDefaults.put(KAFKA_BATCH_SIZE, Long.toString(0x100000L));
        this.producerConfigDefaults.put(KAFKA_MAX_REQUEST_SIZE, Long.toString(0x100000L));
        this.producerConfigDefaults.put(KAFKA_LINGER_MS, Long.toString(50L));
        this.producerConfigDefaults.put(KAFKA_ACKS, DEFAULT_ACKS);
        this.producerConfigDefaults.put(KAFKA_TRANSACTION_TIMEOUT, Long.toString(900000L));
    }

    synchronized ReferencedProducer acquireProducer(KafkaStore store) {
        String node2;
        Options options = store.getOptions();
        Properties producerConfig = this.createPropertiesFromOptions(options);
        ReferencedProducer rp = null;
        Set<String> brokerNodes = this.getBrokerNodes(options, producerConfig);
        Iterator<String> iterator = brokerNodes.iterator();
        while (iterator.hasNext() && (rp = this.producers.get(node2 = iterator.next())) == null) {
        }
        if (rp == null) {
            ReferencedProducer finalRp = rp = new ReferencedProducer(brokerNodes, producerConfig, (Boolean)options.getValueWithDefault(KafkaPlugin.KAFKA_USE_TRANSACTION));
            rp.nodes.forEach(node -> this.producers.put((String)node, finalRp));
        } else {
            boolean propagateConfig = (Boolean)options.getValueWithDefault(KafkaPlugin.KAFKA_PROPAGATE_CONFIG);
            if (!propagateConfig) {
                this.checkOtherInstancesConfig(store, rp, producerConfig);
            } else {
                rp.updateConfig(store, options);
                this.plugin.saveStoresOptions();
            }
            this.checkOtherInstancesConfig(store, rp, producerConfig);
        }
        rp.registerStore(store);
        return rp;
    }

    synchronized void releaseProducer(KafkaStore store, ReferencedProducer rp) {
        if (rp != null) {
            rp.unregisterStore(store);
            if (rp.unused()) {
                rp.nodes.forEach(this.producers::remove);
                rp.close();
            }
        }
    }

    void close() {
        this.producers.values().removeIf(p -> {
            p.close();
            return true;
        });
    }

    @VisibleForTesting
    Set<ReferencedProducer> getReferencedProducers() {
        Set<ReferencedProducer> result = Collections.newSetFromMap(new IdentityHashMap());
        result.addAll(this.producers.values());
        return result;
    }

    private static KafkaProducer<String, Map<?, ?>> createProducer(Properties properties, boolean transactional) {
        if (createProducerHook != null) {
            createProducerHook.run();
        }
        KafkaProducerRegistry.fixClassLoader();
        KafkaProducer producer = new KafkaProducer(KafkaProducerRegistry.getPropertiesAsMap(properties), (Serializer)new StringSerializer(), (Serializer)new KafkaJsonSerializer());
        if (transactional) {
            producer.initTransactions();
        }
        return producer;
    }

    private static Map getPropertiesAsMap(Properties properties) {
        HashMap<String, String> propertiesMap = new HashMap<String, String>();
        Iterator<?> iterator = properties.propertyNames().asIterator();
        while (iterator.hasNext()) {
            Object next = iterator.next();
            propertiesMap.put(next.toString(), properties.getProperty(next.toString()));
        }
        return propertiesMap;
    }

    private static KafkaConsumer<String, String> createConsumer(Properties properties) {
        if (createProducerHook != null) {
            createProducerHook.run();
        }
        KafkaProducerRegistry.fixClassLoader();
        return new KafkaConsumer(properties, (Deserializer)new StringDeserializer(), (Deserializer)new StringDeserializer());
    }

    private static void fixClassLoader() {
        Thread.currentThread().setContextClassLoader(KafkaProducerRegistry.class.getClassLoader());
    }

    private Set<String> getBrokerNodes(Options options, Properties properties) {
        String producerId = (String)options.getValue(KafkaPlugin.KAFKA_PRODUCER_ID);
        return Arrays.stream(properties.getProperty(KAFKA_BOOTSTRAP_SERVERS).split(",")).map(node -> {
            if (producerId != null) {
                node = (String)node + "_" + producerId;
            }
            return node;
        }).collect(Collectors.toSet());
    }

    private String computeTransactionalId(String producerId) {
        String txId = "graphdb_" + this.repositoryId + "_" + DigestUtils.md5Hex((String)StatisticsSettings.getInstance().getInstallationId());
        if (producerId != null) {
            txId = txId + "-" + producerId;
        }
        return txId;
    }

    private Properties createPropertiesFromOptions(Options options) {
        Long bulkUpdateRequestSize;
        boolean transactional = (Boolean)options.getValueWithDefault(KafkaPlugin.KAFKA_USE_TRANSACTION);
        Properties properties = KafkaProducerRegistry.createPropertiesFromOptionsCommon(options, this.producerConfigDefaults);
        if (transactional) {
            String transactionalId = this.computeTransactionalId((String)options.getValue(KafkaPlugin.KAFKA_PRODUCER_ID));
            properties.put(KAFKA_TRANSACTIONAL_ID, transactionalId);
        } else {
            properties.put(KAFKA_IDEMPOTENCE, "false");
        }
        Long bulkUpdateBatchSize = (Long)options.getValue(KafkaPlugin.BULK_UPDATE_BATCH_SIZE);
        if (bulkUpdateBatchSize != null) {
            properties.put(KAFKA_BATCH_SIZE, Long.toString(bulkUpdateBatchSize));
        }
        if ((bulkUpdateRequestSize = (Long)options.getValue(KafkaPlugin.BULK_UPDATE_REQUEST_SIZE)) != null) {
            properties.put(KAFKA_MAX_REQUEST_SIZE, Long.toString(bulkUpdateRequestSize));
        }
        properties.put("compression.type", options.getValueWithDefault(KafkaPlugin.KAFKA_COMPRESSION_TYPE));
        KafkaProducerRegistry.addCustomProducerConfig(properties, options);
        return properties;
    }

    private void checkOtherInstancesConfig(KafkaStore store, ReferencedProducer rp, Properties producerConfig) {
        String difference;
        KafkaStore otherStore = rp.stores.stream().filter(s -> s != store).findFirst().orElse(null);
        if (otherStore != null && (difference = this.getPropertiesDifference(rp.producerConfig, producerConfig)) != null) {
            throw new ConnectorUserException(String.format("Another Kafka connector instance (%s) to the same Kafka broker was created with different options%s", otherStore.getName(), difference));
        }
    }

    private String getPropertiesDifference(Properties before, Properties after) {
        Map differing;
        Map onlyOnRight;
        MapDifference difference = Maps.difference((Map)before, (Map)after);
        if (difference.areEqual()) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        Map onlyOnLeft = difference.entriesOnlyOnLeft();
        if (!onlyOnLeft.isEmpty()) {
            result.append(": only other=").append(onlyOnLeft);
        }
        if (!(onlyOnRight = difference.entriesOnlyOnRight()).isEmpty()) {
            result.append(": only this=").append(onlyOnRight);
        }
        if (!(differing = difference.entriesDiffering()).isEmpty()) {
            result.append(": different values in other and this=").append(differing);
        }
        return result.toString();
    }

    private static void addCustomProducerConfig(Properties properties, Options options) {
        ((Map)options.getValueOr(KafkaPlugin.KAFKA_PRODUCER_CONFIG, Collections.emptyMap())).forEach((key, value) -> properties.put(key, Objects.toString(value)));
    }

    private static Properties createPropertiesFromOptionsTestConnection(Options options) {
        Properties properties = KafkaProducerRegistry.createPropertiesFromOptionsCommon(options, null);
        KafkaProducerRegistry.addCustomProducerConfig(properties, options);
        return properties;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Properties createPropertiesFromOptionsCommon(Options options, Properties defaults) {
        String protocol;
        String nodes = (String)options.getValue(KafkaPlugin.KAFKA_NODE);
        assert (nodes != null);
        String[] nodesSplit = nodes.split("[,;\\s]+");
        CharSequence[] serverAddresses = new String[nodesSplit.length];
        System.arraycopy(nodesSplit, 0, serverAddresses, 0, nodesSplit.length);
        if (serverAddresses.length == 0) {
            throw new ConnectorUserException("At least one Kafka node must be provided.");
        }
        Properties properties = new Properties(defaults);
        properties.put(KAFKA_BOOTSTRAP_SERVERS, String.join((CharSequence)",", serverAddresses));
        boolean ssl = (Boolean)options.getValueWithDefault(KafkaPlugin.KAFKA_SSL);
        String username = null;
        String password = null;
        Object authenticationProvider = OptionsUtil.instantiateClassFromOption((Options)options, KafkaPlugin.AUTHENTICATION_CONFIGURATOR_CLASS);
        if (authenticationProvider != null) {
            String producerId = (String)options.getValue(KafkaPlugin.KAFKA_PRODUCER_ID);
            if (authenticationProvider instanceof PropertiesConfigurator) {
                Properties customProperties = ((PropertiesConfigurator)authenticationProvider).getProperties(nodes, producerId);
                if (customProperties != null) {
                    properties.putAll((Map<?, ?>)customProperties);
                }
            } else {
                if (!(authenticationProvider instanceof UsernamePasswordProvider)) throw new ConnectorUserException("Provided authentication class " + authenticationProvider.getClass().getName() + " does not implement any of the supported interfaces");
                UsernamePasswordProvider.Credentials credentials = ((UsernamePasswordProvider)authenticationProvider).getCredentials(nodes, producerId);
                if (credentials != null) {
                    username = credentials.getUsername();
                    password = credentials.getPassword();
                }
            }
        } else {
            username = (String)options.getValue(KafkaPlugin.KAFKA_PLAIN_AUTH_USERNAME);
            password = (String)options.getValue(KafkaPlugin.KAFKA_PLAIN_AUTH_PASSWORD);
        }
        if (StringUtils.isNotBlank((CharSequence)username) && StringUtils.isNotBlank((CharSequence)password)) {
            properties.put("sasl.mechanism", "PLAIN");
            properties.put("sasl.jaas.config", KafkaProducerRegistry.createPlaintextJaasFromCredentials(username, password));
            protocol = ssl ? SecurityProtocol.SASL_SSL.name() : SecurityProtocol.SASL_PLAINTEXT.name();
        } else {
            protocol = ssl ? SecurityProtocol.SSL.name() : SecurityProtocol.PLAINTEXT.name();
        }
        if (properties.containsKey("security.protocol")) return properties;
        properties.put("security.protocol", protocol);
        return properties;
    }

    static String createPlaintextJaasFromCredentials(String username, String password) {
        return String.format("org.apache.kafka.common.security.plain.PlainLoginModule required username=\"%s\" password=\"%s\";", username.replace("\"", "\\\""), password.replace("\"", "\\\""));
    }

    @VisibleForTesting
    class ReferencedProducer {
        private final boolean transactional;
        private Set<String> nodes;
        @VisibleForTesting
        Properties producerConfig;
        private KafkaProducer<String, Map<?, ?>> producer;
        private final Set<KafkaStore> stores = new HashSet<KafkaStore>();

        private ReferencedProducer(Set<String> nodes, Properties producerConfig, boolean transactional) {
            this.nodes = nodes;
            this.producerConfig = producerConfig;
            this.transactional = transactional;
        }

        private void registerStore(KafkaStore store) {
            this.stores.add(store);
        }

        private void unregisterStore(KafkaStore store) {
            this.stores.remove((Object)store);
        }

        private synchronized void close() {
            try {
                if (this.producer != null) {
                    this.producer.close();
                    this.producer = null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        synchronized void updateConfig(KafkaStore store, Options newOptions) {
            Properties producerConfig = KafkaProducerRegistry.this.createPropertiesFromOptions(newOptions);
            boolean transactional = (Boolean)newOptions.getValueWithDefault(KafkaPlugin.KAFKA_USE_TRANSACTION);
            boolean propagateConfig = (Boolean)newOptions.getValueWithDefault(KafkaPlugin.KAFKA_PROPAGATE_CONFIG);
            if (!propagateConfig) {
                KafkaProducerRegistry.this.checkOtherInstancesConfig(store, this, producerConfig);
            }
            boolean closedPrevious = false;
            if (this.producer != null) {
                this.producer.close();
                closedPrevious = true;
            }
            try {
                this.producer = KafkaProducerRegistry.createProducer(producerConfig, transactional);
                this.nodes.forEach(KafkaProducerRegistry.this.producers::remove);
                this.nodes = KafkaProducerRegistry.this.getBrokerNodes(newOptions, producerConfig);
                this.nodes.forEach(node -> KafkaProducerRegistry.this.producers.put((String)node, this));
                this.stores.forEach(s -> s.updateOptionsNoPropagate(newOptions));
                this.producerConfig = producerConfig;
            }
            catch (Exception e) {
                if (this.producer != null) {
                    this.producer.close();
                    this.producer = null;
                }
                if (closedPrevious) {
                    this.producer = KafkaProducerRegistry.createProducer(this.producerConfig, transactional);
                }
                throw e;
            }
        }

        private boolean unused() {
            return this.stores.size() == 0;
        }

        private KafkaProducer<String, Map<?, ?>> getProducer() {
            if (this.producer == null) {
                throw new IllegalStateException("Driver not initialized yet");
            }
            return this.producer;
        }

        @VisibleForTesting
        int getStoresCount() {
            return this.stores.size();
        }

        synchronized void init() {
            if (this.producer == null) {
                this.producer = KafkaProducerRegistry.createProducer(this.producerConfig, this.transactional);
            }
        }

        void sendRecord(String topic, String key, Map<?, ?> value) {
            if (newProducerRecordHook != null) {
                newProducerRecordHook.run();
            }
            this.getProducer().send(new ProducerRecord(topic, (Object)key, value));
        }

        void begin() {
            this.getProducer().beginTransaction();
        }

        void commit() {
            if (commitHook != null) {
                commitHook.run();
            }
            this.getProducer().commitTransaction();
        }

        void rollback() {
            this.getProducer().abortTransaction();
        }

        int getNumPartitions(String topic) {
            return this.getProducer().partitionsFor(topic).size();
        }
    }

    static class ProducerConfigValidator
    implements Validator<Map<String, Object>> {
        static ProducerConfigValidator INSTANCE = new ProducerConfigValidator();

        private ProducerConfigValidator() {
        }

        @Nullable
        public Object validate(@Nullable Map<String, Object> value, Options optionsSet) {
            if (value == null) {
                return null;
            }
            return value.entrySet().stream().map(e -> {
                Object v = e.getValue();
                String k = (String)e.getKey();
                if (v == null) {
                    return "Invalid value for key '" + k + "', must not be null";
                }
                if (v instanceof List || v instanceof Map) {
                    return "Invalid value for key '" + k + "', must not be an object or array";
                }
                if (BANNED_CONFIG_KEYS.contains(k)) {
                    return "Specifying '" + k + "' via kafkaProducerConfig is not allowed";
                }
                return null;
            }).filter(Objects::nonNull).findFirst().orElse(null);
        }
    }
}

