/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.externalsync.impl.kafka;

import com.ontotext.trree.big.collections.ModifiablePairCollection;
import com.ontotext.trree.plugin.externalsync.impl.LongLongIndexModifiablePairCollection;
import com.ontotext.trree.sdk.PluginException;
import com.ontotext.trree.transactions.TransactionException;
import com.ontotext.trree.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class IndexedEntitiesModifiablePairCollection {
    private final Path indexedEntitiesDir;
    private ModifiablePairCollection indexedEntities;
    private ModifiablePairCollection.ModifiablePairConnection indexedEntitiesConn;

    public IndexedEntitiesModifiablePairCollection(Path pluginPath, String indexName, int entityIdSize) {
        this.indexedEntitiesDir = pluginPath.resolve(indexName).resolve("indexed-entities");
        try {
            Files.createDirectories(this.indexedEntitiesDir, new FileAttribute[0]);
            this.indexedEntities = new ModifiablePairCollection(this.indexedEntitiesDir.resolve("col").toFile(), LongLongIndexModifiablePairCollection.CACHE_SIZE, entityIdSize);
            this.indexedEntities.initialize();
            this.indexedEntitiesConn = this.indexedEntities.getConnection();
            this.indexedEntitiesConn.beginTransaction();
        }
        catch (TransactionException | IOException e) {
            throw new PluginException("Could not initialize indexed entities collection", e);
        }
    }

    void add(long subject) {
        this.indexedEntitiesConn.add(subject, 0L);
    }

    void remove(long subject) {
        this.indexedEntitiesConn.remove(subject, 0L);
    }

    boolean isEntityIndexed(long subject) {
        return this.indexedEntitiesConn.has(subject, 0L);
    }

    void commit() {
        try {
            this.indexedEntitiesConn.commit();
            this.indexedEntitiesConn.beginTransaction();
        }
        catch (TransactionException e) {
            throw new RuntimeException(e);
        }
    }

    void rollback() {
        try {
            this.indexedEntitiesConn.rollback();
            this.indexedEntitiesConn.beginTransaction();
        }
        catch (TransactionException e) {
            throw new RuntimeException(e);
        }
    }

    void drop() {
        try {
            this.indexedEntitiesConn.rollback();
        }
        catch (TransactionException transactionException) {
            // empty catch block
        }
        this.indexedEntitiesConn.close();
        this.indexedEntities.shutdown();
        FileUtils.recursiveDelete((File)this.indexedEntitiesDir.toFile());
    }

    void close() {
        if (this.indexedEntitiesConn != null) {
            this.indexedEntitiesConn.close();
            this.indexedEntitiesConn = null;
        }
        if (this.indexedEntities != null) {
            this.indexedEntities.shutdown();
            this.indexedEntities = null;
        }
    }

    void removeAll() {
        this.indexedEntitiesConn.clear();
    }
}

