/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.query.translation.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.exception.OntopInternalBugException;
import it.unibz.inf.ontop.exception.OntopInvalidKGQueryException;
import it.unibz.inf.ontop.exception.OntopUnsupportedKGQueryException;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.NaryIQTree;
import it.unibz.inf.ontop.iq.UnaryIQTree;
import it.unibz.inf.ontop.iq.impl.IQTreeTools;
import it.unibz.inf.ontop.iq.impl.QueryNodeRenamer;
import it.unibz.inf.ontop.iq.node.AggregationNode;
import it.unibz.inf.ontop.iq.node.BinaryNonCommutativeOperatorNode;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.FilterNode;
import it.unibz.inf.ontop.iq.node.IntensionalDataNode;
import it.unibz.inf.ontop.iq.node.NaryOperatorNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.iq.transform.impl.HomogeneousIQTreeVisitingTransformer;
import it.unibz.inf.ontop.iq.transform.node.HomogeneousQueryNodeTransformer;
import it.unibz.inf.ontop.model.atom.AtomFactory;
import it.unibz.inf.ontop.model.term.GroundTerm;
import it.unibz.inf.ontop.model.term.IRIConstant;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.NonGroundTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import it.unibz.inf.ontop.model.term.functionsymbol.FunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.FunctionSymbolFactory;
import it.unibz.inf.ontop.model.type.RDFDatatype;
import it.unibz.inf.ontop.model.type.TermTypeInference;
import it.unibz.inf.ontop.model.type.TypeFactory;
import it.unibz.inf.ontop.model.vocabulary.XSD;
import it.unibz.inf.ontop.query.translation.impl.RDF4JValueExprTranslator;
import it.unibz.inf.ontop.query.translation.impl.RDF4JValueTranslator;
import it.unibz.inf.ontop.substitution.InjectiveSubstitution;
import it.unibz.inf.ontop.substitution.Substitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.CoreUtilsFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.apache.commons.rdf.api.RDF;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.query.Binding;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.algebra.BinaryTupleOperator;
import org.eclipse.rdf4j.query.algebra.BindingSetAssignment;
import org.eclipse.rdf4j.query.algebra.Difference;
import org.eclipse.rdf4j.query.algebra.Distinct;
import org.eclipse.rdf4j.query.algebra.Extension;
import org.eclipse.rdf4j.query.algebra.ExtensionElem;
import org.eclipse.rdf4j.query.algebra.Filter;
import org.eclipse.rdf4j.query.algebra.Group;
import org.eclipse.rdf4j.query.algebra.GroupElem;
import org.eclipse.rdf4j.query.algebra.Join;
import org.eclipse.rdf4j.query.algebra.LeftJoin;
import org.eclipse.rdf4j.query.algebra.Order;
import org.eclipse.rdf4j.query.algebra.Projection;
import org.eclipse.rdf4j.query.algebra.QueryRoot;
import org.eclipse.rdf4j.query.algebra.Reduced;
import org.eclipse.rdf4j.query.algebra.SingletonSet;
import org.eclipse.rdf4j.query.algebra.Slice;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.Union;
import org.eclipse.rdf4j.query.algebra.ValueExpr;
import org.eclipse.rdf4j.query.algebra.Var;

public class RDF4JTupleExprTranslator {
    private final ImmutableMap<Variable, GroundTerm> externalBindings;
    private final @Nullable Dataset dataset;
    private final boolean treatBNodeAsVariable;
    private final CoreUtilsFactory coreUtilsFactory;
    private final SubstitutionFactory substitutionFactory;
    private final IntermediateQueryFactory iqFactory;
    private final AtomFactory atomFactory;
    private final TermFactory termFactory;
    private final FunctionSymbolFactory functionSymbolFactory;
    private final RDF rdfFactory;
    private final TypeFactory typeFactory;
    private final IQTreeTools iqTreeTools;

    public RDF4JTupleExprTranslator(ImmutableMap<Variable, GroundTerm> externalBindings, @Nullable Dataset dataset, boolean treatBNodeAsVariable, CoreUtilsFactory coreUtilsFactory, SubstitutionFactory substitutionFactory, IntermediateQueryFactory iqFactory, AtomFactory atomFactory, TermFactory termFactory, FunctionSymbolFactory functionSymbolFactory, RDF rdfFactory, TypeFactory typeFactory, IQTreeTools iqTreeTools) {
        this.externalBindings = externalBindings;
        this.dataset = dataset;
        this.treatBNodeAsVariable = treatBNodeAsVariable;
        this.coreUtilsFactory = coreUtilsFactory;
        this.substitutionFactory = substitutionFactory;
        this.iqFactory = iqFactory;
        this.atomFactory = atomFactory;
        this.termFactory = termFactory;
        this.functionSymbolFactory = functionSymbolFactory;
        this.rdfFactory = rdfFactory;
        this.typeFactory = typeFactory;
        this.iqTreeTools = iqTreeTools;
    }

    public IQTree getTree(TupleExpr node) throws OntopUnsupportedKGQueryException, OntopInvalidKGQueryException {
        return this.translate((TupleExpr)node).iqTree;
    }

    private TranslationResult translate(TupleExpr node) throws OntopInvalidKGQueryException, OntopUnsupportedKGQueryException {
        if (node instanceof QueryRoot) {
            return this.translate(((QueryRoot)node).getArg());
        }
        if (node instanceof StatementPattern) {
            return this.translate((StatementPattern)node);
        }
        if (node instanceof Join) {
            return this.translateJoinLikeNode((BinaryTupleOperator)((Join)node));
        }
        if (node instanceof LeftJoin) {
            return this.translateJoinLikeNode((BinaryTupleOperator)((LeftJoin)node));
        }
        if (node instanceof Difference) {
            return this.translate((Difference)node);
        }
        if (node instanceof Union) {
            return this.translate((Union)node);
        }
        if (node instanceof Filter) {
            return this.translate((Filter)node);
        }
        if (node instanceof Projection) {
            return this.translate((Projection)node);
        }
        if (node instanceof Slice) {
            return this.translate((Slice)node);
        }
        if (node instanceof Distinct) {
            return this.translate((Distinct)node);
        }
        if (node instanceof Reduced) {
            return this.translate((Reduced)node);
        }
        if (node instanceof SingletonSet) {
            return this.createTranslationResult((IQTree)this.iqFactory.createTrueNode(), (ImmutableSet<Variable>)ImmutableSet.of());
        }
        if (node instanceof Group) {
            return this.translate((Group)node);
        }
        if (node instanceof Extension) {
            return this.translate((Extension)node);
        }
        if (node instanceof BindingSetAssignment) {
            return this.translate((BindingSetAssignment)node);
        }
        if (node instanceof Order) {
            return this.translate((Order)node);
        }
        throw new OntopUnsupportedKGQueryException("Unsupported SPARQL operator: " + node.toString());
    }

    private static Sets.SetView<Variable> getSharedVariables(TranslationResult left, TranslationResult right) {
        return Sets.intersection((Set)left.iqTree.getVariables(), (Set)right.iqTree.getVariables());
    }

    private VariableGenerator getVariableGenerator(TranslationResult left, TranslationResult right) {
        return this.coreUtilsFactory.createVariableGenerator((Collection)Sets.union((Set)left.iqTree.getKnownVariables(), (Set)right.iqTree.getKnownVariables()));
    }

    private TranslationResult translate(Difference diff) throws OntopInvalidKGQueryException, OntopUnsupportedKGQueryException {
        TranslationResult leftTranslation = this.translate(diff.getLeftArg());
        TranslationResult rightTranslation = this.translate(diff.getRightArg());
        Sets.SetView<Variable> sharedVariables = RDF4JTupleExprTranslator.getSharedVariables(rightTranslation, leftTranslation);
        if (sharedVariables.isEmpty()) {
            return leftTranslation;
        }
        VariableGenerator vGen = this.getVariableGenerator(leftTranslation, rightTranslation);
        InjectiveSubstitution sharedVarsRenaming = (InjectiveSubstitution)sharedVariables.stream().collect(this.substitutionFactory.toFreshRenamingSubstitution(vGen));
        ImmutableExpression ljCond = this.termFactory.getConjunction((ImmutableList)Stream.concat(sharedVarsRenaming.builder().toStream((v, t) -> this.termFactory.getDisjunction(this.getEqOrNullable((Variable)v, (Variable)t, leftTranslation.nullableVariables, rightTranslation.nullableVariables))), Stream.of(this.termFactory.getDisjunction((ImmutableList)sharedVarsRenaming.builder().toStream((x$0, x$1) -> this.termFactory.getStrictEquality(x$0, x$1, new ImmutableTerm[0])).collect(ImmutableCollectors.toList())))).collect(ImmutableCollectors.toList()));
        ImmutableExpression filter = this.termFactory.getConjunction((ImmutableList)sharedVarsRenaming.getRangeSet().stream().map(arg_0 -> ((TermFactory)this.termFactory).getDBIsNull(arg_0)).collect(ImmutableCollectors.toList()));
        InjectiveSubstitution<Variable> leftNonProjVarsRenaming = this.getNonProjVarsRenaming(leftTranslation, rightTranslation, vGen);
        InjectiveSubstitution<Variable> rightNonProjVarsRenaming = this.getNonProjVarsRenaming(rightTranslation, leftTranslation, vGen);
        return this.createTranslationResult((IQTree)this.iqFactory.createUnaryIQTree((UnaryOperatorNode)this.iqFactory.createConstructionNode(leftTranslation.iqTree.getVariables()), (IQTree)this.iqFactory.createUnaryIQTree((UnaryOperatorNode)this.iqFactory.createFilterNode(filter), (IQTree)this.iqFactory.createBinaryNonCommutativeIQTree((BinaryNonCommutativeOperatorNode)this.iqFactory.createLeftJoinNode(ljCond), this.applyInDepthRenaming(leftTranslation.iqTree, leftNonProjVarsRenaming), this.applyInDepthRenaming(rightTranslation.iqTree.applyDescendingSubstitutionWithoutOptimizing((Substitution)sharedVarsRenaming, vGen), rightNonProjVarsRenaming)))), leftTranslation.nullableVariables);
    }

    private IQTree applyInDepthRenaming(IQTree tree, InjectiveSubstitution<Variable> renaming) {
        if (renaming.isEmpty()) {
            return tree;
        }
        QueryNodeRenamer nodeTransformer = new QueryNodeRenamer(this.iqFactory, renaming, this.atomFactory, this.substitutionFactory);
        HomogeneousIQTreeVisitingTransformer iqTransformer = new HomogeneousIQTreeVisitingTransformer((HomogeneousQueryNodeTransformer)nodeTransformer, this.iqFactory);
        return iqTransformer.transform(tree);
    }

    private ImmutableList<ImmutableExpression> getEqOrNullable(Variable sharedVar, Variable renamedVar, ImmutableSet<Variable> leftNullableVars, ImmutableSet<Variable> rightNullableVars) {
        ImmutableExpression equality = this.termFactory.getStrictEquality((ImmutableTerm)sharedVar, (ImmutableTerm)renamedVar, new ImmutableTerm[0]);
        if (leftNullableVars.contains((Object)sharedVar)) {
            return rightNullableVars.contains((Object)sharedVar) ? ImmutableList.of((Object)equality, (Object)this.termFactory.getDBIsNull((ImmutableTerm)sharedVar), (Object)this.termFactory.getDBIsNull((ImmutableTerm)renamedVar)) : ImmutableList.of((Object)equality, (Object)this.termFactory.getDBIsNull((ImmutableTerm)sharedVar));
        }
        return rightNullableVars.contains((Object)sharedVar) ? ImmutableList.of((Object)equality, (Object)this.termFactory.getDBIsNull((ImmutableTerm)renamedVar)) : ImmutableList.of((Object)equality);
    }

    private TranslationResult translate(Group group) throws OntopInvalidKGQueryException, OntopUnsupportedKGQueryException {
        TranslationResult child = this.translate(group.getArg());
        ImmutableList<Substitution<ImmutableTerm>> mergedVarDefs = this.getGroupVarDefs(group.getGroupElements(), (ImmutableSet<Variable>)child.iqTree.getVariables());
        if (mergedVarDefs.size() > 1) {
            throw new Sparql2IqConversionException("Unexpected parsed SPARQL query: nested complex projections appear within an RDF4J Group node: " + group);
        }
        AggregationNode an = this.iqFactory.createAggregationNode((ImmutableSet)group.getGroupBindingNames().stream().map(arg_0 -> ((TermFactory)this.termFactory).getVariable(arg_0)).collect(ImmutableCollectors.toSet()), ((Substitution)mergedVarDefs.get(0)).transform(t -> (ImmutableFunctionalTerm)t));
        UnaryIQTree aggregationTree = this.iqFactory.createUnaryIQTree((UnaryOperatorNode)an, child.iqTree);
        ImmutableSet nullableVariables = Sets.union((Set)Sets.intersection((Set)an.getGroupingVariables(), child.nullableVariables), (Set)an.getSubstitution().getPreImage(t -> t.getFunctionSymbol().isNullable(ImmutableSet.of((Object)0)))).immutableCopy();
        IQTree iqTree = this.applyExternalBindingFilter((IQTree)aggregationTree, (ImmutableSet<Variable>)an.getSubstitution().getDomain());
        return this.createTranslationResult(iqTree, (ImmutableSet<Variable>)nullableVariables);
    }

    private ImmutableList<Substitution<ImmutableTerm>> getGroupVarDefs(List<GroupElem> list, ImmutableSet<Variable> childVariables) {
        ArrayList<VarDef> result = new ArrayList<VarDef>();
        HashSet<Variable> allowedVars = new HashSet<Variable>((Collection<Variable>)childVariables);
        for (GroupElem elem : list) {
            RDF4JValueExprTranslator translator = this.getValueTranslator(allowedVars);
            ImmutableTerm term = translator.getTerm((ValueExpr)elem.getOperator());
            Variable definedVar = this.termFactory.getVariable(elem.getName());
            allowedVars.add(definedVar);
            result.add(new VarDef(definedVar, term));
        }
        return this.mergeVarDefs((ImmutableList<VarDef>)ImmutableList.copyOf(result));
    }

    private TranslationResult translate(Order order) throws OntopInvalidKGQueryException, OntopUnsupportedKGQueryException {
        TranslationResult child = this.translate(order.getArg());
        RDF4JValueExprTranslator translator = this.getValueTranslator((Set<Variable>)child.iqTree.getVariables());
        ImmutableList comparators = (ImmutableList)order.getElements().stream().map(o -> Optional.of(translator.getTerm(o.getExpr())).filter(t -> t instanceof NonGroundTerm).map(t -> (NonGroundTerm)t).map(t -> this.iqFactory.createOrderComparator(t, o.isAscending()))).flatMap(Optional::stream).collect(ImmutableCollectors.toList());
        return comparators.isEmpty() ? child : this.createTranslationResult((IQTree)this.iqFactory.createUnaryIQTree((UnaryOperatorNode)this.iqFactory.createOrderByNode(comparators), child.iqTree), child.nullableVariables);
    }

    private TranslationResult translate(BindingSetAssignment node) {
        ImmutableSet allVars = (ImmutableSet)node.getBindingNames().stream().map(arg_0 -> ((TermFactory)this.termFactory).getVariable(arg_0)).collect(ImmutableCollectors.toSet());
        RDF4JValueTranslator translator = this.getValueTranslator();
        ImmutableList substitutions = (ImmutableList)StreamSupport.stream(node.getBindingSets().spliterator(), false).map(bs -> (Substitution)bs.getBindingNames().stream().collect(this.substitutionFactory.toSubstitution(arg_0 -> ((TermFactory)this.termFactory).getVariable(arg_0), x -> Optional.ofNullable(bs.getBinding(x)).map(Binding::getValue).map(translator::getTermForLiteralOrIri).orElseGet(() -> ((TermFactory)this.termFactory).getNullConstant())))).collect(ImmutableCollectors.toList());
        ImmutableSet nullableVars = (ImmutableSet)((Substitution)substitutions.get(0)).getDomain().stream().filter(v -> substitutions.stream().anyMatch(s -> s.get(v).isNull())).collect(ImmutableCollectors.toSet());
        ImmutableList subtrees = (ImmutableList)substitutions.stream().map(sub -> this.iqFactory.createConstructionNode(sub.getDomain(), sub)).map(cn -> this.iqFactory.createUnaryIQTree((UnaryOperatorNode)cn, (IQTree)this.iqFactory.createTrueNode())).collect(ImmutableCollectors.toList());
        IQTree tree = subtrees.size() == 1 ? (IQTree)subtrees.get(0) : this.iqFactory.createNaryIQTree((NaryOperatorNode)this.iqFactory.createUnionNode(allVars), subtrees);
        IQTree iqTree = this.applyExternalBindingFilter(tree, (ImmutableSet<Variable>)allVars);
        return this.createTranslationResult(iqTree, (ImmutableSet<Variable>)nullableVars);
    }

    private TranslationResult translate(Reduced reduced) throws OntopInvalidKGQueryException, OntopUnsupportedKGQueryException {
        TranslationResult child = this.translate(reduced.getArg());
        return this.createTranslationResult((IQTree)this.iqFactory.createUnaryIQTree((UnaryOperatorNode)this.iqFactory.createDistinctNode(), child.iqTree), child.nullableVariables);
    }

    private TranslationResult translate(Distinct distinct) throws OntopInvalidKGQueryException, OntopUnsupportedKGQueryException {
        TranslationResult child = this.translate(distinct.getArg());
        return this.createTranslationResult((IQTree)this.iqFactory.createUnaryIQTree((UnaryOperatorNode)this.iqFactory.createDistinctNode(), child.iqTree), child.nullableVariables);
    }

    private TranslationResult translate(Slice slice) throws OntopInvalidKGQueryException, OntopUnsupportedKGQueryException {
        TranslationResult child = this.translate(slice.getArg());
        long offset = slice.getOffset() == -1L ? 0L : slice.getOffset();
        return this.createTranslationResult((IQTree)this.iqFactory.createUnaryIQTree((UnaryOperatorNode)(slice.getLimit() == -1L ? this.iqFactory.createSliceNode(offset) : this.iqFactory.createSliceNode(offset, slice.getLimit())), child.iqTree), child.nullableVariables);
    }

    private TranslationResult translate(Filter filter) throws OntopInvalidKGQueryException, OntopUnsupportedKGQueryException {
        TranslationResult child = this.translate(filter.getArg());
        return this.createTranslationResult((IQTree)this.iqFactory.createUnaryIQTree((UnaryOperatorNode)this.iqFactory.createFilterNode(this.getFilterExpression(filter.getCondition(), (Set<Variable>)child.iqTree.getVariables())), child.iqTree), child.nullableVariables);
    }

    private TranslationResult translateJoinLikeNode(BinaryTupleOperator join) throws OntopInvalidKGQueryException, OntopUnsupportedKGQueryException {
        Sets.SetView nullableVariables;
        NaryIQTree joinTree;
        TranslationResult leftTranslation = this.translate(join.getLeftArg());
        TranslationResult rightTranslation = this.translate(join.getRightArg());
        Sets.SetView nullableVariablesLeftOrRight = Sets.union(leftTranslation.nullableVariables, rightTranslation.nullableVariables);
        Sets.SetView<Variable> sharedVariables = RDF4JTupleExprTranslator.getSharedVariables(leftTranslation, rightTranslation);
        Sets.SetView toCoalesce = Sets.intersection(sharedVariables, (Set)nullableVariablesLeftOrRight);
        VariableGenerator variableGenerator = this.getVariableGenerator(leftTranslation, rightTranslation);
        InjectiveSubstitution leftRenamingSubstitution = (InjectiveSubstitution)toCoalesce.stream().collect(this.substitutionFactory.toFreshRenamingSubstitution(variableGenerator));
        InjectiveSubstitution rightRenamingSubstitution = (InjectiveSubstitution)toCoalesce.stream().collect(this.substitutionFactory.toFreshRenamingSubstitution(variableGenerator));
        Substitution topSubstitution = (Substitution)toCoalesce.stream().collect(this.substitutionFactory.toSubstitution(v -> this.termFactory.getImmutableFunctionalTerm((FunctionSymbol)this.functionSymbolFactory.getRequiredSPARQLFunctionSymbol("COALESCE", 2), new ImmutableTerm[]{leftRenamingSubstitution.get(v), rightRenamingSubstitution.get(v)})));
        ImmutableSet projectedVariables = Sets.union((Set)Sets.difference((Set)Sets.union((Set)leftTranslation.iqTree.getVariables(), (Set)rightTranslation.iqTree.getVariables()), (Set)toCoalesce), (Set)topSubstitution.getDomain()).immutableCopy();
        InjectiveSubstitution<Variable> leftNonProjVarsRenaming = this.getNonProjVarsRenaming(leftTranslation, rightTranslation, variableGenerator);
        InjectiveSubstitution<Variable> rightNonProjVarsRenaming = this.getNonProjVarsRenaming(rightTranslation, leftTranslation, variableGenerator);
        IQTree leftTree = this.applyInDepthRenaming(leftTranslation.iqTree.applyDescendingSubstitutionWithoutOptimizing((Substitution)leftRenamingSubstitution, variableGenerator), leftNonProjVarsRenaming);
        IQTree rightTree = this.applyInDepthRenaming(rightTranslation.iqTree.applyDescendingSubstitutionWithoutOptimizing((Substitution)rightRenamingSubstitution, variableGenerator), rightNonProjVarsRenaming);
        Stream<ImmutableExpression> coalescingStream = toCoalesce.stream().map(v -> this.generateCompatibleExpression((Variable)v, (InjectiveSubstitution<Variable>)leftRenamingSubstitution, (InjectiveSubstitution<Variable>)rightRenamingSubstitution));
        if (join instanceof LeftJoin) {
            Sets.SetView variables = Sets.union((Set)leftTranslation.iqTree.getVariables(), (Set)rightTranslation.iqTree.getVariables());
            Optional<ImmutableExpression> filterExpression = Optional.ofNullable(((LeftJoin)join).getCondition()).map(c -> topSubstitution.apply(this.getFilterExpression((ValueExpr)c, (Set<Variable>)variables)));
            Optional joinCondition = this.termFactory.getConjunction(filterExpression, coalescingStream);
            joinTree = this.iqFactory.createBinaryNonCommutativeIQTree((BinaryNonCommutativeOperatorNode)this.iqFactory.createLeftJoinNode(joinCondition), leftTree, rightTree);
            nullableVariables = Sets.union((Set)nullableVariablesLeftOrRight, (Set)Sets.difference((Set)rightTranslation.iqTree.getVariables(), sharedVariables));
        } else if (join instanceof Join) {
            Optional joinCondition = this.termFactory.getConjunction(Optional.empty(), coalescingStream);
            joinTree = this.iqFactory.createNaryIQTree((NaryOperatorNode)this.iqFactory.createInnerJoinNode(joinCondition), ImmutableList.of((Object)leftTree, (Object)rightTree));
            nullableVariables = Sets.difference((Set)nullableVariablesLeftOrRight, sharedVariables);
        } else {
            throw new Sparql2IqConversionException("A left or inner join is expected");
        }
        IQTree joinQuery = this.iqTreeTools.createConstructionNodeTreeIfNontrivial((IQTree)joinTree, topSubstitution, () -> projectedVariables);
        return this.createTranslationResult(joinQuery, (ImmutableSet<Variable>)nullableVariables.immutableCopy());
    }

    private ImmutableExpression generateCompatibleExpression(Variable outputVariable, InjectiveSubstitution<Variable> leftChildSubstitution, InjectiveSubstitution<Variable> rightChildSubstitution) {
        Variable leftVariable = this.substitutionFactory.apply(leftChildSubstitution, outputVariable);
        Variable rightVariable = this.substitutionFactory.apply(rightChildSubstitution, outputVariable);
        ImmutableExpression equalityCondition = this.termFactory.getStrictEquality((ImmutableTerm)leftVariable, (ImmutableTerm)rightVariable, new ImmutableTerm[0]);
        ImmutableExpression isNullExpression = this.termFactory.getDisjunction(this.termFactory.getDBIsNull((ImmutableTerm)leftVariable), new ImmutableExpression[]{this.termFactory.getDBIsNull((ImmutableTerm)rightVariable)});
        return this.termFactory.getDisjunction(equalityCondition, new ImmutableExpression[]{isNullExpression});
    }

    private TranslationResult translate(Projection projection) throws OntopInvalidKGQueryException, OntopUnsupportedKGQueryException {
        TranslationResult child = this.translate(projection.getArg());
        ImmutableMap map = (ImmutableMap)projection.getProjectionElemList().getElements().stream().collect(ImmutableCollectors.toMap(pe -> this.termFactory.getVariable(pe.getName()), pe -> this.termFactory.getVariable(pe.getProjectionAlias().orElse(pe.getName()))));
        Substitution substitution = (Substitution)map.entrySet().stream().collect(this.substitutionFactory.toSubstitutionSkippingIdentityEntries());
        ImmutableSet projectedVars = ImmutableSet.copyOf((Collection)map.values());
        if (substitution.isEmpty() && projectedVars.equals((Object)child.iqTree.getVariables())) {
            return child;
        }
        VariableGenerator variableGenerator = this.coreUtilsFactory.createVariableGenerator((Collection)Sets.union((Set)child.iqTree.getKnownVariables(), (Set)projectedVars));
        IQTree subQuery = child.iqTree.applyDescendingSubstitutionWithoutOptimizing(substitution, variableGenerator);
        Substitution newSubstitution = (Substitution)Sets.difference((Set)projectedVars, (Set)subQuery.getVariables()).stream().collect(this.substitutionFactory.toSubstitution(v -> this.termFactory.getNullConstant()));
        ConstructionNode projectNode = this.iqFactory.createConstructionNode(projectedVars, newSubstitution);
        UnaryIQTree constructTree = this.iqFactory.createUnaryIQTree((UnaryOperatorNode)projectNode, subQuery);
        ImmutableSet nullableVariables = this.substitutionFactory.apply(substitution, child.nullableVariables);
        IQTree iqTree = this.applyExternalBindingFilter((IQTree)constructTree, (ImmutableSet<Variable>)projectNode.getSubstitution().getDomain());
        return this.createTranslationResult(iqTree, (ImmutableSet<Variable>)nullableVariables);
    }

    private TranslationResult translate(Union union) throws OntopInvalidKGQueryException, OntopUnsupportedKGQueryException {
        TranslationResult leftTranslation = this.translate(union.getLeftArg());
        TranslationResult rightTranslation = this.translate(union.getRightArg());
        VariableGenerator variableGenerator = this.getVariableGenerator(leftTranslation, rightTranslation);
        ImmutableSet leftVariables = leftTranslation.iqTree.getVariables();
        ImmutableSet rightVariables = rightTranslation.iqTree.getVariables();
        Sets.SetView nullOnLeft = Sets.difference((Set)rightVariables, (Set)leftVariables);
        Sets.SetView nullOnRight = Sets.difference((Set)leftVariables, (Set)rightVariables);
        ImmutableSet nullableVariables = Sets.union((Set)Sets.union(leftTranslation.nullableVariables, rightTranslation.nullableVariables), (Set)Sets.union((Set)nullOnLeft, (Set)nullOnRight)).immutableCopy();
        ImmutableSet rootVariables = Sets.union((Set)leftVariables, (Set)rightVariables).immutableCopy();
        ConstructionNode leftCn = this.iqFactory.createConstructionNode(rootVariables, (Substitution)nullOnLeft.stream().collect(this.substitutionFactory.toSubstitution(v -> this.termFactory.getNullConstant())));
        ConstructionNode rightCn = this.iqFactory.createConstructionNode(rootVariables, (Substitution)nullOnRight.stream().collect(this.substitutionFactory.toSubstitution(v -> this.termFactory.getNullConstant())));
        InjectiveSubstitution<Variable> leftNonProjVarsRenaming = this.getNonProjVarsRenaming(leftTranslation, rightTranslation, variableGenerator);
        InjectiveSubstitution<Variable> rightNonProjVarsRenaming = this.getNonProjVarsRenaming(rightTranslation, leftTranslation, variableGenerator);
        return this.createTranslationResult((IQTree)this.iqFactory.createUnaryIQTree((UnaryOperatorNode)this.iqFactory.createConstructionNode(rootVariables), (IQTree)this.iqFactory.createNaryIQTree((NaryOperatorNode)this.iqFactory.createUnionNode(rootVariables), ImmutableList.of((Object)this.iqFactory.createUnaryIQTree((UnaryOperatorNode)leftCn, this.applyInDepthRenaming(leftTranslation.iqTree, leftNonProjVarsRenaming)), (Object)this.iqFactory.createUnaryIQTree((UnaryOperatorNode)rightCn, this.applyInDepthRenaming(rightTranslation.iqTree, rightNonProjVarsRenaming))))), (ImmutableSet<Variable>)nullableVariables);
    }

    private TranslationResult translate(StatementPattern pattern) {
        IQTree subTree;
        RDF4JValueExprTranslator translator = this.getValueTranslator((Set<Variable>)ImmutableSet.of());
        VariableOrGroundTerm subject = translator.translateRDF4JVar(pattern.getSubjectVar(), true);
        VariableOrGroundTerm predicate = translator.translateRDF4JVar(pattern.getPredicateVar(), true);
        VariableOrGroundTerm object = translator.translateRDF4JVar(pattern.getObjectVar(), true);
        if (pattern.getScope().equals((Object)StatementPattern.Scope.NAMED_CONTEXTS)) {
            VariableOrGroundTerm graph = translator.translateRDF4JVar(pattern.getContextVar(), true);
            subTree = this.translateQuadPattern(subject, predicate, object, graph);
        } else {
            subTree = this.translateTriplePattern(subject, predicate, object);
        }
        IQTree iqTree = this.applyExternalBindingFilter(subTree, (ImmutableSet<Variable>)subTree.getVariables());
        return this.createTranslationResult(iqTree, (ImmutableSet<Variable>)ImmutableSet.of());
    }

    private IQTree translateTriplePattern(VariableOrGroundTerm subject, VariableOrGroundTerm predicate, VariableOrGroundTerm object) {
        if (this.dataset == null || this.dataset.getDefaultGraphs().isEmpty() && this.dataset.getNamedGraphs().isEmpty()) {
            return this.iqFactory.createIntensionalDataNode(this.atomFactory.getIntensionalTripleAtom(subject, predicate, object));
        }
        Set defaultGraphs = this.dataset.getDefaultGraphs();
        int defaultGraphCount = defaultGraphs.size();
        if (defaultGraphCount == 0) {
            return this.iqFactory.createEmptyNode((ImmutableSet)Stream.of(subject, predicate, object).filter(t -> t instanceof Variable).map(t -> (Variable)t).collect(ImmutableCollectors.toSet()));
        }
        if (defaultGraphCount == 1) {
            IRIConstant graph = this.termFactory.getConstantIRI(((IRI)defaultGraphs.iterator().next()).stringValue());
            return this.iqFactory.createIntensionalDataNode(this.atomFactory.getIntensionalQuadAtom(subject, predicate, object, (VariableOrGroundTerm)graph));
        }
        Variable graph = this.termFactory.getVariable("g" + UUID.randomUUID());
        IntensionalDataNode quadNode = this.iqFactory.createIntensionalDataNode(this.atomFactory.getIntensionalQuadAtom(subject, predicate, object, (VariableOrGroundTerm)graph));
        FilterNode filterNode = this.getGraphFilter((VariableOrGroundTerm)graph, defaultGraphs);
        ImmutableSet projectedVariables = Sets.difference((Set)quadNode.getVariables(), (Set)ImmutableSet.of((Object)graph)).immutableCopy();
        return this.iqFactory.createUnaryIQTree((UnaryOperatorNode)this.iqFactory.createDistinctNode(), (IQTree)this.iqFactory.createUnaryIQTree((UnaryOperatorNode)this.iqFactory.createConstructionNode(projectedVariables), (IQTree)this.iqFactory.createUnaryIQTree((UnaryOperatorNode)filterNode, (IQTree)quadNode)));
    }

    private IQTree translateQuadPattern(VariableOrGroundTerm subject, VariableOrGroundTerm predicate, VariableOrGroundTerm object, VariableOrGroundTerm graph) {
        IntensionalDataNode dataNode = this.iqFactory.createIntensionalDataNode(this.atomFactory.getIntensionalQuadAtom(subject, predicate, object, graph));
        return this.dataset == null || this.dataset.getNamedGraphs().isEmpty() ? dataNode : this.iqFactory.createUnaryIQTree((UnaryOperatorNode)this.getGraphFilter(graph, this.dataset.getNamedGraphs()), (IQTree)dataNode);
    }

    private FilterNode getGraphFilter(VariableOrGroundTerm graph, Set<IRI> graphIris) {
        ImmutableExpression graphFilter = (ImmutableExpression)this.termFactory.getDisjunction(graphIris.stream().map(g -> this.termFactory.getConstantIRI(g.stringValue())).map(iriConstant -> this.termFactory.getStrictEquality((ImmutableTerm)graph, (ImmutableTerm)iriConstant, new ImmutableTerm[0]))).orElseThrow(() -> new MinorOntopInternalBugException("The empty case already handled"));
        return this.iqFactory.createFilterNode(graphFilter);
    }

    private TranslationResult translate(Extension node) throws OntopInvalidKGQueryException, OntopUnsupportedKGQueryException {
        TranslationResult childTranslation = this.translate(node.getArg());
        ImmutableSet childVars = childTranslation.iqTree.getVariables();
        ImmutableList<Substitution<ImmutableTerm>> mergedVarDefs = this.getVarDefs(node.getElements(), (ImmutableSet<Variable>)childVars);
        if (mergedVarDefs.isEmpty()) {
            return childTranslation;
        }
        TranslationResult result = this.createTranslationResult(childTranslation.iqTree, childTranslation.nullableVariables);
        for (Substitution substitution : mergedVarDefs) {
            ImmutableSet<Variable> nullableVariables = result.nullableVariables;
            ImmutableSet newNullableVariables = substitution.getPreImage(t -> t.getVariableStream().anyMatch(arg_0 -> ((ImmutableSet)nullableVariables).contains(arg_0)));
            ConstructionNode constructionNode = this.iqFactory.createConstructionNode(Sets.union((Set)result.iqTree.getVariables(), (Set)substitution.getDomain()).immutableCopy(), substitution);
            UnaryIQTree tree = this.iqFactory.createUnaryIQTree((UnaryOperatorNode)constructionNode, result.iqTree);
            IQTree iqTree = this.applyExternalBindingFilter((IQTree)tree, (ImmutableSet<Variable>)constructionNode.getSubstitution().getDomain());
            result = this.createTranslationResult(iqTree, (ImmutableSet<Variable>)Sets.union(nullableVariables, (Set)newNullableVariables).immutableCopy());
        }
        return result;
    }

    private ImmutableList<Substitution<ImmutableTerm>> getVarDefs(List<ExtensionElem> list, ImmutableSet<Variable> childVars) {
        ArrayList<VarDef> result = new ArrayList<VarDef>();
        HashSet<Variable> allowedVars = new HashSet<Variable>((Collection<Variable>)childVars);
        for (ExtensionElem elem : list) {
            if (elem.getExpr() instanceof Var && elem.getName().equals(((Var)elem.getExpr()).getName())) continue;
            ImmutableTerm term = this.getValueTranslator(allowedVars).getTerm(elem.getExpr());
            Variable definedVar = this.termFactory.getVariable(elem.getName());
            allowedVars.add(definedVar);
            result.add(new VarDef(definedVar, term));
        }
        ImmutableList varDefs = (ImmutableList)result.stream().filter(vd -> !childVars.contains((Object)vd.var)).collect(ImmutableCollectors.toList());
        return this.mergeVarDefs((ImmutableList<VarDef>)varDefs);
    }

    private ImmutableList<Substitution<ImmutableTerm>> mergeVarDefs(ImmutableList<VarDef> varDefs) {
        LinkedList substitutionMapList = new LinkedList();
        substitutionMapList.add(new HashMap());
        for (VarDef varDef : varDefs) {
            Map last = (Map)substitutionMapList.getLast();
            if (varDef.term.getVariableStream().anyMatch(last::containsKey)) {
                substitutionMapList.addLast(new HashMap());
            }
            ((Map)substitutionMapList.getLast()).put(varDef.var, varDef.term);
        }
        return (ImmutableList)substitutionMapList.stream().map(m -> (Substitution)m.entrySet().stream().collect(this.substitutionFactory.toSubstitution())).collect(ImmutableCollectors.toList());
    }

    private InjectiveSubstitution<Variable> getNonProjVarsRenaming(TranslationResult left, TranslationResult right, VariableGenerator variableGenerator) {
        return (InjectiveSubstitution)Sets.intersection((Set)Sets.difference((Set)left.iqTree.getKnownVariables(), (Set)left.iqTree.getVariables()), (Set)right.iqTree.getKnownVariables()).stream().collect(this.substitutionFactory.toFreshRenamingSubstitution(variableGenerator));
    }

    private ImmutableExpression getFilterExpression(ValueExpr expr, Set<Variable> childVariables) {
        ImmutableTerm term = this.getValueTranslator(childVariables).getTerm(expr);
        ImmutableTerm xsdBooleanTerm = term.inferType().flatMap(TermTypeInference::getTermType).filter(t -> t instanceof RDFDatatype).map(t -> (RDFDatatype)t).filter(t -> t.isA(XSD.BOOLEAN)).isPresent() ? term : this.termFactory.getSPARQLEffectiveBooleanValue(term);
        return this.termFactory.getRDF2DBBooleanFunctionalTerm(xsdBooleanTerm);
    }

    private TranslationResult createTranslationResult(IQTree iqTree, ImmutableSet<Variable> nullableVariables) {
        return new TranslationResult(iqTree, nullableVariables);
    }

    private IQTree applyExternalBindingFilter(IQTree tree, ImmutableSet<Variable> variables) {
        if (this.externalBindings.isEmpty()) {
            return tree;
        }
        Sets.SetView externallyBoundedVariables = Sets.intersection(variables, (Set)this.externalBindings.keySet());
        Optional conjunction = this.termFactory.getConjunction(externallyBoundedVariables.stream().map(v -> this.termFactory.getStrictEquality((ImmutableTerm)v, (ImmutableTerm)this.externalBindings.get(v), new ImmutableTerm[0])));
        return conjunction.map(arg_0 -> ((IntermediateQueryFactory)this.iqFactory).createFilterNode(arg_0)).map(f -> this.iqFactory.createUnaryIQTree((UnaryOperatorNode)f, tree)).orElse(tree);
    }

    private RDF4JValueTranslator getValueTranslator() {
        return new RDF4JValueTranslator(this.termFactory, this.rdfFactory, this.typeFactory);
    }

    private RDF4JValueExprTranslator getValueTranslator(Set<Variable> knownVariables) {
        return new RDF4JValueExprTranslator(knownVariables, this.externalBindings, this.treatBNodeAsVariable, this.termFactory, this.rdfFactory, this.typeFactory, this.functionSymbolFactory);
    }

    private static class VarDef {
        private final Variable var;
        private final ImmutableTerm term;

        private VarDef(Variable var, ImmutableTerm term) {
            this.var = var;
            this.term = term;
        }
    }

    private static class Sparql2IqConversionException
    extends OntopInternalBugException {
        Sparql2IqConversionException(String s) {
            super(s);
        }
    }

    private static class TranslationResult {
        private final IQTree iqTree;
        private final ImmutableSet<Variable> nullableVariables;

        private TranslationResult(IQTree iqTree, ImmutableSet<Variable> nullableVariables) {
            this.nullableVariables = nullableVariables;
            this.iqTree = iqTree;
        }
    }
}

