/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.injection.impl;

import com.google.inject.Injector;
import com.google.inject.Module;
import it.unibz.inf.ontop.injection.OntopKGQueryConfiguration;
import it.unibz.inf.ontop.injection.OntopKGQuerySettings;
import it.unibz.inf.ontop.injection.OntopOBDASettings;
import it.unibz.inf.ontop.injection.OntopOptimizationSettings;
import it.unibz.inf.ontop.injection.impl.OntopKGQueryModule;
import it.unibz.inf.ontop.injection.impl.OntopModelConfigurationImpl;
import it.unibz.inf.ontop.injection.impl.OntopOBDAConfigurationImpl;
import it.unibz.inf.ontop.injection.impl.OntopOptimizationConfigurationImpl;
import java.io.File;
import java.util.Map;
import java.util.Properties;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public abstract class OntopKGQueryConfigurationImpl
extends OntopOBDAConfigurationImpl
implements OntopKGQueryConfiguration {
    private final OntopKGQuerySettings settings;
    private final OntopOptimizationConfigurationImpl optimizationConfiguration;

    OntopKGQueryConfigurationImpl(OntopKGQuerySettings settings, OntopKGQueryOptions options) {
        super((OntopOBDASettings)settings, options.obdaOptions);
        this.settings = settings;
        this.optimizationConfiguration = new OntopOptimizationConfigurationImpl((OntopOptimizationSettings)settings, options.optimizationOptions, () -> ((OntopKGQueryConfigurationImpl)this).getInjector());
    }

    OntopKGQueryConfigurationImpl(OntopKGQuerySettings settings, OntopKGQueryOptions options, Supplier<Injector> injectorSupplier) {
        super((OntopOBDASettings)settings, options.obdaOptions, injectorSupplier);
        this.settings = settings;
        this.optimizationConfiguration = new OntopOptimizationConfigurationImpl((OntopOptimizationSettings)settings, options.optimizationOptions, injectorSupplier);
    }

    @Override
    public OntopKGQuerySettings getSettings() {
        return this.settings;
    }

    protected Stream<Module> buildGuiceModules() {
        return Stream.concat(Stream.concat(super.buildGuiceModules(), this.optimizationConfiguration.buildGuiceModules()), Stream.of(new OntopKGQueryModule(this.settings)));
    }

    protected static abstract class OntopKGQueryBuilderMixin<B extends OntopKGQueryConfiguration.Builder<B>>
    extends OntopOBDAConfigurationImpl.OntopOBDAConfigurationBuilderMixin<B>
    implements OntopKGQueryConfiguration.Builder<B> {
        private final OntopOptimizationConfigurationImpl.DefaultOntopOptimizationBuilderFragment<B> optimizationBuilderFragment = new OntopOptimizationConfigurationImpl.DefaultOntopOptimizationBuilderFragment();
        private final OntopModelConfigurationImpl.DefaultOntopModelBuilderFragment<B> modelBuilderFragment = new OntopModelConfigurationImpl.DefaultOntopModelBuilderFragment<B>(){

            protected B self() {
                return (OntopKGQueryConfiguration.Builder)this.self();
            }
        };

        OntopKGQueryBuilderMixin() {
        }

        protected final OntopKGQueryOptions generateKGQueryOptions() {
            return this.generateKGQueryOptions(this.generateOBDAOptions());
        }

        protected final OntopKGQueryOptions generateKGQueryOptions(OntopOBDAConfigurationImpl.OntopOBDAOptions obdaOptions) {
            return this.generateKGQueryOptions(obdaOptions, this.optimizationBuilderFragment.generateOptimizationOptions(obdaOptions.modelOptions));
        }

        protected final OntopKGQueryOptions generateKGQueryOptions(OntopOBDAConfigurationImpl.OntopOBDAOptions obdaOptions, OntopOptimizationConfigurationImpl.OntopOptimizationOptions optimizationOptions) {
            return new OntopKGQueryOptions(obdaOptions, optimizationOptions);
        }

        protected Properties generateProperties() {
            Properties properties = new Properties();
            properties.putAll((Map<?, ?>)super.generateProperties());
            properties.putAll((Map<?, ?>)this.modelBuilderFragment.generateProperties());
            properties.putAll((Map<?, ?>)this.optimizationBuilderFragment.generateProperties());
            return properties;
        }

        public B properties(@Nonnull Properties properties) {
            return (B)((OntopKGQueryConfiguration.Builder)this.modelBuilderFragment.properties(properties));
        }

        public B propertyFile(String propertyFilePath) {
            return (B)((OntopKGQueryConfiguration.Builder)this.modelBuilderFragment.propertyFile(propertyFilePath));
        }

        public B propertyFile(File propertyFile) {
            return (B)((OntopKGQueryConfiguration.Builder)this.modelBuilderFragment.propertyFile(propertyFile));
        }

        public B enableTestMode() {
            return (B)((OntopKGQueryConfiguration.Builder)this.modelBuilderFragment.enableTestMode());
        }
    }

    static class OntopKGQueryOptions {
        final OntopOBDAConfigurationImpl.OntopOBDAOptions obdaOptions;
        final OntopOptimizationConfigurationImpl.OntopOptimizationOptions optimizationOptions;

        private OntopKGQueryOptions(OntopOBDAConfigurationImpl.OntopOBDAOptions obdaOptions, OntopOptimizationConfigurationImpl.OntopOptimizationOptions optimizationOptions) {
            this.obdaOptions = obdaOptions;
            this.optimizationOptions = optimizationOptions;
        }
    }
}

