/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository.manager;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.http.client.HttpClient;
import org.eclipse.rdf4j.common.io.FileUtil;
import org.eclipse.rdf4j.http.client.HttpClientDependent;
import org.eclipse.rdf4j.http.client.HttpClientSessionManager;
import org.eclipse.rdf4j.http.client.SessionManagerDependent;
import org.eclipse.rdf4j.http.client.SharedHttpClientSessionManager;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.util.Configurations;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.FederatedServiceResolver;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.FederatedServiceResolverClient;
import org.eclipse.rdf4j.repository.DelegatingRepository;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.RepositoryResolver;
import org.eclipse.rdf4j.repository.RepositoryResolverClient;
import org.eclipse.rdf4j.repository.config.DelegatingRepositoryImplConfig;
import org.eclipse.rdf4j.repository.config.RepositoryConfig;
import org.eclipse.rdf4j.repository.config.RepositoryConfigException;
import org.eclipse.rdf4j.repository.config.RepositoryConfigUtil;
import org.eclipse.rdf4j.repository.config.RepositoryFactory;
import org.eclipse.rdf4j.repository.config.RepositoryImplConfig;
import org.eclipse.rdf4j.repository.config.RepositoryRegistry;
import org.eclipse.rdf4j.repository.manager.RepositoryInfo;
import org.eclipse.rdf4j.repository.manager.RepositoryManager;
import org.eclipse.rdf4j.repository.sparql.federation.SPARQLServiceResolver;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.rio.RioSetting;
import org.eclipse.rdf4j.rio.UnsupportedRDFormatException;
import org.eclipse.rdf4j.rio.WriterConfig;
import org.eclipse.rdf4j.rio.helpers.BasicWriterSettings;

public class LocalRepositoryManager
extends RepositoryManager {
    public static final String REPOSITORIES_DIR = "repositories";
    private static final RDFFormat CONFIG_FORMAT = RDFFormat.TURTLE;
    private static final String CFG_FILE = "config." + CONFIG_FORMAT.getDefaultFileExtension();
    private static final WriterConfig CFG_CONFIG = new WriterConfig().set((RioSetting)BasicWriterSettings.BASE_DIRECTIVE, (Object)false).set((RioSetting)BasicWriterSettings.PRETTY_PRINT, (Object)true).set((RioSetting)BasicWriterSettings.INLINE_BLANK_NODES, (Object)true);
    private final File baseDir;
    private volatile SharedHttpClientSessionManager client;
    private volatile SPARQLServiceResolver serviceResolver;

    public LocalRepositoryManager(File baseDir) {
        this.baseDir = baseDir;
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    @Override
    public URL getLocation() throws MalformedURLException {
        return this.baseDir.toURI().toURL();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SharedHttpClientSessionManager getSesameClient() {
        SharedHttpClientSessionManager result = this.client;
        if (result == null) {
            LocalRepositoryManager localRepositoryManager = this;
            synchronized (localRepositoryManager) {
                result = this.client;
                if (result == null) {
                    result = this.client = new SharedHttpClientSessionManager();
                }
            }
        }
        return result;
    }

    @Override
    public HttpClient getHttpClient() {
        SharedHttpClientSessionManager nextClient = this.client;
        if (nextClient == null) {
            return null;
        }
        return nextClient.getHttpClient();
    }

    @Override
    public void setHttpClient(HttpClient httpClient) {
        this.getSesameClient().setHttpClient(httpClient);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FederatedServiceResolver getFederatedServiceResolver() {
        SPARQLServiceResolver result = this.serviceResolver;
        if (result == null) {
            LocalRepositoryManager localRepositoryManager = this;
            synchronized (localRepositoryManager) {
                result = this.serviceResolver;
                if (result == null) {
                    result = this.serviceResolver = new SPARQLServiceResolver();
                    result.setHttpClientSessionManager((HttpClientSessionManager)this.getSesameClient());
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutDown() {
        try {
            super.shutDown();
        }
        finally {
            try {
                SPARQLServiceResolver toCloseServiceResolver = this.serviceResolver;
                this.serviceResolver = null;
                if (toCloseServiceResolver != null) {
                    toCloseServiceResolver.shutDown();
                }
            }
            finally {
                SharedHttpClientSessionManager toCloseClient = this.client;
                this.client = null;
                if (toCloseClient != null) {
                    toCloseClient.shutDown();
                }
            }
        }
    }

    public File resolvePath(String path) {
        return new File(this.getBaseDir(), path);
    }

    public File getRepositoryDir(String repositoryID) {
        File repositoriesDir = this.resolvePath(REPOSITORIES_DIR);
        return new File(repositoriesDir, repositoryID);
    }

    @Override
    protected Repository createRepository(String id) throws RepositoryConfigException, RepositoryException {
        Repository repository = null;
        RepositoryConfig repConfig = this.getRepositoryConfig(id);
        if (repConfig != null) {
            repConfig.validate();
            repository = this.createRepositoryStack(repConfig.getRepositoryImplConfig());
            repository.setDataDir(this.getRepositoryDir(id));
            repository.init();
        }
        return repository;
    }

    private Repository createRepositoryStack(RepositoryImplConfig config) throws RepositoryConfigException {
        RepositoryFactory factory = (RepositoryFactory)RepositoryRegistry.getInstance().get((Object)config.getType()).orElseThrow(() -> new RepositoryConfigException("Unsupported repository type: " + config.getType()));
        Repository repository = factory.getRepository(config);
        if (repository instanceof RepositoryResolverClient) {
            ((RepositoryResolverClient)repository).setRepositoryResolver((RepositoryResolver)this);
        }
        if (repository instanceof FederatedServiceResolverClient) {
            ((FederatedServiceResolverClient)repository).setFederatedServiceResolver(this.getFederatedServiceResolver());
        }
        if (repository instanceof SessionManagerDependent) {
            ((SessionManagerDependent)repository).setHttpClientSessionManager((HttpClientSessionManager)this.client);
        } else if (repository instanceof HttpClientDependent) {
            ((HttpClientDependent)repository).setHttpClient(this.getHttpClient());
        }
        if (config instanceof DelegatingRepositoryImplConfig) {
            RepositoryImplConfig delegateConfig = ((DelegatingRepositoryImplConfig)config).getDelegate();
            Repository delegate = this.createRepositoryStack(delegateConfig);
            try {
                ((DelegatingRepository)repository).setDelegate(delegate);
            }
            catch (ClassCastException e) {
                throw new RepositoryConfigException("Delegate specified for repository that is not a DelegatingRepository: " + String.valueOf(delegate.getClass()), (Throwable)e);
            }
        }
        return repository;
    }

    @Override
    public synchronized RepositoryConfig getRepositoryConfig(String id) {
        File dataDir = this.getRepositoryDir(id);
        if (new File(dataDir, CFG_FILE).exists()) {
            RepositoryConfig repositoryConfig;
            File configFile = new File(dataDir, CFG_FILE);
            FileInputStream input = new FileInputStream(configFile);
            try {
                Model model = Rio.parse((InputStream)input, (String)configFile.toURI().toString(), (RDFFormat)CONFIG_FORMAT, (Resource[])new Resource[0]);
                Set repositoryIDs = RepositoryConfigUtil.getRepositoryIDs((Model)model);
                if (repositoryIDs.isEmpty()) {
                    throw new RepositoryConfigException("No repository ID in configuration: " + String.valueOf(configFile));
                }
                if (repositoryIDs.size() != 1) {
                    throw new RepositoryConfigException("Multiple repository IDs in configuration: " + String.valueOf(configFile));
                }
                String repositoryID = (String)repositoryIDs.iterator().next();
                if (!id.equals(repositoryID) && !this.getRepositoryDir(repositoryID).getCanonicalFile().equals(dataDir.getCanonicalFile())) {
                    throw new RepositoryConfigException("Wrong repository ID in configuration: " + String.valueOf(configFile));
                }
                RepositoryConfig config = RepositoryConfigUtil.getRepositoryConfig((Model)model, (String)repositoryID);
                if (Configurations.hasLegacyConfiguration((Model)model) && !Configurations.useLegacyConfig() && config != null) {
                    this.migrateToNewConfigVocabulary(config);
                }
                repositoryConfig = config;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((InputStream)input).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RepositoryConfigException((Throwable)e);
                }
            }
            ((InputStream)input).close();
            return repositoryConfig;
        }
        return null;
    }

    protected void migrateToNewConfigVocabulary(RepositoryConfig config) {
        this.logger.warn("Configuration for {} uses legacy vocabulary, converting.", (Object)config.getID());
        this.addRepositoryConfig(config);
    }

    @Override
    public RepositoryInfo getRepositoryInfo(String id) {
        RepositoryConfig config = this.getRepositoryConfig(id);
        if (config == null) {
            return null;
        }
        RepositoryInfo repInfo = new RepositoryInfo();
        repInfo.setId(config.getID());
        repInfo.setDescription(config.getTitle());
        try {
            repInfo.setLocation(this.getRepositoryDir(config.getID()).toURI().toURL());
        }
        catch (MalformedURLException mue) {
            throw new RepositoryException("Location of repository does not resolve to a valid URL", (Throwable)mue);
        }
        repInfo.setReadable(true);
        repInfo.setWritable(true);
        return repInfo;
    }

    public synchronized List<RepositoryInfo> getAllRepositoryInfos() throws RepositoryException {
        File repositoriesDir = this.resolvePath(REPOSITORIES_DIR);
        String[] dirs = repositoriesDir.list((repositories, name) -> {
            File dataDir = new File(repositories, name);
            return dataDir.isDirectory() && new File(dataDir, CFG_FILE).exists();
        });
        if (dirs == null) {
            return Collections.emptyList();
        }
        ArrayList<RepositoryInfo> result = new ArrayList<RepositoryInfo>();
        for (String name2 : dirs) {
            RepositoryInfo repInfo = this.getRepositoryInfo(name2);
            result.add(repInfo);
        }
        return result;
    }

    @Override
    public synchronized void addRepositoryConfig(RepositoryConfig config) throws RepositoryException, RepositoryConfigException {
        Objects.requireNonNull(config).validate();
        File dataDir = this.getRepositoryDir(config.getID());
        if (!dataDir.exists()) {
            dataDir.mkdirs();
        }
        if (!dataDir.isDirectory()) {
            throw new RepositoryConfigException("Could not create directory: " + String.valueOf(dataDir));
        }
        File configFile = new File(dataDir, CFG_FILE);
        Model model = this.getModelFactory().createEmptyModel();
        String ns = configFile.toURI().toString() + "#";
        config.export(model, (Resource)SimpleValueFactory.getInstance().createIRI(ns, config.getID()));
        File part = new File(configFile.getParentFile(), configFile.getName() + ".part");
        try (FileOutputStream output = new FileOutputStream(part);){
            Rio.write((Iterable)model, (OutputStream)output, (String)configFile.toURI().toString(), (RDFFormat)CONFIG_FORMAT, (WriterConfig)CFG_CONFIG);
        }
        catch (IOException | URISyntaxException | RDFHandlerException | UnsupportedRDFormatException e) {
            throw new RepositoryConfigException(e);
        }
        try {
            Files.move(part.toPath(), configFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new RepositoryConfigException((Throwable)e);
        }
    }

    @Override
    public synchronized boolean removeRepository(String repositoryID) throws RepositoryException, RepositoryConfigException {
        boolean removed = super.removeRepository(repositoryID);
        File dataDir = this.getRepositoryDir(repositoryID);
        if (dataDir.isDirectory()) {
            this.logger.debug("Cleaning up data dir {} for repository {}", (Object)dataDir.getAbsolutePath(), (Object)repositoryID);
            try {
                FileUtil.deleteDir((File)dataDir);
            }
            catch (IOException e) {
                throw new RepositoryConfigException((Throwable)e);
            }
            return true;
        }
        return removed;
    }
}

