/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.plugins.textmining.plugin;

import com.ontotext.graphdb.plugins.textmining.clients.TextMiningClient;
import com.ontotext.graphdb.plugins.textmining.iterators.MasterResultIterator;
import com.ontotext.graphdb.plugins.textmining.model.Document;
import com.ontotext.trree.sdk.Request;
import com.ontotext.trree.sdk.RequestContext;
import com.ontotext.trree.sdk.StatementIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;

public final class TextMiningRequestContext
implements RequestContext {
    private Request request;
    private List<MasterResultIterator> masters;
    private Map<IRI, Document> documents = new HashMap<IRI, Document>();
    private Resource currentNode;
    private Map<IRI, TextMiningClient> textMiningClients = new HashMap<IRI, TextMiningClient>();

    public TextMiningRequestContext(Request request) {
        this.request = request;
    }

    public void setDocument(IRI clientIRI, Document doc) {
        this.documents.put(clientIRI, doc);
    }

    public Document getDocument(IRI clientIRI) {
        return this.documents.get(clientIRI);
    }

    public Resource getCurrentDocumentNode() {
        return this.currentNode;
    }

    public void registerIterator(MasterResultIterator it) {
        this.masters = TextMiningRequestContext.createIteratorList(this.masters);
        this.masters.add(it);
        this.currentNode = it.getDocNode();
    }

    public void unregisterIterator(MasterResultIterator it) {
        this.masters.remove((Object)it);
    }

    public MasterResultIterator findMasterIterator(long subject) {
        return TextMiningRequestContext.findIteratorBySubject(this.masters, subject);
    }

    private static <T extends StatementIterator> List<T> createIteratorList(@Nullable List<T> list) {
        if (list == null) {
            list = new ArrayList<T>();
        }
        return list;
    }

    private static <T extends StatementIterator> T findIteratorBySubject(@Nullable List<T> list, long subject) {
        if (list == null) {
            return null;
        }
        for (StatementIterator it : list) {
            if (it.subject != subject) continue;
            return (T)it;
        }
        return null;
    }

    public Request getRequest() {
        return this.request;
    }

    public void setRequest(Request request) {
        this.request = request;
    }

    public void reset() {
        this.masters = null;
        this.documents = new HashMap<IRI, Document>();
    }

    public TextMiningClient getTextMiningClient(IRI clientIRI) {
        return this.textMiningClients.get(clientIRI);
    }

    public void addTextMiningClient(IRI clientIRI, TextMiningClient textMiningClient) {
        this.textMiningClients.put(clientIRI, textMiningClient);
    }
}

