/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.plugins.textmining.plugin;

import com.ontotext.graphdb.plugins.textmining.clients.ClientBase;
import com.ontotext.graphdb.plugins.textmining.clients.TextMiningClient;
import com.ontotext.graphdb.plugins.textmining.clients.impl.CesClient;
import com.ontotext.graphdb.plugins.textmining.clients.impl.GateClient;
import com.ontotext.graphdb.plugins.textmining.clients.impl.GenericClient;
import com.ontotext.graphdb.plugins.textmining.clients.impl.SpacyClient;
import com.ontotext.graphdb.plugins.textmining.iterators.DummyIterator;
import com.ontotext.graphdb.plugins.textmining.iterators.MasterResultIterator;
import com.ontotext.graphdb.plugins.textmining.iterators.TextMiningConfigIterator;
import com.ontotext.graphdb.plugins.textmining.iterators.TextMiningConfigSubjectIterator;
import com.ontotext.graphdb.plugins.textmining.model.Document;
import com.ontotext.graphdb.plugins.textmining.plugin.ClientConfig;
import com.ontotext.graphdb.plugins.textmining.plugin.ClientType;
import com.ontotext.graphdb.plugins.textmining.plugin.TextMiningRequestContext;
import com.ontotext.trree.sdk.ClientErrorException;
import com.ontotext.trree.sdk.Entities;
import com.ontotext.trree.sdk.InitReason;
import com.ontotext.trree.sdk.ListPatternInterpreter;
import com.ontotext.trree.sdk.ListPreserveOrder;
import com.ontotext.trree.sdk.PatternInterpreter;
import com.ontotext.trree.sdk.PluginBase;
import com.ontotext.trree.sdk.PluginConnection;
import com.ontotext.trree.sdk.PluginException;
import com.ontotext.trree.sdk.Preprocessor;
import com.ontotext.trree.sdk.Request;
import com.ontotext.trree.sdk.RequestContext;
import com.ontotext.trree.sdk.StatementIterator;
import com.ontotext.trree.sdk.UpdateInterpreter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.EmptyIteration;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.sail.NotifyingSailConnection;
import org.eclipse.rdf4j.sail.SailException;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextMiningPlugin
extends PluginBase
implements PatternInterpreter,
UpdateInterpreter,
Preprocessor,
ListPatternInterpreter,
ListPreserveOrder {
    private static final Logger LOGGER = LoggerFactory.getLogger(TextMiningPlugin.class);
    public static final ValueFactory VF = SimpleValueFactory.getInstance();
    private static final String DB_FILENAME = "text-mining-clients.db";
    public static final String TEXT_MINING_NAMESPACE = "http://www.ontotext.com/textmining";
    public static final String TEXT_MINING_PREDICATE_NAMESPACE = "http://www.ontotext.com/textmining#";
    private static final IRI TEXT_MINING_INSTANCE_PREFIX = VF.createIRI("http://www.ontotext.com/textmining", "/instance#");
    private static final IRI TEXT_MINING_SPACY = VF.createIRI("http://www.ontotext.com/textmining#", "Spacy");
    private static final IRI TEXT_MINING_CES = VF.createIRI("http://www.ontotext.com/textmining#", "Ces");
    private static final IRI TEXT_MINING_GATE = VF.createIRI("http://www.ontotext.com/textmining#", "Gate");
    private static final IRI TEXT_MINING_PROVIDER = VF.createIRI("http://www.ontotext.com/textmining#", "Provider");
    private static final IRI TEXT_MINING_SERVICE_PREDICATE = VF.createIRI("http://www.ontotext.com/textmining#", "service");
    private static final IRI TEXT_MINING_CONNECT_PREDICATE = VF.createIRI("http://www.ontotext.com/textmining#", "connect");
    private static final IRI DROP_SERVICE_PREDICATE = VF.createIRI("http://www.ontotext.com/textmining#", "dropService");
    private static final IRI TEXT_MINING_TRANSFORMATION = VF.createIRI("http://www.ontotext.com/textmining#", "transformation");
    private static final IRI TEXT_MINING_HEADER_PREDICATE = VF.createIRI("http://www.ontotext.com/textmining#", "header");
    private static final IRI TEXT_MINING_BASIC_AUTH_PREDICATE = VF.createIRI("http://www.ontotext.com/textmining#", "basicAuth");
    private static final IRI TEXT_MINING_SENSE_2_VEC_PREDICATE = VF.createIRI("http://www.ontotext.com/textmining#", "sense2vec");
    private static final IRI ANNOTATE_TEXT_PREDICATE = VF.createIRI("http://www.ontotext.com/textmining#", "text");
    private static final IRI ANNOTATE_RAW_INPUT_PREDICATE = VF.createIRI("http://www.ontotext.com/textmining#", "rawInput");
    public static final IRI ANNOTATIONS_PREDICATE = VF.createIRI("http://www.ontotext.com/textmining#", "annotations");
    public static final IRI ANNOTATION_TEXT = VF.createIRI("http://www.ontotext.com/textmining#", "annotationText");
    public static final IRI ANNOTATION_KEY = VF.createIRI("http://www.ontotext.com/textmining#", "annotationKey");
    public static final IRI ANNOTATION_START = VF.createIRI("http://www.ontotext.com/textmining#", "annotationStart");
    public static final IRI ANNOTATION_END = VF.createIRI("http://www.ontotext.com/textmining#", "annotationEnd");
    public static final IRI ANNOTATION_TYPE = VF.createIRI("http://www.ontotext.com/textmining#", "annotationType");
    public static final IRI HAS_SENTENSE_PREDICATE = VF.createIRI("http://www.ontotext.com/textmining#", "hasSentence");
    public static final IRI SENTENCE_TEXT = VF.createIRI("http://www.ontotext.com/textmining#", "sentenceText");
    public static final IRI FEATURES_PREDICATE = VF.createIRI("http://www.ontotext.com/textmining#", "features");
    public static final IRI SERVICE_ERRORS_PREDICATE = VF.createIRI("http://www.ontotext.com/textmining#", "serviceErrors");
    private static final IRI TEXT_MINING_SERVICE = VF.createIRI("http://www.ontotext.com/textmining#", "Service");
    private long serviceId;
    private long servicePredicateId;
    private long connectPredicateId;
    private long dropServicePredicateId;
    private long headerPredicateId;
    private long basicAuthPredicateId;
    private long sense2VecPredicateId;
    private long spacyTypeId;
    private long providerTypeId;
    private long cesTypeId;
    private long gateTypeId;
    private long rdfTypeId;
    private long annotateTextPredicateId;
    private long annotateRawInputPredicateId;
    private long annotationPredicateId;
    private long annotationTextPredicateId;
    private long transformationPredicateId;
    private long featuresPredicateId;
    private long serviceErrorsId;
    private final Map<Long, ClientType> clientType = new HashMap<Long, ClientType>();
    private Map<IRI, ClientConfig> configs = new HashMap<IRI, ClientConfig>();
    private Set<Long> configEntities = new HashSet<Long>();

    public String getName() {
        return "text-mining";
    }

    public void initialize(InitReason reason, PluginConnection pluginConnection) {
        this.registerPredicates(pluginConnection.getEntities());
        this.loadFromCache(pluginConnection);
    }

    private void registerPredicates(Entities entities) {
        this.servicePredicateId = entities.put((Value)TEXT_MINING_SERVICE_PREDICATE, Entities.Scope.SYSTEM);
        this.connectPredicateId = entities.put((Value)TEXT_MINING_CONNECT_PREDICATE, Entities.Scope.SYSTEM);
        this.dropServicePredicateId = entities.put((Value)DROP_SERVICE_PREDICATE, Entities.Scope.SYSTEM);
        this.headerPredicateId = entities.put((Value)TEXT_MINING_HEADER_PREDICATE, Entities.Scope.SYSTEM);
        this.basicAuthPredicateId = entities.put((Value)TEXT_MINING_BASIC_AUTH_PREDICATE, Entities.Scope.SYSTEM);
        this.sense2VecPredicateId = entities.put((Value)TEXT_MINING_SENSE_2_VEC_PREDICATE, Entities.Scope.SYSTEM);
        this.spacyTypeId = entities.put((Value)TEXT_MINING_SPACY, Entities.Scope.SYSTEM);
        this.cesTypeId = entities.put((Value)TEXT_MINING_CES, Entities.Scope.SYSTEM);
        this.gateTypeId = entities.put((Value)TEXT_MINING_GATE, Entities.Scope.SYSTEM);
        this.providerTypeId = entities.put((Value)TEXT_MINING_PROVIDER, Entities.Scope.SYSTEM);
        this.rdfTypeId = entities.resolve((Value)RDF.TYPE);
        this.transformationPredicateId = entities.put((Value)TEXT_MINING_TRANSFORMATION, Entities.Scope.SYSTEM);
        this.featuresPredicateId = entities.put((Value)FEATURES_PREDICATE, Entities.Scope.SYSTEM);
        this.clientType.put(this.cesTypeId, ClientType.CES);
        this.clientType.put(this.gateTypeId, ClientType.GATE);
        this.clientType.put(this.spacyTypeId, ClientType.SPACY);
        this.clientType.put(this.providerTypeId, ClientType.GENERIC);
        this.annotateTextPredicateId = entities.put((Value)ANNOTATE_TEXT_PREDICATE, Entities.Scope.SYSTEM);
        this.annotateRawInputPredicateId = entities.put((Value)ANNOTATE_RAW_INPUT_PREDICATE, Entities.Scope.SYSTEM);
        this.annotationPredicateId = entities.put((Value)ANNOTATIONS_PREDICATE, Entities.Scope.SYSTEM);
        this.annotationTextPredicateId = entities.put((Value)ANNOTATION_TEXT, Entities.Scope.SYSTEM);
        this.serviceId = entities.put((Value)TEXT_MINING_SERVICE, Entities.Scope.SYSTEM);
        this.serviceErrorsId = entities.put((Value)SERVICE_ERRORS_PREDICATE, Entities.Scope.SYSTEM);
    }

    public double estimate(long subject, long predicate, long object, long context, PluginConnection pluginConnection, RequestContext requestContext) {
        if (predicate == this.rdfTypeId) {
            return subject == 0L ? 0.01 : Double.POSITIVE_INFINITY;
        }
        if (predicate == this.annotateTextPredicateId || predicate == this.annotateRawInputPredicateId) {
            if (object == 0L) {
                return Double.POSITIVE_INFINITY;
            }
            return subject == Long.MAX_VALUE ? 0.1 : 1.1;
        }
        if (predicate == this.serviceErrorsId) {
            return subject == Long.MAX_VALUE ? 0.08 : 1.08;
        }
        if (context == Long.MAX_VALUE && context != 0L) {
            return 1.4;
        }
        if (predicate == this.annotationPredicateId) {
            return subject == Long.MAX_VALUE ? 0.2 : 1.2;
        }
        if (predicate == this.annotationTextPredicateId) {
            return subject == Long.MAX_VALUE ? 0.3 : 1.3;
        }
        if (predicate == this.servicePredicateId || predicate == this.connectPredicateId || predicate == this.headerPredicateId || predicate == this.basicAuthPredicateId || predicate == this.sense2VecPredicateId) {
            return subject == Long.MAX_VALUE ? 0.01 : Double.POSITIVE_INFINITY;
        }
        return 1.0;
    }

    public double estimate(long subject, long predicate, long[] object, long context, PluginConnection pluginConnection, RequestContext requestContext) {
        if (predicate == this.featuresPredicateId) {
            if (object == null) {
                return Double.POSITIVE_INFINITY;
            }
            return subject == Long.MAX_VALUE ? 0.05 : 1.05;
        }
        return 0.0;
    }

    public StatementIterator interpret(long subject, long predicate, long object, long context, PluginConnection pluginConnection, RequestContext requestContext) {
        IRI configKey;
        ClientConfig client;
        MasterResultIterator mri;
        Resource current;
        final TextMiningRequestContext tmrc = (TextMiningRequestContext)requestContext;
        if (predicate == this.rdfTypeId && this.configEntities.contains(object)) {
            IRI configKey2 = this.getConfigIRIorThrow(object, pluginConnection);
            MasterResultIterator masterResultIterator = new MasterResultIterator(pluginConnection.getEntities(), tmrc);
            TextMiningClient textMiningClient = tmrc.getTextMiningClient(configKey2);
            if (textMiningClient == null) {
                ClientConfig clientConfig = this.configs.get(configKey2);
                if (clientConfig == null) {
                    throw new PluginException("Invalid state. Config entity found, but no client config is found.");
                }
                textMiningClient = this.createClient(clientConfig);
                textMiningClient.setClientIRI(configKey2);
                tmrc.addTextMiningClient(configKey2, textMiningClient);
            }
            masterResultIterator.setTextMiningClient(textMiningClient);
            ((TextMiningRequestContext)requestContext).registerIterator(masterResultIterator);
            return masterResultIterator;
        }
        if (predicate == this.rdfTypeId && (object == this.serviceId || object == this.spacyTypeId || object == this.cesTypeId || object == this.gateTypeId || object == this.providerTypeId)) {
            Set<IRI> keySet = object == this.serviceId ? this.configs.keySet() : this.getConfigKeysMatchingType(object);
            return new TextMiningConfigSubjectIterator(this, keySet.stream().map(Value::stringValue).collect(Collectors.toSet()), predicate, pluginConnection.getEntities());
        }
        if (predicate == this.serviceErrorsId) {
            TextMiningClient client2;
            long s = subject;
            current = tmrc.getCurrentDocumentNode();
            if (current != null && subject == 0L) {
                s = pluginConnection.getEntities().resolve((Value)current);
            }
            if ((mri = tmrc.findMasterIterator(s)) != null && (client2 = mri.getTextMiningClient()) instanceof ClientBase) {
                int errors;
                Value number = pluginConnection.getEntities().get(object);
                if (number == null || !number.isLiteral() || (errors = ((Literal)number).intValue()) < -1) {
                    throw new PluginException("serviceErrors predicate expects -1 or greater but was [" + number + "]");
                }
                ((ClientBase)client2).setErrorsToIgnore(errors);
                return StatementIterator.TRUE();
            }
        }
        if (context != 0L && this.configEntities.contains(context) && (client = this.configs.get(this.getConfigIRIorThrow(context, pluginConnection))) != null) {
            final Entities ent = pluginConnection.getEntities();
            final IRI clientIRI = (IRI)ent.get(context);
            final TextMiningRequestContext tmrc1 = tmrc;
            final long s = subject;
            final long p = predicate;
            final long o = object;
            return new StatementIterator(){
                boolean initialized = false;
                CloseableIteration<? extends Statement, SailException> iter;
                NotifyingSailConnection connection;

                public boolean next() {
                    if (!this.initialized) {
                        this.initialized = true;
                        if (tmrc1.getDocument(clientIRI) == null) {
                            this.iter = new EmptyIteration();
                        } else {
                            this.connection = tmrc1.getDocument(clientIRI).getRDF().getConnection();
                            this.iter = s == 0L || ent.get(s) instanceof Resource ? this.connection.getStatements((Resource)ent.get(s), (IRI)ent.get(p), ent.get(o), true, new Resource[0]) : new EmptyIteration();
                        }
                    }
                    if (!this.iter.hasNext()) {
                        return false;
                    }
                    Statement st = (Statement)this.iter.next();
                    long id = ent.resolve((Value)st.getSubject());
                    if (id == 0L) {
                        id = ent.put((Value)st.getSubject(), Entities.Scope.REQUEST);
                    }
                    this.subject = id;
                    id = ent.resolve((Value)st.getPredicate());
                    if (id == 0L) {
                        id = ent.put((Value)st.getPredicate(), Entities.Scope.REQUEST);
                    }
                    this.predicate = id;
                    id = ent.resolve(st.getObject());
                    if (id == 0L) {
                        id = ent.put(st.getObject(), Entities.Scope.REQUEST);
                    }
                    this.object = id;
                    return true;
                }

                public void close() {
                    if (this.iter != null) {
                        this.iter.close();
                    }
                    if (this.connection != null) {
                        this.connection.close();
                    }
                }
            };
        }
        if (predicate == this.annotateTextPredicateId || predicate == this.annotateRawInputPredicateId) {
            long s = subject;
            current = tmrc.getCurrentDocumentNode();
            if (current != null && subject == 0L) {
                s = pluginConnection.getEntities().resolve((Value)current);
            }
            if (s == 0L) {
                return new DummyIterator("The content to annotate");
            }
            mri = tmrc.findMasterIterator(s);
            if (mri != null) {
                if (object == 0L) {
                    return StatementIterator.EMPTY;
                }
                final Value textValue = pluginConnection.getEntities().get(object);
                return new StatementIterator(){
                    boolean returned = false;

                    public boolean next() {
                        if (this.returned) {
                            return false;
                        }
                        this.returned = true;
                        try {
                            mri.setAnnotateText(textValue);
                            Document doc = mri.getTextMiningClient().annotateDocument(mri.getAnnotateText(), mri.getDocNode(), mri.getDocumentFeatures());
                            tmrc.setDocument(mri.getTextMiningClient().getClientIRI(), doc);
                        }
                        catch (ClientErrorException e) {
                            throw e;
                        }
                        catch (Exception e) {
                            throw new PluginException("Cannot annotate document: " + e.getMessage(), (Throwable)e);
                        }
                        return true;
                    }

                    public void close() {
                        tmrc.setDocument(mri.getTextMiningClient().getClientIRI(), null);
                    }
                };
            }
            return null;
        }
        if (predicate == this.servicePredicateId || predicate == this.connectPredicateId || predicate == this.headerPredicateId || predicate == this.basicAuthPredicateId || predicate == this.sense2VecPredicateId) {
            if (subject == 0L) {
                return StatementIterator.EMPTY;
            }
            IRI configKey3 = this.getConfigIRIorThrow(subject, pluginConnection);
            if (this.configs.containsKey(configKey3)) {
                return new TextMiningConfigIterator(this, this.configs.get(configKey3), predicate, pluginConnection);
            }
        }
        if (subject != 0L && predicate == 0L && object == 0L && !this.configs.isEmpty() && this.configs.containsKey(configKey = this.getConfigIRIorThrow(subject, pluginConnection))) {
            return new TextMiningConfigIterator(this, this.configs.get(configKey), predicate, pluginConnection);
        }
        return null;
    }

    public StatementIterator interpret(long subject, long predicate, long[] object, long context, PluginConnection pluginConnection, RequestContext requestContext) {
        TextMiningRequestContext tmrc = (TextMiningRequestContext)requestContext;
        if (predicate == this.featuresPredicateId) {
            long subjectFromRC = subject;
            Resource current = tmrc.getCurrentDocumentNode();
            if (current != null && subject == 0L) {
                subjectFromRC = pluginConnection.getEntities().resolve((Value)current);
            }
            if (subjectFromRC == 0L) {
                return new DummyIterator("Features required");
            }
            if (object == null || object.length == 0) {
                return StatementIterator.EMPTY;
            }
            HashMap<String, String> features = new HashMap<String, String>();
            if (object[0] != 0L) {
                features.put("id", pluginConnection.getEntities().get(object[0]).stringValue());
            }
            this.putFeature(object, pluginConnection, features, 1, "title");
            this.putFeature(object, pluginConnection, features, 2, "type");
            this.putFeature(object, pluginConnection, features, 3, "author");
            this.putFeature(object, pluginConnection, features, 4, "source");
            this.putFeature(object, pluginConnection, features, 5, "category");
            this.putFeature(object, pluginConnection, features, 6, "date");
            TextMiningRequestContext textMiningRequestContext = (TextMiningRequestContext)requestContext;
            MasterResultIterator mri = textMiningRequestContext.findMasterIterator(subjectFromRC);
            if (mri != null) {
                mri.setDocumentFeatures(features);
                return StatementIterator.TRUE();
            }
        }
        return null;
    }

    private void putFeature(long[] object, PluginConnection pluginConnection, Map<String, String> features, int i, String type) {
        if (object.length >= i && object[i] != 0L) {
            features.put(type, pluginConnection.getEntities().get(object[i]).stringValue());
        }
    }

    public long[] getPredicatesToListenFor() {
        return new long[]{this.servicePredicateId, this.connectPredicateId, this.dropServicePredicateId, this.headerPredicateId, this.basicAuthPredicateId, this.transformationPredicateId, this.sense2VecPredicateId};
    }

    public boolean interpretUpdate(long subject, long predicate, long object, long context, boolean isAddition, boolean isExplicit, PluginConnection pluginConnection) {
        if (predicate == this.servicePredicateId) {
            IRI configKey = this.getConfigIRIorThrow(subject, pluginConnection);
            String serviceLocation = pluginConnection.getEntities().get(object).stringValue();
            this.configs.putIfAbsent(configKey, new ClientConfig());
            this.configs.get(configKey).setServiceLocation(URI.create(serviceLocation));
            this.storeInCache();
            return true;
        }
        if (predicate == this.connectPredicateId) {
            IRI configKey = this.getConfigIRIorThrow(subject, pluginConnection);
            if (object != this.spacyTypeId && object != this.gateTypeId && object != this.cesTypeId && object != this.providerTypeId) {
                throw new PluginException("Unrecognized text mining service type.");
            }
            this.createConfigWithEntity(configKey, pluginConnection);
            ClientType serviceType = this.clientType.get(object);
            this.configs.get(configKey).setType(serviceType);
            LOGGER.info("Created service {} of type {}", (Object)configKey, (Object)serviceType);
            this.storeInCache();
            return true;
        }
        if (predicate == this.headerPredicateId) {
            IRI configKey = this.getConfigIRIorThrow(subject, pluginConnection);
            this.configs.putIfAbsent(configKey, new ClientConfig());
            this.configs.get(configKey).addHeader(pluginConnection.getEntities().get(object).stringValue());
            this.storeInCache();
            return true;
        }
        if (predicate == this.basicAuthPredicateId) {
            IRI configKey = this.getConfigIRIorThrow(subject, pluginConnection);
            this.configs.putIfAbsent(configKey, new ClientConfig());
            this.configs.get(configKey).setBaseAuthHeader(pluginConnection.getEntities().get(object).stringValue());
            this.storeInCache();
            return true;
        }
        if (predicate == this.sense2VecPredicateId) {
            IRI configKey = this.getConfigIRIorThrow(subject, pluginConnection);
            this.configs.putIfAbsent(configKey, new ClientConfig());
            this.configs.get(configKey).setSense2Vec(((Literal)pluginConnection.getEntities().get(object)).booleanValue());
            this.storeInCache();
            return true;
        }
        if (predicate == this.transformationPredicateId) {
            IRI configKey = this.getConfigIRIorThrow(subject, pluginConnection);
            this.configs.putIfAbsent(configKey, new ClientConfig());
            this.configs.get(configKey).setTransformation(pluginConnection.getEntities().get(object).stringValue());
            this.storeInCache();
            return true;
        }
        if (predicate == this.dropServicePredicateId) {
            IRI configKey = this.getConfigIRIorThrow(subject, pluginConnection);
            if (this.configs.containsKey(configKey)) {
                ClientConfig droppedService = this.configs.remove(configKey);
                this.storeInCache();
                this.configEntities.remove(pluginConnection.getEntities().resolve((Value)configKey));
                LOGGER.info("Dropped service {} of type {}", (Object)configKey, (Object)droppedService.getType());
            } else {
                LOGGER.info("Trying to drop not existing service {}", (Object)configKey);
            }
            return true;
        }
        return false;
    }

    private void createConfigWithEntity(IRI configKey, PluginConnection pluginConnection) {
        if (!this.configs.containsKey(configKey)) {
            if (!configKey.stringValue().startsWith(TEXT_MINING_INSTANCE_PREFIX.stringValue())) {
                throw new PluginException("Client name must be within the instance namespace: " + TEXT_MINING_INSTANCE_PREFIX.stringValue());
            }
            ClientConfig config = new ClientConfig();
            config.setName(configKey.getLocalName());
            this.configs.put(configKey, config);
        }
        long entity = pluginConnection.getEntities().put((Value)configKey, Entities.Scope.SYSTEM);
        this.configEntities.add(entity);
    }

    public RequestContext preprocess(Request request) {
        return new TextMiningRequestContext(request);
    }

    private TextMiningClient createClient(ClientConfig clientConfig) {
        switch (clientConfig.getType()) {
            case CES: {
                return new CesClient(clientConfig);
            }
            case SPACY: {
                return new SpacyClient(clientConfig);
            }
            case GATE: {
                return new GateClient(clientConfig);
            }
            case GENERIC: {
                return new GenericClient(clientConfig);
            }
        }
        throw new PluginException("This type of client is not supported: " + clientConfig.getType());
    }

    private IRI getConfigIRIorThrow(long longKeyValue, PluginConnection pluginConnection) {
        Value value = pluginConnection.getEntities().get(longKeyValue);
        if (value.isIRI()) {
            return (IRI)value;
        }
        throw new PluginException("Client must be an IRI");
    }

    private void loadFromCache(PluginConnection pluginConnection) {
        block13: {
            try {
                File cacheFile = new File(this.getDataDir(), DB_FILENAME);
                if (!cacheFile.exists()) break block13;
                try (FileInputStream fileInputStream = new FileInputStream(cacheFile);
                     ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);){
                    this.configs = (Map)objectInputStream.readObject();
                }
            }
            catch (IOException | ClassNotFoundException e) {
                this.configs = new HashMap<IRI, ClientConfig>();
            }
        }
        for (IRI clientConfigIRI : this.configs.keySet()) {
            long clientIRIEntity = pluginConnection.getEntities().put((Value)clientConfigIRI, Entities.Scope.SYSTEM);
            this.configEntities.add(clientIRIEntity);
        }
    }

    private void storeInCache() {
        File dbFile = this.getFile();
        try (FileOutputStream fileOutputStream = new FileOutputStream(dbFile);
             ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);){
            objectOutputStream.writeObject(this.configs);
        }
        catch (IOException e) {
            LOGGER.error("Could not store text mining client services in cache", (Throwable)e);
        }
    }

    private File getFile() {
        File dataDir = this.getDataDir();
        File dbFile = new File(dataDir, DB_FILENAME);
        if (!dataDir.exists()) {
            try {
                FileUtils.forceMkdir((File)dataDir);
                dbFile.createNewFile();
            }
            catch (IOException e) {
                LOGGER.error("Could create directory " + dataDir, (Throwable)e);
            }
        }
        return dbFile;
    }

    public long getRdfTypeId() {
        return this.rdfTypeId;
    }

    public long getServicePredicateId() {
        return this.servicePredicateId;
    }

    public long getConnectPredicateId() {
        return this.connectPredicateId;
    }

    public long getHeaderPredicateId() {
        return this.headerPredicateId;
    }

    public long getTransformationPredicateId() {
        return this.transformationPredicateId;
    }

    public long getSpacyTypeId() {
        return this.spacyTypeId;
    }

    public long getProviderTypeId() {
        return this.providerTypeId;
    }

    public long getCesTypeId() {
        return this.cesTypeId;
    }

    public long getGateTypeId() {
        return this.gateTypeId;
    }

    public long getSense2VecPredicateId() {
        return this.sense2VecPredicateId;
    }

    @NotNull
    private Set<IRI> getConfigKeysMatchingType(long object) {
        return this.configs.keySet().stream().filter(key -> this.configs.get(key).getType() == this.clientType.get(object)).collect(Collectors.toSet());
    }

    public int position(long subject, long predicate, long object, long context, PluginConnection pluginConnection, RequestContext requestContext) {
        if (predicate == this.rdfTypeId) {
            return 1;
        }
        if (predicate == this.annotateTextPredicateId) {
            return 3;
        }
        if (context == Long.MAX_VALUE || context != 0L) {
            return 10;
        }
        if (predicate == this.annotationPredicateId) {
            return 4;
        }
        if (predicate == this.annotationTextPredicateId) {
            return 5;
        }
        if (predicate == this.servicePredicateId || predicate == this.connectPredicateId || predicate == this.headerPredicateId || predicate == this.basicAuthPredicateId || predicate == this.serviceErrorsId || predicate == this.sense2VecPredicateId) {
            return 2;
        }
        return -1;
    }

    public int position(long subject, long predicate, long[] objects, long context, PluginConnection pluginConnection, RequestContext requestContext) {
        if (predicate == this.featuresPredicateId) {
            return 2;
        }
        return -1;
    }
}

