/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.plugins.textmining.clients.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.ontotext.graphdb.plugins.textmining.clients.ClientBase;
import com.ontotext.graphdb.plugins.textmining.model.Annotation;
import com.ontotext.graphdb.plugins.textmining.model.Document;
import com.ontotext.graphdb.plugins.textmining.plugin.ClientConfig;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.http.entity.StringEntity;

public class SpacyClient
extends ClientBase {
    public static final String SENSE_2_VEC = "sense2vec";

    public SpacyClient(ClientConfig config) {
        super(config);
    }

    @Override
    protected StringEntity getStringEntity(final String content, Map<String, String> documentFeatures) throws IOException {
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put("sections", new LinkedList<String>(){
            {
                this.add(content);
            }
        });
        map.put(SENSE_2_VEC, Boolean.valueOf(this.clientConfig.isSense2Vec()));
        ObjectMapper objectMapper = new ObjectMapper();
        String requestBody = objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(map);
        return new StringEntity(requestBody, StandardCharsets.UTF_8);
    }

    @Override
    protected Document convertJSONToDocument(JsonNode jsonNode) {
        Document resultDocument = new Document();
        resultDocument.setRawSource(jsonNode.toString());
        ArrayNode sentences = (ArrayNode)jsonNode.get("data");
        for (JsonNode sentence : sentences) {
            String sentenceText = sentence.get("text").asText();
            resultDocument.getSentences().add(sentenceText);
            ArrayNode entities = (ArrayNode)sentence.get("entities");
            for (JsonNode spacyEntity : entities) {
                Annotation entity = new Annotation();
                entity.setSentenceText(sentenceText);
                String text = spacyEntity.get("text").asText();
                entity.setText(text);
                String label = spacyEntity.get("label").asText();
                entity.setType(label);
                entity.setStartOffset(spacyEntity.get("start_char").asLong());
                entity.setEndOffset(spacyEntity.get("end_char").asLong());
                HashMap<String, Object> features = new HashMap<String, Object>();
                ObjectMapper mapper = new ObjectMapper();
                List entries = (List)mapper.convertValue((Object)spacyEntity.get(SENSE_2_VEC), (TypeReference)new TypeReference<List<Map<String, Object>>>(){});
                features.put(SENSE_2_VEC, entries);
                entity.setFeatures(features);
                resultDocument.getAnnotations().add(entity);
            }
        }
        return resultDocument;
    }
}

