/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.plugins.textmining.clients.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.ontotext.graphdb.plugins.textmining.clients.ClientBase;
import com.ontotext.graphdb.plugins.textmining.model.Document;
import com.ontotext.graphdb.plugins.textmining.plugin.ClientConfig;
import com.ontotext.graphdb.plugins.textmining.plugin.ClientType;
import com.ontotext.trree.sdk.PluginException;
import com.schibsted.spt.data.jslt.Expression;
import com.schibsted.spt.data.jslt.Parser;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import org.apache.http.entity.StringEntity;

public class GenericClient
extends ClientBase {
    public GenericClient(ClientConfig clientConfig) {
        super(clientConfig);
    }

    @Override
    protected Document convertJSONToDocument(JsonNode jsonNode) {
        ObjectMapper objectMapper = new ObjectMapper();
        String jsltTransformation = this.getTransformation();
        Expression expression = Parser.compileString((String)jsltTransformation, Collections.emptyList());
        JsonNode convertedDocumentJson = expression.apply(jsonNode);
        ((ObjectNode)jsonNode).put("content", "content");
        Document document = null;
        try {
            document = (Document)objectMapper.readValue(convertedDocumentJson.toString(), Document.class);
        }
        catch (JsonProcessingException e) {
            throw new PluginException("Document is not properly transformed. Please, check your transformation. ");
        }
        return document;
    }

    @Override
    protected StringEntity getStringEntity(String content, Map<String, String> documentFeatures) throws IOException {
        return new StringEntity(content, StandardCharsets.UTF_8);
    }

    @Override
    public ClientType getClientType() {
        return ClientType.GENERIC;
    }
}

