/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.plugins.textmining.clients.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.ontotext.graphdb.plugins.textmining.clients.ClientBase;
import com.ontotext.graphdb.plugins.textmining.model.Annotation;
import com.ontotext.graphdb.plugins.textmining.model.Document;
import com.ontotext.graphdb.plugins.textmining.plugin.ClientConfig;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.entity.StringEntity;

public class GateClient
extends ClientBase {
    public GateClient(ClientConfig gateConfig) {
        super(gateConfig);
    }

    @Override
    protected StringEntity getStringEntity(String content, Map<String, String> documentFeatures) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        String requestBody = objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)content);
        return new StringEntity(requestBody, StandardCharsets.UTF_8);
    }

    @Override
    protected Document convertJSONToDocument(JsonNode jsonNode) {
        Document resultDocument = new Document();
        resultDocument.setRawSource(jsonNode.toString());
        String documentText = jsonNode.findValue("text").textValue();
        ObjectMapper mapper = new ObjectMapper();
        Map entries = (Map)mapper.convertValue((Object)jsonNode.get("entities"), (TypeReference)new TypeReference<Map<String, Object>>(){});
        for (Map.Entry currentEntry : entries.entrySet()) {
            List entryValues = (List)currentEntry.getValue();
            for (LinkedHashMap entry : entryValues) {
                List indices = (List)mapper.convertValue(entry.get("indices"), (TypeReference)new TypeReference<List<Integer>>(){});
                assert (indices.size() == 2);
                int startNode = (Integer)indices.get(0);
                int endNode = (Integer)indices.get(1);
                String textValue = documentText.substring(startNode, endNode);
                Annotation entity = new Annotation();
                entity.setType((String)currentEntry.getKey());
                entity.setText(textValue);
                entity.setStartOffset(startNode);
                entity.setEndOffset(endNode);
                entity.setFeatures(this.getFeaturesFromResponse(entry));
                resultDocument.getAnnotations().add(entity);
            }
        }
        return resultDocument;
    }

    private Map<String, Object> getFeaturesFromResponse(LinkedHashMap<String, Object> entry) {
        HashMap<String, Object> features = new HashMap<String, Object>();
        entry.forEach((key, value) -> {
            if (!key.equals("indices")) {
                features.put((String)key, value);
            }
        });
        return features;
    }
}

