/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.plugins.textmining.clients.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.ontotext.graphdb.plugins.textmining.clients.ClientBase;
import com.ontotext.graphdb.plugins.textmining.model.Annotation;
import com.ontotext.graphdb.plugins.textmining.model.Document;
import com.ontotext.graphdb.plugins.textmining.plugin.ClientConfig;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.entity.StringEntity;
import org.eclipse.rdf4j.common.io.IOUtil;

public class CesClient
extends ClientBase {
    public static final String CES_JSON_ACCEPT_TYPE = "application/vnd.ontotext.ces+json";
    public static final String CES_JSON_LD_TYPE = "application/vnd.ontotext.ces+json+ld";

    public CesClient(ClientConfig gateConfig) {
        super(gateConfig);
    }

    @Override
    protected StringEntity getStringEntity(String content, Map<String, String> documentFeatures) throws IOException {
        if (this.isJSONLDClient() && !documentFeatures.isEmpty()) {
            String cesJSONLDTemplate = IOUtil.readString((InputStream)this.getClass().getResourceAsStream("/ces/jsonldRequestRemplate.jsonld"));
            cesJSONLDTemplate = this.addFeatureToJSONLD("{{FEATURE_ID}}", "id", "\"@id\": \"", documentFeatures, cesJSONLDTemplate);
            cesJSONLDTemplate = this.addFeatureToJSONLD("{{FEATURE_TYPE}}", "type", "\"@type\": \"", documentFeatures, cesJSONLDTemplate);
            cesJSONLDTemplate = this.addFeatureToJSONLD("{{FEATURE_CATEGORY}}", "category", "\"category\": \"", documentFeatures, cesJSONLDTemplate);
            cesJSONLDTemplate = this.addFeatureToJSONLD("{{FEATURE_SOURCE}}", "source", "\"documentSource\": \"", documentFeatures, cesJSONLDTemplate);
            cesJSONLDTemplate = this.addFeatureToJSONLD("{{FEATURE_AUTHOR}}", "author", "\"author\": \"", documentFeatures, cesJSONLDTemplate);
            cesJSONLDTemplate = this.addFeatureToJSONLD("{{FEATURE_DATE}}", "date", "\"publishDate\": \"", documentFeatures, cesJSONLDTemplate);
            cesJSONLDTemplate = this.addFeatureToJSONLD("{{FEATURE_TITLE}}", "title", "\"title\": \"", documentFeatures, cesJSONLDTemplate);
            return new StringEntity(cesJSONLDTemplate.replace("{{DOCUMENT_CONTENT}}", content), StandardCharsets.UTF_8);
        }
        return new StringEntity(content, StandardCharsets.UTF_8);
    }

    private String addFeatureToJSONLD(String featureTemplate, String featureKey, String prefix, Map<String, String> documentFeatures, String cesJSONLDTemplate) {
        if (documentFeatures.containsKey(featureKey)) {
            return cesJSONLDTemplate.replace(featureTemplate, prefix + documentFeatures.get(featureKey) + "\",");
        }
        return cesJSONLDTemplate.replace(featureTemplate, "");
    }

    @Override
    protected Document convertJSONToDocument(JsonNode jsonNode) {
        Document resultDocument = new Document();
        resultDocument.setRawSource(jsonNode.toString());
        ArrayNode mentions = (ArrayNode)jsonNode.get("mentions");
        for (JsonNode mention : mentions) {
            Annotation entity = new Annotation();
            entity.setText(mention.get("name").asText());
            entity.setType(mention.get("type").asText());
            entity.setStartOffset(mention.get("startOffset").asInt());
            entity.setEndOffset(mention.get("endOffset").asInt());
            entity.setFeatures(this.getFeaturesFromResponse(mention));
            resultDocument.getAnnotations().add(entity);
        }
        return resultDocument;
    }

    @Override
    protected boolean isJSONLDClient() {
        Header acceptHeader = null;
        Header contentTypeHeader = null;
        for (Header h : this.getClientConfig().getHeaders()) {
            if (h.getName().equalsIgnoreCase("Accept")) {
                acceptHeader = h;
            }
            if (!h.getName().equalsIgnoreCase("Content-type")) continue;
            contentTypeHeader = h;
        }
        return acceptHeader != null && acceptHeader.getValue().contains(CES_JSON_LD_TYPE) & contentTypeHeader != null && contentTypeHeader.getValue().contains(CES_JSON_LD_TYPE);
    }

    private Map<String, Object> getFeaturesFromResponse(JsonNode jsonNode) {
        HashMap<String, Object> features = new HashMap<String, Object>();
        ObjectMapper mapper = new ObjectMapper();
        Map entries = (Map)mapper.convertValue((Object)jsonNode.get("features"), (TypeReference)new TypeReference<Map<String, Object>>(){});
        entries.forEach(features::put);
        return features;
    }
}

